/****************************************************************************
 File: nptext.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.5  $
   $Author:   bschwart  $
     $Date:   28 Feb 1992 09:33:06  $

 This file contains the API definition for clsNPTextItem.

 clsNPTextItem inherits from clsNPItem.

 NPTextItem is the text class of PenPoint's ink-management or note-taking
 building block.  (See notepapr.h for more information on the building block.)
 NPTextItem overrides NPItem messages as is appropriate.  See npitem.h for
 details.

****************************************************************************/
#ifndef NPTEXT_INCLUDED
#define NPTEXT_INCLUDED

#ifndef NPITEM_INCLUDED
#include "npitem.h"
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  Types and Constants                                                    *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define clsNPTextItem			MakeGlobalWKN(2571,1)

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  Messages		                                                       *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNewDefaults				takes P_NP_TEXT_ITEM_NEW, returns STATUS
	Initialize pArgs.  Zeros out pArgs->textItem.
*/
typedef struct NP_TEXT_ITEM_NEW_ONLY {

	OBJECT		text;		// string object
	P_STRING	pString;	// string if string object not given
	OBJECT		data;		// data that item will be associated with
							// (item's size measured using data's DC)
	S32			spare1;

} NP_TEXT_ITEM_NEW_ONLY,  *P_NP_TEXT_ITEM_NEW_ONLY;

#define	npTextItemNewFields		\
	npItemNewFields			\
	NP_TEXT_ITEM_NEW_ONLY	textItem;

typedef struct NP_TEXT_ITEM_NEW {

	npTextItemNewFields

} NP_TEXT_ITEM_NEW, *P_NP_TEXT_ITEM_NEW;

#endif
