/****************************************************************************
 File: npscr.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.5  $
   $Author:   bschwart  $
     $Date:   28 Feb 1992 09:33:00  $

 This file contains the API definition for clsNPScribbleItem.

 clsNPScribbleItem inherits from clsNPItem.

 NPScribbleItem is the ink class of PenPoint's ink-management or note-taking
 building block.  (See notepapr.h for more information on the building block.)
 NPScribbleItem overrides NPItem messages as is appropriate.  See npitem.h for
 details.

****************************************************************************/
#ifndef NPSCR_INCLUDED
#define NPSCR_INCLUDED

#ifndef NPITEM_INCLUDED
#include "npitem.h"
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  Types and Constants                                                    *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define clsNPScribbleItem		MakeGlobalWKN(2570,1)

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  Messages		                                                       *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNewDefaults				takes P_NP_SCRIBBLE_ITEM_NEW, returns STATUS
	Initialize pArgs.  Zeros out pArgs->scribbleItem.
*/
typedef struct NP_SCRIBBLE_ITEM_NEW_ONLY {

	OBJECT	scribble;
	OBJECT	data;		// data that item will be associated with
	S32		spare1;

} NP_SCRIBBLE_ITEM_NEW_ONLY,  *P_NP_SCRIBBLE_ITEM_NEW_ONLY;

#define	npScribbleItemNewFields		\
	npItemNewFields			\
	NP_SCRIBBLE_ITEM_NEW_ONLY	scribbleItem;

typedef struct NP_SCRIBBLE_ITEM_NEW {

	npScribbleItemNewFields

} NP_SCRIBBLE_ITEM_NEW, *P_NP_SCRIBBLE_ITEM_NEW;

#endif
