/****************************************************************************
 keyboard.h

 Copyright 1992, GO Corporation, All Rights Reserved

 $Revision:   1.2  $
     $Date:   16 Mar 1992 15:05:48  $

 Interface to the software keyboard class.
 Keyboards do NOT file.

 clsKeyboard inherits from clsKeyCap.
 Provides the standard keyboard look and interaction.

 clsKeyboard inherits from clsKeyCap and provides keyboard-like
 behavior.  It directly supports the standard QWERTY keyboard and the
 PC 101 key keyboard layout and display.  Other forms of keyboards can
 be generated by overriding the keycap layout table.

 The make/break interface is implemented through a call-back procedure.
 This routine is setup in the new parameters and is called with the
 standard keyboard messages: msgKeyMake, msgKeyBreak, msgKeyChar, and
 msgKeyMulti.

 The scan code mapping table is generally reusable for most keyboard
 layouts.

 WARNING:	These API's are not currently in a suitable state for
			developers.


****************************************************************************/
#ifndef KEYBOARD_INCLUDED
#define KEYBOARD_INCLUDED

#ifndef GO_INCLUDED
#include <go.h>
#endif
#ifndef OSHEAP_INCLUDED
#include <osheap.h>
#endif
#ifndef UID_INCLUDED
#include <uid.h>
#endif
#ifndef KEY_INCLUDED
#include <key.h>
#endif
#ifndef KEYCAP_INCLUDED
#include <keycap.h>
#endif
#ifndef KEYSTATE_INCLUDED
#include <keystate.h>
#endif

/****  Quick Help Ids  ****/
/*
 This is the quick help Id for keyboard objects.
*/
#define tagKeyboard					MakeTag(clsKeyboard, 1)

/****  Class Messages  ****/

/****************************************************************************
 msgNewDefaults					takes P_KEYBOARD_NEW, returns STATUS
	Initializes the default new arguments.

 The default settings are:
	pArgs->keyboard.pMap = PC 101 keyboard mapping
	pArgs->keyboard.pProc = pNull;
	pArgs->keyboard.pUserData = NULL;
*/
typedef struct KEYBOARD_NEW_ONLY {
	P_U16 pMap;					// scan code to key map
	P_KEYSTATE_PROC pProc;		// proc for processing events
	P_UNKNOWN pUserData;		// user data for the proc
} KEYBOARD_NEW_ONLY, *P_KEYBOARD_NEW_ONLY;

#define keyboardNewFields		 	\
	keyCapNewFields					\
	KEYBOARD_NEW_ONLY   keyboard;

typedef struct KEYBOARD_NEW {
	keyboardNewFields
} KEYBOARD_NEW, *P_KEYBOARD_NEW;

/****************************************************************************
 msgNew							takes P_KEYBOARD_NEW, returns STATUS
	Creates a new keyboard object.
*/


/****************************************************************************
 msgKeyboardReturn				takes P_KEYBOARD_RET, returns STATUS
	Handles completion of processing of a key event.

 This message is only needed by the virtual keyboard application.
*/
typedef struct KEYBOARD_RET {
	MESSAGE msg;				// message
	P_KEY_DATA pKey;			// key information, see key.h
} KEYBOARD_RET, *P_KEYBOARD_RET;
#define msgKeyboardReturn		MakeMsg(clsKeyboard, 1)


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                       Standard Keyboard Events                          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/****************************************************************************
 msgKeyMake						takes P_KEY_DATA, returns STATUS
	Self call & notification of make key.
*/

/****************************************************************************
 msgKeyBreak					takes P_KEY_DATA, returns STATUS
	Self call & notification of break key.
*/

/****************************************************************************
 msgKeyChar						takes P_KEY_DATA, returns STATUS
	Self call & notification of character event.
*/

/****************************************************************************
 msgKeyMulti					takes P_KEY_DATA, returns STATUS
	Self call & notification of multi-key event.
*/

#endif
