/****************************************************************************
 dvfloppy.h

 Copyright 1992, GO Corporation,   All Rights Reserved

 The public definition of the floppy disk device interface. This device
 is a subset of the basic MIL block device. This module defines 
 extesions and additions to the block device data structures specific
 to floppy devices.

 $Revision:   1.4  $
   $Author:   thall  $
     $Date:   24 Mar 1992 15:08:06  $
****************************************************************************/
#ifndef DVFLOPPY_INCLUDED
#define DVFLOPPY_INCLUDED

#ifndef DVBLOCK_INCLUDED
#include "dvblock.h"
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 This section contains definitions specific to the floppy block device. 
 The definitions contained here are data structures that are the
 basic MIL block device data structures with additional floppy specific
 fields or they are duplicates of the MIL block data structures with
 floppy specific names. The duplicate data structures are included here
 because they are most likely to be modified in custom versions of the
 floppy driver.
*/


/**** Floppy Device Function Transfer Table ****/
/*
 The following data structure is the template for the floppy Function
 Transfer Table. The current definition is the same as the definition
 for the basic MIL block device FTT.
*/

#define fnCountFloppy fnCountBlock

typedef struct MIL_FTT_FLOPPY {
	funcTransTableCommonFields						// FTT common fields
	MIL_FUNCTION_DESC functionDesc[fnCountFloppy];	// block device specific
} MIL_FTT_FLOPPY, *P_MIL_FTT_FLOPPY;

#endif

