/****************************************************************************
 dvfdisk.h

 Copyright 1992, GO Corporation,   All Rights Reserved

 The public definition of the fixed disk device interface.
 This device is a subset of the basic MIL block device. This module
 defines extensions and additions to the block device data structures
 specific to fixed disk devices.

 $Revision:   1.6  $
   $Author:   thall  $
     $Date:   24 Mar 1992 15:07:34  $
****************************************************************************/
#ifndef DVFDISK_INCLUDED
#define DVFDISK_INCLUDED

#ifndef DVBLOCK_INCLUDED
#include "dvblock.h"
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 This section contains definitions specific to the fixed disk block device. 
 The definitions contained here are data structures that are the
 basic MIL block device data structures with additional fixed disk specific
 fields or they are duplicates of the MIL block data structures with
 fixed disk specific names. The duplicate data structures are included here
 because they are most likely to be modified in custom versions of the
 fixed disk driver.
*/


/**** Fixed Disk Device Function Transfer Table ****/
/*
 The following data structure is the template for the fixed disk Function
 Transfer Table. The current definition is the same as the definition
 for the basic MIL block device FTT.
*/


#define fnCountFDisk fnCountBlock

typedef struct MIL_FTT_FDISK {
	funcTransTableCommonFields
	MIL_FUNCTION_DESC functionDesc[fnCountFDisk];
} MIL_FTT_FDISK, *P_MIL_FTT_FDISK;

#endif
