/***********************************************************************
 dvclock.h

 Copyright 1992, GO Corporation,   All Rights Reserved

 The public definition of the clock device interface.

 $Revision:   1.8  $
   $Author:   thall  $
     $Date:   24 Mar 1992 15:14:00  $
***********************************************************************/
#ifndef DVCLOCK_INCLUDED
#define DVCLOCK_INCLUDED

// the functions supported by the clock device.
#define milClockGetDevParameters	milLastCommonFunction+1
#define milClockSetDateTime			milLastCommonFunction+2
#define milClockSetAlarm			milLastCommonFunction+3
#define milClockCancelAlarm			milLastCommonFunction+4
#define milClockAlarmEventCont		milLastCommonFunction+5

#define fnCountClock				fnCountBase+5

typedef struct MIL_FTT_CLOCK {
	funcTransTableCommonFields
	MIL_FUNCTION_DESC functionDesc[fnCountClock];
} MIL_FTT_CLOCK, *P_MIL_FTT_CLOCK;

/***********************************************************************

 Function milClockGetDevParameters- this single stage function returns 
 specific information on the Clock device.

***********************************************************************/

// flags in the field clockFlags
#define clockInvalid        flag0
#define clockAlarmEnabled   flag1

// These define which fields are compared for an alarm in the alarm function.
// For hardware which does not support resolution beyond a day PenPoint will
// schedule a daily alarm until the proper day is reached.
#define alarmUsesSeconds	flag2
#define alarmUsesMinutes	flag3
#define alarmUsesHours		flag4
#define alarmUsesDays		flag5
#define alarmUsesMonths		flag6
#define alarmUsesYears		flag7

/****************************************************************************

	MIL_DATE_TIME

	hours	0-23
	minutes	0-59
	seconds	0-59

	year	0-255, years since 1900
	month	0-11, months since january
	day		1-31

****************************************************************************/
typedef struct MIL_DATE_TIME {
	U8   hours;
	U8   minutes;
	U8   seconds;
	U8   year;
	U8   month;
	U8   day;
} MIL_DATE_TIME, * P_MIL_DATE_TIME;

typedef struct MIL_CLOCK_DEVICE_PARAMETERS {
	U16 clockFlags;
	MIL_DATE_TIME alarmLocalDateTime;
	MIL_DATE_TIME currentLocalDateTime;
	U16 reservedU16[2];
	U32 reservedU32[2];
} MIL_CLOCK_DEVICE_PARAMETERS, *P_MIL_CLOCK_DEVICE_PARAMETERS;

#define rbPublicFieldsClockGetDevParameters \
	MIL_CLOCK_DEVICE_PARAMETERS clockDevParms; \
	U16 funcReservedU16[2]; \
	U32 funcReservedU32[2];

typedef struct MIL_RB_PUB_CLOCK_GET_DEV_PARAMETERS {
	milRequestBlockCommonFields
	rbPublicFieldsClockGetDevParameters
} MIL_RB_PUB_CLOCK_GET_DEV_PARAMETERS, *P_MIL_RB_PUB_CLOCK_GET_DEV_PARAMETERS;

/***********************************************************************

 Function milClockSetDateTime

***********************************************************************/

#define rbPublicFieldsClockSetDateTime \
	MIL_DATE_TIME currentLocalDateTime; \
	U16 funcReservedU16[2]; \
	U32 funcReservedU32[2];

typedef struct MIL_RB_PUB_CLOCK_SET_DATE_TIME {
	milRequestBlockCommonFields
	rbPublicFieldsClockSetDateTime
} MIL_RB_PUB_CLOCK_SET_DATE_TIME, *P_MIL_RB_PUB_CLOCK_SET_DATE_TIME;

/***********************************************************************

 Function milClockSetAlarm

***********************************************************************/

#define rbPublicFieldsClockSetAlarm \
	MIL_DATE_TIME alarmLocalDateTime; \
	U16 funcReservedU16[2]; \
	U32 funcReservedU32[2];

typedef struct MIL_RB_PUB_CLOCK_SET_ALARM {
	milRequestBlockCommonFields
	rbPublicFieldsClockSetAlarm
} MIL_RB_PUB_CLOCK_SET_ALARM, *P_MIL_RB_PUB_CLOCK_SET_ALARM;

/***********************************************************************

 Function milClockCancelAlarm

***********************************************************************/

#define rbPublicFieldsClockCancelAlarm \
	U16 funcReservedU16[2]; \
	U32 funcReservedU32[2];

typedef struct MIL_RB_PUB_CLOCK_CANCEL_ALARM {
	milRequestBlockCommonFields
	rbPublicFieldsClockCancelAlarm
} MIL_RB_PUB_CLOCK_CANCEL_ALARM, *P_MIL_RB_PUB_CLOCK_CANCEL_ALARM;

/***********************************************************************

 Function milClockAlarmEventCont

***********************************************************************/

#define rbPublicFieldsClockEventCont \
	P_MIL_ASYNC_EVENT_FUNC pClockAlarmEventFunc; \
	U16 funcReservedU16[2]; \
	U32 funcReservedU32[2];

typedef struct MIL_RB_PUB_CLOCK_ALARM_EVENT_CONT {
	milRequestBlockCommonFields
	rbPublicFieldsClockEventCont
} MIL_RB_PUB_CLOCK_ALARM_EVENT_CONT, *P_MIL_RB_PUB_CLOCK_ALARM_EVENT_CONT;

#endif
