/****************************************************************************
 drvmil.h
 Copyright 1992, GO Corporation, All Rights Reserved

 Driver to MIL interface definitions, routines, etc.

 $Revision:   1.22  $
   $Author:   CPAYNE  $
     $Date:   02 Mar 1992 01:20:34  $
****************************************************************************/
#ifndef DRVMIL_INCLUDED
#define DRVMIL_INCLUDED

#ifndef GO_INCLUDED
#include <go.h>
#endif

#ifndef OSPRIV_INCLUDED
#include <ospriv.h>
#endif

#ifndef MIL_INCLUDED
#include <mil.h>
#endif

#define	milMaxHWIntLevels		16		// number of supported hardware 
										// interrupt levels

// This is public so debugger can correlate MIL symbol table with code
extern P_MIL_COMMON_ENTRY	pMILCommonStart;

P_MIL_COMMON_DATA EXPORTED DrvMILCommonData (void);

STATUS EXPORTED DrvMILRequestBlockCreate (
	U16					logicalId,
	PP_UNKNOWN			ppReqBlock
);
STATUS EXPORTED DrvMILRequestBlockFree (
	P_UNKNOWN			pReqBlock
);

/****************************************************************************
   DrvMILRequestBlockReset	returns STATUS
   
   Reset a previously created request block.
   NOTE: logical id must be set by the caller.
****************************************************************************/
STATUS EXPORTED DrvMILRequestBlockReset (
	P_MIL_REQUEST_BLOCK pReqBlock
);

STATUS EXPORTED DrvMILRequestBlockInit (
	U16					logicalId,
	P_MIL_REQUEST_BLOCK pReqBlock,
	SIZEOF				size
);
STATUS EXPORTED DrvMILRequest (
	P_MIL_REQUEST_BLOCK pReqBlock
);
STATUS EXPORTED DrvMILFastRequest (
	P_MIL_REQUEST_BLOCK pReqBlock
);
STATUS EXPORTED DrvMILCancelRequest (
	P_MIL_REQUEST_BLOCK pReqBlock
);

STATUS EXPORTED DrvMILInstallDevice (
	P_MIL_DEVICE_INFO pDeviceInfo
);

STATUS EXPORTED DrvMILDeinstallDevice (
	U16 LogicalId
);

/****************************************************************************
   DrvMILFindLogicalId

   Searches from *pLogicalId for a device of type deviceType
   Returns stsOK with *pLogicalId set if a match is found,
   otherwise returns stsNoMatch.

   NOTE: don't forget to zero *pLogicalId variable before the first
   call to DrvMILFindLogicalId.

****************************************************************************/
STATUS EXPORTED DrvMILFindLogicalId (
	UID				deviceType,
	P_U16			pLogicalId
);

STATUS GLOBAL DrvMILLogDevToHWInt (
	U16					logDeviceId,
	P_U32				pHWIntLevels,
	P_U16				pHWIntLevel
);

#endif

