/*
 *  dirent.h    Portable directory entry definitions
 *
 *  Copyright (C) by WATCOM Systems Inc. 1991.  All rights reserved.
 */
#ifndef _DIRENT_H_INCLUDED
#pragma pack(1);

#ifndef GO_INCLUDED
 #include <go.h>
#endif

#ifndef _TYPES_H_INCLUDED
 #include <sys/types.h>
#endif

#ifndef _STAT_H_INCLUDED
 #include <sys/stat.h>
#endif

typedef struct dirent {
    void*       d_handle;                   /* readdir handle */
    char        d_name[maxNameLength + 1];  /* file's name */
    char        d_attr;                     /* file's attribute */
} DIR;

/* File attribute constants for d_attr field */

#define _A_NORMAL   0x00    /* Normal file - read/write permitted */
#define _A_RDONLY   0x01    /* Read-only file */
#define _A_SUBDIR   0x10    /* Subdirectory */

/*
 *  POSIX 1003.1 Prototypes.
 */

extern DIR      *opendir( const char *__dirname );
extern struct dirent    *readdir( DIR *__dirp );
extern void      rewinddir( DIR *__dirp );
extern int       closedir( DIR *__dirp );

#pragma pack();
#define _DIRENT_H_INCLUDED
#endif
