/****************************************************************************
 File: tttview.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.5  $
 $Author:   kcatlin  $
 $Date:   30 Jan 1992 19:14:46  $

 This file contains the API definition for clsTttView.
 clsTttView inherits from clsView.
 clsTttView displays a representation of clsTttData as a grid of Xs and Os.
****************************************************************************/
#ifndef TTTVIEW_INCLUDED
#define TTTVIEW_INCLUDED

#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
#endif

#ifndef WIN_INCLUDED
#include <win.h>
#endif

#ifndef VIEW_INCLUDED
#include <view.h>
#endif

#ifndef SYSGRAF_INCLUDED
#include <sysgraf.h>
#endif

#ifndef TTTPRIV_INCLUDED
#include <tttpriv.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Defines													   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

//
// Tags used by the view's option sheet.
//
#define tagTttViewOptionSheet	MakeTag(clsTttView, 0)
#define tagTttViewCard			MakeTag(clsTttView, 1)
#define tagCardLineThickness	MakeTag(clsTttView, 2)

//
//	Tags for TTT's quick help.
//
#define	tagTttQHelpForView		MakeTag(clsTttView, 3)
#define	tagTttQHelpForLineCtrl 	MakeTag(clsTttView, 4)
// tagCardLineTickness (defined above) is also used for quick help.



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Common Typedefs										   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef OBJECT 
TTT_VIEW, * P_TTT_VIEW;


typedef struct {

	U32		lineThickness;
	U32		spare1;
	U32		spare2;

} TTT_VIEW_METRICS, * P_TTT_VIEW_METRICS,
  TTT_VIEW_NEW_ONLY, * P_TTT_VIEW_NEW_ONLY;


typedef struct TTT_VIEW_INST {

	TTT_VIEW_METRICS		metrics;
	SYSDC 					dc;
	// AKN - currentCell is used to hold hit row/col
	TTT_DATA_SET_SQUARE	currentCell;
	RECT32					selectedRange;

} TTT_VIEW_INST,
  * P_TTT_VIEW_INST,
  * * PP_TTT_VIEW_INST;

  
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Private Functions									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 TttViewOptions	returns STATUS

	Called in response to msgSelOptions and the "Check" gesture.
*/
STATUS PASCAL
TttViewOptions(
	OBJECT				self,
	PP_TTT_VIEW_INST	pData);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Exported Functions									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 ClsTttViewInit	returns STATUS
	Initializes / installs clsTttView.

	This routine is only called during installation of the class.
*/
STATUS PASCAL
ClsTttViewInit (void);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Messages for clsTttView							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew		takes P_TTT_VIEW_NEW, returns STATUS
	category: class message
	Creates an instance of clsTttView.
*/


#define	tttViewNewFields	\
	viewNewFields			\
	TTT_VIEW_NEW_ONLY		tttView;


typedef struct TTT_VIEW_NEW {

	tttViewNewFields

} TTT_VIEW_NEW, * P_TTT_VIEW_NEW;


/****************************************************************************
 msgNewDefaults		takes P_TTT_VIEW_NEW, returns STATUS
	category: class message
	Initializes the TTT_VIEW_NEW structure to default values.

	pArgs->view.createDataObject = true;
	pArgs->tttView.lineThickness = 5L;
	pArgs->tttView.spare1 = 0;
	pArgs->tttView.spare2 = 0;
*/


/****************************************************************************
 msgTttViewGetMetrics	takes P_TTT_VIEW_METRICS, returns STATUS
	Gets TTT_VIEW metrics.
*/
#define msgTttViewGetMetrics 	 			MakeMsg(clsTttView, 0)


/****************************************************************************
 msgTttViewSetMetrics	takes P_TTT_VIEW_METRICS, returns STATUS
	Sets the TTT_VIEW metrics.
*/
#define msgTttViewSetMetrics 	 			MakeMsg(clsTttView, 1)


/****************************************************************************
 msgTttViewToggleSel		takes nothing, returns STATUS
	Causes the view to toggle whether or not it holds the selection.
*/
#define msgTttViewToggleSel					MakeMsg(clsTttView, 2)


/****************************************************************************
 msgTttViewTakeSel			takes nothing, returns STATUS
	Causes the view to toggle whether or not it holds the selection.
*/
#define msgTttViewTakeSel					MakeMsg(clsTttView, 3)

#endif	// TTTVIEW_INCLUDED

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                        AKN - defines for constants (r,w)					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define	numberOfRows						5
#define 	numberOfColumns					5
