/****************************************************************************
 File: openobj.c
 
 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.18  $
   $Author:   kcatlin  $
     $Date:   31 Jan 1992 08:40:30  $

 This file contains the class definition and methods for clsTestOpenObject.

 This is a stub for and open service Object class. This class is only used
 for mult-user services that wish to pass a new uid to each opener.

 Notes:

 There's really not a whole lot to the default behavior for this class.
 Basically just put your stuff here.
****************************************************************************/
#include <string.h>
#include <stdlib.h>
#include <debug.h>
#include <list.h>
#include <fs.h>
#include <os.h>
#include <osheap.h>
#include <servmgr.h>
#include <method.h>

#include <openobj.h>

typedef struct INSTANCE_DATA {
	U32					unused1;
	U32					unused2;
} INSTANCE_DATA, *P_INSTANCE_DATA;


/****************************************************************************
	TestOpenObjectNewDefaults
	
****************************************************************************/
MsgHandlerWithTypes(TestOpenObjectNewDefaults, P_TEST_OPEN_OBJECT_NEW, P_INSTANCE_DATA)
{
	MsgHandlerParametersNoWarning;

	return stsOK;
	
} // TestOpenObjectNewDefaults


/****************************************************************************
	TestOpenObjectNew
	
****************************************************************************/
MsgHandlerWithTypes(TestOpenObjectNew, P_TEST_OPEN_OBJECT_NEW, P_INSTANCE_DATA)
{
	INSTANCE_DATA					inst;
	STATUS							s;

	MsgHandlerParametersNoWarning;

	s = stsOK;

	StsWarn(ObjectWrite(self, ctx, &inst));

	return s;

} // TestOpenObjectNew


/****************************************************************************
	TestOpenObjectFree

****************************************************************************/
MsgHandlerWithTypes(TestOpenObjectFree, P_ARGS, P_INSTANCE_DATA)
{
	MsgHandlerParametersNoWarning;

	return stsOK;

} 	// TestOpenObjectFree


/****************************************************************************
	ClsTestOpenObjectInit
	
	Install our class.
****************************************************************************/
STATUS PASCAL ClsTestOpenObjectInit(void)
{
	STATUS					s;
	CLASS_NEW				new;

	// Create the service class.
	ObjCallWarn(msgNewDefaults, clsClass, &new);
	new.object.uid			= clsTestOpenObject;
	new.cls.pMsg			= clsTestOpenObjectTable;
	new.cls.ancestor		= clsOpenServiceObject;
	new.cls.size			= SizeOf(INSTANCE_DATA);
	new.cls.newArgsSize		= SizeOf(TEST_OPEN_OBJECT_NEW);
	ObjCallRet(msgNew, clsClass, &new, s);

	return s;

} // ClsTestOpenObjectInit


