/****************************************************************************
 $Workfile:   PIXWIN.H  $

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.3  $
   $Author:   kcatlin  $
     $Date:   31 Jan 1992 08:34:36  $

 This file contains the API definition for class clsPixWin.
****************************************************************************/
#ifndef PIXWIN_INCLUDED
#define PIXWIN_INCLUDED

#include <go.h>
#include <uid.h>
#include <win.h>
#include <clsmgr.h>

#define clsPixWin MakePrivateWKN(2, 1)

typedef struct
{
	P_STRING pName;
	U16 spare1;
	SIZE32	size;		// size of file to create if pName doesn't exist
	S32 planeCount;		// depth of file to create if pName doesn't exist 
	BOOLEAN bCreate;	// create file if it doesn't exist?
	S16 spare2;
	S32 spare3;
} PIXWIN_NEW_ONLY,  *P_PIXWIN_NEW_ONLY;

#define	pixWinNewFields		\
	winNewFields			\
	PIXWIN_NEW_ONLY	pixwin;

typedef struct
{
  pixWinNewFields

} PIXWIN_NEW, *P_PIXWIN_NEW;

/****************************************************************************
 msgNewDefaults				takes P_PIXWIN_NEW, returns STATUS
	Initializes the PIXWIN_NEW structure to default values.

	pNew->pixwin.name = pNull;
	pNew->pixwin.type = pNull;
	pNew->pixwin.size = {0,0};
	pNew->win.input = inputTransparent;
*/

/****************************************************************************
 msgPixWinPixelmap			takes P_OBJECT, returns STATUS
 	Return pointer to off-screen pixelmap
*/
#define msgPixWinPixelmap			MakeMsg(clsPixWin, 1)


STATUS EXPORTED ClsPixWinInit( void );
#endif
