/****************************************************************************
 File: inputapp.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.8  $
   $Author:   kcatlin  $
     $Date:   05 Mar 1992 10:48:34  $

 This is a sample appliction to demonstrate pen-based application input.
 The application creates a subclass of clsWin (clsInWin) and installs it 
 as the client of the application frame.  This window responds to a variety
 of input events to do some interesting drawing on the screen.

 CAUTION:  This program has been written for teaching purposes ONLY.
 It is not even vaguely of product quality.
***************************************************************************/

#include <debug.h>
#include <clsmgr.h>
#include <frame.h>
#include <app.h>
#include <appmgr.h>
#include <string.h>
#include <input.h>
#include <pen.h>
#include <sysgraf.h>
#include <methods.h>

#define	clsInputApp	    wknGDTh
#define clsInWin        MakePrivateWKN(40, 1)

// Instance data for an input window
typedef struct INWIN_INST {
    OBJECT dc;
    XY32 prevLoc;
} INWIN_INST, *P_INWIN_INST;
			  
/****************************************************************************
 InputMsgAppOpen

 When the application is opened, this 
****************************************************************************/
MsgHandler(InputMsgAppOpen)
{
	STATUS			s;
	WIN_NEW			inNew;
	FRAME_METRICS	frameMetrics;
	APP_METRICS		appMetrics;
	WIN_METRICS		winMetrics;

	// Ancestor called in method table

	// Create an instance of the inWin class 
	ObjCallRet(msgNewDefaults, clsInWin, &inNew, s);
	
	// set the input flags to get tip & move events
	inNew.win.flags.input = inputTip | inputMoveDown | inputMoveUp	|
	                        inputOutProx | inputExit | inputInProx |
	                        inputMoveDelta;

	ObjCallRet(msgNew, clsInWin, &inNew, s);

	// Tell the frame of the application about the client window
	ObjCallJmp(msgAppGetMetrics, self, &appMetrics, s, Error1);
	ObjCallJmp(msgFrameGetMetrics, appMetrics.mainWin, &frameMetrics, \
				s, Error1);
    frameMetrics.clientWin = inNew.object.uid;
    ObjCallJmp(msgFrameSetMetrics, appMetrics.mainWin, &frameMetrics, \
				s, Error1);


	// Relayout the window
	winMetrics.options = wsLayoutDefault;
	ObjCallJmp(msgWinLayout, appMetrics.mainWin, &winMetrics, \
				s, Error1);

	return stsOK;

	// Recover from errors here.  In particular, free resources.
Error1:
	(void) ObjCallWarn(msgFree, inNew.object.uid, pNull);
	(void) ObjCallAncestorWarn(msgDestroy, self, pNull, ctx);

	return s;
	MsgHandlerParametersNoWarning;
} /* InputMsgAppOpen */

/****************************************************************************
  ClsInputAppInit

  Install the Input App application class as a well-known UID.
****************************************************************************/
STATUS ClsInputAppInit (void)
{	   
	APP_MGR_NEW	new;
	STATUS		s;

	// Install the input app class as a descendant of clsApp.
	ObjCallRet(msgNewDefaults, clsAppMgr, &new, s);
	new.object.uid	 		  	= clsInputApp;
	new.object.key	 		  	= (OBJ_KEY)clsInputApp;
	new.cls.pMsg				= clsInputAppTable;
	new.cls.ancestor			= clsApp;
	new.cls.size				= Nil(SIZEOF);	// no instance data
	new.cls.newArgsSize			= SizeOf(APP_NEW);
	new.appMgr.flags.accessory	= false;
	new.appMgr.flags.stationery = true;
	strcpy(new.appMgr.defaultDocName, new.appMgr.name);
	strcpy(new.appMgr.company, "GO Corporation");
	ObjCallRet(msgNew, clsAppMgr, &new, s);

#ifdef DEBUG
	if (DbgFlagGet('S', 1l)) {
		Debugf("Turning on message tracing for clsInputApp");
		(void)ObjCallWarn(msgTrace, clsInputApp, (P_ARGS) true);
	}
#endif

	return stsOK;

} /* ClsInputAppInit */


/****************************************************************************
  InWinInit

  Method for initializing the InWin instance data.  Also called when 
  restoring the inWin.  Simply creates a DC associated with the window 
  used to do all drawing when processing input.
****************************************************************************/
MsgHandler(InWinInit)
{
    INWIN_INST inst;
    SYSDC_NEW dcNew;
    STATUS s;

	// Ancestor called in method table

	// Clear the local instance data
	memset(&inst, 0, sizeof(inst));

	// Create a drawing context to perform the drawing 
    ObjectCall(msgNewDefaults, clsSysDrwCtx, &dcNew);
    ObjCallRet(msgNew, clsSysDrwCtx, &dcNew, s);

	// Tie the window and the drawing context together
    ObjectCall(msgDcSetWindow, dcNew.object.uid, self);

    // we'll only deal in screen coordinates in this example 
    ObjectCall(msgDcUnitsDevice, dcNew.object.uid, Nil(P_ARGS));

	// Tell the DC to draw in XOR mode
    ObjectCall(msgDcSetMode, dcNew.object.uid, (P_ARGS)sysDcDrawDynamic);

	// Tell the DC to fill closed figures with the foreground pattern (black)
    ObjectCall(msgDcSetFillPat, dcNew.object.uid, (P_ARGS)sysDcPatForeground);

	// Write out the instance data
    inst.dc = dcNew.object.uid;		   
    inst.prevLoc.x = minS32;
    inst.prevLoc.y = minS32;
    return ObjectWrite(self, ctx, &inst);
	MsgHandlerParametersNoWarning;
} /* InWinInit */

/****************************************************************************
  InWinFree

  Releases the resources associated with the object.  Specifically, the DC.
****************************************************************************/
MsgHandler(InWinFree)
{
    INWIN_INST inst;

    inst = *(P_INWIN_INST)pData;
    return ObjectCall(msgFree, inst.dc, Nil(P_ARGS));
	// Ancestor called after in method table
	MsgHandlerParametersNoWarning;
} /* InWinFree */

/****************************************************************************
  InWinInput

  Method for processing input events.  Responds to a variety of pen input
  events by drawing a square in the window as the pen moves.
****************************************************************************/
MsgHandlerArgType(InWinInput, P_INPUT_EVENT)
{
    INWIN_INST inst;
    RECT32 box;

	inst = *(P_INWIN_INST)pData;

    box.size.w = 14;
    box.size.h = 14;

    ObjCallWarn(msgWinBeginPaint, inst.dc, Nil(P_ARGS));
													  
    switch (pArgs->devCode) {
        case msgPenDown:
#ifdef DEBUG
         	if (DbgFlagGet('S', 2l))
                 DPrintf("Pen Down at location (%ld,%ld)\n", pArgs->xy);
#endif
            /* draw a rectangle with the origin at the point */
            box.origin = pArgs->xy;
            ObjectCall(msgDcDrawRectangle, inst.dc, &box);

            inst.prevLoc = pArgs->xy;
            ObjectWrite(self, ctx, &inst);
            break;
        case msgPenExitDown:
        case msgPenOutProxDown:
        case msgPenUp:
#ifdef DEBUG
        	if (DbgFlagGet('S', 2l))
                DPrintf("Pen Up at location (%ld,%ld)\n", pArgs->xy);
#endif
            /* redraw the rect at the last location to clear it */
            box.origin = inst.prevLoc;
            ObjectCall(msgDcDrawRectangle, inst.dc, &box);

            inst.prevLoc.x = minS32;
            ObjectWrite(self, ctx, &inst);
            break;
        case msgPenMoveDown:
#ifdef DEBUG
        	if (DbgFlagGet('S', 2l))
                DPrintf("Pen Moved to location (%ld,%ld)\n", pArgs->xy);
#endif
            if (inst.prevLoc.x != minS32) {
                /* redraw the rect at the last location */
                box.origin = inst.prevLoc;
                ObjectCall(msgDcDrawRectangle, inst.dc, &box);
            }

            /* draw a rectangle with the origin at the point */
            box.origin = pArgs->xy;
            ObjectCall(msgDcDrawRectangle, inst.dc, &box);

            inst.prevLoc = pArgs->xy;
            ObjectWrite(self, ctx, &inst);
            break;
        default:
            break;
    }
    ObjectCall(msgWinEndPaint, inst.dc, Nil(P_ARGS));
	
    return stsInputTerminate;     // indicates completion of the event
	MsgHandlerParametersNoWarning;
} /* InWinInput */

/****************************************************************************
  ClsInWinInit

  Install the Input Window class.
****************************************************************************/
STATUS ClsInWinInit (void)
{
	CLASS_NEW c;
    STATUS s;

	ObjectCall(msgNewDefaults, clsClass, &c);
	c.object.key =      (OBJ_KEY)clsInWin;
	c.object.uid =      clsInWin;
	c.cls.pMsg =      	clsInWinTable;
	c.cls.ancestor =  	clsWin;             // subclass of clsWin
	c.cls.size =      	SizeOf(INWIN_INST); // instance data size
	c.cls.newArgsSize = SizeOf(WIN_NEW);
	ObjCallRet(msgNew, clsClass, &c, s);

    return (stsOK);
} /* ClsInWinInit */


/****************************************************************************
 Main application entry point
****************************************************************************/
void CDECL main (int argc, char *argv[], U16 processCount)
{
	if (processCount == 0) {

		// install the application class
		ClsInputAppInit();
		AppMonitorMain(clsInputApp, objNull);

	} else {
		// install local class
        ClsInWinInit();
   		AppMain();
	}
	Unused(argc); Unused(argv);
} /* main */

