/****************************************************************************
 File: clabel.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.12  $
   $Author:   pstahl  $
     $Date:   16 Mar 1992 14:49:38  $

 This file contains the class definition and methods for clsCLabel.
****************************************************************************/
#include <methods.h>
#include <clabel.h>
#include <os.h>
#include <app.h>
#include <frame.h>
#include <string.h>
#include <debug.h>
#include <sel.h>

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * // 
//                           clsObject Methods							   //
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

/****************************************************************************
	ClockLabelNewDefaults
	
	Respond to msgNewDefaults.
****************************************************************************/
MsgHandlerArgType(ClockLabelNewDefaults, P_LABEL_NEW)
{
	MsgHandlerParametersNoWarning;


	pArgs->border.style.selectedAlter	= bsAlterBackground;

	return stsOK;

}	// ClockLabelNewDefaults

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //
//                           clsBorder Methods							   //
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

/****************************************************************************
	ClockLabelBorderSetSelected
	
	Respond to msgBorderSetSelected.
****************************************************************************/
MsgHandlerArgType(ClockLabelBorderSetSelected, P_ARGS)
{
	BORDER_STYLE		bs;
	BOOLEAN				value = (BOOLEAN)(U32)pArgs;
	STATUS				s;
	MsgHandlerParametersNoWarning;


	// Turn on/off press-drag style on self.
	ObjCallRet(msgBorderGetStyle, self, &bs, s);
	bs.drag = (value == true) ? bsDragNone : bsDragHoldDown;
	ObjCallRet(msgBorderSetStyle, self, &bs, s);

	// Pass to ancestor...
	return ObjectCallAncestor(msg, self, pArgs, ctx);

}	// ClockBorderSetSelected

/****************************************************************************
	ClsClockLabelInit
	
	Install the class.
****************************************************************************/
STATUS ClsClockLabelInit (void)
{
	CLASS_NEW		new;
	STATUS			s;


	// Create the class.
	ObjectCall(msgNewDefaults, clsClass, &new);
	new.object.uid		= clsClockLabel;
	new.object.key		= (OBJ_KEY)clsClockLabelTable;
	new.cls.pMsg		= clsClockLabelTable;
	new.cls.ancestor	= clsLabel;
	new.cls.size		= 0;
	new.cls.newArgsSize	= SizeOf(LABEL_NEW);
	ObjCallRet(msgNew, clsClass, &new, s);

	return stsOK;

}  // ClsClockLabelInit


