/****************************************************************************
 File: tabbar.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.51  $
   $Author:   cmeyer  $
     $Date:   18 Mar 1992 14:47:12  $

 This file contains the API definition for clsTabBar.

 clsTabBar inherits from clsTkTable.
 Implements a window that lays out its children in a single column or row.

 TabBars are most often seen at the side of Notebooks.  clsTabBar will
 overlap its children in a regular fashion if they won't fit in the long
 dimension.  clsTabBar also handles flick gestures forwarded to it by
 rearranging the children.
****************************************************************************/

/**** Debugging Flags ****/
/*
 The clsTabBar debugging flag is 'K'.  Defined values are:

    flag12 (0x1000):    general debug info
*/

#ifndef TABBAR_INCLUDED
#define TABBAR_INCLUDED

												#ifndef TKTABLE_INCLUDED
#include <tktable.h>
												#endif


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef OBJECT TAB_BAR, *P_TAB_BAR;

/****  Direction  ****/
#define	tbDirectionVertical		0	// vertical tab bar
#define	tbDirectionHorizontal	1	// horizontal tab bar

typedef struct TAB_BAR_STYLE {
	U16	direction			: 1,	// vertical or horizontal
		incrementalLayout	: 1,	// careful about add and remove children
		spare				: 14;	// unused (reserved)
} TAB_BAR_STYLE, *P_TAB_BAR_STYLE;

/*
 Default TabBar style:
//{
 	direction			= tbDirectionVertical
 	incrementalLayout	= true
//}
*/

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Messages									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew		takes P_TAB_BAR_NEW, returns STATUS
	category: class message
	Creates a tabBar window.

 The fields you commonly set are:
	pArgs->tabBar.style.direction:	whether horizontal or vertical
*/

typedef struct TAB_BAR_NEW_ONLY {
	TAB_BAR_STYLE		style;			// overall style
	U32					spare;			// unused (reserved)
} TAB_BAR_NEW_ONLY, *P_TAB_BAR_NEW_ONLY;

#define	tabBarNewFields		\
	tkTableNewFields		\
	TAB_BAR_NEW_ONLY	 	tabBar;

typedef struct TAB_BAR_NEW {
	tabBarNewFields
} TAB_BAR_NEW, *P_TAB_BAR_NEW;


/****************************************************************************
 msgNewDefaults				takes P_TAB_BAR_NEW, returns STATUS
	category: class message
	Initializes the TAB_BAR_NEW structure to default values.

 Zeroes out pArgs->tabBar and sets
//{
	pArgs->win.flags.style |= wsTransparent | wsClipChildren;
	pArgs->win.flags.input |= inputDisable | inputTransparent;

	pArgs->gWin.style.gestureEnable = false;

	pArgs->border.style.backgroundInk |= bsInkExclusive;
	pArgs->border.style.leftMargin = bsMarginNone;
	pArgs->border.style.rightMargin = bsMarginNone;
	pArgs->border.style.bottomMargin = bsMarginNone;
	pArgs->border.style.topMargin = bsMarginNone;

	pArgs->tableLayout.style.tblXAlignment = tlAlignCenter;
	pArgs->tableLayout.style.tblYAlignment = tlAlignCenter;
	pArgs->tableLayout.style.growChildHeight = false;
	pArgs->tableLayout.style.reverseY = true;

	pArgs->tableLayout.numCols.constraint = tlAbsolute;
	pArgs->tableLayout.numCols.value = 1;
	pArgs->tableLayout.numRows.constraint = tlInfinite;
	pArgs->tableLayout.colWidth.constraint = tlChildrenMax;
	pArgs->tableLayout.colWidth.gap = 0;
	pArgs->tableLayout.rowHeight.constraint = tlGroupMax;
	pArgs->tableLayout.rowHeight.gap = defaultRowGap;

	pArgs->tabBar.style.incrementalLayout = true;
//}

 Also sets the default child structure in pArgs->tkTable.pButtonNew to be
 appropriate for labels and buttons that may be rotated 270 degrees
 and have curved overlapping "tabs".
*/


/****************************************************************************
 msgTabBarGetStyle		takes P_TAB_BAR_STYLE, returns STATUS
	Passes back the style values.
*/
#define msgTabBarGetStyle	  	MakeMsg(clsTabBar, 1)


/****************************************************************************
 msgTabBarSetStyle		takes P_TAB_BAR_STYLE, returns STATUS
	Sets the style values.
*/
#define msgTabBarSetStyle	  	MakeMsg(clsTabBar, 2)


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *				    Messages from Other Classes							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgSave	takes P_OBJ_SAVE, returns STATUS
	Causes an object to file itself in an object file.

 clsTabBar responds by filing away its instance data.
*/


/****************************************************************************
 msgRestore	takes P_OBJ_RESTORE, returns STATUS
	Creates and restores an object from an object file.

 clsTabBar responds by restoring its instance data.
*/


/****************************************************************************
 msgWinLayoutSelf takes P_WIN_METRICS, returns STATUS
    Tells a window to layout its children.

 When a tabBar receives msgWinLayoutSelf, it will ignore the current
 positions of its children and do a full relayout, crunching the children
 toward the bottom (right) of itself, if necessary.

 To insert or remove a child and cause the tabBar to incrementally fix
 up the tab positions (i.e., without doing a full relayout), use
 msgTkTableAdd* and msgTkTableRemove.  When a tabBar receives these
 messages, it checks its incrementalLayout style bit.  If this is on,
 the tabBar will fix up the area around the inserted/removed child.
 If the style bit is off, the tabBar will not do relayout.

 If you want to add/remove more than a few tabs, turn incrementalLayout
 off, add/remove the children, then send msgWinLayout to the tabBar.

 See Also
	msgTkTableAdd*:		adds a child and will immediately fix up the layout
						of the tabBar's children (if style.incrementalLayout
						is true).
	msgTkTableRemove:	removes a child and will immediately fix up the layout
						of the tabBar's children (if style.incrementalLayout
						is true).
*/


/****************************************************************************
 msgWinSend 	takes P_WIN_SEND, returns STATUS
    Sends a message up a window ancestry chain.

 When a tabBar receives this message, it is usually because the tabBar has
 an "expand" menu up, and the user has tapped on one of those menu buttons.

 If the pArgs->msg is not msgMenuDone, or the tabBar does not have a menu up,
 the tabBar will just return the result of calling its ancestor.

 Otherwise, the tabBar will take down the menu via msgMenuShow, post
 a msgDestroy to it, and then return stsOK.  This is all the tabBar must do
 at this point, since the principle work of the menuButton was done when
 it sent its message to its client (in this case, the client is the tabBar).
*/


/****************************************************************************
 msgGWinForwardedGesture	takes P_GWIN_GESTURE, returns STATUS
	Message received when object is forwarded a gesture.

 TabBars respond to flick gestures by potentially altering the layout
 of their child windows.  This allows a user to rearrange the child buttons
 when there's not enough room to display all the children fully.

 The tabBar will first test pArgs->msg to see if it is not a flick gesture
 or it is but it would have no meaning.  If either is true, the tabBar
 will return stsMessageIgnored.

 If all the children are fully displayed, the tabBar will return stsOK.

 If style.direction is tbDirectionVertical and pArgs->msg is xgsFlickLeft,
 or the direction is tbDirectionHorizontal and pArgs->msg is xgsFlickUp,
 the tabBar will create and put up a menu over itself that looks like
 an expanded tabBar.  The user then tap on one of the menu buttons;
 this will have the same effect as tapping on the corresponding tabBar
 child.  After putting up the menu, the tabBar will return stsOK.

 If all of the above checks failed, the tabBar will process the flick
 gesture by moving its children as appropriate and then returning stsOK.
*/


/****************************************************************************
 msgTkTableChildDefaults		takes P_UNKNOWN, returns STATUS
	Sets the defaults in P_ARGS for a common child.

 Here is how a tabBar processes this message if style.direction is
 tbDirectionVertical:
//{
	pArgs->win.flags.style &= ~wsParentClip;
	pArgs->win.flags.style |= wsClipSiblings | wsClipChildren;

	if <pArgs->object.class inherits from clsBorder> {
		pArgs->border.style.edge = bsEdgeTop | bsEdgeRight | bsEdgeBottom;
		pArgs->border.style.join = bsJoinRound;
		pArgs->border.style.backgroundInk = bsInkWhite;
		pArgs->border.style.topMargin = bsMarginMedium;
		pArgs->border.style.bottomMargin = bsMarginMedium;

		pArgs->border.style.shadow = bsShadowThinBlack;
	}

	if <pArgs->object.class inherits from clsLabel> {
		pArgs->label.style.xAlignment = lsAlignCenter;
		pArgs->label.style.yAlignment = lsAlignCenter;
		pArgs->label.style.rotation = lsRotate270;
		pArgs->label.scale = lsScaleMedium;
	}
//}

 Here is how a tabBar processes this message if style.direction is
 tbDirectionHorizontal:
//{
	pArgs->win.flags.style &= ~wsParentClip;
	pArgs->win.flags.style |= wsClipSiblings | wsClipChildren;

	if <pArgs->object.class inherits from clsBorder> {
		pArgs->border.style.edge = bsEdgeLeft | bsEdgeRight | bsEdgeBottom;
		pArgs->border.style.join = bsJoinRound;
		pArgs->border.style.backgroundInk = bsInkWhite;
		pArgs->border.style.leftMargin = bsMarginMedium;
		pArgs->border.style.rightMargin = bsMarginMedium;
		pArgs->border.style.topMargin = bsMarginSmall;
		pArgs->border.style.bottomMargin = bsMarginSmall;

		pArgs->border.style.shadow = bsShadowThinBlack;
		pArgs->border.style.shadowGap = bsGapNone;
	}

	if <pArgs->object.class inherits from clsLabel> {
		pArgs->label.style.xAlignment = lsAlignCenter;
		pArgs->label.style.yAlignment = lsAlignCenter;
		pArgs->label.style.rotation = lsRotateNone;
		pArgs->label.scale = lsScaleMedium;
	}
//}
*/


/****************************************************************************
 msgTkTableAddAsFirst		takes WIN, returns STATUS
	Adds specified window as the first child in the table.

 clsTabBar responds by first calling its ancestor, then checking
 style.incrementalLayout.  If this is false, the tabBar will just return
 stsOK.

 Otherwise, the tabBar will do whatever layout is necessary to fix up
 the positions of its children.
*/


/****************************************************************************
 msgTkTableAddAsLast		takes WIN, returns STATUS
	Adds specified window as the last child in the table.

 clsTabBar responds by first calling its ancestor, then checking
 style.incrementalLayout.  If this is false, the tabBar will just return
 stsOK.

 Otherwise, the tabBar will do whatever layout is necessary to fix up
 the positions of its children.
*/


/****************************************************************************
 msgTkTableAddAsSibling		takes P_TK_TABLE_ADD_SIBLING, returns STATUS
	Inserts specified window in front of or behind an existing child.

 clsTabBar responds by first calling its ancestor, then checking
 style.incrementalLayout.  If this is false, the tabBar will just return
 stsOK.

 Otherwise, the tabBar will do whatever layout is necessary to fix up
 the positions of its children.
*/


/****************************************************************************
 msgTkTableAddAt		takes P_TK_TABLE_ADD_AT, returns STATUS
	Inserts specified window table at specified index.

 clsTabBar responds by first calling its ancestor, then checking
 style.incrementalLayout.  If this is false, the tabBar will just return
 stsOK.

 Otherwise, the tabBar will do whatever layout is necessary to fix up
 the positions of its children.
*/


/****************************************************************************
 msgTkTableRemove		takes WIN, returns STATUS
	Extracts specified window.

 Currently, the tabBar just calls its ancestor and does not attempt to
 fix up the layout of its children.  This may change in the future.
*/


#endif	// TABBAR_INCLUDED
