/****************************************************************************
 File: rescmplr.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.6  $
   $Author:   jbennett  $
     $Date:   06 Mar 1992 16:09:10  $

 This file contains definitions for input to the resource compiler.

 The resource compiler is a program which runs under MS-DOS.  In conjunction
 with your resource compiler input and the C compiler it will create a
 PenPoint resource file.

 NOTE: THIS IS A MSDOS INCLUDE FILE, DO NOT CHANGE IT TO BE PENPOINT
 COMPATIBLE.
****************************************************************************/
#ifndef RESCMPLR_INCLUDED
#define RESCMPLR_INCLUDED

#ifndef RESFILE_INCLUDED
#include <resfile.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   				Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****  Types  ****/

/*
 Prototype for the client-supplied agent writing routine.  If you wish to
 supply your own agent writing routine then write a routine of type
 P_AGENT_TYPE and supply the address to the routine in the field
 pAgentWriteProc of RC_INPUT.  Your routine should write out (using fwrite
 to file) its representation of the data described by pResInput (and
 optionally also by pAgentData).
*/
typedef void (PASCAL * P_AGENT_WRITE) (
	P_UNKNOWN				file,			// DOS file handle
	struct RC_INPUT			* pResInput,	// Data described below
	P_UNKNOWN				pAgentData,		// Res Agent specific data
	U32						spare1,			// For future
	U32						spare2			// For future
);

/*
 The resource compiler uses the information supplied by RC_INPUT to create
 resources.  Typically only the first four or five fields of RC_INPUT are
 used.  At a minimum you should set resId, pData and dataLen.  You do
 not need to set dataLen if you set agent to resStringResAgent or
 resStringArrayResAgent (the resource compiler will infer dataLen from pData).
 You should set agent if you do not want the default resource data agent.
 You should set minSysVersion if it has a non-zero value.  You may set
 objectData to true in the rare case that an object resource is being created
 by the resource compiler.  You should set pAgentWriteProc and optionally
 pAgentWriteData if you are providing your own routine to write the resource
 data to the resource file.
*/
typedef struct RC_INPUT {
	RES_ID				resId;				// the resource ID
	P_UNKNOWN			pData;				// points to data
	U16					dataLen;			// length of data
	UID					agent;				// usually resDefaultResAgent
	U16					minSysVersion;		// min sys version for resource
	U16					reserved;
	BOOLEAN				objectData;			// usually false
	P_AGENT_WRITE		pAgentWriteProc;	// pNull, unless supplying routine
	P_UNKNOWN			pAgentWriteData;	// usually pNull
} RC_INPUT, *P_RC_INPUT, **PP_RC_INPUT;

/*
 If you use resTaggedStringArrayResAgent as the agent for a resource.  Then the
 data must be a list of RC_TAGGED_STRINGs.  This is converted into a linear
 string array and the filed using the resStringArrayResAgent agent.
 */		   							  	 	   				 

#define resTaggedStringArrayResAgent	 ((UID)MakeTag(clsResFile, 0xff))

typedef struct RC_TAGGED_STRING {

	TAG					tag;
	P_STRING			pString;
	
} RC_TAGGED_STRING, *P_RC_TAGGED_STRING;
				  

/****  Public variable  ****/

/*
 resInput is an exported variable that the resource compiler expects.
 Each element in the resInput array is a pointer to a structure
 describing the next resource.  The list must be terminated with a
 null pointer.
*/
extern	P_RC_INPUT	resInput [];	// Resource compiler input


/****  Example  ****/

/*
 Here is example input for rescmplr (or rc):

//{
	// Resource ids
	#define resIdRfANumber				MakeWknResId(clsExample, 1)
	#define resIdRfAString				MakeWknResId(clsExample, 2)
	#define resIdRfAStringArray			MakeWknResId(clsExample, 3)
	#define resIdRfATaggedStringArray	MakeWknResId(clsExample, 4)
	
	#define tagExampleErrorBogus		MakeTag(clsExample, 0)
	#define tagExampleErrorWrong		MakeTag(clsExample, 1)
	#define tagExampleErrorAgain		MakeTag(clsExample, 2)
					  										  	 
	// A number.
	static U16		aNumber = 1;

	// A string array.
	static P_CHAR errorTextData [] = {
		"This is bogus.",
		"You got it wrong.",
		"I think you need to try again.",

		pNull						// Define end of string array.
	};

	// A tagged string array.  
	// This is equivalent to the above string array even thought the
	// elements are in a different order.
	static P_RC_TAGGED_STRING errorTextTaggedData [] = {
	
		tagExampleErrorWrong,	"You got it wrong.",
		tagExampleErrorAgain,	"I think you need to try again.",
		tagExampleErrorBogus,	"This is bogus.",
				   
		pNull
	};

	// Res compiler input for aNumber.
	static RC_INPUT	aNumberRes = {
		resIdRfANumber,
		&aNumber,
		sizeof(aNumber)
	};

	// Res compiler input for aString.
	static RC_INPUT	aStringRes = {
		resIdRfAString,
		"Sample string",
		0,					// Size inferred by res compiler.
		resStringResAgent
	};

	// Res compiler input for aStringArray.
	static RC_INPUT	aStringArrayRes = {
		resIdRfAStringArray,
		errorTextData,
		0,					// Size inferred by res compiler.
		resStringArrayResAgent
	};

	// Res compiler input for aTaggedStringArray.
	static RC_INPUT	aTaggedStringArrayRes = {
		resIdRfATaggedStringArray,
		errorTextTaggedData,
		0,					// Size inferred by res compiler.
		resTaggedStringArrayResAgent
	};				   

	// Input for resource compiler.
	P_RC_INPUT	resInput [] = {
		&aNumberRes,
		&aStringRes,
		&aStringArrayRes,
		&aTaggedStringArrayRes,
		pNull
	};
//}
*/

#endif	// RESCMPLR_INCLUDED

