/****************************************************************************
 File: rcapp.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.23  $
     $Date:   03 Mar 1992 11:46:40  $

 This file contains the API definition for clsRootContainerApp.

 clsRootContainerApp inherits from clsApp.
 Abstract class for root containers.

 This class defines the API for all root container applications.
 Root containers are expected to respond to this API as part of
 their implementation.

 PenPoint includes one implementation of a root container: the notebook.
 The messages defined in this class allow programatic control of
 a root container application.  

 To get the uid of the root container of interest use 
 msgAppGetRoot (see app.h) or msgAppMgrGetRoot (see appmgr.h).
****************************************************************************/
#ifndef RCAPP_INCLUDED
#define RCAPP_INCLUDED

#include <clsmgr.h>
#include <uuid.h>

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef OBJECT RCAPP, *P_RCAPP;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *			Messages													   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****  Sequential Access Messages  ****/
/*
 * The next four messages provide sequential access to documents within
 * the target root container.  
 */
/****************************************************************************
 msgRCAppNextDoc		takes nothing, returns STATUS
	Increments a root container's internal pointer to the next document.  
	
 This message is sent to a root container to cause it to move to the
 next page.  This message does not actually cause the page turn to 
 occur.  After one or more msgRCAppNextDoc, you must send
 msgRCAppExecuteGotoDoc to actually force the page turn to happen.
*/
#define msgRCAppNextDoc					MakeMsg(clsRootContainerApp, 1)

/****************************************************************************
 msgRCAppPrevDoc		takes nothing, returns STATUS
	Decrements a root container's internal pointer to the previous document.  
	
 This message is sent to a root container to cause it to move to the
 previous page.  This message does not actually cause the page turn to 
 occur.  After one or more msgRCAppPrevDoc, you must send
 msgRCAppExecuteGotoDoc to actually force the page turn to happen.
*/
#define msgRCAppPrevDoc					MakeMsg(clsRootContainerApp, 2)

/****************************************************************************
 msgRCAppExecuteGotoDoc		takes nothing, returns STATUS
	Turns a root container to the page pointed to by its internal pointer.

 Send this message after a series of msgRCAppNextDoc or msgRCAppPrevDoc
 calls to force the page turn to happen.
*/
#define msgRCAppExecuteGotoDoc			MakeMsg(clsRootContainerApp, 3)

/****************************************************************************
 msgRCAppCancelGotoDoc		takes P_UUID, returns STATUS
	Resets a root container's internal pointer to the current document.

 Send this message after a series of msgRCAppNextDoc or msgRCAppPrevDoc
 calls to cancel the calls reset the root contaner's internal pointer
 to the current page.
*/
#define msgRCAppCancelGotoDoc			MakeMsg(clsRootContainerApp, 4)

/****  Random Access Messages  ****/
/*
 * The next two messages provide random access to documents within
 * the target root container.  
 */
/****************************************************************************
 msgRCAppGotoContents		takes nothing, returns STATUS
	Turns a root container to its contents page.

 Send this message to a root container to force it to turn to its table of 
 contents.
*/
#define msgRCAppGotoContents			MakeMsg(clsRootContainerApp, 5)

/****************************************************************************
 msgRCAppGotoDoc			takes P_RCAPP_GOTO_DOC, returns STATUS
	Turns a root container to a document, or floats the document over
    the current page.

 Send this message to a root container to turn to or float a document.
 The specified document must be within the root container.
*/
#define msgRCAppGotoDoc					MakeMsg(clsRootContainerApp, 6)

typedef struct RCAPP_GOTO_DOC {
	BOOLEAN		gotoDoc;					// True=turn to, False=float.
	UUID		docUUID;					// UUID of target document.
	UUID		reserved1;                  // Reserved.
	U32			reserved2[2];	            // Reserved.
	char		reserved3[nameBufLength];   // Reserved.
	U32			reserved4[4];	            // Reserved.
} RCAPP_GOTO_DOC, *P_RCAPP_GOTO_DOC;

#endif	// RCAPP_INCLUDED
