/****************************************************************************
 File: pport.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.11  $
   $Author:   jgarrett  $
     $Date:   10 Mar 1992 16:24:40  $

 This file contains the API definition for clsParallelPort.
 clsParallelPort inherits from clsMILService. 

 This mil service provides the interface between the parallel printer
 mil device and the rest of Penpoint.  This interface allows for the
 configuring of the parallel printer mil device and for printing using
 the parallel printer mil device.  The pport mil service will typically
 only be accessed by printer drivers since they are responsible for
 rendering an image for printing.

 You access this mil service by using the standard service access techniques.
 These techniques are discribed in servmgr.h.

 The pport mil service is a member of the 'theParallelDevices' and
 'thePrinterDevices' service managers.

****************************************************************************/

#ifndef PPORT_INCLUDED
#define PPORT_INCLUDED

#ifndef GO_INCLUDED
#include <go.h>
#endif

#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
#endif

#ifndef MIL_SERVICE_INCLUDED
#include <milserv.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *				Common #defines and typedefs							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef OBJECT			PPORT, *P_PPORT;


#define stsPPortBusy         MakeStatus(clsParallelPort, 1)
#define stsPPortOutOfPaper   MakeStatus(clsParallelPort, 2)
#define stsPPortOffLine      MakeStatus(clsParallelPort, 3)
#define stsPPortNoPrinter    MakeStatus(clsParallelPort, 4)
#define stsPPortPrinterErr   MakeStatus(clsParallelPort, 5)



typedef struct PPORT_METRICS
{
	U16		version;			// version number of pport
	U16		devFlags;			// device flags (none defined)
	U16		unitFlags;			// unit flags (see dvparall.h)
	U32		initDelay;			// time in microSeconds init signal
								// is applied to printer
	U32		interruptTimeOut;	// the printer should be ready to accept
								// another character within this time
								// period (in milliseconds)
} PPORT_METRICS, *P_PPORT_METRICS;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Parallel Port Class Messages						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgPPortStatus	takes P_PPORT_STATUS, returns STATUS
	returns the current hardware status of the printer.

	'pportStatus' is the contents of the parallel port status register.

*/

#define msgPPortStatus					MakeMsg(clsParallelPort, 3)

#define pportStsBusy					flag7	// printer is busy
#define pportStsAcknowledge				flag6	// printer acknowledged char.
#define pportStsEndOfPaper				flag5	// printer out of paper
#define pportStsSelected				flag4	// printer on line
#define pportStsIOError					flag3	// printer error occurred
#define pportStsInterruptHappened		flag2	// printer interrupt occurred

typedef struct PPORT_STATUS
{
	U16	pportStatus;
} PPORT_STATUS, *P_PPORT_STATUS;


/****************************************************************************
 msgPPortStatus	takes P_NULL, returns STATUS
	initializes the printer.

	The printer is initialized by asserting the control
	line "Initialize" to the printer for initDelay microseconds.

*/

#define msgPPortInitialize				MakeMsg(clsParallelPort, 4)


/****************************************************************************
 msgPPortAutoLineFeedOn	takes P_NULL, returns STATUS
	inserts a line feed after each carriage return.

	The auto line feed signal to the printer is set active.

*/

#define msgPPortAutoLineFeedOn		MakeMsg(clsParallelPort, 5)


/****************************************************************************
 msgPPortAutoLineFeedOff	takes P_NULL, returns STATUS
	disables inserting a line feed after each carriage return.

	The auto line feed signal to the printer is set inactive.

*/

#define msgPPortAutoLineFeedOff		MakeMsg(clsParallelPort, 6)


/****************************************************************************
 msgPPortGetTimeDelays	takes P_PPORT_TIME_DELAYS, returns STATUS
	gets the initialization and interrupt time out intervals.	

	The initialization time period is the time the initialization pulse
	is asserted to the printer in microseconds.  The interrupt time out
	interval is the maximum time the printer will assert busy before being
	ready to accept another character in milliseconds.

*/

#define msgPPortGetTimeDelays			MakeMsg(clsParallelPort, 7)

typedef struct PPORT_TIME_DELAYS
{
	U32	initDelay;					// initialization delay
	U32	interruptTimeOut;			// interrupt time out
								
								
} PPORT_TIME_DELAYS, *P_PPORT_TIME_DELAYS;


/****************************************************************************
 msgPPortSetTimeDelays	takes P_PPORT_TIME_DELAYS, returns STATUS
	sets the initialization and interrupt time out intervals.

	Neither value can be zero.  It's best to get the present
	values before changing the time intervals.

*/

#define msgPPortSetTimeDelays			MakeMsg(clsParallelPort, 8)

/****************************************************************************
 msgPPortCancelPrint	takes P_NULL, returns STATUS
	cancels the printing of the buffer currently being printed.

*/

#define msgPPortCancelPrint				MakeMsg(clsParallelPort, 9)

/****************************************************************************
 msgNew	takes P_PPORT_NEW, returns STATUS
	creates a new pport object.

*/

#define pportNewFields		\
	milServiceNewFields

typedef struct PPORT_NEW {
	pportNewFields
} PPORT_NEW, *P_PPORT_NEW;


STATUS EXPORTED ClsParallelPortInit(void);

#endif	// PPORT_INCLUDED

