/****************************************************************************
 File: power.h
 
 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.10  $                                 
   $Author:   mnudelma  $                               
     $Date:   21 Feb 1992 15:27:14  $                 

 This file contains the API definition for class clsPowerButton.  

 clsPowerButton inherits from clsObject.
 "thePowerButton" is a well known object that provides notification when 
 the machine is turned off and on.
****************************************************************************/

#ifndef POWER_INCLUDED
#define POWER_INCLUDED

#ifndef GO_INCLUDED
#include <go.h>
#endif
#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
#endif


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *	Messages                                             			  	   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/****************************************************************************
 msgPBMachinePoweringUp takes nothing, returns nothing
	category: observer notification
	Notifies clients that the machine is powering up.

 Sent by the system to observers of thePowerButton.  Indicates that
 the machine is in the process of powering up.  
 
 The system will not power up until all observers of thePowerButton are
 notified.  The system will wait until the notification message has 
 completed for each client.
*/
#define msgPBMachinePoweringUp              MakeMsg(clsPowerButton, 1)

/****************************************************************************
 msgPBMachinePoweringDown takes nothing, returns nothing
	category: observer notification
	Notifies clients that the machine is powering down.

 Sent by the system to observers of thePowerButton.  Indicates that
 the machine is in the process of powering down.

 Most applications do not need to observe the power button, since
 theSystem sends the appropriate messages to all applications and
 services when the machine powers down.

 The system will not power down until all observers of thePowerButton are
 notified.  The system will wait until the notification message has 
 completed for each client.
*/
#define msgPBMachinePoweringDown             MakeMsg(clsPowerButton, 2)

#endif	// POWER_INCLUDED

