/****************************************************************************
 File: pagenum.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.48  $
   $Author:   cmeyer  $
     $Date:   16 Mar 1992 17:35:56  $

 This file contains the API definition for clsPageNum.

 clsPageNum inherits from clsLabel.

 Page numbers are the standard notebook frame decorations which display
 the current page number.
****************************************************************************/
#ifndef PAGENUM_INCLUDED
#define PAGENUM_INCLUDED

													#ifndef LABEL_INCLUDED
#include <label.h>
													#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef OBJECT PAGE_NUM;

typedef struct PAGE_NUM_STYLE {
	U16	spare		: 16;	// unused (reserved)
} PAGE_NUM_STYLE, *P_PAGE_NUM_STYLE;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Messages									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew		takes P_PAGE_NUM_NEW, returns STATUS
	category: class message
	Creates a pagenum window.
*/

typedef struct PAGE_NUM_NEW_ONLY {
	PAGE_NUM_STYLE	style;
	U32				pageNumber;	// initial page number
	U32				spare;		// unused (reserved)
} PAGE_NUM_NEW_ONLY, *P_PAGE_NUM_NEW_ONLY;

#define	pageNumNewFields	\
	labelNewFields			\
	PAGE_NUM_NEW_ONLY		pageNum;

typedef struct PAGE_NUM_NEW {
	pageNumNewFields
} PAGE_NUM_NEW, *P_PAGE_NUM_NEW;

/****************************************************************************
 msgNewDefaults				takes P_PAGE_NUM_NEW, returns STATUS
	category: class message
	Initializes the PAGE_NUM_NEW structure to default values.

 Zeroes out pArgs->pageNum and sets
//{
	pArgs->border.style.leftMargin = bsMarginMedium;
	pArgs->border.style.rightMargin = bsMarginMedium;
	pArgs->border.style.bottomMargin = bsMarginSmall;
	pArgs->border.style.topMargin = bsMarginMedium;

	pArgs->label.style.xAlignment = lsAlignRight;
	pArgs->label.style.yAlignment = lsAlignCenter;
//}   
*/


/****************************************************************************
 msgPageNumGetStyle		takes P_PAGE_NUM_STYLE, returns STATUS
	Passes back the current style values.
*/
#define msgPageNumGetStyle	  	MakeMsg(clsPageNum, 1)

/****************************************************************************
 msgPageNumSetStyle		takes P_PAGE_NUM_STYLE, returns STATUS
	Sets the style values.
*/
#define msgPageNumSetStyle	  	MakeMsg(clsPageNum, 2)

/****************************************************************************
 msgPageNumGet		takes P_U32, returns STATUS
	Passes back the current page number.
*/
#define msgPageNumGet		  	MakeMsg(clsPageNum, 3)

/****************************************************************************
 msgPageNumSet		takes U32, returns STATUS
	Sets the current page number.
*/
#define msgPageNumSet		  	MakeMsg(clsPageNum, 4)

/****************************************************************************
 msgPageNumIncr		takes S32, returns STATUS
	Increments the current page number.
*/
#define msgPageNumIncr		  	MakeMsg(clsPageNum, 5)

#endif	// PAGENUM_INCLUDED
