/****************************************************************************
 ostypes.h
 Copyright 1992, GO Corporation, All Rights Reserved

 Module Description:
 This include file describes types for the Penpoint kernel.

 $Revision:   1.31  $
   $Author:   twiegman  $
	 $Date:   24 Feb 1992 17:03:40  $
****************************************************************************/
#ifndef OSTYPES_INCLUDED
#define OSTYPES_INCLUDED


#ifndef GO_INCLUDED
#include <go.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Defines									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* Status values: errors */
#define stsOSBadPointer					MakeStatus(clsOS, 1)
#define stsOSOutOfMem					stsOutOfMem
#define stsOSNoMoreOwners				MakeStatus(clsOS, 3)
#define stsOSInvalidPath				MakeStatus(clsOS, 4)
#define stsOSNoSemaExists				MakeStatus(clsOS, 5)
#define stsOSTimeOut					MakeStatus(clsOS, 6)
#define stsOSSemaReset					MakeStatus(clsOS, 7)
#define stsOSAliasesExist				MakeStatus(clsOS, 8)
#define stsOSInvalidOperationForTask	MakeStatus(clsOS, 9)
#define stsOSInvalidTaskId				MakeStatus(clsOS, 10)
#define stsOSTransactionInvalid			MakeStatus(clsOS, 11)
#define stsOSRequestTooBig				MakeStatus(clsOS, 12)
#define stsOSHeapIntegrityError			MakeStatus(clsOS, 13)
#define stsOSInvalidHeapId				MakeStatus(clsOS, 14)
#define stsOSSegmentDiscarded			MakeStatus(clsOS, 16)
#define stsOSFlashEraseFailure			MakeStatus(clsOS, 17)
#define stsOSFlashProgramFailure		MakeStatus(clsOS, 18)
#define stsOSBadExeFormat				MakeStatus(clsOS, 19)
#define stsOSInstallInternalError		MakeStatus(clsOS, 20)
#define stsOSMissingEntryName			MakeStatus(clsOS, 21)
#define stsOSMissingEntryOrdinal		MakeStatus(clsOS, 22)
#define stsOSInitiateInternalError		MakeStatus(clsOS, 23)
#define stsOSInitiateStackOverflow		MakeStatus(clsOS, 24)
#define stsOSProgInstallError			MakeStatus(clsOS, 25)
#define stsOSTooManySelectors			MakeStatus(clsOS, 26)
#define stsOSTooManyInstances			MakeStatus(clsOS, 27)
#define stsOSDependenciesExist			MakeStatus(clsOS, 28)
#define stsOSTooManyRequireds			MakeStatus(clsOS, 29)
#define stsOSPathTooLong				MakeStatus(clsOS, 30)
#define stsOSModuleNotFound				MakeStatus(clsOS, 31)
#define stsOSBadDLCFormat				MakeStatus(clsOS, 32)
#define stsOSMissingDependency			MakeStatus(clsOS, 33)
#define stsOSInvalidProgramHandle		MakeStatus(clsOS, 34)
#define stsOSHeapOpen                   MakeStatus(clsOS, 35)
#define stsOSHeapNotOpen                MakeStatus(clsOS, 36)

/* Status values: warnings */
#define stsOSSemaLockBroken				MakeWarning(clsOS, 1)

/* Misc defines */
#define osNullTaskId			((OS_TASK_ID)NULL)
#define osNullOpenSema			((OS_SEMA_ID)NULL)
#define osInvalidHandle			((OS_HANDLE)NULL)
#define osInfiniteTime			0xFFFFFFFF
#define maxModNameLength		32

/* Well known heap ids */
#define osInvalidHeapId			((OS_HEAP_ID)0)
#define osProcessHeapId			((OS_HEAP_ID)&OSProcessHeapValue)
#define osProcessSharedHeapId	((OS_HEAP_ID)OSThisProcess())

/* Filters */
#define osAnyITMessage				0xFFFFFFFF
#define osStartupCommandLineFilter	flag0
#define osClsmgrSend				flag0
#define osClsmgrReply				flag1
#define osMILFilter					flag2
#define osAppSend					flag3
#define osAppReply					flag4
#define osTestManagerFilter			flag5
#define osClsmgrPost				flag6
#define osInstallWaitingFilter		flag30
#define osTerminatedTaskFilter		flag31

/* NOTE: flag25 - flag29 reserved for users */
#define userDefinedFilters			(flag25|flag26|flag27|flag28|flag29)

#define objSendFilter				((OS_ITMSG_FILTER)osClsmgrSend)
#define objReplyFilter				((OS_ITMSG_FILTER)osClsmgrReply)

/*
 Used to treat the intNum field as a hardware interrupt level (vs a MIL
 logical device id) in the routines OSSetInterrupt, OSIntMask and OSIntEOI.
*/
#define	osIntNumIsHardwareLevel		flag15


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Typedefs								   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef P_UNKNOWN				P_MEM;				// Pointer to memory
typedef U32						OS_HANDLE;			// Handle to an object
typedef U16						OS_TASK_ID;			// Task Id
typedef OS_HANDLE				OS_SEMA_ID;			// Open semaphore Id
typedef P_UNKNOWN				OS_PROG_HANDLE;		// Loaded program handle
typedef OS_HANDLE				OS_ITMSG_ID;		// message identifier
typedef U32						OS_ITMSG_FILTER;	// Inter-task msg filter
typedef U16						OS_INTERRUPT_ID;	// logical interrupt ID
typedef U32						OS_MILLISECONDS;	// number of milliseconds
typedef U32						OS_TASK_ERROR;

typedef P_MEM*					PP_MEM;
typedef OS_HANDLE*				P_OS_HANDLE;
typedef OS_TASK_ID*				P_OS_TASK_ID;
typedef OS_SEMA_ID*				P_OS_SEMA_ID;
typedef OS_PROG_HANDLE*			P_OS_PROG_HANDLE;
typedef OS_ITMSG_ID*			P_OS_ITMSG_ID;
typedef OS_ITMSG_FILTER*		P_OS_ITMSG_FILTER;
typedef OS_TASK_ERROR*			P_OS_TASK_ERROR;

typedef P_UNKNOWN				OS_HEAP_ID, * P_OS_HEAP_ID;

typedef enum OS_TASK_MODE {
  osThisTaskOnly,				// "act" on this task only
  osTaskFamily,					// "act" on all tasks in the task family
  osAllTasks					// "act" on all tasks in the system
} OS_TASK_MODE, * P_OS_TASK_MODE;

typedef enum OS_PRIORITY_CLASS {
  osDefaultClass,				// use existing class
  osHighPriority,				// the class is "high priority"
  osMedHighPriority,			// the class is "med high priority"
  osMedLowPriority,				// the class is "med low priority"
  osLowPriority					// the class is "low priority"
} OS_PRIORITY_CLASS, * P_OS_PRIORITY_CLASS;

typedef struct OS_ITMSG_INFO* P_OS_ITMSG_INFO;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Public Functions							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 OSThisProcess	returns OS_TASK_ID
	Passes back the task id of this tasks process.

 Note: This function is defined here (instead of in os.h) to satisfy the
 definition for osProcessSharedHeapId above.
*/
OS_TASK_ID EXPORTED0 OSThisProcess(void);

//REFGEN BEGINIGNORE

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Private Variable							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*	PRIVATE: Represents the heap in each process, use osProcessHeapId */
extern P_UNKNOWN OSProcessHeapValue;

//REFGEN ENDIGNORE

#endif // OSTYPES_INCLUDED
