/****************************************************************************
 File: mcicon.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.21  $
   $Author:   cmeyer  $
     $Date:   16 Mar 1992 17:35:40  $

 This file contains the API definition for clsMoveCopyIcon.

 clsMoveCopyIcon inherits from clsIcon.

 Move-copy icons support the move/copy UI.
 Move-copy icon with drag style mcDragMove will appear with a single marquee.
 Move-copy icon with drag style mcDragCopy will appear with a double marquee.
****************************************************************************/
#ifndef MCICON_INCLUDED
#define MCICON_INCLUDED

													#ifndef ICON_INCLUDED
#include <icon.h>
													#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef OBJECT MOVE_COPY_ICON;

/****  Drag Styles  ****/
#define	mcDragNone				0	// disabled
#define	mcDragMove				1	// drag means move
#define	mcDragCopy				2	// drag means copy
//								3	// unused (reserved)

typedef struct MOVE_COPY_ICON_STYLE {
	U16	move				: 2,	// private
		copy				: 2,	// private
		drag				: 2,	// drag behavior
		destroyOnSelChange	: 1,	// destroy self on msgSelChangedOwners
		spare	  			: 9;	// unused (reserved)
} MOVE_COPY_ICON_STYLE, *P_MOVE_COPY_ICON_STYLE;


/* tag for clsTrack instances created by clsMoveCopyIcon */
#define	tagMoveCopyIconTrack			MakeTag(clsMoveCopyIcon, 1)

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Messages									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew		takes P_MOVE_COPY_ICON_NEW, returns STATUS
	category: class message
	Creates a move-copy icon window.

 If style.drag is not mcDragNone, sets the following:
//{
	pArgs->win.flags.input |= inputMoveDown | inputMoveDelta;
	pArgs->win.flags.input &= ~inputLRContinue;

	pArgs->gWin.style.gestureEnable = false;

	pArgs->border.style.edge			= bsEdgeAll;
	pArgs->border.style.leftMargin		= bsMarginSmall;
	pArgs->border.style.rightMargin		= bsMarginSmall;
	pArgs->border.style.bottomMargin	= bsMarginSmall;
	pArgs->border.style.topMargin		= bsMarginSmall;
	pArgs->border.style.borderInk		= bsInkBlack;
	pArgs->border.style.lineStyle		= 
		(pArgs->moveCopyIcon.style.drag == mcDragMove) ? 
		bsLineMarquee : bsLineDoubleMarquee;
	pArgs->border.style.selected		= true;
//}

 Note that if you set style.destroyOnSelChanged to true, you must
 add the move copy icon as an observer of theSelectionManager to have
 the move copy icon notified when the selection changes.
*/

typedef struct MOVE_COPY_ICON_NEW_ONLY {
	MOVE_COPY_ICON_STYLE 		style;			// overall style
	U32							spare;			// unused (reserved)
} MOVE_COPY_ICON_NEW_ONLY, *P_MOVE_COPY_ICON_NEW_ONLY;

#define	moveCopyIconNewFields		\
	iconNewFields					\
	MOVE_COPY_ICON_NEW_ONLY			moveCopyIcon;

typedef struct MOVE_COPY_ICON_NEW {
	moveCopyIconNewFields
} MOVE_COPY_ICON_NEW, *P_MOVE_COPY_ICON_NEW;

/****************************************************************************
 msgNewDefaults				takes P_MOVE_COPY_ICON_NEW, returns STATUS
	category: class message
	Initializes the MOVE_COPY_ICON_NEW structure to default values.

 Zeroes out pArgs->moveCopyIcon and sets
//{
	pArgs->moveCopyIcon.style.move = mcMoveCopyEnable;
	pArgs->moveCopyIcon.style.copy = mcMoveCopyEnable;
//}
*/
/*
 Default MOVE_COPY_ICON_STYLE:
//{
 	drag				= mcDragNone
 	destroyOnSelChange	= false
//}
*/

/****************************************************************************
 msgMoveCopyIconGetStyle		takes P_MOVE_COPY_ICON_STYLE, returns STATUS
	Passes back the current style values.
*/
#define msgMoveCopyIconGetStyle		MakeMsg(clsMoveCopyIcon, 1)

/****************************************************************************
 msgMoveCopyIconSetStyle		takes P_MOVE_COPY_ICON_STYLE, returns STATUS
	Sets the style values.

 Note that changing style.drag is not implemented.
*/
#define msgMoveCopyIconSetStyle		MakeMsg(clsMoveCopyIcon, 2)

/****************************************************************************
 msgMoveCopyIconDone		takes P_MOVE_COPY_ICON_DONE, returns STATUS
	category: client notification
	Sent to the control.client when the icon completes move or copy mode.

 If the client responds with stsRequestDenied, stsMessageIgnored, or
 a status < stsOK, the moveCopyIcon will be jumped to pArgs->rect.origin
 and the single or double marquee will be restarted.  Otherwise, msgDestroy
 will be self-sent.
*/
#define msgMoveCopyIconDone		MakeMsg(clsMoveCopyIcon, 6)

typedef struct MOVE_COPY_ICON_DONE {
	WIN			icon;		// icon sending msg
	BOOLEAN		move;		// true for Move, false for Copy
	WIN			dest;		// destination window to move/copy to
	XY32		destXY;		// point to move/copy to in dest space
	XY32		penOffset;	// offset of pen from icon origin (grab point)
	SIZE32		iconSize;	// unused (reserved)
	U32			spare1;		// unused (reserved)
	U32			spare2;		// unused (reserved)
	U32			spare3;		// unused (reserved)
} MOVE_COPY_ICON_DONE, *P_MOVE_COPY_ICON_DONE;


/****************************************************************************
 msgMoveCopyIconCancel		takes OBJECT, returns STATUS
	category: client notification
	Sent to the control.client when the icon cancels move or copy mode.

 clsMoveCopyIcon will send self as pArgs.  This is sent when
 style.destroyOnSelChange is true, and msgSelChangedOwners is received.
*/
#define msgMoveCopyIconCancel	MakeMsg(clsMoveCopyIcon, 5)


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *				    Messages from other classes							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/****************************************************************************
 msgInputEvent 					takes P_INPUT_EVENT, returns STATUS
	Notification of an input event. 

 If style.drag is not mcDragNone, clsMoveCopyIcon responds as follows:

	If pArgs->devCode is msgPenMoveDown and the pen has moved beyond 
	a defined threshold, or pArgs->devCode is msgPenExitDown, an instance of
	clsTrack will be created to	indicate the move/copy.

	If pArgs->devCode is msgPenUp, and msgPenDown has already been seen,
	msgMoveCopyIconCancel is sent to the client.
*/


/****************************************************************************
 msgTrackProvideMetrics			takes P_TRACK_METRICS, returns STATUS
	category: third-party notification
	Sent to a track client before track is created.

 If pArgs->tag is tagMoveCopyIconTrack, msgTrackProvideMetrics(pArgs) is sent
 to the moveCopyIcon's client.
*/

/****************************************************************************
 msgTrackDone					takes P_TRACK_METRICS, returns STATUS
	category: client notification
	Sent by a tracker when it's done.

 clsMoveCopyIcon will hit-detect pArgs->curXY to locate the window
 over which the track was dropped.  The client will be sent
 msgMoveCopyIconDone with the following MOVE_COPY_ICON_DONE parameters:
//{
		icon		= self;
		move		= true for move, false for copy;
		dest		= destination window;
		destXY		= pArgs->curXY in dest window's space;
		penOffset	= pArgs->curXY in pArgs->rect-relative space;
//}
*/
#define msgTrackDone			MakeMsg(clsTrack, 6)

/****************************************************************************
 msgSelChangedOwners	takes P_SEL_OWNERS, returns STATUS
	Notify the observers when either of the selection owners have changed.

 If style.destroyOnSelChange is true, clsMoveCopyIcon will send
 msgMoveCopyIconCancel(self) to its client followed by msgDestroy to
 self.
*/


//REFGEN BEGINIGNORE

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *               Private Messages                                          *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****  Note: these may all be removed in a future release  ****/

/****  Move/Copy Styles  ****/
#define	mcMoveCopyNone			0	// disabled
#define	mcMoveCopyEnable		1	// enabled
#define	mcMoveCopyMap			2	// map move to copy or copy to move
//								3	// unused (reserved)

/****************************************************************************
 msgMoveCopyIconMove		takes pNull, returns STATUS
	Puts the icon in move mode, creating a copy of the icon as a child of
	theRootWindow.
*/
#define msgMoveCopyIconMove			MakeMsg(clsMoveCopyIcon, 7)

/****************************************************************************
 msgMoveCopyIconCopy		takes pNull, returns STATUS
	Puts the icon in copy mode, creating a copy of the icon as a child of
	theRootWindow.
*/
#define msgMoveCopyIconCopy			MakeMsg(clsMoveCopyIcon, 8)

/****************************************************************************
 msgMoveCopyIconAbort		takes pNull, returns STATUS
	Exits from move or copy mode, destroying the copy of the icon.
*/
#define msgMoveCopyIconAbort			MakeMsg(clsMoveCopyIcon, 9)

/****************************************************************************
 msgMoveCopyIconBeginMove		takes OBJECT, returns STATUS
	category: client notification
	Sent to the control.client when the icon enters move mode.

 clsMoveCopyIcon will send self as pArgs.
*/
#define msgMoveCopyIconBeginMove	MakeMsg(clsMoveCopyIcon, 3)

/****************************************************************************
 msgMoveCopyIconBeginCopy		takes OBJECT, returns STATUS
	category: client notification
	Sent to the control.client when the icon enters copy mode.

 clsMoveCopyIcon will send self as pArgs.
*/
#define msgMoveCopyIconBeginCopy	MakeMsg(clsMoveCopyIcon, 4)

//REFGEN ENDIGNORE

#endif	// MCICON_INCLUDED

