/*
 *  malloc.h    Memory allocation functions
 *
 *  Copyright (C) by WATCOM Systems Inc. 1988-1991.  All rights reserved.
 */
#ifndef _MALLOC_H_INCLUDED

#pragma pack(1);

#ifndef _SIZE_T_DEFINED_
#define _SIZE_T_DEFINED_
typedef unsigned size_t;
#endif

#if defined(__SMALL__) || defined(__MEDIUM__) || defined(__386__)
 #define NULL   0
#else
 #define NULL   0L
#endif

void  *alloca(size_t __size);
void  *_alloca(size_t __size);

#define __ALLOCA_ALIGN( s )      (((s)+(sizeof(int)-1))&~(sizeof(int)-1))

#define alloca(size) _alloca(__ALLOCA_ALIGN(size))

#if defined(__386__)
#pragma aux     _alloca = 0x29 0xc4      /* sub esp,eax */\
                          0x8B 0x04 0x24 /* mov eax,[esp] (touch stack) */\
                          0x89 0xe0      /* mov eax,esp */\
                        parm caller [eax] value[eax] modify [esp];
#elif defined(__SMALL__) || defined(__MEDIUM__) /* small data models */
#pragma aux     _alloca = 0x29 0xc4 /* sub sp,ax */\
                          0x89 0xe0 /* mov ax,sp */\
                        parm caller [ax] value[ax] modify [sp];
#else                                           /* large data models */
#pragma aux     _alloca = 0x29 0xc4 /* sub sp,ax */\
                          0x89 0xe0 /* mov ax,sp */\
                          0x8c 0xd2 /* mov dx,ss */\
                        parm caller [ax] value[ax dx] modify [sp];
#endif

void *calloc( size_t __n,size_t __size );
void free( void *__ptr );
void *malloc( size_t __size );
void *realloc( void *__ptr,size_t __size );
void *_smalloc( size_t __size );

#pragma pack();

#define _MALLOC_H_INCLUDED
#endif
