/****************************************************************************
 File: itable.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.3  $
   $Author:   kcatlin  $
     $Date:   16 Mar 1992 08:45:54  $

 This file contains the API for clsIconChoice.

 clsIconTable inherits from clsToggleTable.
 IconTables are non-exclusive toggle tables with icon buttons and boxed-style
 previewing/on feedback.

 See the documentation for msgTkTableChildDefaults below.
****************************************************************************/

#ifndef ITABLE_INCLUDED
#define ITABLE_INCLUDED

												#ifndef TTABLE_INCLUDED
#include <ttable.h>
												#endif

												#ifndef ICON_INCLUDED
#include <icon.h>
												#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef OBJECT ICON_TABLE;

typedef struct ICON_TABLE_STYLE {
	U16	spare   : 16;  // unused (reserved)
} ICON_TABLE_STYLE, *P_ICON_TABLE_STYLE;

/****************************************************************************
 msgNew						takes P_ICON_TABLE_NEW, returns STATUS
	category: class message
	Creates an iconTable (and its nested icon windows).
*/

typedef struct ICON_TABLE_NEW_ONLY {
	ICON_TABLE_STYLE	style;		// overall style
	ICON_NEW			iconNew;	// storage for default child new struct
	U32					spare;		// unused (reserved)
} ICON_TABLE_NEW_ONLY, *P_ICON_TABLE_NEW_ONLY;

#define	iconTableNewFields	\
	toggleTableNewFields	\
	ICON_TABLE_NEW_ONLY		iconTable;

typedef struct ICON_TABLE_NEW {
	iconTableNewFields
} ICON_TABLE_NEW, *P_ICON_TABLE_NEW;


/****************************************************************************
 msgNewDefaults				takes P_ICON_TABLE_NEW, returns STATUS
	category: class message
	Initializes the ICON_TABLE_NEW structure to default values.

 Sets up pArgs->tkTable.pButtonNew to create instances of clsIcon with
 boxed-style previewing/on feedback by default as follows:
//{
	pButtonNew->button.style.feedback	= bsFeedbackBox;
	pButtonNew->button.style.contact	= bsContactToggle;
//}
 Zeroes out pNew.iconTable.
*/


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *				    Messages from Other Classes							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgTkTableChildDefaults		takes P_UNKNOWN, returns STATUS
	Sets the defaults in P_ARGS for a common child.

 Here is how an iconTable processes this message:

//{
	if <pArgs->object.class inherits from clsButton> {
		pArgs->button.style.feedback = bsFeedbackBox;
	}
//}
*/


#endif	// ITABLE_INCLUDED
