/****************************************************************************
 File: install.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.46  $
   $Author:   rfoster  $
     $Date:   27 Feb 1992 23:14:42  $

 This file contains definitions for IMProgramInstall and IMModuleLoad.  The
 functions described in this file are contained in INSTALL.LIB.

 APPLICATION DEVELOPERS MUST USE THESE FUNCTIONS INSTEAD OF 
 OSProgramInstall AND OSModuleLoad.
 
 OSProgramInstall and OSModuleLoad do not dispatch messages, because they
 are Ring 0 routines. This will cause the system to lock up if the code
 being loaded needs to send messages to the process that installed it,
 as all applications and services do. 

****************************************************************************/

#ifndef INSTALL_INCLUDED
#define INSTALL_INCLUDED

/****************************************************************************
 IMProgramInstall	returns STATUS
	Low-level .exe installation routine.

*/
STATUS EXPORTED IMProgramInstall(
    P_STRING 				pPath,		// WorkingDir relative path of 
										//   .exe or .dlc file          
    P_STRING 				pWorkingDir,// WorkingDir relative path of where
										//   to set the WorkingDir of the
										//   instance 0's process          
	P_OS_PROG_HANDLE 		pProgHandle,// Out: program handle   
    P_STRING 				pBadName,   // Out: if error, dll/exe that was bad
		                                //   Buffer must be nameBufLength
    P_STRING 				pBadRef		// Out: If error, reference that was bad
);		                                //   Buffer must be nameBufLength


/****************************************************************************
 IMModuleLoad	returns STATUS
	Low-level .dll installation routine.

*/
STATUS EXPORTED IMModuleLoad(
    P_STRING 				pPath,		// WorkingDir relative path of 
										//   .dll or .dlc file          
    P_STRING 				pWorkingDir,// WorkingDir relative path of where
										//   to set the WorkingDir of the
										//   DLLMain() process          
	P_OS_PROG_HANDLE 		pProgHandle,// Out: program handle   
    P_STRING 				pBadName,   // Out: if error, dll that was bad
		                                //   Buffer must be nameBufLength
    P_STRING 				pBadRef		// Out: If error, reference that was bad
);		                                //   Buffer must be nameBufLength

#endif // INSTALL_INCLUDED
