/****************************************************************************
 File: iconwin.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.24  $
   $Author:   pstahl  $
     $Date:   06 Mar 1992 12:59:10  $

 This file contains the API definition for clsIconWin.

 clsIconWin inherits from clsTkTable.
 Icon windows are windows that contain a number of embedded windows.

 Icon windows can manage their children icons to give them uniform
 appearance and layout.  Icon windows can also force their icons to
 open floating, and they can deny the ability of users to set icon
 options.  Examples of icon window subclasses are the Bookshelf,
 Accessories, and the Cork Margin.
****************************************************************************/
#ifndef ICONWIN_INCLUDED
#define ICONWIN_INCLUDED

                                            #ifndef TKTABLE_INCLUDED
#include <tktable.h>
                                            #endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef OBJECT ICON_WIN, *P_ICON_WIN;

/****  Icon Window Style  ****/
/*
 This structure defines the various icon window styles.
 The fields are as follows:

    -: iconType             What appearance to give the icons.  The
                            values for this field are defined in appwin.h,
                            and are things like awPictAndTitle (large
                            icon over label), awPictOnly (large icon),
                            awSmallPictAndTitle (small icon to the left
                            of a label), awSmallPictOnly (small icon), and
                            awSmallPictOverTitle (small icon over label).
    -: propagateIconType    If this field is true, all icons in the icon
                            window are forced to have the same iconType.
                            If the user changes one icon's iconType, all
                            icons in the icon window will change to match.
    -: allowOpenInPlace     If this field is true, documents will be able
                            to open inside the icon window.  If false,
                            documents will always open floating.
    -: constrainedLayout    If this field is true, the icon window will
                            arrange icons into neat rows and columns.  An
                            icon dragged to a new location in the icon
                            window will be "snapped" into place.  If this
                            field is false, icons are left where they're
                            dropped.
    -: showOptions          If this field is true, users may make the
                            check gesture over an icon in the icon window
                            to bring up the icon option sheet.  If it is
                            false, the check gesture will be rejected.
*/
 

typedef struct ICON_WIN_STYLE {
	U16	iconType		  : 4;	// Use AppWin icon types (see appwin.h).
	U16	propagateIconType : 1;  // True = all icons in win are same type.
	U16	allowOpenInPlace  : 1;  // False= always open floating.
	U16	constrainedLayout : 1;  // True = line up icons in rows & columns.
	U16 showOptions		  : 1;  // True = allow option sheet display.
	U16	reserved		  : 8;	// Reserved.
} ICON_WIN_STYLE, *P_ICON_WIN_STYLE;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Messages									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew         takes P_ICON_WIN_NEW, returns STATUS
    category: class message
	Creates a new icon window.
*/

typedef struct ICON_WIN_NEW_ONLY {
	ICON_WIN_STYLE	style;
	U32				reserved[4];
} ICON_WIN_NEW_ONLY, *P_ICON_WIN_NEW_ONLY;

#define	iconWinNewFields		\
	tkTableNewFields			\
	ICON_WIN_NEW_ONLY			iconWin;

typedef struct ICON_WIN_NEW {
	iconWinNewFields
} ICON_WIN_NEW, *P_ICON_WIN_NEW;

/****************************************************************************
 msgNewDefaults         takes P_ICON_WIN_NEW, returns STATUS
    category: class message
	Initializes the ICON_WIN_NEW structure to default values.

 Zeroes out pArgs->iconWin and sets
//{
	pArgs->win.flags.style						&= ~wsShrinkWrapWidth;
	pArgs->win.flags.style						&= ~wsShrinkWrapHeight;
	pArgs->win.flags.style						|= wsCaptureGeometry;
	pArgs->win.flags.style						|= wsClipChildren;
	pArgs->win.flags.style						|= wsHeightFromWidth;
	pArgs->gWin.style.grabDown					= false;
	pArgs->embeddedWin.style.embeddor			= true;
	pArgs->tableLayout.style.tblXAlignment		= tlAlignLeft;
	pArgs->tableLayout.style.tblYAlignment		= tlAlignBottom;
	pArgs->tableLayout.style.childXAlignment	= tlAlignCenter;
	pArgs->tableLayout.style.childYAlignment	= tlAlignCenter;
	pArgs->tableLayout.style.growChildWidth		= false;
	pArgs->tableLayout.style.growChildHeight	= false;
	pArgs->tableLayout.style.placement			= tlPlaceRowMajor;
	pArgs->tableLayout.style.senseOrientation	= false;
	pArgs->tableLayout.style.reverseX			= false;
	pArgs->tableLayout.style.reverseY			= true;
	pArgs->tableLayout.numRows.constraint		= tlInfinite;
	pArgs->tableLayout.numCols.constraint		= tlMaxFit;
	pArgs->tableLayout.rowHeight.constraint		= tlGroupMax;
	pArgs->tableLayout.rowHeight.gap			= 2;
	pArgs->tableLayout.colWidth.constraint		= tlGroupMax;
	pArgs->tableLayout.colWidth.gap				= 3;
	pArgs->iconWin.style.iconType			    = awSmallPictAndTitle;
	pArgs->iconWin.style.propagateIconType	    = false;
	pArgs->iconWin.style.allowOpenInPlace	    = false;
	pArgs->iconWin.style.constrainedLayout	    = true;
//}
 If the environment variable "ICONWIN.SHOWOPTIONS" is set,
 pArgs->iconWin.style.showOptions is set to true, otherwise false.
*/

/****************************************************************************
 msgIconWinGetMetrics	takes P_ICON_WIN_METRICS, returns STATUS
	Passes back an icon window's metrics.

 Since the icon window metrics structure currently contains no information
 other than the icon window style, use msgIconWinGetStyle instead of
 this message.
*/
#define msgIconWinGetMetrics	 				MakeMsg(clsIconWin, 1)

typedef struct ICON_WIN_METRICS {
	ICON_WIN_STYLE	style;
	U32				reserved[4];
} ICON_WIN_METRICS, *P_ICON_WIN_METRICS;

/****************************************************************************
 msgIconWinGetStyle	takes P_ICON_WIN_STYLE, returns STATUS
	Passes back an icon window's style.
*/
#define msgIconWinGetStyle		 				MakeMsg(clsIconWin, 2)

/****************************************************************************
 msgIconWinSetStyle	takes P_ICON_WIN_STYLE, returns STATUS
	Specifies an icon window's style.
*/
#define msgIconWinSetStyle		 				MakeMsg(clsIconWin, 3)

#endif	// ICONWIN_INCLUDED

