/****************************************************************************
 File: HWCUSTOM.H

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.8  $
   $Author:   pstahl  $
     $Date:   01 Apr 1992 16:39:44  $

 This file contains definitions for clsHWCustomFrame.
 clsHWCustomFrame inherits from clsFrame.

 This file contains the API definition for clsHWCustomFrame.  Instances of
 clsHWCustomFrame are created by the Settings Notebook when the user taps
 the "Customize" button on the Installed Handwriting page.  The Settings
 Notebook will pass in the handle of the prototype set to be customized.
 It is up to clsHWCustomFrame instances to carry out the customization and 
 destroy themselves when finished.
****************************************************************************/

/**** Debugging Flags ****/
/*
 clsHWCustomFrame uses the Handwriting debug flag set 'Z'.
 clsHWCustomFrame uses:

    40000:  Show all internal debugging messages

*/

#ifndef HWCUSTOM_INCLUDED
#define HWCUSTOM_INCLUDED

#ifndef FRAME_INCLUDED
#include <frame.h>
#endif

#ifndef FS_INCLUDED
#include <fs.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef struct HWCUSTOM_NEW_ONLY {
    OBJECT  protoSetHandle;     // handle of prototype set to customize
} HWCUSTOM_NEW_ONLY;

#define hwCustomNewFields \
    frameNewFields       \
    HWCUSTOM_NEW_ONLY   hwcustom;

typedef struct HWCUSTOM_NEW {
    hwCustomNewFields
} HWCUSTOM_NEW, *P_HWCUSTOM_NEW;

/****  File System Attributes  ****/

/*
 The values for the 32-bit attribute hwCustomAttrCustomizable are:

 0:  This profile is fully customizable.

 1:  This engine allows customization, but this profile is the original,
 generic profile for this engine; users must rename it before they 
 customize it. This will to prevent users from inadvertently overwriting
 the original copy of the profile on the distribution media.  If the
 attribute is 1, Handwriting Customization will pop up a dialog forcing
 the user to copy or rename the profile before customization.

 2:  This profile is not customizable.

 Any other value:  Same as 0; profile is fully customizable.

 If the attribute is missing from the directory, Customization will assume
 the profile is fully customizable.

 Here is the magic incantation to stamp the attribute on a profile:
//{
    STAMP /G "<profile>" /A 800278 <value>
//}
 For instance, the GOWrite profile gets stamped like this:
//{
    STAMP /G "GOWrite" /A 800278 1
//}
 This will stamp a value of 1 on the GOWrite directory for Admin 316
 (clsHWCustomFrame), Index 1.
*/
#define hwCustomAttrCustomizable	FSMakeFix32Attr(clsHWCustomFrame, 1)

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Messages									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNewDefaults				takes P_HWCUSTOM_NEW, returns STATUS
	category: class message
	Initializes the HWCUSTOM_NEW structure to default values.
    Default values are the same as for clsFrame, with a protoSetHandle of 0.

*/

/****************************************************************************
 msgNew		takes P_HWCUSTOM_NEW, returns STATUS
	category: class message
	Creates a handwriting customization frame window, acting on the
    handwriting prototype set in pArgs->hwcustom.protoSetHandle.
    If protoSetHandle==0, acts on theCurrentInstalledHWXProtos.

*/

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								  Quick Help Tags						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define hlpHWCustomIcon             MakeTag(clsHWCustomFrame, 0)
#define hlpHWCustomNote             MakeTag(clsHWCustomFrame, 1)
#define hlpHWCustomAlert            MakeTag(clsHWCustomFrame, 2)
#define hlpHWCustomExitNote         MakeTag(clsHWCustomFrame,25)
#define hlpHomeWinLCLabel           MakeTag(clsHWCustomFrame, 5)
#define hlpHomeWinUCLabel           MakeTag(clsHWCustomFrame, 6)
#define hlpHomeWinNumLabel          MakeTag(clsHWCustomFrame, 7)
#define hlpHomeWinSymLabel          MakeTag(clsHWCustomFrame, 8)
#define hlpHomeWinSCLabel           MakeTag(clsHWCustomFrame, 9)
#define hlpHomeWinExitLabel         MakeTag(clsHWCustomFrame,10)
#define hlpHomeWinNextArrow         MakeTag(clsHWCustomFrame, 4)
#define hlpHomeWinStatTitle         MakeTag(clsHWCustomFrame,21)
#define hlpHomeWinStatTSets         MakeTag(clsHWCustomFrame,22)
#define hlpHomeWinStatRecRt         MakeTag(clsHWCustomFrame,23)
#define hlpHomeWinStatLearn         MakeTag(clsHWCustomFrame,24)
#define hlpHomeWinStatRecom         MakeTag(clsHWCustomFrame,26)
#define hlpHomeWinInstrs            MakeTag(clsHWCustomFrame,11)
#define hlpHomeWinBlankAreas        MakeTag(clsHWCustomFrame, 3)
#define hlp26WinTitle               MakeTag(clsHWCustomFrame,12)
#define hlp26WinLearnBtn            MakeTag(clsHWCustomFrame,13)
#define hlp26WinClearBtn            MakeTag(clsHWCustomFrame,14)
#define hlp26WinNextBtn             MakeTag(clsHWCustomFrame,15)
#define hlp26WinDoneBtn             MakeTag(clsHWCustomFrame,16)
#define hlp26WinInstrs              MakeTag(clsHWCustomFrame,18)
#define hlp26WinInputLabel          MakeTag(clsHWCustomFrame,19)
#define hlp26WinInputBox            MakeTag(clsHWCustomFrame,20)
#define hlp26WinBlankAreas          MakeTag(clsHWCustomFrame,17)


#endif //HWCUSTOM_INCLUDED
