/****************************************************************************
 File: gmargin.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.15  $
   $Author:   bschwart  $
     $Date:   18 Feb 1992 15:59:54  $

 This file contains the API definition for clsGestureMargin.

 clsGestureMargin inherits from clsScrollWin.

 clsGestureMargin adds a margin to the scroll win on the opposite side from
 the scroll bar.  Gestures made in the margin are forwarded to the
 client win.

 clsGestureMargin is used in PenPoint by the MiniNote application.  MiniNote
 uses the gesture margin in lieu of a scroll win.  When MiniNote is in
 writing mode, the margin is gray.  In gesture mode, the margin is white.

 Gesture mode is intended to indicate a "safe" mode in which the 11 core
 gestures can be used.  In ink mode, some gestures do not work and be may
 interpreted as some other type of data (e.g. ink).

****************************************************************************/

#ifndef GMARGIN_INCLUDED
#define GMARGIN_INCLUDED

#ifndef SWIN_INCLUDED
#include <swin.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  Types and Constants                                                    *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define clsGestureMargin			MakeGlobalWKN(2572,1)
#define clsGestureMarginInnerWin	MakeGlobalWKN(2573,1)

typedef struct GESTURE_MARGIN_STYLE {

	U16	gestureMargin		: 1,	// gesture margin on/off
		wideGestureMargin	: 1,	// make the gesture margin wide
									// (not implemented)
		maskGestureMargin	: 1,	// mask out gestureMargin
		inkMode				: 1,	// margin is gray for if in ink mode

		reserved			:12;

} GESTURE_MARGIN_STYLE, *P_GESTURE_MARGIN_STYLE;

typedef struct {

	GESTURE_MARGIN_STYLE	style;
	S32						spares[4];

} GESTURE_MARGIN_NEW_ONLY, *P_GESTURE_MARGIN_NEW_ONLY;

#define	gestureMarginNewFields		\
	scrollWinNewFields			\
	GESTURE_MARGIN_NEW_ONLY	gestureMargin;

typedef struct {

	gestureMarginNewFields

} GESTURE_MARGIN_NEW, *P_GESTURE_MARGIN_NEW;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  Messages		                                                       *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgGestureMarginGetStyle		takes P_GESTURE_MARGIN_STYLE, returns STATUS
	Passes back the receiver's current style values.
*/
#define msgGestureMarginGetStyle	MakeMsg(clsGestureMargin, 1)

/****************************************************************************
 msgGestureMarginSetStyle		takes P_GESTURE_MARGIN_STYLE, returns STATUS
	Sets the receiver's style values.
*/
#define msgGestureMarginSetStyle	MakeMsg(clsGestureMargin, 2)

/****************************************************************************
 msgGestureMarginSetInkMode			takes BOOLEAN, returns STATUS
	Sets margin to be either ink or gesture mode.
*/
#define msgGestureMarginSetInkMode	MakeMsg(clsGestureMargin, 3)

#endif
