/*
 *  fcntl.h     File control options used by open
 *
 *  Copyright (C) by WATCOM Systems Inc. 1988-1991.  All rights reserved.
 */
#ifndef _FCNTL_H_INCLUDED

#ifndef _TYPES_H_INCLUDED
 #include <sys/types.h>
#endif

#define O_RDONLY        0x0000  /* open for read only */
#define O_WRONLY        0x0001  /* open for write only */
#define O_RDWR          0x0002  /* open for read and write */
#define O_APPEND        0x0010  /* writes done at end of file */
#define O_CREAT         0x0020  /* create new file */
#define O_TRUNC         0x0040  /* truncate existing file */
#define O_EXCL          0x0400  /* exclusive open */
#define O_SHRMEM        0x0800  /* open file for sharing across process */

int  open( const char *__path, int __oflag, ... );
int creat( const char *__path, mode_t __mode );

#define _FCNTL_H_INCLUDED
#endif
