/****************************************************************************
 File: ewnew.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.19  $
     $Date:   28 Feb 1992 15:40:44  $

 This file contains the API definition for creating embedded windows.

 See embedwin.h for information.  Essentially all of the documentation is 
 in embedwin.h.
****************************************************************************/
#ifndef EWNEW_INCLUDED
#define EWNEW_INCLUDED

#ifndef GWIN_INCLUDED
#include <gwin.h>
#endif

#ifndef UUID_INCLUDED
#include <uuid.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****  EmbeddedWin Selection Types  ****/
/*
 * Use one of these values in an embeddedWin's style.selection.
 *
 * See the section "Selection Interaction" in embedwin.h for a description
 * of each of these values.
*/
#define ewSelectUnknown			0	// take selection based on parent
									// embeddedWin's style.selection
#define ewSelect				1	// take selection via msgSelSetOwner
#define ewSelectPreserve		2	// take selection via 
									// msgSelSetOwnerPreserve

/****  Move/Copy Modes  ****/
/*
 * These are the possible values for style.moveCopyMode.  The mode is set 
 * while an embeddedWin is involved in a move/copy.  Clients and subclasses
 * must NOT alter the value of this field.
*/
#define ewMoveCopyModeOff		0
#define ewMoveMode				1
#define ewCopyMode				2

/****  Embedded Window Style  ****/
typedef struct EMBEDDED_WIN_STYLE {

	U16 embeddor		  : 1;	// Allow embedding. Causes response to 
						  		// msgGWinGesture, msgEmbeddedWinMove, 
						  		// and msgEmbeddedWinCopy.  See section
								// "Embedding."
	U16	embeddee		  : 1;	// Can be embedded. Causes embeddedWin to 
								// generate UUID.  See section "Embedding."
	U16	selection		  : 2;	// Selection style. Most clients use
						  		// ewSelectUnknown.  See section "Selection
								// Interaction."
	U16	moveable		  : 1;	// embeddedWin is moveable.  Responds
						  		// to msgSelBeginMove by self sending
						  		// msgEmbeddedWinBeginMove.
	U16	copyable		  : 1;	// embeddedWin is copyable. Responds
						  		// to msgSelBeginCopy by self sending
						  		// msgEmbbeddedWinBeginCopy.
	U16	moveCopyMode	  : 2;	// Current move/copy mode.  Clients must not
								// set this field.
	U16 deletable		  : 1;	// Destroy in response to msgEWDestroy?
	U16 moveCopyContainer : 1;	// Private
	U16 embedForward	  : 1;	// See comments with msgEmbeddedWinGetDest 
								// and msgEmbeddedWinForwardedGetDest.
	U16 quickMove		  : 1;	// Use optimizations when moving windows 
								// within a common parent or within a common
								// process.  True by default.  See section
								// "Move Optimizations."
						  		// msgEmbeddedWinExtract/InsertChild.
	U16	reserved		  : 4;	// Reserved for future use.
	U16	reserved2		  : 16;	// Reserved for future use.

} EMBEDDED_WIN_STYLE, *P_EMBEDDED_WIN_STYLE;


/****  Embedded Window Metrics  ****/
/*
 * Passed back from msgEmbeddedWinGetMetrics.
*/
typedef struct EMBEDDED_WIN_METRICS {

	UUID				uuid;			// Defined if style.embeddee is true.
	EMBEDDED_WIN_STYLE	style;

} EMBEDDED_WIN_METRICS, *P_EMBEDDED_WIN_METRICS;


/****************************************************************************
 msgNew		takes P_EMBEDDED_WIN_NEW, returns STATUS
	category: class message
	Creates a new embeddedWin object.

 If style.embeddor is true, objCapCreate is set in object.cap.  If the
 passed in uuid is nil, and the object is an embeddee, a uuid is created.
*/
typedef struct EMBEDDED_WIN_NEW_ONLY {

	UUID				uuid;
	EMBEDDED_WIN_STYLE	style;
	U32					reserved[4];

} EMBEDDED_WIN_NEW_ONLY, *P_EMBEDDED_WIN_NEW_ONLY;

#define	embeddedWinNewFields	\
	gWinNewFields				\
	EMBEDDED_WIN_NEW_ONLY		embeddedWin;

typedef struct EMBEDDED_WIN_NEW {
	embeddedWinNewFields
} EMBEDDED_WIN_NEW, *P_EMBEDDED_WIN_NEW;


/****************************************************************************
 msgNewDefaults		takes P_EMBEDDED_WIN_NEW, returns STATUS
	category: class message
	Initializes the EMBEDDED_WIN_NEW structure to default values.

 Zeros out pNew->embeddedWin and then executes the following:
//{
	win.flags.style |= wsSendFile
	MakeNilUUID(pArgs->embeddedWin.uuid);
	pArgs->embeddedWin.style.deletable = true;
	pArgs->embeddedWin.style.quickMove = true;
//}
*/

#endif
