@echo off
rem ****************************************************************
rem * Usage
rem * 
rem * 	gensyms -t tag [-i] file [file ...]
rem * 
rem * 
rem * Description
rem * 
rem * 	Gensyms takes a tag and a file list.  It generates a file,
rem * 	named s_tag.c, which includes a function, named
rem * 	tagInitSymbols().  When tagInitSymbols() is called, it augments
rem *	the clsmgr by providing symbolic names for all of the messages, 
rem *	statuses, and classes defined in the filelist 
rem *
rem *	The -t flag is mandatory, and must be followed by a tag.  The
rem *   tag must be 6 or fewer characters.
rem *
rem *	If -i is given, then the caller-provided file s_tag.h is 
rem * 	included in the generated .c file.  If given, the -i flag must
rem *	immediately follow the tag.
rem * 
rem ****************************************************************


rem ****************************************************************
rem * Initialize, including shifting off the name of the batch file.
rem ****************************************************************
if not exist gensyms.t2 goto T3
del gensyms.t2 
:T3
if not exist gensyms.t3 goto INIT_DONE
del gensyms.t3
:INIT_DONE
shift

rem ****************************************************************
rem * Get the tag
rem ****************************************************************
if '%0' == '-t' goto GET_TAG
echo Error: no tag specified
goto ERROR_EXIT
:GET_TAG
shift
set SYM_TAG=%0
shift

rem ****************************************************************
rem * Generate a header for the output file
rem ****************************************************************
echo // > gensyms.t1
echo // WARNING:  File generated by GO utility: Gensyms.  >> gensyms.t1
echo // Do not edit.  Instead, run gensyms again. >> gensyms.t1
echo // >> gensyms.t1
echo #ifdef DEBUG >> gensyms.t1

rem ****************************************************************
rem * Finish generating the header:
rem * 	* process the -i flag, if there is one.
rem * 	* The beginning of the file should include clsmgr.h 
rem ****************************************************************
if not '%0' == '-i' goto INCL_DONE
echo #include "s_%SYM_TAG%.h" >> gensyms.t1
shift
:INCL_DONE

echo #include "clsmgr.h" >> gensyms.t1

rem ****************************************************************
rem * Process each file:
rem * 	* Copy contains into gensyms.tmp.
rem * 	* Add includes for caller-specified include files to the header.
rem ****************************************************************
echo # Temporary file generated by gensyms.  Should be deleted > gensyms.tmp

if '%0' == '' goto ERROR_EXIT

:NEXT_FILE
if exist %0 goto COMPLETE_NAME
if '%PENPOINT_PATH%' == '' goto BAD_FILE
if not exist %PENPOINT_PATH%\sdk\inc\%0 goto BAD_FILE
echo Scanning %PENPOINT_PATH%\sdk\inc\%0...
echo #include "%PENPOINT_PATH%\sdk\inc\%0" >> gensyms.t1
type %PENPOINT_PATH%\sdk\inc\%0 >> gensyms.tmp
shift
if not '%0' == '' goto NEXT_FILE
goto FORMAT

:COMPLETE_NAME
echo Scanning %0...
echo #include "%0" >> gensyms.t1
type %0 >> gensyms.tmp
shift
if not '%0' == '' goto NEXT_FILE

:FORMAT

echo Formatting...
if '%PENPOINT_PATH%' == '' goto AWK_DEFAULT
awk -f %PENPOINT_PATH%\sdk\util\symbols\gensyms.awk %SYM_TAG% gensyms.tmp
goto AWK_DONE
:AWK_DEFAULT
awk -f \penpoint\sdk\util\symbols\gensyms.awk %SYM_TAG% gensyms.tmp
:AWK_DONE
del gensyms.tmp

cat gensyms.t1 gensyms.t2 gensyms.t3 > s_%SYM_TAG%.c

rem ****************************************************************
rem * Normal Exit
rem ****************************************************************
:NORMAL_EXIT
del gensyms.t1
del gensyms.t2 
del gensyms.t3
goto COMMON_EXIT

rem ****************************************************************
rem * Error Exit
rem * 	* Someday: I'd like to set ERRORLEVEL here, but I can't 
rem * 	  find a way to do so.
rem ****************************************************************
:BAD_FILE
echo File does not exist: %0
:ERROR_EXIT
echo Usage: gensyms -t tag [-i] {file list}
echo	Possible errors:
echo        Tag was greater than 6 characters.
echo        File list was empty or the files did not exist.
echo    Gensyms will generate file s_TAG.c where TAG is the 6 character tag.

rem ****************************************************************
rem * Common Exit;  Code common to normal and error exits.
rem ****************************************************************
:COMMON_EXIT
set SYM_TAG=
:EXIT
