#
# Utility Commands
#
# $Revision:   1.9  $
#   $Author:   bldmstr  $
#     $Date:   04 Feb 1992 14:45:04  $
#

release: everything
	%if %defined(INCS)
	%foreach file in $(INCS)
	-copy $(file) $(PENPOINT_PATH)\sdk\inc
	%endfor
	%endif
	%if %defined(PINCS)
	%foreach file in $(PINCS)
	-copy $(file) $(GO_PATH)\pinc
	%endfor
	%endif
	%if %file($(PROJ).lib)
	copy $(PROJ).lib $(PENPOINT_PATH)\sdk\lib
	%endif

latestrelease: everything
	%if %defined(INCS)
	%foreach file in $(INCS)
	-copy $(file) $(LATEST_PATH)$(PENPOINT_PATH)\sdk\inc
	%endfor
	%endif
	%if %file($(PROJ).lib)
	copy $(PROJ).lib $(LATEST_PATH)$(PENPOINT_PATH)\sdk\lib
	%endif
	%if %defined(DLL_SRCS)
	%if !%dir($(LATEST_PATH)$(DLL_OUT))
	mkdir $(LATEST_PATH)$(DLL_OUT)
	%endif
	copy $(DLL_OUT)\$(PREFIX)$(PROJ).dll $(LATEST_PATH)$(DLL_OUT)
	copy $(DLL_OUT)\$(PREFIX)$(PROJ).mpd $(LATEST_PATH)$(DLL_OUT)
	%endif
	%if %defined(EXE_SRCS)
	%if !%dir($(LATEST_PATH)$(EXE_OUT))
	mkdir $(LATEST_PATH)$(EXE_OUT)
	%endif
	copy $(EXE_OUT)\$(PREFIX)$(PROJ).exe $(LATEST_PATH)$(EXE_OUT)
	copy $(EXE_OUT)\$(PREFIX)$(PROJ).mpe $(LATEST_PATH)$(EXE_OUT)
	%endif

backup:
	mkdir a:\$(HOME)
	del a:\$(HOME)\*.*
	copy *.asm a:\$(HOME)
	copy *.c a:\$(HOME)
	copy *.h a:\$(HOME)
	copy *.tbl a:\$(HOME)
	copy *.rc a:\$(HOME)
	copy *.mak a:\$(HOME)
	copy *.def a:\$(HOME)

netbackup:
	mkdir z:\home\$(OWNER)\go\source\$(HOME)
	copy *.asm z:\home\$(OWNER)\go\source\$(HOME)
	copy *.c z:\home\$(OWNER)\go\source\$(HOME)
	copy *.h z:\home\$(OWNER)\go\source\$(HOME)
	copy *.tbl z:\home\$(OWNER)\go\source\$(HOME)
	copy *.rc z:\home\$(OWNER)\go\source\$(HOME)
	copy *.mak z:\home\$(OWNER)\go\source\$(HOME)
	copy *.def z:\home\$(OWNER)\go\source\$(HOME)

cleanup:
	%if %file($(EXE_OUT)\$(PREFIX)$(PROJ).exe)
	del $(EXE_OUT)\$(PREFIX)$(PROJ).exe
	%endif
	%if %file($(EXE_OUT)\app.res)
	del $(EXE_OUT)\app.res
	%endif
	%if %file($(EXE_OUT)\$(PREFIX)$(PROJ).mpe)
	del $(EXE_OUT)\$(PREFIX)$(PROJ).mpe
	%endif
	%if %file($(DLL_OUT)\$(PREFIX)$(PROJ).dll)
	del $(DLL_OUT)\$(PREFIX)$(PROJ).dll
	%endif
	%if %file($(DLL_OUT)\$(PREFIX)$(PROJ).mpd)
	del $(DLL_OUT)\$(PREFIX)$(PROJ).mpd
	%endif
	%if %file($(EXE_OUT)\penpoint.dir)
	del $(EXE_OUT)\penpoint.dir
	%endif
	%if %file($(PROJ).lib)
	del $(PROJ).lib
	%endif
	del $(OBJ_OUT)\*.obj
	del *.mpe
	del *.mpd
	del *.err
	del *.cod
    	del *.lst
	del *.dok

freshen:
	%foreach file in $(DLL_SRCS) $(EXE_SRCS) $(EXE_RC) $(INCS) $(PINCS) $(LINCS) $(DEFS) $(MAKEFILENAME) $(OTHER_CHECKIN) $(SERVICE_RC) $(DLL_LBC) $(INIT_LBC)

	%if %exists($(file)) && %writable($(file))
	@%echo
	@%echo ********** Skipping $(file) because it's writable **********
	@%echo
	%else
	-n:\public\tools\pvcs\vdiff -C$(BUILD_DIR)\$(PROJ)\vcs.cfg -T -R $(file) $(file)
	%if %status > 0
	@%echo
	@%echo ********** Getting $(file) from build directory **********
	@%echo
	n:\public\tools\pvcs\get -C$(BUILD_DIR)\$(PROJ)\vcs.cfg $(file)
	-del $(OBJ_OUT)\$[r,$(file)].obj
	%else
	@%echo
	@%echo ********** Skipping $(file) because they're the same **********
	@%echo
	%endif
	%endif

	%endfor

getall:
	%foreach file in $(DLL_SRCS) $(EXE_SRCS) $(EXE_RC) $(INCS) $(PINCS) $(LINCS) $(DEFS) $(MAKEFILENAME) $(OTHER_CHECKIN) $(SERVICE_RC) $(DLL_LBC) $(INIT_LBC)

	@%echo
	@%echo ********** Getting $(file) from build directory **********
	@%echo
	-n:\public\tools\pvcs\get -C$(BUILD_DIR)\$(PROJ)\vcs.cfg $(file)

	%endfor

checkin: $(DLL_SRCS) $(EXE_SRCS) $(EXE_RC) $(INCS) $(DEFS) $(MAKEFILENAME) $(OTHER_CHECKIN) $(PINCS) $(LINCS) $(SERVICE_RC) $(DLL_LBC) $(INIT_LBC)
   w:kanban $(VCSID) $(LOCK) -c <@<
         $(DLL_SRCS) $(EXE_SRCS) $(EXE_RC) $(INCS) $(DEFS) $(MAKEFILENAME) $(OTHER_CHECKIN) $(PINCS) $(LINCS) $(SERVICE_RC) $(DLL_LBC) $(INIT_LBC)
<

refgen: $(INCS)
   %foreach file in $(INCS)
     @%echo
     @%echo ********** Checking in $(file) **********
     @%echo
     -n:\public\tools\pvcs\put -Cvcs.cfg -Vrelease -Y -M$(CI_COMMENT) $(CI_LOCK) ($(file))
   %endfor


## The following line tells PolyMake to preserve the intermediate .out and
## .rtf files.
#  Not clear if it's desired in this case.
#.PRECIOUS
	
#
# REFGEN process: create output files from header file.
#

# Got rid of ROOTDIR check because different people have the path separator
# as either"/" or "\"
MKSBIN = N:\public\tools\mks\bin

.h.out:
	@%echo ********** Running awk script to generate $[r,$*].out and $[r,$*].err **********
	$(MKSBIN)\awkl -f N:\public\go\sdk\doc\refgen\refgen.awk $[r,$*].h > $[r,$*].err
	$(MKSBIN)\mv refgen.out $[r,$*].out

.h.err:
	@%echo ********** Running awk script to generate $[r,$*].err and $[r,$*].out **********
	$(MKSBIN)\awkl -f N:\public\go\sdk\doc\refgen\refgen.awk $[r,$*].h > $[r,$*].err
	$(MKSBIN)\mv refgen.out $[r,$*].out

.out.rtf:
	@%echo ********** Running r2w to create $[r,$*].rtf (and $[r,$*].r2w log) **********
	N:\public\go\sdk\doc\refgen\r2w $[r,$*].out $[r,$*].rtf s > $[r,$*].r2w

.rtf.dok:
	@%echo ********** Converting RTF to Word file $[r,$*].dok **********
	-del $[r,$*].dok
	N:\public\tools\word5\rtf_dos $[r,$*].rtf $[r,$*].dok N:\public\tools\word5\sdk.sty /g

.out.mtb:
	@%echo ********** Running awk script to extract msg table $[r,$*].mtb **********
	$(MKSBIN)\awkl -f N:\public\go\sdk\doc\refgen\msgtable.awk $[r,$*].out
	$(MKSBIN)\mv msgtable.out $[r,$*].mtb




