#
# go.mak: Standard makefile rules
#
# $Revision:   1.121  $
#   $Author:   sisaac  $
#     $Date:   06 Apr 1992 13:43:12  $
#

.DEFAULT:
        %if "$(BM)" == "y"
          %if !%exists($@) && "$@" != "exports" && "$@" != "everything" && "$@" != "installer"
            %if !%dir(n:\public\go\build\$(ARCH)\$(PROJ)\vcs\$@)
              %if !%exists($[m,n:\public\go\build\$(ARCH)\$(PROJ)\vcs\*.??v,$@])
                @echo"set BSTATUS=file_not_found>c:\bstatus.bat
                @echo"set BDATA=$@>>c:\bstatus.bat
              %endif
              c:\pvcs\get -Cn:\public\go\build\$(ARCH)\$(PROJ)\vcs.cfg -q $(VCSFLAGS) $@
            %else
              md $@
              cd $@
              c:\pvcs\get -Cn:\public\go\build\$(ARCH)\$(PROJ)\$@\vcs.cfg -q $(VCSFLAGS) *.??v
              cd $(CWD)
            %endif
          %endif
        %endif
        
.INCLUDE $(MAKEFILE_PATH)\defaults.mak

everything: $(LINCS) $(OTHER_EVERYTHING) $(EVERYTHING) $(OTHER_LAST)
exports: $(OTHER_EXPORT) $(EXPORT_INCS) $(EXPORT_PINCS) $(EXPORT_LIBS) \
         $(EXPORT_LAST)

#
# Create object output directory if none exists
#

$(OBJ_OUT):
        %if !%dir($(OBJ_OUT)\..\..)
          md $(OBJ_OUT)\..\..
        %endif
        %if !%dir($(OBJ_OUT)\..)
          md $(OBJ_OUT)\..
        %endif
        %if !%dir($(OBJ_OUT))
          md $(OBJ_OUT) 
        %endif

#
# Build object module from C file
#

.c.obj:
	@%echo 
	@%echo ********** Building $[r,$*].obj **********
	@%echo
        %if "$(MODE)" == "dos" || "$(MODE)" == "dosdebug"
          @%setenv INCLUDE=$(MSC)\include;$(INCLUDE)
	  cl $(CC_FLAGS) $($[r,$*]_CFLAGS) /E $(CC_DEBUG) $[r,$*].c > $(TMP)\$[r,$*].i
          %if "$(BM)" == "y"
            cl $(CC_FLAGS) $($[r,$*]_CFLAGS) /Fo$(OBJ_OUT)\ $(CC_DEBUG) /Tc $(TMP)\$[r,$*].i
          %else
	    cl $(CC_FLAGS) $($[r,$*]_CFLAGS) /Fo$(OBJ_OUT)\ $(CC_DEBUG) /Tc $(TMP)\$[r,$*].i > $[r,$*].err
	    type $[r,$*].err
          %endif
	  del $(TMP)\$[r,$*].i
        %else
	  @%setenv INCLUDE=$(INCLUDE)           #Other C compiler flags set
                                                #through WCC386 environ var
    	  @%setenv WCC386=$(WCC386)
          @%echo 386 Compiler flags=$(WCC386)
          %if "$(BM)" == "y"
 	    wcc386p $($[r,$*]_CFLAGS) /Fo$*.obj $[r,$*].c
          %else
 	    wcc386p $($[r,$*]_CFLAGS) /Fo$*.obj $[r,$*].c > $[r,$*].err
	    type $[r,$*].err
          %endif
        %endif
	@%setenv INCLUDE=$(INCLUDE)

#
# Build a new method.h if it is missing
#
$(OBJ_OUT)\method.obj: method.h method.tbl

method.h:
        del $(OBJ_OUT)\method.obj

#
# Build object module from TBL file
#
.tbl.obj:
	@%echo 
	@%echo ********** Building $[r,$*].obj **********
	@%echo 
    	@%setenv WCC=$(WCC)
        @%echo Data Compiler flags=$(WCC)
    	@%setenv WCC386=$(WCC386)
        @%echo 386 Compiler flags=$(WCC386)
        %if "$(BM)" == "y"
	$(PENPOINT_PATH)\sdk\util\clsmgr\mt $(MT_FLAGS) $< -Fo=$*.obj
        %else
	$(PENPOINT_PATH)\sdk\util\clsmgr\mt $(MT_FLAGS) $< -Fo=$*.obj>$[r,$*].err
        %endif

#
# Build resource file from RC file
#
.rc.res:
	@%echo 
	@%echo ********** Building $[r,$*].res **********
	@%echo 
        %if "$(BM)" == "y"
	  $(TOOLS)\rc $[r,$*].rc
        %else
	  $(TOOLS)\rc $[r,$*].rc > $[r,$*].err
	  type $[r,$*].err
        %endif

#
# Build object module from ASM file
#
.asm.obj:
	@%echo 
	@%echo ********** Building $[r,$*].obj **********
	@%echo 
    %if "$(BM)" == "y"
      ml $(ASM_FLAGS) $(ASM_DEBUG) /Fo$(OBJ_OUT)\$[r,$*].obj $[r,$*].asm
    %else
      ml $(ASM_FLAGS) $(ASM_DEBUG) /Fo$(OBJ_OUT)\$[r,$*].obj $[r,$*].asm > $[r,$*].err
	  type $[r,$*].err
    %endif


#
# build .dfc files by combining .defs with copyright description
#
exe.dfc: $(EXE_DEF)
	copy $(EXE_DEF)+$(PINC)\gocpyrht.def exe.dfc

dll.dfc: $(DLL_DEF)
	copy $(DLL_DEF)+$(PINC)\gocpyrht.def dll.dfc

#
# Build dynamic link library
#
$(DLL_OUT)\$(PREFIX)$(PROJ).dll: $(DLL_OBJS) $(DLL_LBC) \
                                 $[f, $(LIBR), $(DLL_LIBS), lib] \
                                 $[f, $(PLIB), $(PLIB_PFX)$[s," $(PLIB_PFX)",$(DLL_PLIBS)], lib] \
				 $(FULL_DISTRIBUTED_DLLS) $(FULL_DISTRIBUTED_APPS) \
				 $(FULL_DISTRIBUTED_SERVICES)
	@%echo
	@%echo ********** Building $(PROJ).dll **********
	@%echo
	@%setenv LIB=$(LIB);$(MSC)\lib
	%if !%dir($(DLL_OUT))
	mkdir $(DLL_OUT)
	%endif
	wlinkp <@<
	   SYSTEM PenPoint DLL 
           NAME $(DLL_OUT)\$(PREFIX)$(PROJ).dll
           $(DLL_LINK_DEBUG)
	   FILE $[s,",",$(DLL_OBJS)]
	   EXPORT=dll
	   LIBRARY $(DLL_LIBRARIES)
	   SEGMENT CLASS 'CODE' Share $(DLL_CODE), CLASS 'DATA' Share $(DLL_DATA), CLASS 'BSS' Share $(DLL_DATA)
	   OPTION Modname='$(DLL_LNAME)'
	   OPTION Map=$(PREFIX)$(PROJ).mpd
	   OPTION Quiet,NOD,Verbose
           $(DLL_LINK_SYMBOLS)
<

	%if %defined(DLL_LINK_SYMBOLS)
           # put line numbers into symbol file 
           getln $(PREFIX)$(PROJ).sym >>$(PREFIX)$(PROJ).mpd
           del $(PREFIX)$(PROJ).sym 
        %endif

	%if "$(DLL_OUT)" != "."
	copy $(PREFIX)$(PROJ).mpd $(DLL_OUT)
	%endif
	@%setenv LIB=$(LIB)

	%if %defined(FULL_DISTRIBUTED_DLLS)
	%foreach dist_dir in $(FULL_DISTRIBUTED_DLLS)
        %if %dir($(dist_dir))
	-cpov /ov u $(dist_dir)\*.* $(DLL_OUT)
        %else
	copy $(dist_dir) $(DLL_OUT)
        %endif
	%endfor
	%endif

	%if %defined(FULL_DISTRIBUTED_SERVICES)
	%foreach file in $(FULL_DISTRIBUTED_SERVICES)
        %if %dir($(file))
	-cpov /ov u $(file) $(DLL_OUT)
        %else
	copy $(file) $(DLL_OUT)
        %endif
	%endfor
	-copy $(DISTRIBUTED_SERVICES_IN)\PENPOINT.DIR $(DLL_OUT)
	%endif

	%if %defined(FULL_DISTRIBUTED_APPS)
	%foreach file in $(FULL_DISTRIBUTED_APPS)
	-md $(DLL_OUT)\$[r,$(file)]
	-xcopy $(file) $(DLL_OUT)\$[r,$(file)] /s
	%endfor
	-copy $(DISTRIBUTED_APPS_IN)\PENPOINT.DIR $(DLL_OUT)
	%endif

# Steve Isaac added the service-specific stamping below for 386.
    %if $(DLL_TYPE) == "service" || $(DLL_TYPE) == "distributed_service"
      cd $(TOOLS)
      %if %defined(SERVICE_NAME)
        -stamp $(DLL_OUT)\.. /g "$(SERVICE_NAME)" /d $(PROJ)
        -stamp $(DLL_OUT)\.. /g "$(SERVICE_NAME)" /a 01E00208 "$(SERVICE_VERSION)"
        -stamp $(DLL_OUT)\.. /g "$(SERVICE_NAME)" /a 01600182 "$(DLL_LNAME)"
        %if %defined(SERVICE_TYPE)
          -stamp $(DLL_OUT)\.. /g "$(SERVICE_NAME)" /a 0660013a "$(SERVICE_TYPE)"
        %else
          -stamp $(DLL_OUT)\.. /g "$(SERVICE_NAME)" /a 0660013a "Service"
        %endif
        -stamp $(DLL_OUT)\.. /g "$(SERVICE_NAME)" /a 0080013a 1000240
        %if %defined(SERVICE_HOME)
          -stamp $(DLL_OUT)\.. /g "$(SERVICE_NAME)" /A 04E001F2 "\\$(SERVICE_HOME)\PenPoint\Service\$(SERVICE_NAME)"
          -stamp $(DLL_OUT)\.. /g "$(SERVICE_NAME)" /A 048001F2 1
        %endif
        %if %defined(DLL_DLC)
          -stamp $(DLL_OUT) /g "$(SERVICE_NAME).dlc" /d $(PROJ).dlc
        %else
          -stamp $(DLL_OUT) /g "$(SERVICE_NAME).dll" /d $(PROJ).dll
        %endif
      %else
        -stamp $(DLL_OUT)\.. /g "$(PROJ)" /d $(PROJ)
        -stamp $(DLL_OUT)\.. /g "$(PROJ)" /a 01E00208 "$(SERVICE_VERSION)"
        -stamp $(DLL_OUT)\.. /g "$(PROJ)" /a 01600182 "$(DLL_LNAME)"
        %if %defined(SERVICE_TYPE)
          -stamp $(DLL_OUT)\.. /g "$(PROJ)" /a 0660013a "$(SERVICE_TYPE)"
        %else
          -stamp $(DLL_OUT)\.. /g "$(PROJ)" /a 0660013a "Service"
        %endif
        %if %defined(SERVICE_HOME)
          -stamp $(DLL_OUT)\.. /g "$(PROJ)" /A 04E001F2 "\\$(SERVICE_HOME)\PenPoint\Service\$(PROJ)"
          -stamp $(DLL_OUT)\.. /g "$(PROJ)" /A 048001F2 1
        %endif
        -stamp $(DLL_OUT)\.. /g "$(PROJ)" /a 0080013a 1000240
      %endif
      cd $(CWD)
    %endif

#
# Copy out dlc file 
# DLow & MAS added mkdir at Beta0.9D build
#
$(DLL_OUT)\$(DLL_DLC): $(DLL_DLC)
	%if %defined(DLL_DLC)
      %if !%dir($(DLL_OUT))
        mkdir $(DLL_OUT)
	  %endif
	  copy $(DLL_DLC) $(DLL_OUT)
	%endif

#
# Decide whether to build import or real library
#
%if !%defined(PLIB_SRCS)

#
# Build public import library
#
$(LIB_OUT)\$(PROJ).lib: $(DLL_LBC)
	@%echo
	@%echo ********** Building public import lib: $(PROJ).lib **********
	@%echo
	wlib -b -n $(LIB_OUT)\$(PROJ).lib @dll

%else
#
# Build private library
#
$(PLIB_OUT)\$(PLIB_PFX)$(PROJ).lib: $(PLIB_OBJS) $[f, $(PLIB), $(PLIB_LIBS)]
	@%echo
	@%echo ********** Building private library: $(PLIB_PFX)$(PROJ).lib **********
	@%echo
    %if %exists($(PLIB_OUT)\$(PLIB_PFX)$(PROJ).lib)
      del $(PLIB_OUT)\$(PLIB_PFX)$(PROJ).lib
    %endif
    wlib /b $(PLIB_OUT)\$(PLIB_PFX)$(PROJ).lib <@<
      -+$[s, "\n-+", $(PLIB_OBJS) $[f, $(PLIB), $(PLIB_LIBS)]]
<
%endif

#
# SPage added init.dll target at Beta0.9G build
# Build init.dll installation DLL
#
# this stuff copied from DLL rules above, except that init.dll goes in
# EXE_OUT.
# does it need a .dfc file?
#
$(EXE_OUT)\$(PREFIX)init.dll: $(INIT_OBJS) $(INIT_LBC) \
                                 $[f, $(LIBR), $(INIT_LIBS), lib] \
                                 $[f, $(PLIB), $(PLIB_PFX)$(INIT_PLIBS), lib]
	@%echo
	@%echo ********** Building init.dll **********
	@%echo
	@%setenv LIB=$(LIB);$(MSC)\lib
	%if !%dir($(EXE_OUT))
      mkdir $(EXE_OUT)
	%endif
	wlinkp <@<
	   SYSTEM PenPoint DLL 
           NAME $(EXE_OUT)\$(PREFIX)init.dll
           $(DLL_LINK_DEBUG)
	   FILE $[s,",",$(INIT_OBJS)]
	   EXPORT=init
	   LIBRARY $(INIT_LIBRARIES)
	   SEGMENT CLASS 'CODE' Share $(INIT_CODE), CLASS 'DATA' Share $(INIT_DATA), CLASS 'BSS' Share $(INIT_DATA)
	   OPTION Modname='$(INIT_LNAME)'
	   OPTION Map=$(PREFIX)init.mpd
	   OPTION Quiet,NOD,Verbose
           $(INIT_LINK_SYMBOLS)
<
	%if %defined(INIT_LINK_SYMBOLS)
      # put line numbers into symbol file 
      getln $(PREFIX)init.sym >>$(PREFIX)init.mpd
      del $(PREFIX)init.sym 
    %endif

	%if "$(EXE_OUT)" != "."
	  copy $(PREFIX)init.mpd $(EXE_OUT)
	%endif
	@%setenv LIB=$(LIB)
# end of SPAGE inst.dll stuff


#
# Build executable
#
$(EXE_OUT)\$(PREFIX)$(PROJ).exe: $(EXE_OBJS) $(EXE_RES) $(FULL_DISTRIBUTED_DLLS) $(FULL_DISTRIBUTED_APPS) \
		$(FULL_DISTRIBUTED_SERVICES)
	@%echo
	@%echo ********** Building $(PROJ).exe **********
	@%echo
	%if !%dir($(EXE_OUT))
      mkdir $(EXE_OUT)
	%endif

    %if "$(MODE)" == "dos" || "$(MODE)" == "dosdebug"
	  @%setenv LIB=$(LIB);$(MSC)\lib
	  link $(EXE_FLAGS) /SEG:$(EXE_SEG) /ST:$(EXE_STACK) $(EXE_DEBUG) <@<
	    $[s,"+\n",$(EXE_OBJS)],$(EXE_OUT)\$(PREFIX)$(PROJ).exe,$(PREFIX)$(PROJ).mpe,$[s,"+\n",$(EXE_LIBS)],;
<
      @%setenv LIB=$(LIB)
    %else
      wlinkp <@<
       SYSTEM PenPoint
         NAME $(EXE_OUT)\$(PREFIX)$(PROJ).exe
           $(EXE_LINK_DEBUG)
        FILE $[s,",",$(EXE_OBJS)]
        LIBRARY $[s,",",$(EXE_LIBS)]
          $(EXE_DATA_DIRECTIVE)
	    OPTION Quiet, Map=$(PREFIX)$(PROJ).mpe, NOD, Verbose, Stack=$(EXE_STACK), MODNAME='$(EXE_LNAME)'
          $(EXE_LINK_SYMBOLS)
<
      %if %defined(EXE_LINK_SYMBOLS)
        # put line numbers into symbol file 
        getln $(PREFIX)$(PROJ).sym >>$(PREFIX)$(PROJ).mpe
        del $(PREFIX)$(PROJ).sym 
      %endif
    %endif

    %if "$(EXE_OUT)" != "."
      copy $(PREFIX)$(PROJ).mpe $(EXE_OUT)
    %endif

    %if %defined(EXE_RES)
      %foreach file in $(EXE_RES)
        copy $(file) $(EXE_OUT)
      %endfor
    %endif

	%if %defined(FULL_DISTRIBUTED_DLLS)
	%foreach dist_dir in $(FULL_DISTRIBUTED_DLLS)
        %if %dir($(dist_dir))
	-cpov /ov u $(dist_dir)\*.* $(EXE_OUT)
        %else
	copy $(dist_dir) $(EXE_OUT)
        %endif
	%endfor
	%endif

	%if %defined(FULL_DISTRIBUTED_APPS)
	%foreach file in $(FULL_DISTRIBUTED_APPS)
	-md $(EXE_OUT)\$[r,$(file)]
	-xcopy $(file) $(EXE_OUT)\$[r,$(file)] /s
	%endfor
	-copy $(DISTRIBUTED_APPS_IN)\PENPOINT.DIR $(EXE_OUT)
	%endif

# SPage revised stamp rules for B0.9G.
# SIsaac revised this for 386, adding version, Application string, and uid.
  %if "$(MODE)" != "dos" && "$(MODE)" != "dosdebug"
    cd $(TOOLS)
	%if %defined(EXE_NAME)
		-stamp $(EXE_OUT)\.. /g "$(EXE_NAME)" /d $(PROJ)
		-stamp $(EXE_OUT)\.. /g "$(EXE_NAME)" /a 01E00208 "$(APP_VERSION)"
	 	-stamp $(EXE_OUT)\.. /g "$(EXE_NAME)" /a 01600182 "$(EXE_LNAME)"
		-stamp $(EXE_OUT)\.. /g "$(EXE_NAME)" /a 0660013a "Application"
		-stamp $(EXE_OUT)\.. /g "$(EXE_NAME)" /a 0080013a 10001a0
		%if %defined(APP_HOME)
			-stamp $(EXE_OUT)\.. /g "$(EXE_NAME)" /A 04E001F2 "\\$(APP_HOME)\PenPoint\App\$(EXE_NAME)"
			-stamp $(EXE_OUT)\.. /g "$(EXE_NAME)" /A 048001F2 1
		%endif
		%if %defined(EXE_DLC)
			-stamp $(EXE_OUT) /g "$(EXE_NAME).dlc" /d $(PROJ).dlc
		%else
		 	-stamp $(EXE_OUT) /g "$(EXE_NAME).exe" /d $(PROJ).exe
		%endif
	%else
		-stamp $(EXE_OUT)\.. /g "$(PROJ)" /d $(PROJ)
		-stamp $(EXE_OUT)\.. /g "$(PROJ)" /a 01E00208 "$(APP_VERSION)"
	 	-stamp $(EXE_OUT)\.. /g "$(PROJ)" /a 01600182 "$(EXE_LNAME)"
		-stamp $(EXE_OUT)\.. /g "$(PROJ)" /a 0660013a "Application"
		-stamp $(EXE_OUT)\.. /g "$(PROJ)" /a 0080013a 10001a0
		%if %defined(APP_HOME)
			-stamp $(EXE_OUT)\.. /g "$(PROJ)" /A 04E001F2 "\\$(APP_HOME)\PenPoint\App\$(PROJ)"
			-stamp $(EXE_OUT)\.. /g "$(PROJ)" /A 048001F2 1
		%endif
	%endif
    cd $(CWD)
  %endif

#
# Build app.res
#
$(EXE_OUT)\app.res: $(EXE_RESFILES)
	@%echo
	@%echo ********** Building app.res **********
	@%echo
	%if !%dir($(EXE_OUT))
	mkdir $(EXE_OUT)
	%endif
	%foreach file in $(EXE_RESFILES)
		$(TOOLS)\resappnd $(file) temp.res
	%endfor
	copy temp.res $(EXE_OUT)\app.res
	del temp.res

#
# Build service.res
#
$(OBJ_OUT)\timestmp.sr: $(SERVICE_RESFILES)
        @%echo
        @%echo ********** Building service.res **********
        @%echo
        %if !%dir($(DLL_OUT))
          mkdir $(DLL_OUT)
        %endif
        %foreach file in $(SERVICE_RESFILES)
          $(TOOLS)\resappnd $(file) service.res
        %endfor
        $(TOOLS)\resappnd service.res $(TMP)\tmp.res
        copy $(TMP)\tmp.res $(DLL_OUT)\service.res
        del $(TMP)\tmp.res
        del service.res
        echo">$(OBJ_OUT)\timestmp.sr

#
# Copy out dlc file 
# DLow & MAS added mkdir at Beta0.9D build
#
$(EXE_OUT)\$(EXE_DLC): $(EXE_DLC)
	%if %defined(EXE_DLC)
	%if !%dir($(EXE_OUT))
	mkdir $(EXE_OUT)
	%endif
	@%echo ********** Copying $(EXE_DLC) **********
	copy $(EXE_DLC) $(EXE_OUT)
	%endif

#
# Copy out stuff for misc 
#
$(DLL_OUT)\misc: $(MISC)
	%if %defined(MISC)
	@%echo ********** Creating MISC directory **********
	%if %dir($(DLL_OUT)\misc)
	-rm -rf $(DLL_OUT)\misc
	%endif
	mkdir $(DLL_OUT)\misc
	%foreach file in $(MISC)
	-xcopy $(file) $(DLL_OUT)\misc /s
	%endfor
	%endif

#
# Copy out stuff for misc 
#
$(EXE_OUT)\misc: $(MISC)
	%if %defined(MISC)
	@%echo ********** Creating MISC directory **********
	%if %dir($(EXE_OUT)\misc)
	-rm -rf $(EXE_OUT)\misc
	%endif
	mkdir $(EXE_OUT)\misc
	%foreach file in $(MISC)
	-xcopy $(file) $(EXE_OUT)\misc /s
	%endfor
	%endif

#
# Copy out stuff for help 
#
$(EXE_OUT)\help: $(HELP)
	%if %defined(HELP)
	@%echo ********** Creating HELP directory **********
	%if %dir($(EXE_OUT)\help)
	-rm -rf $(EXE_OUT)\help
	%endif
	mkdir $(EXE_OUT)\help
	%foreach file in $(HELP)
	mkdir $(EXE_OUT)\help\$(file)
	-xcopy $(file)\*.* $(EXE_OUT)\help\$(file) /s 
	%endfor
	%endif

#
# Copy out stuff for stationery
#
$(EXE_OUT)\statnry: $(STATIONERY)
	%if %defined(STATIONERY)
	@%echo ********** Creating STATNRY directory **********
	%if %dir($(EXE_OUT)\statnry)
	-rm -rf $(EXE_OUT)\statnry 
	%endif
	mkdir $(EXE_OUT)\statnry
	%foreach file in $(STATIONERY)
	mkdir $(EXE_OUT)\statnry\$(file)
	-xcopy $(file)\*.* $(EXE_OUT)\statnry\$(file) /s
        %if "$(BM)" == "y"
        -rm -fr $(file)
        %endif
	%endfor
	%endif

#
# Copy out stuff for inst
#
$(DLL_OUT)\inst: $(INST)
	%if %defined(INST)
	@%echo ********** Creating INST directory **********
	%if %dir($(DLL_OUT)\inst)
	-rm -rf $(DLL_OUT)\inst
	%endif
	mkdir $(DLL_OUT)\inst
	%foreach file in $(INST)
	-xcopy $(file) $(DLL_OUT)\inst /s
	%endfor
	%endif

#
# Build symbols file
#
s_$(PROJ_ABBREV).c: $(SYM_INCS) $(OTHER_SYM_INCS)
	%setenv SYM_TAG=$(PROJ_ABBREV)
	$(PENPOINT_PATH)\sdk\util\symbols\gensyms -t $(PROJ_ABBREV) $(SYM_FLAGS) $(SYM_INCS) $(OTHER_SYM_INCS)
	%setenv SYM_TAG=

#
# Make the s_xxxx.obj file explicitly depend on the s_xxxx.c file.
# This stops polymake from deleting the s_xxxx.c file.
#
$(OBJ_OUT)\s_$(PROJ_ABBREV).obj: s_$(PROJ_ABBREV).c

#
# Get the PenPoint resource files
#
$(OBJ_OUT)\timestmp.ppr: $(PP_RES)
    %foreach file in $?    
        $(TOOLS)\resappnd $(file) $(PENPOINT_PATH)\boot\junk.res
    %endfor
    $(TOOLS)\resappnd $(PENPOINT_PATH)\boot\junk.res $(PENPOINT_PATH)\boot\penpoint.res
    del $(PENPOINT_PATH)\boot\junk.res
    $(TOOLS)\resappnd $(PENPOINT_PATH)\boot\penpoint.res $(PENPOINT_PATH)\boot\junk.res
    attrib -r $(PENPOINT_PATH)\boot\*.res 
    copy $(PENPOINT_PATH)\boot\junk.res $(PENPOINT_PATH)\boot\penpoint.res
    del $(PENPOINT_PATH)\boot\junk.res 
    $(TOOLS)\resappnd $(PENPOINT_PATH)\boot\penpoint.res $(_PP_PATH)\boot\penpoint.res
    $(TOOLS)\resappnd $(_PP_PATH)\boot\penpoint.res $(_PP_PATH)\boot\junk.res
    attrib -r $(_PP_PATH)\boot\penpoint.res 
    copy $(_PP_PATH)\boot\junk.res $(_PP_PATH)\boot\penpoint.res
    del $(_PP_PATH)\boot\junk.res 
    echo">$(OBJ_OUT)\timestmp.ppr

#
# Export the PINCS files
#

%foreach file in $(PINCS)
$(PINC_OUT)\$(file): $(file)
	@%echo 
	@%echo ********** Exporting $(file) **********
	@%echo 
        @copy $< $@
        @attrib -r $@ >nul
%endfor

#
# Export the INCS files
#

%foreach header in $(INCS)
#### This line must be present to avoid polymake bug - TA
$(INC_OUT)\$(header): $(header)
	@%echo 
	@%echo ********** Exporting $(header) **********
	@%echo 
        @copy $< $@
        @attrib -r $@ >nul
%endfor

#
# Get the LINCS files
#

%foreach header in $(LINCS)
#### This line must be present to avoid polymake bug - TA
.\$(header): $(header)
        @attrib -r $@ >nul
%endfor

#
# This must be at the bottom.
#
.INCLUDE $(MAKEFILE_PATH)\util.mak



