#
# Default settings for go.mak
#
# $Revision:   1.75  $
#   $Author:   sisaac  $
#     $Date:   06 Apr 1992 11:50:30  $
#

.MEMSWAP

#
# Path to the penpoint directory
#
%if !%defined(PENPOINT_PATH)
PENPOINT_PATH = \$(ARCH)\penpoint
%endif

#
# Path to the penpoint debug directory
#
%if !%defined(_PP_PATH)
_PP_PATH = \$(ARCH)\_pp
%endif

#
# Path to the penpoint installer directory
#
%if !%defined(PP_INST_PATH)
PP_INST_PATH = \$(ARCH)\install.pp
%endif

#
# Path to the penpoint directory
#
%if !%defined(PP_PATH)
%if "$(MODE)" == "production"
PP_PATH = $(PENPOINT_PATH)
%elseif "$(MODE)" == "debug"
PP_PATH = $(_PP_PATH)
%elseif "$(MODE)" == "debug2"
PP_PATH = $(_PP_PATH)
%elseif "$(MODE)" == "installer"
PP_PATH = $(PP_INST_PATH)
%else
PP_PATH = $(PENPOINT_PATH)
%endif
%endif

#
# Path to the go directory
#
%if !%defined(GO_PATH)
GO_PATH = \$(ARCH)\go
%endif

#
# Path to directory where the build is occuring
#
%if !%defined(BUILD_PATH)
BUILD_PATH = $(CWD)
%endif

#
# Default exe data segment class
#
%if !%defined(EXE_DATA)
EXE_DATA = nonshared
%endif

#
# Linker directive for exe data segment.
#
%if "$(EXE_DATA)" == "shared"
EXE_DATA_DIRECTIVE = SEGMENT CLASS 'DATA' SHARE, CLASS 'BSS' SHARE
%endif

#
# Type of exe [system or non_system]
#
%if !%defined(EXE_TYPE)
EXE_TYPE = app
%endif

#
# Type of dll [system or non-system]
#
%if !%defined(DLL_TYPE)
DLL_TYPE = app
%endif

#
# Where to put .exe files
#
%if !%defined(EXE_OUT)

%if "$(EXE_TYPE)" == "system"

%if "$(MODE)" == "production"
EXE_OUT = $(PP_PATH)\boot\app\$(PROJ)
%elseif "$(MODE)" == "debug"
EXE_OUT = $(PP_PATH)\boot\app\$(PROJ)
%elseif "$(MODE)" == "debug2" && "$(BM)" != "y"
EXE_OUT = $(PP_PATH)\boot\app\$(PROJ)
%elseif "$(MODE)" == "debug2" && "$(BM)" == "y"
EXE_OUT = $(GO_PATH)\$(PROJ)
%elseif "$(MODE)" == "dos" || "$(MODE)" == "dosdebug"
EXE_OUT = $(GO_PATH)\$(PROJ)
%else
EXE_OUT = $(PP_PATH)\boot\app\$(PROJ)
%endif

%elseif "$(EXE_TYPE)" == "app"

%if "$(MODE)" == "production"
EXE_OUT = $(PP_PATH)\app\$(PROJ)
%elseif "$(MODE)" == "debug"
EXE_OUT = $(PP_PATH)\app\$(PROJ)
%elseif "$(MODE)" == "debug2" && "$(BM)" != "y"
EXE_OUT = $(PP_PATH)\app\$(PROJ)
%elseif "$(MODE)" == "debug2" && "$(BM)" == "y"
EXE_OUT = $(GO_PATH)\$(PROJ)
%elseif "$(MODE)" == "dos" || "$(MODE)" == "dosdebug"
EXE_OUT = $(GO_PATH)\$(PROJ)
%else
EXE_OUT = $(PP_PATH)\app\$(PROJ)
%endif

%elseif "$(EXE_TYPE)" == "distributed"

%if "$(MODE)" == "production"
EXE_OUT = $(PP_PATH)\sdk\app\$(PROJ)
%elseif "$(MODE)" == "debug"
EXE_OUT = $(PP_PATH)\sdk\app\$(PROJ)
%elseif "$(MODE)" == "debug2" && "$(BM)" != "y"
EXE_OUT = $(PP_PATH)\sdk\app\$(PROJ)
%elseif "$(MODE)" == "debug2" && "$(BM)" == "y"
EXE_OUT = $(GO_PATH)\$(PROJ)
%elseif "$(MODE)" == "dos" || "$(MODE)" == "dosdebug"
EXE_OUT = $(GO_PATH)\$(PROJ)
%else
EXE_OUT = $(PP_PATH)\sdk\app\$(PROJ)
%endif

%endif

%endif

#
# Where to put .dll files
#
%if !%defined(DLL_OUT)

%if "$(DLL_TYPE)" == "system"

%if "$(MODE)" == "production"
DLL_OUT = $(PP_PATH)\boot\dll
%elseif "$(MODE)" == "debug"
DLL_OUT = $(PP_PATH)\boot\dll
%elseif "$(MODE)" == "debug2" && "$(BM)" != "y"
DLL_OUT = $(PP_PATH)\boot\dll
%elseif "$(MODE)" == "debug2" && "$(BM)" == "y"
DLL_OUT = $(GO_PATH)\$(PROJ)
%else
DLL_OUT = $(PP_PATH)\boot\dll
%endif

%elseif "$(DLL_TYPE)" == "app"

%if "$(MODE)" == "production"
DLL_OUT = $(PP_PATH)\app\$(PROJ)
%elseif "$(MODE)" == "debug"
DLL_OUT = $(PP_PATH)\app\$(PROJ)
%elseif "$(MODE)" == "debug2" && "$(BM)" != "y"
DLL_OUT = $(PP_PATH)\app\$(PROJ)
%elseif "$(MODE)" == "debug2" && "$(BM)" == "y"
DLL_OUT = $(GO_PATH)\$(PROJ)
%else
DLL_OUT = $(PP_PATH)\app\$(PROJ)
%endif

%elseif "$(DLL_TYPE)" == "service"

%if "$(MODE)" == "production"
DLL_OUT = $(PP_PATH)\service\$(PROJ)
%elseif "$(MODE)" == "debug"
DLL_OUT = $(PP_PATH)\service\$(PROJ)
%elseif "$(MODE)" == "debug2" && "$(BM)" != "y"
DLL_OUT = $(PP_PATH)\service\$(PROJ)
%elseif "$(MODE)" == "debug2" && "$(BM)" == "y"
DLL_OUT = $(GO_PATH)\$(PROJ)
%else
DLL_OUT = $(PP_PATH)\service\$(PROJ)
%endif

%elseif "$(DLL_TYPE)" == "distributed"

%if "$(MODE)" == "production"
DLL_OUT = $(PP_PATH)\sdk\dll\$(PROJ)
%elseif "$(MODE)" == "debug"
DLL_OUT = $(PP_PATH)\sdk\dll\$(PROJ)
%elseif "$(MODE)" == "debug2" && "$(BM)" != "y"
DLL_OUT = $(PP_PATH)\sdk\dll\$(PROJ)
%elseif "$(MODE)" == "debug2" && "$(BM)" == "y"
DLL_OUT = $(GO_PATH)\$(PROJ)
%else
DLL_OUT = $(PP_PATH)\sdk\dll\$(PROJ)
%endif

%elseif "$(DLL_TYPE)" == "distributed_service"
%if "$(MODE)" == "production"
DLL_OUT = $(PP_PATH)\sdk\service\$(PROJ)
%elseif "$(MODE)" == "debug"
DLL_OUT = $(PP_PATH)\sdk\service\$(PROJ)
%elseif "$(MODE)" == "debug2" && "$(BM)" != "y"
DLL_OUT = $(PP_PATH)\sdk\service\$(PROJ)
%elseif "$(MODE)" == "debug2" && "$(BM)" == "y"
DLL_OUT = $(GO_PATH)\$(PROJ)
%else
DLL_OUT = $(PP_PATH)\sdk\service\$(PROJ)
%endif

%endif

%endif


#
# Default target directories
#
%if !%defined(OBJ)
OBJ = $(GO_PATH)\$(PROJ)\obj
%endif

%if !%defined(DOBJ)
DOBJ = $(GO_PATH)\$(PROJ)\dbgobj
%endif

%if !%defined(DOSOBJ)
DOSOBJ = $(GO_PATH)\$(PROJ)\dosobj
%endif

%if !%defined(DDOBJ)
DDOBJ = $(GO_PATH)\$(PROJ)\ddobj
%endif

%if !%defined(PP_INST_OBJ)
PP_INST_OBJ = $(GO_PATH)\$(PROJ)\instobj
%endif

%if !%defined(LIBR)
%if "$(MODE)" == "production"
LIBR = $(PENPOINT_PATH)\sdk\lib
%elseif "$(MODE)" == "debug"
LIBR = $(PENPOINT_PATH)\sdk\lib
%elseif "$(MODE)" == "debug2" && "$(BM)" != "y"
LIBR = $(PENPOINT_PATH)\sdk\lib
%elseif "$(MODE)" == "debug2" && "$(BM)" == "y"
LIBR = $(GO_PATH)\$(PROJ)
%else
LIBR = $(PENPOINT_PATH)\sdk\lib
%endif
%endif

%if !%defined(PLIB)
PLIB = $(GO_PATH)\plib
%endif

%if !%defined(INC)
INC = $(PENPOINT_PATH)\sdk\inc
%endif

%if !%defined(PINC)
PINC = $(GO_PATH)\pinc
%endif

#
# Where to put public .h files
#
%if !%defined(INC_OUT)
%if "$(MODE)" == "production"
INC_OUT	= $(INC)
%elseif "$(MODE)" == "debug"
INC_OUT	= $(INC)
%elseif "$(MODE)" == "debug2"
INC_OUT = $(INC)
%else
INC_OUT	= $(INC)
%endif
%endif

#
# Where to put private .h files
#
%if !%defined(PINC_OUT)
%if "$(MODE)" == "production"
PINC_OUT	= $(PINC)
%elseif "$(MODE)" == "debug"
PINC_OUT	= $(PINC)
%elseif "$(MODE)" == "debug2"
PINC_OUT        = $(PINC)
%else
PINC_OUT	=.
%endif
%endif

#
# Where to put .obj files
#
%if !%defined(OBJ_OUT)
%if "$(MODE)" == "production"
OBJ_OUT	= $(OBJ)
%elseif "$(MODE)" == "debug"
OBJ_OUT	= $(DOBJ)
%elseif "$(MODE)" == "debug2"
OBJ_OUT	= $(DOBJ)
%elseif "$(MODE)" == "dos"
OBJ_OUT = $(DOSOBJ)
%elseif "$(MODE)" == "dosdebug"
OBJ_OUT = $(DDOBJ)
%elseif "$(MODE)" == "installer"
OBJ_OUT = $(PP_INST_OBJ)
%else
OBJ_OUT	= $(GO_PATH)\$(PROJ)
%endif
%endif

#
# Where to put imp .lib files
#
%if !%defined(LIB_OUT)
%if "$(MODE)" == "production"
LIB_OUT	= $(LIBR)
%elseif "$(MODE)" == "debug"
LIB_OUT	= $(LIBR)
%elseif "$(MODE)" == "debug2"
LIB_OUT	= $(LIBR)
%elseif "$(MODE)" == "dos"
LIB_OUT	= $(LIBR)
%elseif "$(MODE)" == "dosdebug"
LIB_OUT	= $(LIBR)
%else
LIB_OUT	= $(LIBR)
%endif
%endif

#
# Where to put private .lib files
#
%if !%defined(PLIB_OUT)
%if "$(MODE)" == "production"
PLIB_OUT = $(PLIB)
%elseif "$(MODE)" == "debug"
PLIB_OUT = $(PLIB)
%elseif "$(MODE)" == "debug2"
PLIB_OUT = $(PLIB)
%elseif "$(MODE)" == "dos"
PLIB_OUT = $(PLIB)
%elseif "$(MODE)" == "dosdebug"
PLIB_OUT = $(PLIB)
%else
PLIB_OUT = $(PLIB)
%endif
%endif

#
# Output filename prefix
#
%if !%defined(PREFIX)
%if "$(MODE)" == "production"
PREFIX	=
%elseif "$(MODE)" == "debug"
PREFIX	=
%elseif "$(MODE)" == "debug2"
PREFIX	=
%else
PREFIX	=
%endif
%endif

#
# Output Private Library prefix
#
%if !%defined(PLIB_PFX)
%if "$(MODE)" == "production"
PLIB_PFX=
%elseif "$(MODE)" == "debug" || "$(MODE)" == "debug2"
%if "$(DLL_PLIBS)" != ""
PLIB_PFX=_
%elseif "$(PLIB_SRCS)" != ""
PLIB_PFX=_
%else
PLIB_PFX=
%endif
%endif
%endif

#
# DLL Libraries to link
#
%if %defined(DLL_PLIBS) 
        DLL_LIBRARIES = $[s,",", $(PLIB_PFX)$(DLL_PLIBS)]
%endif
%if %defined(DLL_PLIBS) && %defined(DLL_LIBS)
        DLL_LIBRARIES += ,$[s,",", $(DLL_LIBS)]
%elseif %defined(DLL_LIBS)
        DLL_LIBRARIES = $[s,",", $(DLL_LIBS)]
%endif

#
# INIT Libraries to link
#
%if %defined(INIT_PLIBS) 
        INIT_LIBRARIES = $[s,",", $(PLIB_PFX)$(INIT_PLIBS)]
%endif
%if %defined(INIT_PLIBS) && %defined(INIT_LIBS)
        INIT_LIBRARIES += ,$[s,",", $(INIT_LIBS)]
%elseif %defined(INIT_LIBS)
        INIT_LIBRARIES = $[s,",", $(INIT_LIBS)]
%endif

#
# Name of DLL_LBC
#
%if %defined(DLL_LNAME) 
        DLL_LBC = dll.lbc
%endif

#
# Name of INIT_LBC
#
%if %defined(INIT_LNAME) 
        INIT_LBC = init.lbc
%endif

#
# C compile flags
#
%if !%defined(CC_OPT)
CC_OPT = /Otaxf+
%endif

#
# C compile flags
#
%if !%defined(CC_FLAGS)
%if "$(MODE)" == "production"
CC_FLAGS = /3s /Sg $(CC_OPT) /W3 /We /Zc /Zq /fpc
%elseif "$(MODE)" == "installer"
CC_FLAGS = /3s /Sg $(CC_OPT) /W3 /We /Zc /Zq /fpc
%elseif "$(MODE)" == "debug"
CC_FLAGS = /3s /Sg $(CC_OPT) /W3 /We /Zc /Zq /fpc
%elseif "$(MODE)" == "debug2"
CC_FLAGS = /3s /Sg /Oif+ /s /W3 /We /Zc /Zq /fpc
%elseif "$(MODE)" == "dos"
CC_FLAGS = /Alwf /G2sc /W3 /Zp /c
%elseif "$(MODE)" == "dosdebug"
CC_FLAGS = /Alwf /G2sc /W3 /Zp /c
%else
CC_FLAGS = /3s /Sg $(CC_OPT) /W3 /We /Zc /Zq /fpc
%endif
%endif

#
# C compile debug flags
#
%if !%defined(CC_DEBUG)
%if "$(MODE)" == "production"
CC_DEBUG =
%elseif "$(MODE)" == "installer"
CC_DEBUG =
%elseif "$(MODE)" == "debug"
CC_DEBUG = /D1 /En /DDEBUG
%elseif "$(MODE)" == "debug2"
  %if "$(BM)" == "y"
    CC_DEBUG = /D2~ /En /DDEBUG
  %else
    CC_DEBUG = /D2 /En /DDEBUG
  %endif
%elseif "$(MODE)" == "dos"
CC_DEBUG = /Zi /DDOS
%elseif "$(MODE)" == "dosdebug"
CC_DEBUG = /Zi /DDOS /DDEBUG /Zd /Od
%else
CC_DEBUG = /D1 /En /DDEBUG
%endif
%endif

#
# Set C environment variable for wcc
#
%if "$(MODE)" == "production"
%if !%defined(WCC)
WCC =
%endif
%else
%if !%defined(WCC)
WCC = /DDEBUG
%else
WCC += /DDEBUG
%endif
%endif

#
# Set C environment variable for wcc386
#
%if !%defined(WCC386)
WCC386 = $(CC_DEBUG) $(CC_FLAGS)
%else
WCC386 += $(CC_DEBUG) $(CC_FLAGS)
%endif

#
# Set C environment variable for wcc386 for installer_version
#
%if "$(MODE)" == "installer"
WCC386 += /DINSTALLER_VERSION
%endif

#
# ASM compile flags
#
%if !%defined(ASM_FLAGS)
ASM_FLAGS = /c /Zm /Fl /Cx
%endif

#
# ASM compile debug flags
#
%if !%defined(ASM_DEBUG)
%if "$(MODE)" == "production"
ASM_DEBUG =
%elseif "$(MODE)" == "debug"
ASM_DEBUG = /Zd
%elseif "$(MODE)" == "debug2"
ASM_DEBUG = /Zd
%else
ASM_DEBUG = /Zd
%endif
%endif

#
# .dll segment size
#
%if !%defined(DLL_SEG)
DLL_SEG = 256
%endif

#
# .dll link flags
#
%if !%defined(DLL_FLAGS)
DLL_FLAGS = /NOD /NOE /B /ST:0
%endif

#
# .dll link debug flags
#
%if !%defined(DLL_DEBUG)
%if "$(MODE)" == "production"
DLL_DEBUG = /MAP /LI
%elseif "$(MODE)" == "debug"
DLL_DEBUG = /CO /MAP /LI
%elseif "$(MODE)" == "debug2"
DLL_DEBUG = /CO /MAP /LI
%else
DLL_DEBUG = /MAP /LI /CO 
%endif
%endif

#
# Watcom .DLL link debug flags
#
%if !%defined(DLL_LINK_DEBUG)
%if "$(MODE)" == "production"
DLL_LINK_DEBUG =
%elseif "$(MODE)" == "debug"
DLL_LINK_DEBUG = DEBUG LINES
%elseif "$(MODE)" == "debug2"
DLL_LINK_DEBUG = DEBUG ALL
%else
DLL_LINK_DEBUG = DEBUG LINES
%endif
%endif

#
# .exe segment size
#
%if !%defined(EXE_SEG)
EXE_SEG = 256
%endif

#
# .exe stack size
#
%if !%defined(EXE_STACK)
EXE_STACK = 15000
%endif

#
# .exe link flags
#
%if !%defined(EXE_FLAGS)
EXE_FLAGS = /NOD /NOE /B
%endif

#
# .exe link debug flags
#
%if !%defined(EXE_DEBUG)
%if "$(MODE)" == "production"
EXE_DEBUG = /MAP /LI
%elseif "$(MODE)" == "debug"
EXE_DEBUG = /CO /MAP /LI
%elseif "$(MODE)" == "debug2"
EXE_DEBUG = /CO /MAP /LI
%else
EXE_DEBUG = /CO /MAP /LI
%endif
%endif

#
# Watcom .exe link debug flags
#
%if !%defined(EXE_LINK_DEBUG)
%if "$(MODE)" == "production"
EXE_LINK_DEBUG =
%elseif "$(MODE)" == "debug"
EXE_LINK_DEBUG = DEBUG LINES
%elseif "$(MODE)" == "debug2"
EXE_LINK_DEBUG = DEBUG ALL
%else
EXE_LINK_DEBUG = DEBUG LINES
%endif
%endif

#
# .def file names
#
%if !%defined(EXE_DEF)
EXE_DEF = exe.def
%endif

%if !%defined(DLL_DEF)
DLL_DEF = dll.def
%endif

%if !%defined(INIT_DEF)
INIT_DEF = init.def
%endif

#
# .def file names
#
%if !%defined(DEFS)
%if %defined(DLL_SRCS)
DEFS1 = $(DLL_DEF)
%endif
%if %defined(EXE_SRCS)
DEFS2 = $(EXE_DEF)
%endif
DEFS = $(DEFS1) $(DEFS2)
%endif

#
# Makefile name
#
%if !%defined(MAKEFILENAME)
MAKEFILENAME = makefile.mak
%endif

#
# Object file names
#
DLL_OBJS = $[f,$(OBJ_OUT),$(DLL_SRCS),obj] $(OTHER_DLL_OBJS)
EXE_OBJS = $[f,$(OBJ_OUT),$(EXE_SRCS),obj] $(OTHER_EXE_OBJS)
PLIB_OBJS = $[f,$(OBJ_OUT),$(PLIB_SRCS),obj] $(OTHER_DLL_OBJS)
INIT_OBJS = $[f,$(OBJ_OUT),$(INIT_SRCS),obj] $(OTHER_INIT_OBJS)

#
# Resource file names
#
# SPage: EXE_RESFILES is derived from EXE_RC only if undefined.
# Note that EXE_RC's are compiled to EXE_RESFILES which create app.res,
# and this is not the same as the other resfiles in EXE_RES.  It's a mess...
%if !%defined(EXE_RESFILES)
%if %defined (EXE_RC)
EXE_RESFILES = $[f,,$(EXE_RC),res]
%endif
%else
%if %defined (EXE_RC)
EXE_RESFILES += $[f,,$(EXE_RC),res]
%endif
%endif

#
# Resource file names
#
%if !%defined(SERVICE_RESFILES)
%if %defined (SERVICE_RC)
OTHER_LAST += $(OBJ_OUT)\timestmp.sr
SERVICE_RESFILES = $[f,,$(SERVICE_RC),res]
%endif
%else
OTHER_LAST += $(OBJ_OUT)\timestmp.sr
SERVICE_RESFILES += $(DLL_OUT)\service.res
%endif

#
# PenPoint resource file names
#
%if %defined(PP_RES)
OTHER_LAST += $(OBJ_OUT)\timestmp.ppr
%endif

#
# Export files
#
EXPORT_INCS = $[f,$(INC_OUT),$(INCS)]
EXPORT_PINCS = $[f,$(PINC_OUT),$(PINCS)]
%if %defined(DLL_SRCS)
EXPORT_LIBS = $(LIB_OUT)\$(PROJ).lib
%endif

#
# Default short name of project for use with symbols.
# Should be overridden for projects with names of 7 or 
# more characters to something with 6 or fewer characters. 
#
%if !%defined(PROJ_ABBREV)
PROJ_ABBREV = $(PROJ)
%endif

#
# Default files to run through gensyms 
#
%if !%defined(SYM_INCS)
SYM_INCS = $(INCS) $(PINCS) $(LINCS)
%endif

#
# Default home
#
%if !%defined(HOME)
HOME = $(PROJ)
%endif

#
# Checkin comment
#
%if !%defined(CI_COMMENT)
CI_COMMENT = "new revision"
%endif

#
# Checkin lock
#
%if !%defined(CI_LOCK)
CI_LOCK = -l
%endif

#
# Default dlc filename
#
%if  %defined(EXE_SRCS) &&   					\
	!%defined(EXE_DLC)  &&    				\
	    ("$(DLL_TYPE)" != "system") &&				\
	        (%defined(DISTRIBUTED_DLLS) || %defined(DLL_SRCS))
    EXE_DLC = $(PROJ).dlc
%endif

%if  !%defined(EXE_SRCS) &&  					\
	!%defined(DLL_DLC) &&  					\
            %defined(DISTRIBUTED_DLLS)
    DLL_DLC = $(PROJ).dlc
%endif

#
# Compute what first to build
#
%if !%defined(BM)
%if !%defined(OTHER_EVERYTHING)
OTHER_EVERYTHING = $(OBJ_OUT)
%else
OTHER_EVERYTHING += $(OBJ_OUT)
%endif
%endif

#
# Compute what to build
#
%if !%defined(EVERYTHING)

%if %defined(DLL_SRCS)

EVERY1 = $(DLL_OUT)\$(PREFIX)$(PROJ).dll $(LIB_OUT)\$(PROJ).lib

%if %defined(MISC)
EVERY1 += $(DLL_OUT)\misc
%endif

%elseif %defined(PLIB_SRCS)
EVERY1 = $(PLIB_OUT)\$(PLIB_PFX)$(PROJ).lib
%endif

%if %defined(DLL_DLC)
EVERY1 += $(DLL_OUT)\$(DLL_DLC)
%endif

%if %defined(EXE_SRCS)

%if %defined(EXE_DLC)
EVERY2 = $(EXE_OUT)\$(EXE_DLC)
%endif

EVERY2 += $(EXE_OUT)\$(PREFIX)$(PROJ).exe

%if %defined(INIT_SRCS)
EVERY2 += $(EXE_OUT)\$(PREFIX)init.dll
%endif

%if %defined(EXE_RESFILES) 
EVERY2 += $(EXE_OUT)\app.res
%endif

%if %defined(MISC)
EVERY2 += $(EXE_OUT)\misc
%endif

%if %defined(HELP)
EVERY2 += $(EXE_OUT)\help
%endif

%if %defined(STATIONERY)
EVERY2 += $(EXE_OUT)\statnry
%endif

%if %defined(INST)
EVERY2 += $(DLL_OUT)\inst
%endif

%endif

EVERYTHING = $(EVERY1) $(EVERY2)

%endif

#
# Where to get source files
#
%if !%defined(BUILD_DIR)
BUILD_DIR = n:\public\go\build\$(ARCH)
%endif

#
# Path to latest
#
%if !%defined(LATEST_PATH)
LATEST_PATH = n:\public\go\latest
%endif

#
# Path to prerelease directory
#
%if !%defined(PREREL_PATH)
PREREL_PATH = n:\public\go\prerel
%endif

#
# Path to release directory
#
%if !%defined(REL_PATH)
REL_PATH = n:\public\go\$(VERSION)
%endif

#
# Path to makefile directory
#
%if !%defined(MAKEFILE_PATH)
MAKE = $(PENPOINT_PATH)\sdk\util\make
%endif
%if !%defined(MAKEFILE_PATH)
MAKEFILE_PATH = $(PENPOINT_PATH)\sdk\util\make
%endif

#
# Path to the tools directory
#
%if !%defined(TOOLS)
TOOLS = $(PENPOINT_PATH)\sdk\util\dos
%endif

#
# Where to get distributed dlls from
#
%if !%defined(DISTRIBUTED_DLLS_IN)

%if "$(MODE)" == "production"
DISTRIBUTED_DLLS_IN = $(PP_PATH)\sdk\dll
%elseif "$(MODE)" == "debug"
DISTRIBUTED_DLLS_IN = $(PP_PATH)\sdk\dll
%elseif "$(MODE)" == "debug2"
DISTRIBUTED_DLLS_IN = $(PP_PATH)\sdk\dll
%else
DISTRIBUTED_DLLS_IN = $(PP_PATH)\sdk\dll
%endif

%if %defined(DISTRIBUTED_DLLS)
%foreach name in $(DISTRIBUTED_DLLS)
FULL_DISTRIBUTED_DLLS += $(DISTRIBUTED_DLLS_IN)\$(name)
%endfor
%endif

%endif

#
# Where to get distributed services from
#
%if !%defined(DISTRIBUTED_SERVICES_IN)

%if "$(MODE)" == "production"
DISTRIBUTED_SERVICES_IN = $(PP_PATH)\sdk\service
%elseif "$(MODE)" == "debug"
DISTRIBUTED_SERVICES_IN = $(PP_PATH)\sdk\service
%elseif "$(MODE)" == "debug2"
DISTRIBUTED_SERVICES_IN = $(PP_PATH)\sdk\service
%else
DISTRIBUTED_SERVICES_IN = $(PP_PATH)\sdk\service
%endif

%if %defined(DISTRIBUTED_SERVICES)
%foreach name in $(DISTRIBUTED_SERVICES)
FULL_DISTRIBUTED_SERVICES += $(DISTRIBUTED_SERVICES_IN)\$(name)
%endfor
%endif

%endif

#
# Where to get distributed apps from
#
%if !%defined(DISTRIBUTED_APPS_IN) && %defined(DISTRIBUTED_APPS)

%if "$(MODE)" == "production"
DISTRIBUTED_APPS_IN = $(PP_PATH)\sdk\app
%elseif "$(MODE)" == "debug"
DISTRIBUTED_APPS_IN = $(PP_PATH)\sdk\app
%elseif "$(MODE)" == "debug2"
DISTRIBUTED_APPS_IN = $(PP_PATH)\sdk\app
%else
DISTRIBUTED_APPS_IN = $(PP_PATH)\sdk\app
%endif

%foreach name in $(DISTRIBUTED_APPS)
FULL_DISTRIBUTED_APPS += $(DISTRIBUTED_APPS_IN)\$(name)
%endfor


%endif

#
# Default app version string
#
%if !%defined(APP_VERSION)
APP_VERSION = 1.0
%endif

#
# Default service version string
#
%if !%defined(SERVICE_VERSION)
SERVICE_VERSION = 1.0
%endif
