C
C     GI CP1600 SYMBOL CROSS REFERENCE GENERATOR
C
      COMMON /IOUNIT/ KXFIL, KEYBD, KDSPLY, LIST, LUNIT
C
      INTEGER SYM,PTR,PTRMAX
      COMMON /USYM/ SYM(4,400),PTR,PTRMAX
C
      INTEGER XLINE,XPTR,XBUF
      COMMON /XWRK1/ NSYM,XLINE,XPTR,XBUF(64)
C
      INTEGER XWORK
      COMMON /XWRK2/ XWORK(600),IS1,IS2
C
      INTEGER RCOUNT, SYMAT
      COMMON/XWRK3/ RCOUNT(401),SYMAT(18)
C
      COMMON /MS16/ MS1(4), MS2(5), MS3(2), MS4(2), MS5(2), MS6(2)
C
      DIMENSION NAMLST(8), NAMXRF(8), KTITLE(6), KTMDT(8)
      DATA KSPC/2H  /
C
C.... IDENTIFY VERSION
C
      WRITE(KDSPLY,1000)
 1000 FORMAT(' S16XRF VER. 01B')
C
C.... REQUEST CROSS REF FILE
C
    5 WRITE(KDSPLY,1025)
 1025 FORMAT(' CROSS REF FILE ?')
      DO 6 I = 1,8
      NAMXRF(I) = KSPC
    6 CONTINUE
      READ(KEYBD,1020) NAMXRF
      IF(NAMXRF(1) .EQ. KSPC) STOP
C
C.... OPEN XREF FILE
C
      CALL OPNINP(NAMXRF(1),KSPC,K)
      IF(K .EQ. 0) GO TO 7
      WRITE(KDSPLY,1030)
 1030 FORMAT(' XREF FILE DOES NOT EXIST !!')
      GO TO 5
C
C.... INITIALIZE
C
    7 LIST = KDSPLY
C
C.... REQUEST LISTING FILE NAME
C.... NO NAME IMPLIES LIST ON TERMINAL
C
      WRITE(KDSPLY,1010)
 1010 FORMAT(' LISTING FILE ?')
      READ(KEYBD,1020) NAMLST
 1020 FORMAT(8A1)
      IF(NAMLST(1) .EQ. KSPC) GO TO 8
      LIST = LUNIT
      CALL OPNLST(NAMLST(1))
C
C.... READ CROSS REF FILE
C
    8 READ  (KXFIL) KTITLE,KTMDT,NSYM,IBIN
      IS1 = 1
      IS2 = NSYM
      IWMAX = 500
      XPTR = 65
C
C.... PRINT LISTING HEADING
C
      WRITE(LIST,1280) KTITLE, KTMDT
 1280 FORMAT(1X,6A1,4X,'GI  S16XRF VER. 01B',10X,8A2,/)
C
C.... INIT COUNT ARRAY
C
      DO 10 I=1,NSYM
   10 RCOUNT(I) = 0
C
C.... FIND ALL SYMBOL REFS (1 TO NSYM) & COUNT
C
   20 CALL XREAD(I)
      IF(I .LT. 0) GO TO 30
      RCOUNT(I) = RCOUNT(I) + 1
      GO TO 20
C
C.... READ IN SYMBOL TABLE
C
   30 READ  (KXFIL) ((SYM(J,I),J=1,4),I=1,NSYM)
C
C.... DATA COLLECTED - COLLECT REFERENCES
C
  100 CONTINUE
      IF (IS1 .GT. NSYM) GO TO 999
      REWIND KXFIL
      XPTR = 65
      READ  (KXFIL) KTITLE,KTMDT,NSYM,IBIN
C
      IOS = 0
      DO 120 I=IS1,NSYM
        NS = IOS + RCOUNT(I)
        IF (NS .LE. IWMAX) GO TO 110
        IS2 = I-1
        GO TO 130
  110   RCOUNT(I) = IOS
        IOS = NS
      IS2 = I
  120 CONTINUE
C
C.... SYMBOL LIMITS THIS PASS ARE IS1,IS2
C....   NOW FILL XWORK WITH REFERENCES
C
  130 CALL XREAD(I)
      IF(I .LT. 0) GO TO 200
      J = RCOUNT(I) + 1
      RCOUNT(I) = J
      XWORK(J) = XLINE
      GO TO 130
C
C.... PASS COMPLETE, LIST SYMBOLS AND REFERENCES
C
  200 CONTINUE
      JSYM = 1
      DO 290 ISYM=IS1,IS2
C
C.... DECODE SYMBOL ATTRIBUTES
C
      I = SYM(4,ISYM)
      I1 = IAND(I,3)+1
C
C.... IF ABS ASSEMBLY MAKE ALL RELS INTO ABS
C
      IF(I1.EQ.3 .AND. IBIN.EQ.2) I1 = 2
      I2 = IAND(ISL(I,-4),7) + 1
      I3 = IAND(ISL(I,-7),1) + 1
      I4 = IAND(ISL(I,-8),1) + 1
      I5 = IAND(ISL(I,-3),1) + 1
      I6 = IAND(ISL(I,-9),1) + 1
C
C.... UNPACK SYMBOL NAME
C
      DO 220 I=1,2
        K = SYM(I,ISYM)
        DO 230 J=1,3
          M = (I*3)-J+1
          SYMAT(M) = MOD40U(MOD(K,40))
          K = K/40
  230   CONTINUE
  220 CONTINUE
C
C.... CONVERT VALUE TO OCTAL DIGITS
C
      I = SYM(3,ISYM)
      K = 12
  240 SYMAT(K) = IAND(I,7)
      I = ISL(I,-3)
      K = K-1
      IF (K.GT.7) GO TO 240
      SYMAT(K) = IAND(I,1)
C
C.... PUT ATTRIBUTE NAMES IN LINE BUFFER
C
      SYMAT(13) = MS1(I1)
      SYMAT(14) = MS2(I2)
      SYMAT(15) = MS3(I3)
      SYMAT(16) = MS4(I4)
      SYMAT(17) = MS5(I5)
      SYMAT(18) = MS6(I6)
C
C.... PRINT NAME, VALUE, ATTRIBUTES, REFERENCES
C
      K = RCOUNT(ISYM)
      WRITE (LIST,1290) (SYMAT(I),I=1,18),(XWORK(I),I=JSYM,K)
 1290 FORMAT (1X,6A1,1X,6I1,2X,A1,1X,A2,1X,A1,1X,A1,1X,A2,1X,A2,2X,
     *           8I6/(32X,8I6))
      JSYM = RCOUNT(ISYM) + 1
  290 CONTINUE
C
C.... PRINTING DONE, SET NEXT PASS
C
      IS1 = IS2 + 1
      GO TO 100
C
  999 CALL CLSINP
      IF(LIST .EQ. LUNIT) CALL CLSLST
      GO TO 5
      END
      SUBROUTINE XREAD(I)
C
      COMMON /IOUNIT/ KXFIL, KEYBD, KDSPLY, LIST, LUNIT
C
      INTEGER XLINE,XPTR,XBUF
      COMMON /XWRK1/ NSYM,XLINE,XPTR,XBUF(64)
C
      INTEGER XWORK
      COMMON /XWRK2/ XWORK(600),IS1,IS2
C
C.... IF BUFFER FINISHED, READ NEW ONE
C
    5 IF (XPTR.LT.65) GO TO 10
      READ  (KXFIL) XBUF
      XPTR = 1
C
C.... PROCESS WORDS UNTIL GOOD SYMBOL OR EOF
C
   10 I = XBUF(XPTR)
      XPTR = XPTR+1
      IF (I.LT.0) GO TO 30
      IF (I.LE.NSYM) GO TO 20
C
C.... SET NEW LINE
C
      XLINE = I - NSYM
      GO TO 5
C
C.... CHECK FOR SYMBOL IN CURRENT RANGE
C
   20 IF (I.LT.IS1 .OR. I.GT.IS2) GO TO 5
C
C.... ARGUMENT VALUE IS GOOD SYMBOL INDEX OR EOF (-1)
C
   30 RETURN
      END
      BLOCK DATA
C
      COMMON /IOUNIT/ KXFIL, KEYBD, KDSPLY, LIST, LUNIT
C
      COMMON /MS16/ MS1(4), MS2(5), MS3(2), MS4(2), MS5(2), MS6(2)
C
      INTEGER ACHR
      COMMON /ACHR/ ACHR(64)
C
      DATA MS1 /2HU , 2HA , 2HR , 2HX /
      DATA MS2 /2H  , 2HEQ, 2HIN, 2HDT, 2HRS/
      DATA MS3 /2H  , 2HG /
      DATA MS4 /2H  , 2HE /
      DATA MS5 /2HUR, 2H  /
      DATA MS6 /2H  , 2HDD/
C
      DATA ACHR /2H  ,2H! ,2H" ,2H# ,2H$ ,2H% ,2H& ,2H' ,
     1           2H( ,2H) ,2H* ,2H+ ,2H, ,2H- ,2H. ,2H/ ,
     2           2H0 ,2H1 ,2H2 ,2H3 ,2H4 ,2H5 ,2H6 ,2H7 ,
     3           2H8 ,2H9 ,2H: ,2H; ,2H< ,2H= ,2H> ,2H? ,
     4           2H@ ,2HA ,2HB ,2HC ,2HD ,2HE ,2HF ,2HG ,
     5           2HH ,2HI ,2HJ ,2HK ,2HL ,2HM ,2HN ,2HO ,
     6           2HP ,2HQ ,2HR ,2HS ,2HT ,2HU ,2HV ,2HW ,
     7           2HX ,2HY ,2HZ ,
     8           2H[ ,2H` ,2H^ ,2H_ /
C             ABOVE HOLLERITH CHARACTERS ARE:
C             LEFT BRACKET, BACK SLASH, RIGHT BRACKET,
C             UP ARROW, LEFT ARROW
C
      DATA KEYBD/1/,KDSPLY/2/,KXFIL/3/,LUNIT/4/
      END
      FUNCTION MOD40U(K)
C
C.... CONVERT MODULO 40 CHARACTER TO HOLLERITH
C
      INTEGER ACHR
      COMMON /ACHR/ ACHR(64)
C
C.... CHECK FOR SPACE ( 0 )
C
      IF(K .EQ. 0) I = 1
C
C.... CHECK FOR A - Z ( 1 - 26 )
C
      IF(K .GE. 1 .AND. K .LE. 26 ) I = K + 33
C
C.... CHECK FOR $ ( 27 )
C
      IF(K .EQ. 27) I = 5
C
C.... CHECK FOR & ( 28 )
C
      IF(K .EQ. 28) I = 7
C
C.... CHECK FOR ? ( 29 )
C
      IF(K .EQ. 29) I = 32
C
C.... CHECK FOR 0 - 9 ( 30 - 39 )
C
      IF(K .GE. 30 .AND. K .LE. 39) I = K - 13
      MOD40U = ACHR(I)
      RETURN
      END
 