      BLOCK DATA
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
      COMMON /CONST/ KB15, ML16B, ML15B
      INTEGER VERNO
      COMMON /VERNO/ VERNO(6)
      INTEGER HEAD, HEADMX, HEADFL
      COMMON /HEADNG/ HEAD(58), HEADMX, HEADFL
      COMMON /PAGCNT/ NUMPAG, NUMLIN, MAXLIN
      INTEGER SYMIDX,SYMLIM,SYMFUL,SYMLOW,SYMMID,SYMMAX,SYMTBL
      COMMON /SYMBOL/ SYMIDX,SYMLIM,SYMFUL,SYMLOW,SYMMID,SYMMAX,
     +                SYMTBL(4,400)
      COMMON /IOUNIT/ KSRC, KOBJ, KEYBD, KDSPLY, KXREF, LIST, LUNIT
      COMMON /INLINE/LINENO,IPTR,INMAX,ILBL,IOPR,IOPRN,ICOMM,IN(60)
      INTEGER ASCBLK
      COMMON /ASCIIK/ ASCBLK, MSK1, MSK2, MSK3
      COMMON /KTERMS/ KTERMS(7)
      COMMON /KDIGS/ KDIGS(16)
      INTEGER ACHR
      COMMON /ACHR/ ACHR(64)
      INTEGER DONEST, DOPTR, DOMAX, DOSTK
      COMMON /DOSTAK/ DONEST, DOPTR, DOMAX, DOSTK(72)
      COMMON /IFSTAK/ IFFLG, IFCNT, IFPTR, IFMAX, IFSTK(40)
      COMMON /IDNMSK/ M1,M2,KHRBIT
C.... MASKS FOR CLEARING & SETTING THE SECOND HOLLERTITH
C.... CHARACTER IN HOST COMPUTER WORD
      DATA M1/8ZFF00FFFF/, M2/8Z00FF0000/
C.... NUMBER OF BITS IN HOST COMPUTER HOLLERITH CHARACTER
      DATA KHRBIT/8/
C.... MAX DO STACK DEPTH
      DATA DOMAX/4/
C.... MAX IF-THEN BLOCKS
      DATA IFMAX/40/
C.... MASKS
      DATA KB15 /4Z8000/, ML16B /4ZFFFF/, ML15B /4Z7FFF/
C.... VERSION MESSAGE TEXT
      DATA VERNO(1)/'S1'/, VERNO(2)/'6S'/, VERNO(3)/'XA'/
      DATA VERNO(4)/'L '/, VERNO(5)/'V0'/, VERNO(6)/'2D'/
C.... HEADING BUFFER
      DATA HEADMX /58/, HEADFL /0/
C.... PAGE CONTROLS
      DATA NUMPAG/0/, NUMLIN/0/, MAXLIN/60/
C.... SYMBOL TABLE CONTROLS
      DATA SYMIDX/1/, SYMLIM/400/
C.... I/O UNITS
      DATA KSRC/3/,KOBJ/4/,KEYBD/1/,KXREF/5/
      DATA KDSPLY/2/,LUNIT/6/
C.... STATEMENT TAB POSITION CONTROLS
      DATA IPTR/1/,  INMAX/59/, ILBL/1/
      DATA IOPR/8/, IOPRN/13/, ICOMM/25/
C.... MASKS
      DATA ASCBLK/4Z2020/
      DATA MSK1/2ZFF/, MSK2/4ZFF00/, MSK3/4ZFC00/
C.... STRING TERMINATION CHARACTERS
      DATA KTERMS(1)/'  '/, KTERMS(2)/','/
      DATA KTERMS(3)/';'/,  KTERMS(4)/'+'/
      DATA KTERMS(5)/'-'/, KTERMS(6)/' '/
      DATA KTERMS(7)/' '/
C.... LITERAL DIGITS
      DATA KDIGS(1)/'0'/, KDIGS(2)/'1'/
      DATA KDIGS(3)/'2'/, KDIGS(4)/'3'/
      DATA KDIGS(5)/'4'/, KDIGS(6)/'5'/
      DATA KDIGS(7)/'6'/, KDIGS(8)/'7'/
      DATA KDIGS(9)/'8'/, KDIGS(10)/'9'/
      DATA KDIGS(11)/'A'/, KDIGS(12)/'B'/
      DATA KDIGS(13)/'C'/, KDIGS(14)/'D'/
      DATA KDIGS(15)/'E'/, KDIGS(16)/'F'/
C.... ASCII CHARACTERS
      DATA ACHR /1H ,1H!,1H",1H#,1H$,1H%,1H&,1H',
     1           1H(,1H),1H*,1H+,1H,,1H-,1H.,1H/,
     2           1H0,1H1,1H2,1H3,1H4,1H5,1H6,1H7,
     3           1H8,1H9,1H:,1H;,1H<,1H=,1H>,1H?,
     4           1H@,1HA,1HB,1HC,1HD,1HE,1HF,1HG,
     5           1HH,1HI,1HJ,1HK,1HL,1HM,1HN,1HO,
     6           1HP,1HQ,1HR,1HS,1HT,1HU,1HV,1HW,
     7           1HX,1HY,1HZ,1H[,1H\,1H],1H^,1H_/
      END

      COMMON /INLINE/LINENO,IPTR,INMAX,ILBL,IOPR,IOPRN,ICOMM,IN(60)
      INTEGER ORGFLG
      COMMON /ORGFLG/ ORGFLG
      INTEGER ENTFLG
      COMMON /ENTFLG/ ENTFLG
      INTEGER TITLE
      COMMON /TITLE/ TITLE(6)
      INTEGER SYMIDX,SYMLIM,SYMFUL,SYMLOW,SYMMID,SYMMAX,SYMTBL
      COMMON /SYMBOL/ SYMIDX,SYMLIM,SYMFUL,SYMLOW,SYMMID,SYMMAX,
     +                SYMTBL(4,400)
      INTEGER ASMFLG
      COMMON /CAFLGS/ LSTFLG, ASMFLG
      INTEGER SDBDSW
      COMMON /SDBDSW/ SDBDSW
      INTEGER CASFLG
      COMMON /CASFLG/ CASFLG
      INTEGER BINFLG, BINTYP
      COMMON /BINFLG/ BINFLG, BINTYP
      INTEGER WRDSIZ
      COMMON /WRDSIZ/ WRDSIZ
      COMMON /MEMLIM/ MEMLO, MEMHI
      COMMON /LSTFLG/ LSTOPT, LSTFIL, LSTXPD
      COMMON /INPUT/ INPUT(60)
      INTEGER ACHR
      COMMON /ACHR/ ACHR(64)
      EQUIVALENCE (KSPC,ACHR(1))
      INTEGER HEAD, HEADMX, HEADFL
      COMMON /HEADNG/ HEAD(58), HEADMX, HEADFL
      COMMON /CODE/ NPASS,LOC,INCODE,INSTR,ISKEL,LNKCOD,LSTCOD
      COMMON /ERRCNT/ NERR, NINFO
      COMMON /PAGCNT/ NUMPAG, NUMLIN, MAXLIN
      COMMON /IOUNIT/ KSRC, KOBJ, KEYBD, KDSPLY, KXREF, LIST, LUNIT
      COMMON /FNAMES/ NAMIN(8), NAMBIN(8), NAMXRF(8), NAMLST(8)
      INTEGER VERNO
      COMMON /VERNO/ VERNO(6)
      INTEGER XFLG, XLINE, XPTR, XBUF
      COMMON /XREF/ XFLG, NSYM, XLINE, XPTR, XBUF(64)
      COMMON /DATE/ KTD(8)
      INTEGER UTIL
      COMMON /REGS/ UTIL, INDX, LINK
      INTEGER OBJBFR
      COMMON /OBJBFR/ OBJBFR(64)
      INTEGER DONEST, DOPTR, DOMAX, DOSTK
      COMMON /DOSTAK/ DONEST, DOPTR, DOMAX, DOSTK(72)
      COMMON /IFSTAK/ IFFLG, IFCNT, IFPTR, IFMAX, IFSTK(40)
C.... IDENTIFY CURRENT VERSION NUMBER
      WRITE(KDSPLY,1020) VERNO
 1020 FORMAT(X,6A2)
C.... GET TIME AND DATE
   10 CALL TIME
C.... REQUEST USER TO IDENTIFY FILES
      CALL IDENT
C.... INITIALIZE FOR PASS 1
      NPASS = 1
C.... SYMBOL TABLE POINTER
      SYMIDX = 1
C.... SYMBOL TABLE OVERFLOW FLAG
      SYMFUL = 0
C.... IF-THEN BLOCK COUNT
      IFCNT = 0
C.... CLEAR TITLE BUFFER
      DO 20 I = 1, 6, 1
      TITLE(I) = KSPC
   20 CONTINUE
C.... INITIALIZE FOR PASS 1 & 2
C.... INDICATE PASS NUMBER
   30 WRITE(KDSPLY,1025) NPASS
 1025 FORMAT(/,' PASS',I2)
C.... LOCATION COUNTER
      LOC = 0
C.... ORG LISTING FLAG
      ORGFLG = 0
C.... OPERATION CODE
      INCODE = 0
C.... PAGE = HOME ON FIRST WRITE NUMBER, LINES/PAGE
      NUMPAG = 0
      NUMLIN = MAXLIN
C.... STATEMENT LINE NUMBER
      LINENO = 0
C.... CLEAR DBL BYTE DATA
      SDBDSW = 0
C.... CLEAR OPEN CONDITIONAL ASSEMBLY FLAG
      CASFLG = 0
C.... TOTAL NUMBER ERRORS, INFORMATIVES
      NERR = 0
      NINFO = 0
C.... # BITS IN MEMORY WORD
      WRDSIZ = 0
C.... MEMORY LIMITS
      MEMLO = 0
      MEMHI = 32767
C.... OBJECT BUFFER
      DO 35 I = 1, 64, 1
      OBJBFR(I) = 0
   35 CONTINUE
C.... RELOCATABLE ASSEMBLY
      BINTYP = 1
C.... ENTRY DEFINTION FLAG
      ENTFLG = 0
C.... CONDITIONAL ASSEMBLY
      ASMFLG = 1
C.... CONDITIONAL LISTING
      LSTFLG = 1
C.... INDEX REGISTER
      INDX = 4
C.... UTILITY REGISTER
      UTIL = 3
C.... LINKAGE REGISTER
      LINK = 5
C.... SET DO NEST COUNT
      DONEST = 0
C.... SET DO STACK POINTER
      DOPTR = 1
C.... SET IF-THEN CONTROLS
      IFFLG = 0
      IFPTR = 1
C.... CLEAR PAGE HEADING BUFFER
      HEADFL = 0
      DO 40 I = 1, HEADMX, 1
      HEAD(I) = KSPC
   40 CONTINUE
C.... READ A STATEMENT
   45 CALL INSRC
C.... ASSEMBLE STATEMENT
      CALL ASMBL
C.... CHECK FOR END OF STATEMENT
      IF(INCODE .NE. -1) GO TO 45
C.... TERMINATE AFTER PASS 2
      IF(NPASS .EQ. 2) GO TO 100
C.... RE-POSITION FILE FOR INPUT TO PASS 2
      REWIND KSRC
C.... COMPLETE ANY INDIRECT SYMBOL DEFINTIONS
      CALL FINSYM
C.... SORT SYMBOL TABLE
      CALL SRTSYM
C.... OPEN OBJECT FILE IF REQUIRED
      IF(BINFLG .NE. -1) CALL OPNOUT(NAMBIN(1))
C.... OPEN LIST FILE IF REQUIRED
      IF(LSTFIL .EQ. 1) CALL OPNLST(NAMLST(1))
C.... OPEN CROSS REFERENCE FILE IF REQUIRED
      IF(XFLG .EQ. 0) GO TO 50
      NSYM = SYMIDX - 1
      CALL OPNXRF(NAMXRF(1))
      WRITE(KXREF) TITLE, KTD, NSYM, BINTYP
      XLINE = NSYM
      XPTR = 1
C.... INITIALIZE FOR PASS 2
   50 NPASS = 2
C.... RUN PASS 2
      GO TO 30
C.... END PASS 2
C.... CHECK FOR OPEN IF-THEN BLOCKS
  100 IF(IFFLG .NE. 0) CALL ERROR(21)
C.... CHECK FOR OPEN DO-LOOPS
      IF(DOPTR .NE. 1) CALL ERROR(22)
C.... CHECK FOR TOO MANY IF-THEN BLOCKS
      IF(IFCNT .GT. IFMAX) CALL ERROR(24)
C.... CHECK FOR END OF FILE
      READ(KSRC,1050,END=103) INPUT
 1050 FORMAT(60A1)
      CALL ERROR(26)
C.... CHECK FOR OBJECT FILE GENERATED
  103 IF(BINFLG .EQ. -1) GO TO 113
C.... APPEND SYMBOL TABLE TO OBJECT FILE
C.... CHECK FOR NULL TABLE
      IF(SYMIDX .LE. 1) GO TO 110
C.... WRITE SYMBOLS
      L = SYMIDX - 1
      K = 0
      DO 105 I = 1, L, 1
      WRITE(KOBJ) K, (SYMTBL(J,I), J = 1, 3, 1), K, K
  105 CONTINUE
C.... MARK END OF FILE
  110 K = -1
      WRITE(KOBJ) K, K, K, K, K, K
C.... CLOSE OBJECT FILE
      CALL CLSOUT
C.... CLOSE OUT CROSS REFERENCE FILE IF OPEN
  113 IF(XFLG .EQ. 0) GO TO 115
      CALL REFSYM(-1)
      WRITE(KXREF) ((SYMTBL(J,I),J=1,4),I=1,NSYM)
      CALL CLSXRF
C.... CHECK FOR LISTING REQUESTED
  115 IF(LSTOPT .EQ. 0) GO TO 120
C.... LIST SYMBOL TABLE
      CALL LSTSYM
C.... LIST ERROR SUMMARY
      IF(NUMLIN .GT. MAXLIN-4) CALL NXTPAG
      WRITE(LIST,1010) NERR, NINFO
C.... LIST FILE NAMES
      WRITE(LIST,1000) NAMIN, NAMBIN, NAMXRF
 1000 FORMAT(/,' SRC FILE:',8A1,'  OBJ FILE:',8A1,
     +        '  XREF FILE:',8A1)
C.... IF FILE LISTING, SUMMARIZE ERRORS ON TERMINAL
      IF(LSTFIL .EQ. 0) GO TO 140
C.... SUMMARIZE ERRORS IF NO LISTING WAS REQUESTED
  120 WRITE(KDSPLY,1010) NERR, NINFO
 1010 FORMAT(1X,I4,' ERR(S)  ',I4,' INFO(S)')
C.... ASSEMBLY FINISHED, CLOSE SOURCE FILE
  140 CALL CLSINP
C.... CLOSE LISTING FILE IF OPEN
      IF(LSTFIL .EQ. 1) CALL CLSLST
C.... RE-RUN
      WRITE(KDSPLY,1040)
 1040 FORMAT(///)
      GO TO 10
      END

      SUBROUTINE TIME
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... RETURN TIME AND DATE
      COMMON /DATE/ KTD(8)
      COMMON /KDT/ KDT(4)
      CALL TIMDAT
      DECODE(16,1000,KDT) KTD
 1000 FORMAT(8A2)
      RETURN
      END
      SUBROUTINE ASMBL
      IMPLICIT INTEGER(A-Z)
C.... GENERAL INSTRUMENT CORPORATION
C.... 600 WEST JOHN STREET
C.... MICROELECTRONICS DIVISION
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C.... INSTRUCTION ASSEMBLER
C.... RELOCATABLE OBJECT CODES
C.... 0 = ADDRESS CHANGE, DELTA FOLLOWS IN NEXT WORD
C.... 1 = 1 WORD ABSOLUTE FOLLOWS
C.... 2 = 2 WORDS ABSOLUTE FOLLOW
C.... 3 = 3 WORDS ABSOLUTE FOLLOW
C.... 4 = 1 WORD RELOCATABLE FOLLOWS
C.... 5 = 1 WORD ABSOLUTE, 1 WORD RELOCATABLE FOLLOW
C.... 6 = 1 WORD ABSOLUTE, 2 WORDS RELOCATABLE FOLLOW (DBL BYTE LIT)
C.... 7 = 2 BYTES RELOCATABLE FOLLOW (BYTE DIRECTIVE)
C.... 8 = 1 WORD ABSOLUTE, 2 WORDS RELOCATBLE FOLLOW (J,JSR)
C.... 9 = 1 EXTERNAL REFERENCE WORD FOLLOWS
C.... 10 = 1 ABS WORD, 1 EXT REF WORD FOLLOWS
C.... 11 = 1 ABS WORD, 1 EXT REF DISPL WORD FOLLOWS
C.... 12 = 1 ABS WORD, 2 EXT REF BYTES FOLLOW
C.... 13 = 2 EXT REF BYTES FOLLOW
C.... 14 = 1 ABS WORD, 2 EXT REF WORDS (J,JSR) FOLLOW
C.... 15 = 1 PROGRAM ENTRY ADDRESS WORD FOLLOWS
C.... 16 = 2 MODULE IDENTIFICATION WORDS FOLLOW
C.... 17 = 2 GLOBAL SYMBOL WORDS FOLLOW
C.... 18 = 2 EXTERNAL REF SYMBOL WORDS FOLLOW
C.... ASCII BLANKS AND MASKS (MSK1 = 2ZFF, MSK2 = 4ZFF00, MSK3 = 4ZFC00)
      COMMON /ASCIIK/ ASCBLK, MSK1, MSK2, MSK3
      COMMON /ERRPTR/ ERRPTR
      COMMON /DSCSTK/ DSCSTK(6)
      COMMON /DOSTAK/ DONEST, DOPTR, DOMAX, DOSTK(72)
      COMMON /IFSTAK/ IFFLG, IFCNT, IFPTR, IFMAX, IFSTK(40)
      COMMON /ORGFLG/ ORGFLG
      COMMON /TITLE/ TITLE(6)
      COMMON /CONST/ KB15, ML16B, ML15B
      COMMON /SDBDSW/ SDBDSW
      COMMON /CASFLG/ CASFLG
      COMMON /ENTFLG/ ENTFLG
      COMMON /WRDSIZ/ WRDSIZ
      COMMON /BINFLG/ BINFLG, BINTYP
      COMMON /CODE/ NPASS,LOC,INCODE,INSTR,ISKEL,LNKCOD,LSTCOD
      COMMON /ARGS/ VALUE, STATUS, NATURE, SCOND, STYPE
      COMMON /INLINE/LINENO,IPTR,INMAX,ILBL,IOPR,IOPRN,ICOMM,IN(60)
      COMMON /KTERMS/ KTERMS(7)
      COMMON /KDIGS/ KDIGS(16)
      COMMON /ACHR/ ACHR(64)
      EQUIVALENCE (KSPC,ACHR(1))
      EQUIVALENCE (KXCLM,ACHR(2))
      EQUIVALENCE (KQUOT,ACHR(3))
      EQUIVALENCE (KPRCNT,ACHR(6))
      EQUIVALENCE (KAMPRS,ACHR(7))
      EQUIVALENCE (KAPOS,ACHR(8))
      EQUIVALENCE (KLPRN,ACHR(9))
      EQUIVALENCE (KRPRN,ACHR(10))
      EQUIVALENCE (KASTRX,ACHR(11))
      EQUIVALENCE (KPLUS,ACHR(12))
      EQUIVALENCE (KCOMMA,ACHR(13))
      EQUIVALENCE (KMINUS,ACHR(14))
      EQUIVALENCE (KDOT,ACHR(15))
      EQUIVALENCE (KSLASH,ACHR(16))
      EQUIVALENCE (K1,ACHR(18))
      EQUIVALENCE (K2,ACHR(19))
      EQUIVALENCE (K6,ACHR(23))
      EQUIVALENCE (K7,ACHR(24))
      EQUIVALENCE (KSCOLN,ACHR(28))
      EQUIVALENCE (KEQ,ACHR(30))
      EQUIVALENCE (KA,ACHR(34))
      EQUIVALENCE (KD,ACHR(37))
      EQUIVALENCE (KC,ACHR(36))
      EQUIVALENCE (KE,ACHR(38))
      EQUIVALENCE (KF,ACHR(39))
      EQUIVALENCE (KG,ACHR(40))
      EQUIVALENCE (KH,ACHR(41))
      EQUIVALENCE (KI,ACHR(42))
      EQUIVALENCE (KL,ACHR(45))
      EQUIVALENCE (KN,ACHR(47))
      EQUIVALENCE (KO,ACHR(48))
      EQUIVALENCE (KP,ACHR(49))
      EQUIVALENCE (KQ,ACHR(50))
      EQUIVALENCE (KR,ACHR(51))
      EQUIVALENCE (KS,ACHR(52))
      EQUIVALENCE (KT,ACHR(53))
      EQUIVALENCE (KU,ACHR(54))
      EQUIVALENCE (KW,ACHR(56))
      EQUIVALENCE (KX,ACHR(57))
      EQUIVALENCE (KZ,ACHR(59))
      EQUIVALENCE (KUPARW,ACHR(63))
      COMMON /SYMTMP/ SYMTMP(4)
      COMMON /HEADNG/ HEAD(58), HEADMX, HEADFL
      COMMON /CAFLGS/ LSTFLG, ASMFLG
      COMMON /MEMLIM/ LOMEM, HIMEM
      COMMON /REGS/ UTIL, INDX, LINK
      DIMENSION WRDVAL(16)
      DATA WRDVAL/1,3,7,15,31,63,127,255,511,1023,
     +            2047,4095,8191,16383,32767,0/
C.... NMI = AAD1 HEX, 125321 OCTAL
      DATA NMI/4ZAAD1/
C.... NDI = A969 HEX, 124551 OCTAL
      DATA NDI/4ZA969/
C.... CLEAR LISTING RELOCATION FLAG
      LSTCOD = KSPC
C.... SET NORMAL STRING TERMINATION
      KTERMS(6) = KSPC
      KTERMS(7) = KSPC
C.... SET "!" ERROR POINTER
      ERRPTR = KXCLM
C.... CHECK FOR BLANK OR COMMENTS LINE
      DO 60 IPTR = ILBL, INMAX, 1
      IF (IN(IPTR) .NE. KSPC) GO TO 100
   60 CONTINUE
C.... BLANK LINE, LIST IT
      GO TO 260
C.... FOUND SOMETHING, CHECK FOR COMMENTS LINE
  100 IF (IN(IPTR) .EQ. KSCOLN) GO TO 260
C.... IDENTIFY STATEMENT OPERATOR
      CALL IDNTOP
C.... CHECK FOR DIRECTIVES NOT EFFECTED BY CONDITIONAL ASSEMBLY
C.... I.E., IFEQ, IFNE, ENDC
      IF (INCODE .GE. -11 .AND. INCODE .LE. -9) GO TO 155
C.... IF ASSEMBLY DISABLED BY DIRECTIVE, LIST SOURCE ONLY
      IF (ASMFLG .EQ. 0) GO TO 260
C.... CHECK FOR STATEMENT LABEL
  155 IPTR = ILBL
      IF (IN(1) .EQ. KSPC) GO TO 160
C.... GOT LABEL, CHECK FOR OPERATORS ALLOWING LABELS,IE,
C.... INSTRUCTIONS, EQU
C.... RES, ZERO, WORD, BYTE, TEXT
      IF (INCODE .GE. 0 .OR. INCODE .EQ. -5) GO TO 180
      IF (INCODE .LE. -15 .AND. INCODE .GE. -19) GO TO 180
C.... INVALID USE OF LABEL, ISSUE DIAGNOSTIC, IGNORE LABEL
      CALL ERROR(1)
      GO TO 200
C.... NO LABEL, CHECK FOR EQU, IE, MUST HAVE LABEL WITH EQU
C.... IF HAVE EQU WITH NO LABEL, ISSUE DIAGNOSTIC, IGNORE IT
  160 IF (INCODE .EQ. -5) CALL ERROR(1)
      GO TO 200
C.... STATEMENT HAS A LABEL
C.... ON PASS 1 INSERT LABEL IN SYMBOL TABLE
C.... ON PASS 2 CHECK LABEL FOR MULTIPLE DEFINITION
  180 CALL LBLPRC
C.... PROCESS OPERATORS
C.... ASSEMBLY DIRECTIVE, UNRECOGNIZED OP, INSTRUCTIONS
C.... SET OPERAND POINTER
  200 IPTR = IOPRN
      IF (INCODE) 220, 1000, 1050
C.... ASSEMBLY DIRECTIVES
C.... -1 = END
C.... -2 = ABS
C.... -3 = ORG
C.... -4 = EOT
C.... -5 = EQU
C.... -6 = PAGE
C.... -7 = LST
C.... -8 = NLST
C.... -9 = IFEQ
C.... -10 = IFNE
C.... -11 = ENDC
C.... -12 = HEAD
C.... -13 = BITS
C.... -14 = MEML
C.... -15 = RES
C.... -16 = ZERO
C.... -17 = WORD
C.... -18 = BYTE
C.... -19 = TEXT
C.... -20 = ENTR
C.... -21 = REL
C.... -22 = GLOB
C.... -23 = EXT
C.... -24 = UTIL
C.... -25 = INDX
C.... -26 = LINK
C.... -27 = REGS
C.... PROCESS ASSEMBLY DIRECTIVES
  220 I = -INCODE
      GO TO ( 240, 250, 300, 260, 270, 440, 480, 500, 540, 580,
     +        600, 620, 700, 740, 800, 800, 860, 860, 900, 940,
     +        950, 980, 980, 3200, 3300, 3400, 3500), I
C.... E N D
  240 CALL OPRFIN
      IF (NPASS .EQ. 2) GO TO 245
      IF (IFPTR .GT. IFMAX) GO TO 243
      IFSTK(IFPTR) = LOC
      IFPTR = IFPTR + 1
  243 IFCNT = IFCNT + 1
  245 IF (IFFLG .LE. 0) GO TO 247
      IFFLG = IFFLG -1
      INCODE = 0
      GO TO 260
C!!!! WATCH OUT FOR 16 BIT INSTALLATIONS
  247 IF (LOC .GT. 0) LOC = LOC - 1
C.... CLOSE OUT OBJECT MODULE
      CALL WRTOBJ(-3,0)
C.... LIST LAST USED LOCATION AND SOURCE
      CALL PRINT(4)
      GO TO 280
C.... A B S
  250 I = 2
      GO TO 955
C.... E O T
  260 CALL PRINT(1)
      GO TO 280
C.... E Q U
  270 CALL PRINT(5)
C.... COMMON SUBROUTINE RETURN PATH
  280 RETURN
C.... O R G
  300 CALL XTROPR
      IF (VALUE .GE. 0) GO TO 310
C.... OPERAND VALUE ILLEGAL
      CALL ERROR(12)
      GO TO 260
C.... CHECK FOR ANY BINARY OUTPUT YET
  310 IF (BINFLG .NE. 1) GO TO 320
C.... ISSUE ADDRESS ADJUSTMENT OBJ SEQ
C!!!! WATCH OUT FOR 16 BIT INSTALLATIONS
      CALL  WRTOBJ(0,VALUE-LOC)
C.... SET NEW LOCATION COUNTER
  320 LOC = VALUE
C.... CHECK FOR MEM LIMIT ERROR
      IF (LOC .LT. LOMEM .OR. LOC .GT. HIMEM) CALL ERROR(20)
C.... IF OPERAND NOT ABS, ILLEGAL VALUE DIAGNOSTIC
      IF (SCOND .GT. 1) CALL ERROR(12)
C.... CHECK FOR OPERAND FINISHED
  330 CALL OPRFIN
  340 ORGFLG = 1
      CALL PRINT(4)
      GO TO 280
C.... P A G E
  440 CALL OPRFIN
      CALL PRINT(1)
      CALL NXTPAG
      GO TO 280
C.... L S T
  480 LSTFLG = 1
  490 CALL OPRFIN
      GO TO 260
C.... N L S T
  500 CALL OPRFIN
      CALL PRINT(1)
      LSTFLG = 0
      GO TO 280
C.... I F E Q
  540 ASMFLG = 0
      CALL XTROPR
      IF (VALUE .EQ. 0) ASMFLG = 1
C.... CHECK FOR OPEN CONDITIONAL ASSEMBLY
  545 I = IPTR
      IPTR = IOPR
      IF (CASFLG .NE. 0) CALL ERROR(19)
      CASFLG = 1
      IPTR = I
C.... CHECK FOR OPERAND ABS
  550 IF (SCOND .GT. 1) CALL ERROR(12)
      GO TO 490
C.... I F N E
  580 ASMFLG = 0
      CALL XTROPR
      IF (VALUE .NE. 0) ASMFLG = 1
      GO TO 545
C.... E N D C
  600 ASMFLG = 1
C.... CHECK FOR OPEN CONDITIONAL ASSEMBLY
      I = IPTR
      IPTR = IOPR
      IF (CASFLG .NE. 1) CALL ERROR(19)
      IPTR = I
      CASFLG = 0
      GO TO 490
C.... H E A D
  620 DO 630 I = 1, HEADMX, 1
      HEAD(I) = KSPC
  630 CONTINUE
C.... SET HEADING FLAG
      HEADFL = 1
C.... USE FIRST CHARACTER AS STRING DELIMITER
      K = IN(IPTR)
C.... Q ERROR IF DELIMTER NOT " OR '
      IF (K .NE. KQUOT .AND. K .NE. KAPOS) CALL ERROR (14)
      IPTR = IPTR + 1
C.... MOVE STRING TO HEADING BUFFER UNTIL DELIMTER
      I = 1
  640 IF (IN(IPTR) .EQ. K) GO TO 650
      HEAD(I) = IN(IPTR)
C.... CHECK FOR END OF SOURCE OR HEAD BUFFER FULL
      IF (IPTR .GE. INMAX .OR. I .GE. HEADMX) GO TO 660
      IPTR = IPTR + 1
      I = I + 1
      GO TO 640
C.... BYPASS STRING TERMINATOR
  650 IPTR = IPTR + 1
      GO TO 490
C.... POSSIBLE HEADING STRING TRUNCATION
  660 CALL ERROR(17)
      GO TO 260
C.... B I T S
  700 CALL XTROPR
      IF (VALUE .GE. 1 .AND. VALUE .LE. 16) GO TO 710
C.... OPERAND VALUE ILLEGAL
      CALL ERROR(12)
      VALUE = 16
C.... SET MEMORY WORD SIZE
  710 WRDSIZ = WRDVAL(VALUE)
      GO TO 550
C.... M E M L
  740 CALL XTROPR
C.... IF OPERAND NOT ABS, ILLEGAL VALUE DIAGNOSTIC
      IF (SCOND .GT.1) GO TO 745
      IF (VALUE .GE. 0) GO TO 750
      VALUE = 0
C.... CHECK FOR OPERAND VALUE ILLEGAL
  745 CALL ERROR(12)
  750 CALL NXTSTR
      IF (STATUS .EQ. 1) GO TO 760
      IF (VALUE .GE. 0) GO TO 770
  755 CALL ERROR (12)
      VALUE = 8191
C.... MEML, DEFINE LOWER AND UPPER MEMORY ADDRESS LIMITS
  760 LOMEM = 0
      HIMEM = VALUE
      GO TO 260
  770 LOMEM = VALUE
      CALL XTROPR
      IF (VALUE .LT. LOMEM) GO TO 755
      HIMEM = VALUE
      GO TO 550
C.... R E S   -   Z E R O
C.... EXTRACT NUMBER OF WORDS TO RES OR ZERO
  800 CALL XTROPR
C.... CHECK FOR OPERAND ABSOLUTE
      IF (SCOND .GT. 1) CALL ERROR(12)
      IF (VALUE .GT. 0) GO TO 810
      CALL ERROR(12)
      CALL PRINT(4)
      GO TO 280
C.... CHECK FOR OPERAND FINISHED
  810 CALL OPRFIN
      CALL PRINT(4)
C.... CHECK FOR 'ZERO'
      IF (INCODE .EQ. -16) GO TO 840
C.... RES
  820 CALL WRTOBJ(0,VALUE)
C!!!! WATCH OUT FOR 16 BIT INSTALLATIONS
      LOC = LOC + VALUE
      GO TO 280
C.... ZERO
  840 INSTR = 0
      LNKCOD = 1
  850 CALL GENCOD(3)
      VALUE = VALUE - 1
      IF (VALUE .LE. 0) GO TO 280
      GO TO 850
C.... W O R D   -   B Y T E
  860 CALL PRINT(4)
      ERRPTR = KUPARW
C.... EXTRACT OPERAND
  870 CALL XTROPR
C.... CHECK FOR BYTE
      IF (INCODE .EQ. -18) GO TO 890
C.... CHECK FOR WORD SIZE EXCEEDED
      CALL CHKWRD
      INSTR = VALUE
C.... SET 1 WORD ABS OBJ SEQ
      LNKCOD = 1
      LSTCOD = KSPC
C.... CHECK FOR RELOCATABLE OPERAND
      IF (SCOND .NE. 2) GO TO 875
C.... SET RELOCATABLE CODES
      LNKCOD = 4
      LSTCOD = KR
C.... CHECK FOR EXTERNAL OPERAND
  875 IF (SCOND .NE. 3) GO TO 880
      LNKCOD = 9
      LSTCOD = KX
  880 CALL GENCOD(3)
C.... LOCATE NEXT OPERAND, CHECK FOR NO MORE
      CALL NXTSTR
      IF (STATUS .EQ. 1) GO TO 280
      GO TO 870
C.... BYTE
C.... SET 2 WORD ABS OBJ CODE SEQ
  890 LNKCOD = 2
      LSTCOD = KSPC
C.... CHECK FOR RELOCATABLE OPERAND
      IF (SCOND .NE. 2) GO TO 893
      LNKCOD = 7
      LSTCOD = KR
      GO TO 895
C.... CHECK FOR EXTERNAL OPERAND
  893 IF (SCOND .NE. 3) GO TO 895
      LNKCOD = 13
      LSTCOD = KX
C.... EXTRACT LOW BYTE, HIGH BYTE
  895 I = VALUE
      VALUE = IAND(VALUE,MSK1)
      CALL CHKWRD
      INSTR = VALUE
      CALL  GENCOD(3)
C.... SET OBJ SEQ CONTINUATION
      LNKCOD = -1
C.... EXTRACT HIGH BYTE
      VALUE = ISL(IAND(I,MSK2),-8)
      CALL CHKWRD
      INSTR = VALUE
      GO TO 880
C.... T E X T
  900 CALL PRINT(4)
      ERRPTR = KUPARW
      LNKCOD = 1
      L = 0
C.... CHECK FOR TEXT 2 (2 CHRS/WORD)
      IF (IN(IPTR) .EQ. K2) GO TO 903
C.... CHECK FOR TEXT 1 (1 CHR/WORD)
      IF (IN(IPTR) .NE. K1) GO TO 905
      L = 1
C.... BYPASS 1 OR 2
  903 IPTR = IPTR + 1
C.... LOCATE START OF TEXT STRING
      CALL NXTSTR
      IF (STATUS .EQ. 0) GO TO 905
C.... NO STRING, SYNTAX ERROR
      CALL ERROR(6)
      GO TO 260
C.... USE FIRST CHR AS STRING DELIMITER
  905 K = IN(IPTR)
C.... Q ERROR IF DELIMTER NOT " OR '
      IF (K .NE. KQUOT .AND. K .NE. KAPOS) CALL ERROR (14)
      IPTR = IPTR + 1
C.... PACK 2 CHRS/WORD
  910 INSTR = ASCBLK
      IF (L .EQ. 1) INSTR = 0
C.... FLAG WORD AS NOT FULL
      I = 0
      DO 920 J = 1, 2, 1
C.... CHK FOR STRING DELIMTER
      IF (IN(IPTR) .EQ. K) GO TO 930
C.... CONVERT TO 7 BIT ASCII
      CALL ASCII(IN(IPTR))
C.... PACK CHRS LOW BYTE HIGH BYTE
      IF (J .EQ. 1) INSTR = IOR(IAND(INSTR,MSK2),VALUE)
      IF (J .EQ. 2) INSTR = IOR(IAND(INSTR,MSK1),ISL(VALUE,8))
C.... FLAG WORD FULL
      I = 1
C.... CHECK FOR END OF STATEMENT
      IF (IPTR .GE. INMAX) GO TO 937
      IPTR = IPTR + 1
      IF (L .EQ. 1) GO TO 925
  920 CONTINUE
C.... CHECK FOR WORD SIZE EXCEEDED
  925 VALUE = INSTR
      CALL CHKWRD
      CALL GENCOD(3)
      GO TO 910
C.... BYPASS STRING TERMINATOR
  930 IPTR = IPTR + 1
C.... CHECK FOR OPERAND FINISHED
      CALL OPRFIN
C.... OUTPUT LAST LINE IF REQUIRED
  933 IF (I .NE. 0) CALL GENCOD(3)
      GO TO 280
C.... POSSIBLE TEXT STRING TRUNCATION
  937 CALL ERROR(17)
      GO TO 933
C.... E N T R
  940 IF (ENTFLG .NE. 0) GO TO 957
      CALL XTROPR
      ENTFLG = 1
      CALL WRTOBJ(15,VALUE)
      IF (ORGFLG .EQ. 0) GO TO 330
      GO TO 490
C.... R E L
  950 I = 1
C.... CHECK FOR NO BINARY GENERATED YET
  955 IF (BINFLG .NE. 1) GO TO 960
C.... DIRECTIVE USE ERROR
  957 IPTR = IOPR
      CALL ERROR(19)
      GO TO 260
  960 BINTYP = I
C.... PROCESS TITLE STRING IF ANY
      IF (IN(IPTR) .EQ. KSPC) GO TO 330
C.... GENERATE TITLE  OBJ SEQ
      CALL PAKSYM(3)
      CALL WRTOBJ(16,SYMTMP(3))
      CALL WRTOBJ(-2,SYMTMP(4))
C.... MOVE TITLE
      IPTR = IOPRN
      DO 970 I = 1, 6, 1
      IF (IN(IPTR) .EQ. KSPC) GO TO 975
      IF (NPASS .EQ. 1) TITLE(I) = IN(IPTR)
      IPTR = IPTR + 1
  970 CONTINUE
  975 IF (ORGFLG .EQ. 0) GO TO 330
      GO TO 490
C.... G L O B   -   E X T
C.... PACK SYMBOL
  980 CALL PAKSYM(3)
      IF (STATUS .EQ. -1) GO TO 260
C.... ENTER UNREFERENCED SYMBOL IN SYMBOL TABLE
      CALL OPRSYM(0)
C.... LOCATE NEXT SYMBOL
      CALL NXTSTR
      IF (STATUS .NE. 1) GO TO 980
      IF (ORGFLG .EQ. 0) GO TO 340
      GO TO 260
C.... U T I L
 3200 CALL XTROPR
      IF (VALUE .GE. 0 .AND. VALUE .LE. 5) GO TO 3220
      CALL ERROR(12)
      VALUE = 0
 3220 UTIL = VALUE
      GO TO 490
C.... I N D X
 3300 CALL XTROPR
      IF (VALUE .GE. 1 .AND. VALUE .LE. 5) GO TO 3320
      CALL ERROR(12)
      VALUE = 1
 3320 INDX = VALUE
      GO TO 490
C.... L I N K
 3400 CALL XTROPR
      IF (VALUE .EQ. 4 .OR. VALUE .EQ. 5) GO TO 3420
      CALL ERROR(12)
      VALUE = 5
 3420 LINK = VALUE
      GO TO 490
C.... R E G S
 3500 CALL OPRFIN
      CALL PRINT(1)
C.... CLEAR STATEMENT
      DO 3510 I = 1,INMAX
      IN(I) = KSPC
 3510 CONTINUE
C.... GENERATE - RN = N
      IN(ILBL) = KR
      IN(IOPR) = KEQ
      INCODE = -5
      DO 3520 I = 1,8
      IN(ILBL+1) = KDIGS(I)
      IN(IOPRN) = KDIGS(I)
      CALL LBLPRC
 3520 CONTINUE
C.... GENERATE - RU = UTIL REG #
      IN(ILBL+1) = KU
      IN(IOPRN) = KDIGS(UTIL+1)
      CALL LBLPRC
C.... GENERATE - SP = 6
      IN(ILBL) = KS
      IN(ILBL+1) = KP
      IN(IOPRN) = K6
      CALL LBLPRC
C.... GENERATE - PC = 7
      IN(ILBL) = KP
      IN(ILBL+1) = KC
      IN(IOPRN) = K7
      CALL LBLPRC
      GO TO 280
C.... UNRECOGNIZED OPERATOR, GENERATE 4 NOP INSTRUCTIONS (NOP = 64)
 1000 K = 3
      LNKCOD = 1
C.... PRINT LINE NO., ADDR, CONTENTS, SRC ON 1ST LINE
      CALL GENCOD(1)
 1010 DO 1020 I = 1, K, 1
C.... PRINT ADDR, CONTENS ON REMAINING LINES
 1020 CALL GENCOD(2)
      GO TO 280
C.... INSTRUCTION OPERATORS
C.... IF ASSEMBLY DISABLED BY DIRECTIVE, LIST SOURCE ONLY
 1050 IF (ASMFLG .EQ. 0) GO TO 260
C.... INSTRUCTION PROCESSING CODES
C.... 1 - ZERO OPERAND
C.... 2 - ONE REGISTER OPERAND
C.... 3 - REGISTER SHIFT, ROTATE AND SWAP (R0-R3 ONLY)
C.... 4 - BRANCHES
C.... 5 - NOP
C.... 6 - BEXT
C.... 7 - REGISTER INDIRECT TO REGISTER
C.... 8 - REGISTER TO REGISTER
C.... 9 - IMMEDIATE DATA TO REGISTER
C.... 10 - DIRECT ADDRESS TO REGISTER
C.... 11 - JSR
C.... 12 - JSRE
C.... 13 - JSRD
C.... 14 - J
C.... 15 - JE
C.... 16 - JD
C.... 17 - MVO@
C.... 18 - MVOI
C.... 19 - MVO
C.... 20 - JR
C.... 21 - CLRR
C.... 22 - TSTR
C.... 23 - SDBD
C.... 24 - GSWD
C.... 25 - SIN
C.... 26 - CALL
C.... 27 - GOTO
C.... 28 - GO@
C.... 29 - IF
C.... 30 - PUTU
C.... 31 - GETU
C.... 32 - LET
C.... 33 - DO
C.... 34 - CONT
C.... 35 - ELSE
C.... CHECK FOR INVALID DBL BYTE DATA SEQ
      IPTR = IOPR
      IF (SDBDSW.EQ.1.AND.INCODE.NE.7.AND.INCODE.NE.9)CALL ERROR(9)
      IPTR = IOPRN
C.... PROCESS OPERANDS
      GO TO (1100, 1400, 1500, 1600, 1600, 1600, 1800,
     +       1800, 2100, 2100, 2300, 2400, 2500, 2600,
     +       2700, 2800, 2900, 2900, 2900, 1800, 1400,
     +       1400, 1100, 1500, 1300, 4000, 4100, 4200,
     +       4400, 4600, 4620, 4800, 5000, 5080, 5200), INCODE
C.... INSTRUCTION TYPE 1
C.... ZERO OPERAND INSTRUCTIONS
 1100 INSTR = ISKEL
 1140 LNKCOD = 1
C.... CHECK FOR OPERAND FINISHED
      CALL OPRFIN
      CALL GENCOD(1)
 1160 SDBDSW = 0
C.... CHECK FOR SDBD INSTRUCTION
      IF (INCODE .EQ. 23) SDBDSW = 1
      GO TO 280
C.... INSTRUCTION TYPE 25
C.... SIN 0 OR 1
 1300 VALUE = 0
C.... CHECK FOR OPTIONAL OPERAND
      IF (IN(IPTR) .EQ. KSPC) GO TO 1440
      CALL XTROPR
      CALL CHKREG(1)
      GO TO 1440
C.... INSTRUCTION TYPE 2, 21, 22
C.... ONE OPERAND INSTRUCTIONS ( VALUE = 0-7 ONLY )
 1400 CALL XTROPR
C.... CHECK FOR VALID REGISTER (0-7)
      CALL CHKREG(7)
      IF (INCODE .EQ. 2) GO TO 1440
C.... CLRR OR TSTR, USE R AS RS AND RD
      ISKEL = IOR(ISKEL,ISL(VALUE,3))
 1440 INSTR = IOR(ISKEL,VALUE)
      GO TO 1140
C.... INSTRUCTION TYPE 3
C.... SHIFTS AND ROTATES
C.... 1 OPERAND WITH SECOND OPTIONAL
 1500 CALL XTROPR
C.... SHIFTS ON REG 0-3 ONLY
      CALL CHKREG(3)
      INSTR = IOR(ISKEL,VALUE)
C.... CHECK FOR SWAP OR CLHB
      IF (IAND(INSTR,56) .EQ.0) GO TO 1140
C.... CHECK FOR GSWD
      IF (INCODE .EQ. 24) GO TO 1140
C.... CHECK FOR OPTIONAL OPERAND
      CALL NXTSTR
      IF (STATUS .EQ. 1) GO TO 1540
      CALL XTROPR
C.... CHECK FOR OPERAND ABS
      IF (SCOND .GT. 1) CALL ERROR(12)
C.... CAN SHIFT 1 OR 2 PLACES ONLY
      IF (VALUE .EQ. 1 .OR. VALUE .EQ. 2) GO TO 1560
C.... OPERAND VALUE ILLEGAL
      CALL ERROR(12)
 1540 VALUE = 1
 1560 INSTR = IOR(INSTR,ISL(VALUE-1,2))
      GO TO 1140
C.... INSTRUCTION TYPE 4, 5, 6
C.... BRANCHES, NOPP, BEXT
C.... SET SYMBOL TYPE TO INSTRUCTION
 1600 STYPE = 0
      K = 0
C.... CHECK FOR NOPP
      IF (INCODE .EQ. 5) GO TO 1630
      CALL XTROPR
C.... CHECK DESTINATION SYMBOL TYPE FOR EQU, INSTRUCTION OR ADRS
C.... ON PASS 2 ONLY
C.... EQU    = 1
C.... INSTRUCTION   = 2
C.... WORD, BYTE, TEXT = 3
C.... RES, ZERO   = 4
      IF (STYPE.EQ.3 .OR. STYPE.EQ.4) CALL ERROR(16)
C.... CHECK FOR EXT DEST
      IF (SCOND .EQ. 3) GO TO 1630
C.... COMPUTE DESTINATION DISPLACEMENT FROM CURRENT POSITION
C!!!! WATCH OUT FOR 16 BIT INSTALLATIONS
      K = VALUE - LOC - 2
      IF (STATUS .EQ. -1) K = 0
C.... CHECK FOR FORWARD BRANCH
      IF (K .GE. 0) GO TO 1620
C.... BACKWARD BRANCH, SET S BIT (2'5)
      ISKEL = IOR(ISKEL,32)
C.... ON BACKWARD BRANCH DISPLACEMENT IS 1'S COMPLEMENT
      K = INOT(K)
C!!!! IN 1'S COMPLEMENT INSTALLATIONS
C!!!! THE FOLLOWING STATEMENT IS REQUIRED
C!!!! K = K + 1
C.... CHECK FOR DISPLACEMENT EXCEEDING WORD SIZE OF MEMORY
 1620 IF (WRDSIZ .EQ. 0) GO TO 1630
      IF (IAND(K,WRDSIZ) .NE. K) CALL ERROR(15)
 1630 INSTR = ISKEL
C.... SAVE OPERAND CONDITION
      I = SCOND
C.... CHECK FOR BEXT, IF SO, 2ND OPERAND REQUIRED
      IF (INCODE .NE. 6) GO TO 1660
C.... LOCATE AND EXTRACT EXTERNAL CONDITION CODE
      CALL NXTSTR
C.... CHECK FOR SECOND OPERAND
      IF (STATUS .EQ. 0) GO TO 1635
C.... NO SECOND OPERAND, SYNTAX ERROR
      CALL ERROR(6)
      GO TO 1645
C.... EXTRACT SECOND OPERAND
 1635 CALL XTROPR
C.... CHECK FOR VALUE = 0-15
      IF (VALUE .GE. 0 .AND. VALUE .LE. 15) GO TO 1650
C.... INVALID EXT CONDITION, ISSUE DIAGNOSTIC
 1640 CALL ERROR(12)
 1645 VALUE = 0
      GO TO 1655
C.... CHECK FOR OPERAND ABS
 1650 IF (SCOND .GT. 1) CALL ERROR(12)
 1655 INSTR = IOR(INSTR,VALUE)
C.... SET 2 WORD ABS INSTRUCTION SEQ
 1660 LNKCOD = 2
C....CHECK FOR OPERAND FINISHED
      CALL OPRFIN
C.... CHECK FOR EXTERNAL SYMBOL
      IF (I .EQ. 3) LNKCOD = 11
      CALL GENCOD(1)
      IF (I .EQ. 3) LSTCOD = KX
C.... SET UP SECOND WORD OF INSTRUCTION
C.... IE, BRANCH DISPLACEMENT
 1670 INSTR = K
C.... SET OBJECT CODE CONTINUATION CODE
      LNKCOD = -1
 1680 CALL GENCOD(2)
      GO TO 1160
C.... INSTRUCTION TYPE 7, 8, 20
C.... TWO OPERAND INSTRUCTIONS
C.... MEMORY VIA REGISTER INDIRECT TO REGISTER
C.... REGISTER TO REGISTER
C.... JR - JUMP REGISTER (MOVR N,R7)
 1800 J = 1
C.... EXTRACT SOURCE REGISTER
      CALL XTROPR
C.... IF @ CHECK INDIRECT REGISTER MODE FOR 0-7
      IF (INCODE .NE. 7) GO TO 1805
      CALL CHKMOD
C.... GIVE ERROR IF SBDB & MODE 1,2,3
      IF (SDBDSW .EQ. 1 .AND. VALUE .LT. 4) CALL ERROR(9)
C.... IF R CHECK FOR REGISTER 0-7
 1805 IF (INCODE .EQ. 8) CALL CHKREG(7)
C.... MERGE INSTUCTION SKELETON AND MODE CODE
 1810 INSTR = IOR(ISKEL,ISL(VALUE,3))
C.... CHECK FOR JR (JUMP REGISTER)
      IF (INCODE .EQ. 20) GO TO 1140
C.... LOCATE SECOND OPERAND, ISSUE SYNTAX DIAGNOSTIC IF NONE
      CALL NXTSTR
      IF (STATUS .EQ. 0) GO TO 1815
      CALL ERROR(6)
      VALUE = 0
      GO TO 1840
C.... EXTRACT DESTINATION REGISTER, CHECK FOR 0-7
 1815 CALL XTROPR
      CALL CHKREG(7)
 1840 INSTR = IOR(INSTR,VALUE)
C.... CHECK FOR OPERAND FINISHED
      CALL OPRFIN
      LNKCOD = 1
C.... MERGE INSTRUCTION AND REGISTER CODE
      CALL GENCOD(J)
      GO TO 1160
C.... INSTRUCTION TYPE 9, 10
C.... TWO OPERAND INSTRUCTIONS
C.... IMMEDIATE DATA AND DIRECT ADDRESS INSTRUCTIONS
C.... EXTRACT SOURCE OPERAND (ADDR OR LIT)
 2100 CALL XTROPR
C.... SAVE OPERAND CONDITION
      I = SCOND
C.... SAVE 1ST OPERAND VALUE FOR 2ND WORD OF INSTRUCTION
      K = VALUE
C.... SAVE OPERAND NATURE
      N = NATURE
C.... EXTRACT SECOND OPERAND - REGISTR 0-7
      CALL NXTSTR
      IF (STATUS .EQ. 0) GO TO 2110
C.... OPERAND MISSING, SYNTAX ILLEGAL
      CALL ERROR(6)
      VALUE = 0
      GO TO 2130
 2110 CALL XTROPR
C.... CHECK FOR VALID REGISTER
      CALL CHKREG(7)
C.... CHECK FOR OPERAND FINISHED
      CALL OPRFIN
C.... MERGE REG & INSTR SKEL
 2130 INSTR = IOR(ISKEL,VALUE)
C.... CHECK FOR DIRECT ADDRESS INSTRUCTIONS
      IF (INCODE .EQ. 10) GO TO 2140
C.... CHECK FOR DOUBLE BYTE DATA REQUESTED BY USER
      IF (SDBDSW .EQ. 1) GO TO 2240
C.... CHECK FOR DOUBLE BYTE IMMEDIATE DATA REQUIRED
C.... FOR LITERAL OPERAND ONLY
      IF (WRDSIZ .EQ.0) GO TO 2140
      IF (N .NE. 1) GO TO 2140
      IF (IAND(K,WRDSIZ) .NE. K) GO TO 2200
C.... CHECK FOR WORD SIZE EXCEEDED
 2140 VALUE = K
 2145 LNKCOD = 2
      CALL CHKWRD
C.... CHECK FOR OPERAND ABS
      IF (I .LT. 2) GO TO 2160
C.... CHECK FOR RELOCATABLE OPERAND
      IF (I .EQ. 3) GO TO 2150
C.... SET 2 WORD RELOCATABLE OBJECT CODE SEQUENCE
      LNKCOD = 5
      CALL GENCOD(1)
C.... SET LISTING RELOCATABLE FLAG
      LSTCOD = KR
      GO TO 1670
C.... SET 2 WORD EXTERNAL OBJECT CODE SEQUENCE
 2150 LNKCOD = 10
      CALL GENCOD(1)
C.... SET LISTING EXTERNAL FLAG
      LSTCOD = KX
      GO TO 1670
 2160 CALL GENCOD(1)
      GO TO 1670
C.... GENERATE SDBD INSTRUCTION
 2200 LNKCOD = 1
      J = INSTR
      INSTR = 1
      CALL GENCOD(1)
      INSTR = J
      J = 2
      GO TO 2260
 2240 J = 1
C.... SET 3 WORD ABSOLUTE OBJECT CODE SEQUENCE
 2260 LNKCOD = 3
C.... IF OPERAND RELOCATABLE, SET 3 WORD REL OBJ CODE SEQ
      IF (I .EQ. 2) LNKCOD = 6
C.... CHECK FOR EXTERNAL OPERAND
      IF (I .EQ. 3) LNKCOD = 12
C.... GENERATE 1ST WORD OF INSTRUCTION
      CALL GENCOD(J)
C.... GENERATE LOW BYTE
      INSTR = IAND(K,MSK1)
      VALUE = INSTR
      CALL CHKWRD
C.... SET OBJECT CODE CONTINUATION
      LNKCOD = -1
C.... SET REL LISTING FLAG IF OPERAND IS RELOCATABLE
      IF (I .EQ. 2) LSTCOD = KR
C.... SET EXT LISTING FLAG IF OPERAND EXTERNAL
      IF (I .EQ. 3) LSTCOD = KX
      CALL GENCOD(2)
C.... GENERATE UPPER BYTE
      INSTR = ISL(IAND(K,MSK2),-8)
      VALUE = INSTR
      CALL CHKWRD
      GO TO 1680
C.... INSTRUCTION TYPE 11, 12, 13
C.... JSR, JSRE, JSRD
 2300 K = 0
      GO TO 2520
C.... SET INTERRUPT ENABLE BIT
 2400 K = 1
      GO TO 2520
C.... SET INTERRUPT DISABLE BIT
 2500 K = 2
C.... EXTRACT 1ST OPERAND - REGISTER DESIGNATION
 2520 CALL XTROPR
C.... CHECK FOR VALID REGISTER
      IF (VALUE .GE. 4 .AND. VALUE .LE. 7) GO TO 2540
      CALL ERROR(7)
 2530 VALUE = 4
C.... CHECK FOR OPERAND NOT ABS
 2540 IF (SCOND .GT. 1) CALL ERROR(12)
C.... COMBINE REGISTER AND INTERRUPT CONTROL BITS
      I = IOR(ISL(VALUE-4,8),K)
C.... LOCATE DESTINATION
      CALL NXTSTR
      IF (STATUS .NE. 1) GO TO 2560
C.... NO DESTINATIOIN FOUND, ISSUE SYNTAX DIAGNOSTIC
      CALL ERROR(6)
      VALUE = 0
      GO TO 2570
C.... EXTRACT DESTINATION
 2560 STYPE = 2
      CALL XTROPR
C.... CHECK FOR OPERAND FINISHED
      CALL OPRFIN
C.... CHECK DESTINATION TYPE FOR RES OR DATA
      IF (STYPE.EQ.3 .OR. STYPE.EQ.4) CALL ERROR(16)
C.... SECOND WORD CONTAINS INTERRUPT E/D BITS, MOST SIGNIFICANT SIX
C.... BITS OF DESTINATION ADDRESS  AND REGISTER DESIGNATOR
C.... THIRD WORD CONTAINS LEAST SIGNIFICANT TEN BITS OF DESTINATION
 2570 LNKCOD = 3
C.... IF OPERAND RELOCATABLE, SET 3 WORD REL OBJ CODE SEQ
      IF (SCOND .EQ. 2) LNKCOD = 8
C.... IF OPERAND EXTERNAL, SET 3 WORD EXT OBJ CODE SEQ
      IF (SCOND .EQ. 3) LNKCOD = 14
      INSTR = ISKEL
C.... ISSUE FIRST INSTRUCTION WORD
      CALL GENCOD(1)
C.... BUILD SECOND INSTRUCTION WORD
      INSTR = IOR(I,ISL(IAND(VALUE,MSK3),-8))
C.... SET OBJ CODE CONTINUATION
      LNKCOD = -1
C.... SET LISTING REL CODE IF OPERAND REL
      IF (SCOND .EQ. 2) LSTCOD = KR
C.... SET LISTING EXT FLAG IF OPERAND EXT
      IF (SCOND .EQ. 3) LSTCOD = KX
C.... ISSUE SECOND INSTRUCTION WORD
      CALL GENCOD(2)
C.... BUILD THIRD INSTRUCTION WORD
      INSTR = IAND(VALUE,1023)
      GO TO 1680
C.... INSTRUCTION TYPE 14,15,16
C.... J, JE, JD
 2600 K = 0
      GO TO 2820
C.... SET INTERRUPT ENABLE BIT
 2700 K = 1
      GO TO 2820
C.... SET INTERRUPT DISABLE BIT
 2800 K = 2
C.... COMBINE FORCED R7 AND INTERRUPT CONTROL BITS
 2820 I = IOR(768,K)
      GO TO 2560
C.... INSTRUCTION TYPE 17, 18, 19
C.... MOVE REGISTER OUT INSTRUCTIONS
C.... MVO@ - MOVE OUT REGISTER VIA REGISTER INDIRECT
C.... MVO  - MOVE OUT REGISTER TO DIRECT ADDRESS
C.... MVOI - MOVE OUT REGISTER TO IMMEDIATE LOCATION
C.... EXTRACT SOURCE REGISTER
 2900 CALL XTROPR
C.... CHECK FOR REGISTER 0-7
      CALL CHKREG(7)
C.... MERGE INSTRUCTION SKELETON AND SOURCE REGISTER CODE
      K = IOR(ISKEL,VALUE)
C.... LOCATE DESTINATION OPERAND
      CALL NXTSTR
C.... CHECK FOR OPERAND FOUND
      IF (STATUS .EQ. 0) GO TO 2920
      VALUE = 0
C.... SECOND ARGUMENT OPTIONAL ON MVOI
      IF (INCODE .EQ. 18) GO TO 2960
C.... DESTINATION OPERAND NOT FOUND, ISSUE SYNTAX DIAGNOSTIC, DEFAULT TO ZERO
      CALL ERROR(6)
      GO TO 2930
C.... EXTRACT DESTINATION OPERAND
 2920 CALL XTROPR
C.... CHECK FOR OPERAND FINISHED
      CALL OPRFIN
C.... CHECK FOR MVOI OR MVO  INSTRUCTIONS
 2930 IF (INCODE .NE. 17) GO TO 2960
C.... MVO@ INSTRUCTION
C.... CHECK FOR INDIRECT REGISTER 0-7
      CALL CHKMOD
C.... MERGE INSTRUCTION AND MODE
 2940 INSTR = IOR(K,ISL(VALUE,3))
C.... INSTRUCTION COMPLETE, LIST AND GENERATE 1 WORD
      GO TO 1140
C.... MVOI AND MVO  INSTRUCTIONS
 2960 INSTR = K
C.... OPERAND CONDITION
      I = SCOND
C.... INSTRUCTION COMPLETE, LIST AND GENERATE 2 WORDS
      K = VALUE
      GO TO 2145
C.... INSTRUCTION TYPE 26 - C A L L
C.... SET UP CALL LINK REGISTER
 4000 CALL PRINT(4)
      ERRPTR = KUPARW
      I = ISL(LINK-4,8)
C.... ALLOW STRING TERMINATION WITH "("
      KTERMS(6) = KLPRN
C.... EXTRACT DESTINATION
      CALL XTROPR
C.... SET ABS CODE
      LNKCOD = 3
C.... SET REL CODE
      IF (SCOND .EQ. 2) LNKCOD = 8
C.... SET EXT CODE
      IF (SCOND .EQ. 3) LNKCOD = 14
C.... ISSUE FIRST INSTRUCTION WORD
      INSTR = 4
      CALL GENCOD(3)
C.... BUILD SECOND INSTRUCTION WORD
      INSTR = IOR(I,ISL(IAND(VALUE,MSK3),-8))
C.... SET OBJ SEQ CONT CODE
      LNKCOD = -1
C.... SET REL LIST CODE
      IF (SCOND .EQ. 2) LSTCOD = KR
C.... SET EXT LIST CODE
      IF (SCOND .EQ. 3) LSTCOD = KX
C.... ISSUE SECOND INSTRUCTION WORD
      CALL GENCOD(3)
C.... BUILD THIRD INSTRUCTION WORD
      INSTR = IAND(VALUE,1023)
C.... ISSUE THIRD INSTRUCTION WORD
      CALL GENCOD(3)
C.... CHECK FOR ARGUMENTS
      CALL SKPSPC
      IF(STATUS .EQ. 1) GO TO 4480
      IF (IN(IPTR) .NE. KLPRN) GO TO 4480
      IPTR = IPTR + 1
C.... LOCATE ARGUMENTS IF ANY
      CALL SKPSPC
      IF (STATUS .EQ. 1) GO TO 4430
C.... SET STRING TERMINATION ")"
      KTERMS(6) = KRPRN
C.... EXTRACT ARGUMENT
 4020 CALL XTROPR
      INSTR = VALUE
C.... DEFAULT OBJ CODE = ABS
      LNKCOD = 1
      LSTCOD = KSPC
C.... CHECK FOR REL
      IF (SCOND .NE. 2) GO TO 4040
      LNKCOD = 4
      LSTCOD = KR
C.... CHECK FOR EXT
 4040 IF (SCOND .NE. 3) GO TO 4060
      LNKCOD = 9
      LSTCOD = KX
C.... ISSUE CODE
 4060 CALL GENCOD(3)
C.... LOCATE NEXT ARGUMENT
      CALL NXTSTR
C.... CHECK FOR END OF STATEMENT
      IF (STATUS .EQ. 1) GO TO 4430
C.... CHECK FOR END OF ARGUMENTS
      IF (IN(IPTR) .NE. KRPRN) GO TO 4020
      IPTR = IPTR + 1
      GO TO 4480
C.... INSTRUCTION TYPE 27 - G O T O
 4100 CALL PRINT(4)
      ERRPTR = KUPARW
C.... ALLOW GO SPC TO
      IF (ISKEL .EQ. 0) GO TO 4120
      IF (IN(IPTR) .NE. KT .OR. IN(IPTR+1) .NE. KO) GO TO 4120
      IPTR = IPTR + 2
      CALL SKPSPC
      IF (STATUS .EQ. 1) GO TO 4430
C.... EXTRACT DESTINATION
 4120 CALL GENDST(512)
      GO TO 4480
C.... INSTRUCTION TYPE 28 - G O @
 4200 CALL PRINT(4)
      ERRPTR = KUPARW
      I = UTIL
      UTIL = 7
      CALL XTRDSC(2,640)
      UTIL = I
 4220 CALL OPRFIN
      GO TO 280
C.... INSTRUCTION TYPE 29 - I F
 4400 IFWHIL = -1
      CALL PRINT(4)
      ERRPTR = KUPARW
C.... CHECK FOR OPENING "("
      IF (IN(IPTR) .NE. KLPRN) GO TO 4410
      IPTR = IPTR + 1
      CALL SKPSPC
      IF (STATUS .EQ. 1) GO TO 4430
 4410 KTERMS(7) = KRPRN
C.... ISSUE MVI D,RU (120U)
      CALL XTRDSC(2,640)
C.... LOCATE NEXT ELEMENT
      CALL SKPSPC
      IF (STATUS .EQ. 1) GO TO 4430
C.... CHECK FOR RELATIONAL IF
      IF (IN(IPTR) .EQ. KDOT) GO TO 4490
C.... CHECK FOR DO-WHILE ENTRY
      IF (IFWHIL .NE. -1) GO TO 4430
C.... MUST BE ARITHMETIC IF, ISSUE TSTR RU (2UU)
      INSTR = IOR(128,ISL(UTIL,3))
      CALL GENINS(INSTR)
C.... EXTRACT < 0 DESTINATION
      CALL SKPSPC
      IF (STATUS .EQ. 1) GO TO 4430
      IF (IN(IPTR) .NE. KRPRN) GO TO 4420
      IPTR = IPTR + 1
      CALL SKPSPC
      IF (STATUS .EQ. 1) GO TO 4430
C.... BMI (1013)
 4420 CALL GENDST(523)
C.... EXTRACT = 0 DESTINATION
      CALL NXTSTR
      IF (STATUS .NE. 1) GO TO 4440
 4430 CALL ERROR(6)
      GO TO 280
C.... BZE (1004)
 4440 CALL GENDST(516)
C.... EXTRACT > 0 DESTINATION
      CALL NXTSTR
      IF (STATUS .EQ. 1) GO TO 4430
C.... BPL (1003)
      CALL GENDST(515)
C.... CHECK FOR STATEMENT FINISHED
 4480 CALL OPRFIN
      GO TO 280
C.... RELATIONAL IF
 4490 IFCMP = 0
 4492 I = IN(IPTR+1)
      J = IN(IPTR+2)
      K = IN(IPTR+3)
      N = 0
C.... .POS. BPL (1003)
      IF (I.EQ.KP .AND. J.EQ.KO .AND. K.EQ.KS) GO TO 4530
C.... .ZERO. BZE (1004)
      IF (I.EQ.KZ .AND. J.EQ.KE .AND. K.EQ.KR) GO TO 4540
C.... .NEG. BMI (1013)
      IF (I.EQ.KN .AND. J.EQ.KE .AND. K.EQ.KG) GO TO 4560
C.... .NONZERO. BNZE (1014)
      IF (I .EQ. KN .AND. J .EQ. KO) GO TO 4550
C.... .EQ. - BEQ (1004)
      IF (I.EQ.KE .AND. J.EQ.KQ) N = 516
C.... .NE. - BNEQ (1014)
      IF (I.EQ.KN .AND. J.EQ.KE) N = 524
C.... .LT. - BLT (1005)
      IF (I.EQ.KL .AND. J.EQ.KT) N = 517
C.... .GE. - BGE (1015)
      IF (I.EQ.KG .AND. J.EQ.KE) N = 525
C.... .LE. - BLE (1006)
      IF (I.EQ.KL .AND. J.EQ.KE) N = 518
C.... .GT. - BGT (1016)
      IF (I.EQ.KG .AND. J.EQ.KT) N = 526
C.... .LGE. - BLGE (1001)
      IF (I.EQ.KL.AND.J.EQ.KG.AND.K.EQ.KE) N = 513
C.... .LLT. - BLLT (1011)
      IF (I.EQ.KL.AND.J.EQ.KL.AND.K.EQ.KT) N = 521
C.... BYPASS OPERATOR
      IPTR = IPTR + 3
      IF (N .EQ. 513 .OR. N .EQ. 521) IPTR = IPTR + 1
      IF (IN(IPTR) .NE. KDOT) GO TO 4430
      IPTR = IPTR + 1
C.... CHECK FOR OPERATOR IDENTIFIED
      IF (N .EQ. 0) GO TO 4430
C.... EXTRACT SECOND DESCRIPTOR
      CALL SKPSPC
      IF (STATUS .EQ. 1) GO TO 4430
C.... ISSUE CMP VAR,RU (150U)
      CALL XTRDSC(2,832)
C.... CHECK FOR WHILE ENTRY
 4494 IF (IFWHIL .NE. -1) GO TO 4573
C.... GET NEXT STRING
      CALL SKPSPC
      IF (STATUS .EQ. 1) GO TO 4430
C.... CHECK FOR COMPOUND IF, IE, DOT NEXT
      IF (IN(IPTR) .NE. KDOT) GO TO 4500
C.... CHECK FOR COMPOUND IF ALREADY
      IF (IFCMP .NE. 0) GO TO 4430
C.... CHECK FOR .OR. - .AND.
      I = IN(IPTR+1)
      J = IN(IPTR+2)
      K = IN(IPTR+3)
      IF (I.NE.KO .OR. J.NE.KR) GO TO 4496
      IPTR = IPTR + 3
      IFCMP = 1
      GO TO 4497
 4496 IF (I.NE.KA .OR. J.NE.KN .OR. K.NE.KD) GO TO 4430
      IPTR = IPTR + 4
      IFCMP = 2
 4497 IF (IN(IPTR) .NE. KDOT) GO TO 4430
      IPTR = IPTR + 1
C.... ISSUE GSWD RU (6U)
      CALL GENINS(48)
C.... ISSUE PSHR RU (116U)
      CALL GENINS(624)
C.... SAVE FIRST RELATIONSHIP
      IFCND = N
C.... LOCATE SECOND PART OF STATEMENT
      CALL SKPSPC
      IF (STATUS .EQ. 1) GO TO 4430
C.... ISSUE MVI D,RU (120U)
      CALL XTRDSC(2,640)
C.... LOCATE RELATIONAL OPERATOR
      CALL SKPSPC
      IF (STATUS .EQ. 1) GO TO 4430
      IF (IN(IPTR) .NE. KDOT) GO TO 4430
C.... HANDLE SECOND PART OF STATEMENT
      GO TO 4492
C.... CHECK FOR CLOSING ")"
 4500 IF (IN(IPTR) .NE. KRPRN) GO TO 4502
      IPTR = IPTR + 1
      CALL SKPSPC
      IF (STATUS .EQ. 1) GO TO 4430
C.... CHECK FOR COMPOUND IF
 4502 IF (IFCMP .EQ. 0) GO TO 4510
C.... ISSUE GSWD RU (6U)
      CALL GENINS(48)
C.... ISSUE PULR RI (126I)
      INSTR = IOR(688,INDX)
      CALL GENCOD(3)
C.... ISSUE RSWD RI (7I)
      INSTR = IOR(56,INDX)
      CALL GENCOD(3)
C.... ISSUE FIRST CONDITIONAL BRANCH
      INSTR = IFCND
      IFCND = 3
C.... IF .AND. TYPE IF INVERT BRANCH INSTRUCTION
      IF (IFCMP .EQ. 2) CALL INVBRN(INSTR)
C.... ISSUE FIRST CONDITIONAL BRANCH
      LNKCOD = 2
      LSTCOD = KSPC
      CALL GENCOD(3)
      LNKCOD = -1
      INSTR = IFCND
      CALL GENCOD(3)
C.... ISSUE RSWD RU (7U)
      CALL GENINS(56)
C.... HANDLE DESTINATION
 4510 I = IN(IPTR)
      J = IN(IPTR+1)
      K = IN(IPTR+2)
      L = IN(IPTR+3)
      IPTR = IPTR + 4
C.... CHECK FOR THEN
      IF (I.EQ.KT.AND.J.EQ.KH.AND.K.EQ.KE.AND.L.EQ.KN) GO TO 4570
C.... CHECK FOR GOTO
      IF (I .NE. KG .OR. J .NE. KO) GO TO 4430
      IF (K .NE. KSPC) GO TO 4520
      IPTR = IPTR - 2
      CALL SKPSPC
      IF (STATUS .EQ. 1) GO TO 4430
      K = IN(IPTR)
      L = IN(IPTR+1)
      IPTR = IPTR + 2
 4520 IF (K .NE. KT .OR. L .NE. KO) GO TO 4430
C.... CHECK FOR .AND. TYPE IF
      IF (IFCMP .EQ. 2) GO TO 4525
C.... .OR. TYPE IF, INVERT BRANCH INSTRUCTION
      CALL INVBRN(N)
C.... ISSUE INVERTED BRANCH AROUND DESTINATION
      LNKCOD = 2
      LSTCOD = KSPC
      INSTR = N
      CALL GENCOD(3)
      LNKCOD = -1
      INSTR = 2
      CALL GENCOD(3)
C.... ISSUE UNCONDITIONAL BRANCH (1000)
      N = 512
C.... EXTRACT DESTINATION
 4525 CALL SKPSPC
      IF (STATUS .EQ. 1) GO TO 4430
      CALL GENDST(N)
      GO TO 4480
C.... .POS. BPL (1003)
 4530 N = 515
 4533 IPTR = IPTR + 4
 4535 IF (IN(IPTR) .NE. KDOT) GO TO 4430
      IPTR = IPTR + 1
C.... ISSUE TSTR RU (2UU)
      INSTR = IOR(ISL(UTIL,3),128)
      CALL GENINS(INSTR)
C.... PROCESS DESTINATION
      GO TO 4494
C.... .ZERO. BZE (1004)
 4540 N = 516
 4545 IPTR = IPTR + 5
      GO TO 4535
C.... .NONZERO. BNZE (1014)
 4550 IPTR = IPTR + 4
      IF (IN(IPTR) .NE. KZ) GO TO 4430
      N = 524
      GO TO 4533
C.... .NEG. BMI (1013)
 4560 N = 523
      GO TO 4533
C.... IF-THEN
C.... CHECK FOR OPEN IF-THEN BLOCK
 4570 IF (IFFLG .NE. 0) CALL ERROR(21)
      IFFLG = IFFLG + 1
 4573 CALL OPRFIN
C.... CHECK FOR .AND. COMPOUND IF
      IF (IFCMP .NE. 2) GO TO 4574
C.... ISSUE BRANCH TO THEN CODE
      LNKCOD = 2
      LSTCOD = KSPC
      INSTR = N
      CALL GENCOD(3)
      LNKCOD = -1
      INSTR = 2
      CALL GENCOD(3)
C.... ISSUE BRANCH TO END
      N = 512
      GO TO 4580
C.... INVERT BRANCH TYPE
 4574 CALL INVBRN(N)
C.... GENERATE BRANCH TO NEXT ELSE OR TERM
 4580 LNKCOD = 2
      LSTCOD = KSPC
      INSTR = N
      CALL GENCOD(3)
      LNKCOD = -1
      INSTR = 0
      IF (NPASS .EQ. 1) GO TO 4585
C.... CHECK FOR WHILE ENTRY
      IF (IFWHIL .NE. -1) GO TO 4583
      INSTR = IFSTK(IFPTR) - LOC - 1
      IFPTR = IFPTR + 1
      GO TO 4585
 4583 INSTR = IFWHIL - LOC + 1
 4585 CALL GENCOD(3)
      GO TO 280
C.... INSTRUCTION TYPE 30,31 - P U T U,  G E T U
 4600 I = 1
      GO TO 4640
 4620 I = 2
 4640 CALL PRINT(4)
      ERRPTR = KUPARW
      CALL XTRDSC(I,ISKEL)
      GO TO 4220
C.... INSTUCTION TYPE 32 - L E T
 4800 CALL PRINT(4)
      ERRPTR = KUPARW
C.... SEARCH FOR "="
      DO 4810 IPTR = IPTR, INMAX
      IF (IN(IPTR) .EQ. KSCOLN) GO TO 4430
      IF (IN(IPTR) .EQ. KEQ) GO TO 4820
 4810 CONTINUE
      GO TO 4430
C.... CHANGE = TO ; FOR LEFT SIDE EXTRACT
 4820 IN(IPTR) = KSCOLN
      IPTR = IPTR + 1
C.... LOCATE FIRST RIGHT SIDE DESCRIPTOR
      CALL SKPSPC
      IF (STATUS .EQ. 1) GO TO 4430
      J = 0
      K = IN(IPTR)
C.... CHECK FOR UNARY +
      IF (K .EQ. KPLUS) GO TO 4830
C.... CHECK FOR UNARY -
      IF (K .NE. KMINUS) GO TO 4825
C.... ISSUE NEGR RU (40)
      J = 32
      GO TO 4830
C.... CHECK FOR UNARY .NOT.
 4825 IF (K .NE. KDOT) GO TO 4835
      IF (IN(IPTR+1) .NE. KN) GO TO 4835
      IF (IN(IPTR+2) .NE. KO .OR. IN(IPTR+3) .NE. KT) GO TO 4430
      IPTR = IPTR + 4
      IF (IN(IPTR) .NE. KDOT) GO TO 4430
C.... ISSUE COMR RU (30)
      J = 24
 4830 IPTR = IPTR + 1
      CALL SKPSPC
      IF (STATUS .EQ. 1) GO TO 4430
C.... EXTRACT FIRST RIGHT SIDE DESCRIPTOR
 4835 CALL XTRDSC(2,640)
C.... CHECK FOR - OR .NOT. OPERATIONS
      IF (J .EQ. 0) GO TO 4837
C.... ISSUE UNARY CODE
      CALL GENINS(J)
      GO TO 4850
C.... LOCATE OPERATOR, IF ANY
 4837 CALL SKPSPC
      IF (STATUS .EQ. 1) GO TO 4860
C.... IDENTIFY OPERATOR ( + - )
 4838 J = 0
      K = IN(IPTR)
C.... + -> ADD (1300)
      IF (K .EQ. KPLUS) J = 704
C.... - -> SUB (1400)
      IF (K .EQ. KMINUS) J = 768
C.... * - MULTIPLY
      IF (K .EQ. KASTRX) J = 1
C.... / - DIVIDE
      IF (K .EQ. KSLASH) J = 2
C.... CHECK FOR OPERATOR IDENTIFIED
      IF (J .NE. 0) GO TO 4840
C.... TRY .AND. - .XOR. - .IOR. - .SLL. - .SLR. - .SAR.
      IF (K .NE. KDOT) GO TO 4430
      N = IN(IPTR+1)
      K = IN(IPTR+2)
      L = IN(IPTR+3)
      IF (N.EQ.KA.AND.K.EQ.KN.AND.L.EQ.KD) J = 896
      IF (N.EQ.KX.AND.K.EQ.KO.AND.L.EQ.KR) J = 960
      IF (N.EQ.KI.AND.K.EQ.KO.AND.L.EQ.KR) J = 3
      IF (N.EQ.KS.AND.K.EQ.KL.AND.L.EQ.KL) J = 72
      IF (N.EQ.KS.AND.K.EQ.KL.AND.L.EQ.KR) J = 96
      IF (N.EQ.KS.AND.K.EQ.KA.AND.L.EQ.KR) J = 104
C.... CHECK FOR OPERATOR NOT IDENTIFIED
      IF (J .EQ. 0) GO TO 4430
      IPTR = IPTR + 4
      IF (IN(IPTR) .NE. KDOT) GO TO 4430
 4840 IPTR = IPTR + 1
C.... LOCATE SECOND RIGHT SIDE DESCRIPTOR
      CALL SKPSPC
      IF (STATUS .EQ. 1) GO TO 4430
C.... CHECK FOR .IOR.
      IF (J .NE. 3) GO TO 4843
C.... .IOR.
C.... ISSUE COMR RU (3U)
      CALL GENINS(24)
C.... ISSUE PSHR RU (116U)
      CALL GENINS(624)
C.... ISSUE MVI D,RU (120U)
      CALL XTRDSC(2,640)
C.... ISSUE COMR RU (3U)
      CALL GENINS(24)
C.... ISSUE AND@ SP,RU (166U)
      CALL GENINS(944)
C.... ISSUE COMR RU (3U)
      CALL GENINS(24)
      GO TO 4850
C.... CHECK FOR MULT OR DIVIDE
 4843 IF (J .EQ. 1 .OR. J .EQ. 2) GO TO 4900
C.... CHECK FOR .SLL. .SLR. .SAR.
      IF (J .GT. 104) GO TO 4845
C.... .SLL. .SLR. .SAR.
C.... ISSUE PSHR RU (116U)
      CALL GENINS(624)
C.... ISSUE MVI D,RU (120U)
      CALL XTRDSC(2,640)
C.... ISSUE MOVR RU,RI (02UI)
      LNKCOD = 1
      LSTCOD = KSPC
      INSTR = IOR(128,IOR(ISL(UTIL,3),INDX))
      CALL GENCOD(3)
C.... ISSUE PULR RU (126U)
      CALL GENINS(688)
C.... ISSUE DECR RI (002I)
      INSTR = IOR(16,INDX)
      CALL GENCOD(3)
C.... ISSUE BMI (1013)
      LNKCOD = 2
      INSTR = 523
      CALL GENCOD(3)
      LNKCOD= -1
      INSTR = 3
      CALL GENCOD(3)
C.... ISSUE SHIFT INSTRUCTION (011U,014U,015U)
      CALL GENINS(J)
C.... ISSUE B (1040)
      LNKCOD = 2
      INSTR = 544
      CALL GENCOD(3)
      LNKCOD = -1
      INSTR = 5
      CALL GENCOD(3)
      GO TO 4850
 4845 CALL XTRDSC(2,J)
C.... CHECK FOR COMPOUND STATEMENT
 4850 CALL SKPSPC
      IF (STATUS .NE. 1) GO TO 4838
C.... EXTRACT LEFT SIDE DESCRIPTOR
 4860 IPTR = IOPRN
      CALL XTRDSC(1,576)
      GO TO 280
C.... MULT - DIVDE, ISSUE PSHR RU (116U)
 4900 CALL GENINS(624)
C.... EXTRACT SECOND DESCRIPTOR
      CALL XTRDSC(2,640)
C.... ISSUE PSHR RU (116U)
      CALL GENINS(624)
C.... $MI = 125321,0 OCTAL
      K = NMI
C.... $DI = 124551,0 OCTAL
      IF (J .EQ. 2) K = NDI
C.... ENTER REFERENCED $MI OR $DI SYMBOL IN SYMBOL TABLE
      IF (NPASS .EQ. 2) GO TO 4940
      SYMTMP(3) = K
      SYMTMP(4) = 0
      INCODE = -23
      CALL OPRSYM(8)
C.... ISSUE EXT REF OBJ CODE
 4940 CALL WRTEXT(K,0)
C.... ISSUE JSR 5,0
      LNKCOD = 14
      LSTCOD = KSPC
      INSTR = 4
      CALL GENCOD(3)
      LNKCOD = -1
      LSTCOD = KX
      INSTR = 256
      CALL GENCOD(3)
      INSTR = 0
      CALL GENCOD(3)
C.... ISSUE PULR RU (126U)
      CALL GENINS(688)
      GO TO 4850
C.... INSTRUCTION TYPE 33 - D O
C.... CHECK FOR DO-LOOP BLOCK NESTING > MAX
 5000 IF (DONEST .LT. DOMAX) GO TO 5005
      CALL ERROR(23)
      CALL PRINT(4)
      GO TO 280
C.... EXTRACT DO TARGET
 5005 CALL XTROPR
C.... CHECK FOR EXTERNAL DO TARGET
      IF (SCOND .EQ. 3) CALL ERROR(25)
C.... SAVE CONT STATEMENT LABEL
      N1 = SYMTMP(3)
      N2 = SYMTMP(4)
      CALL PRINT(4)
      ERRPTR = KUPARW
C.... LOCATE NEXT STATEMENT ELEMENT
      CALL SKPSPC
C.... CHECK FOR UNCONDITIONAL DO
      IF (STATUS .EQ. 1) GO TO 5070
      I = IN(IPTR)
      J = IN(IPTR+1)
      K = IN(IPTR+2)
C.... CHECK FOR FOR
      IF (I.EQ.KF .AND. J.EQ.KO .AND. K.EQ.KR) GO TO 5007
C.... CHECK FOR WHILE
      IF (I.EQ.KW .AND. J.EQ.KH .AND. K.EQ.KI) GO TO 5060
C.... NOT FOR OR WHILE ASSUME FOR
      GO TO 5008
C.... DO FOR
 5007 IPTR = IPTR + 3
      CALL SKPSPC
      IF (STATUS .EQ. 1) GO TO 4430
C.... SAVE CONTROL VARIABLE POINTER
 5008 L = IPTR
C.... LOCATE "="
      DO 5010 IPTR = IPTR, INMAX
      IF (IN(IPTR) .EQ. KSCOLN) GO TO 4430
      IF (IN(IPTR) .EQ. KEQ) GO TO 5040
 5010 CONTINUE
C.... SYNTAX ERROR
      GO TO 4430
C.... CHANGE = TO ; FOR LEFT SIDE EXTRACT
 5040 IN(IPTR) = KSCOLN
      IPTR = IPTR + 1
C.... EXTRACT LOOP CONTROL VARIABLE INITIAL VALUE
      CALL SKPSPC
      IF (STATUS .EQ. 1) GO TO 4430
      CALL XTROPR
C.... CHECK FOR LITERAL ZERO
      IF (NATURE .EQ. 1 .AND. VALUE .EQ. 0) GO TO 5043
C.... SET UP CONTROL VAR INIT CODE
      INSTR = IOR(640,UTIL)
      IF (NATURE .EQ. 1) INSTR = IOR(INSTR,56)
      DSCSTK(3) = INSTR
      DSCSTK(6) = VALUE
      CALL DSCCOD
      GO TO 5047
C.... INIT VALUE = 0, ISSUE CLRR RU (7UU)
 5043 INSTR = IOR(IOR(448,ISL(UTIL,3),UTIL))
      LNKCOD = 1
      LSTCOD = KSPC
      CALL GENCOD(3)
C.... EXTRACT FINAL VALUE
 5047 CALL NXTSTR
      IF (STATUS .EQ. 1) GO TO 4430
      CALL XTROPR
C.... SET UP DO STACK
      DOSTK(DOPTR) = LOC
      DOSTK(DOPTR+1) = VALUE
      DOSTK(DOPTR+2) = SYMTMP(4)
      DOSTK(DOPTR+3) = SYMTMP(3)
      DOSTK(DOPTR+4) = SCOND
      DOSTK(DOPTR+5) = NATURE
C.... DEFAULT STEP = 1
      DOSTK(DOPTR+6) = 1
      DOSTK(DOPTR+7) = 0
      DOSTK(DOPTR+8) = 0
      DOSTK(DOPTR+9) = 0
      DOSTK(DOPTR+10) = 1
C.... EXTRACT STEP VALUE, IF ANY
      CALL NXTSTR
      IF (STATUS .EQ. 1) GO TO 5050
      CALL XTROPR
C.... SET UP STEP
      DOSTK(DOPTR+6) = VALUE
      DOSTK(DOPTR+7) = SYMTMP(4)
      DOSTK(DOPTR+8) = SYMTMP(3)
      DOSTK(DOPTR+9) = SCOND
      DOSTK(DOPTR+10) = NATURE
C.... EXTRACT LOOP CONTROL VARIABLE
 5050 J = IPTR
      IPTR =  L
      CALL XTROPR
C.... CHECK FOR LITERAL ON LEFT OF =
      IF (NATURE .NE. 2) GO TO 4430
C.... SET UP LOOP CONTROL VARIABLE
      DOSTK(DOPTR+11) = VALUE
      DOSTK(DOPTR+12) = SYMTMP(4)
      DOSTK(DOPTR+13) = SYMTMP(3)
      DOSTK(DOPTR+14) = SCOND
C.... SET UP CONTINUE STATEMENT LABEL
      DOSTK(DOPTR+15) = N2
      DOSTK(DOPTR+16) = N1
      DOSTK(DOPTR+17) = 0
      DOPTR = DOPTR + 18
      DONEST = DONEST + 1
C.... ISSUE LOOP CONTROL VARIABLE INITIALIZATION CODE
      DSCSTK(3) = IOR(576,UTIL)
      DSCSTK(6) = VALUE
      CALL DSCCOD
      IPTR = J
      GO TO 4220
C.... DO WHILE
 5060 IF (IN(IPTR+3) .NE. KL .OR. IN(IPTR+4) .NE. KE) GO TO 4430
      IPTR = IPTR + 5
      CALL SKPSPC
      IF (STATUS .EQ. 1) GO TO 4430
      DOSTK(DOPTR) = LOC
      DOSTK(DOPTR+1) = N2
      DOSTK(DOPTR+2) = N1
      DOSTK(DOPTR+3) = 1
      DOPTR = DOPTR + 4
      DONEST = DONEST + 1
C.... ENTER IF PROCESSOR TO HANDLE CONDITION
      IFWHIL = VALUE
      GO TO 4410
C.... UNCONDITIONAL DO
 5070 CALL OPRFIN
      DOSTK(DOPTR) = LOC
      DOSTK(DOPTR+1) = N2
      DOSTK(DOPTR+2) = N1
      DOSTK(DOPTR+3) = 1
      DOPTR = DOPTR + 4
      DONEST = DONEST + 1
      GO TO 280
C.... INSTRUCTION TYPE 34 - C O N T
C.... CHECK FOR LABEL
 5080 IF (IN(ILBL) .NE. KSPC) GO TO 5081
      IPTR = ILBL
      CALL ERROR(1)
      GO TO 260
 5081 CALL OPRFIN
C.... CHECK FOR NO OPEN DO-LOOP
      IF (DOPTR .LE. 1) GO TO 260
C.... CHECK FOR CONT LABEL AND DO TARGET SAME
      IF (SYMTMP(1) .NE. DOSTK(DOPTR-2) .OR.
     +    SYMTMP(2) .NE. DOSTK(DOPTR-3)) GO TO 260
      CALL PRINT(4)
      ERRPTR = KUPARW
C.... DEFAULT UNCODITIONAL DO LOOP END (B = 1040)
      I = 544
      J = 4
C.... DETERMINE DO-LOOP TYPE
      IF (DOSTK(DOPTR-1) .EQ. 1) GO TO 5090
C.... CONDITIONAL DO-LOOP, GENERATE MVI VAR,RU
 5085 NATURE = 2
      SCOND = DOSTK(DOPTR-4)
C.... GENERATE EXTERNAL SYMBOL REFERENCE IF REQUIRED
      IF (SCOND .EQ. 3) CALL WRTEXT(DOSTK(DOPTR-5),DOSTK(DOPTR-6))
      DSCSTK(3) = IOR(640,UTIL)
      DSCSTK(6) = DOSTK(DOPTR-7)
      CALL DSCCOD
C.... GENERATE ADD STEP,RU
      NATURE = DOSTK(DOPTR-8)
      SCOND = DOSTK(DOPTR-9)
      VALUE = DOSTK(DOPTR-12)
C.... CHECK FOR LOOP INCREMENT OF 1
      IF (NATURE .EQ. 1 .AND. VALUE .EQ. 1) GO TO 5087
C.... GENERATE EXTERNAL SYMBOL REFERENCE IF REQUIRED
      IF (SCOND .EQ. 3) CALL WRTEXT(DOSTK(DOPTR-10),DOSTK(DOPTR-11))
      INSTR = IOR(704,UTIL)
C.... GENERATE ADDI IF LITERAL
      IF (NATURE .NE. 2) INSTR = IOR(INSTR,56)
      DSCSTK(3) = INSTR
      DSCSTK(6) = VALUE
      CALL DSCCOD
      GO TO 5088
C.... ISSUE INCR RU (1U)
 5087 INSTR = IOR(8,UTIL)
      LSTCOD = KSPC
      LNKCOD = 1
      CALL GENCOD(3)
C.... GENERATE CMP FINI,RU
 5088 NATURE = DOSTK(DOPTR-13)
      SCOND = DOSTK(DOPTR-14)
C.... GENERATE EXTERNAL SYMBOL REFERENCE IF REQUIRED
      IF (SCOND .EQ. 3) CALL WRTEXT(DOSTK(DOPTR-15),DOSTK(DOPTR-16))
      INSTR = IOR(832,UTIL)
C.... GENERATE CMPI IF LITERAL
      IF (NATURE .NE. 2) INSTR = IOR(INSTR,56)
      DSCSTK(3) = INSTR
      DSCSTK(6) = DOSTK(DOPTR-17)
      CALL DSCCOD
C.... DO-LOOP END (BLE = 1046)
      I = 550
      J = 18
C.... GENERATE BRANCH BACK TO TOP OF DO-LOOP
 5090 DSCSTK(1) = 2
      DSCSTK(2) = KSPC
      DSCSTK(3) = I
      DSCSTK(4) = -1
      DSCSTK(5) = KSPC
C!!!! IN 1'S COMPLEMENT INSTALLATIONS
C!!!! THE FOLLOWING STATEMENT SHOULD BE:
C!!!! DSCSTK(6) = LOC - DOSTK(DOPTR-J) + 2
      DSCSTK(6) = LOC - DOSTK(DOPTR-J) + 1
      DOPTR = DOPTR - J
      DONEST = DONEST - 1
      CALL ISSCOD
      GO TO 4220
C.... INSTRUCTION TYPE 35 - E L S E
 5200 IF (NPASS .EQ. 2) GO TO 5220
      IF (IFPTR .GT. IFMAX) GO TO 5210
      IFSTK(IFPTR) = LOC + 2
      IFPTR = IFPTR + 1
 5210 IFCNT = IFCNT + 1
C.... CHECK FOR NO OPEN IF-THEN
 5220 IF (IFFLG .NE. 0) GO TO 5230
      CALL ERROR(27)
 5225 CALL PRINT(4)
      GO TO 280
C.... CHECK FOR NO LABEL
 5230 IF (IN(ILBL) .EQ. KSPC) GO TO 5235
      IPTR = ILBL
      CALL ERROR(1)
 5235 CALL OPRFIN
      CALL PRINT(4)
C.... GENERATE IF-THEN BLOCK CLOSE
      LNKCOD = 2
      LSTCOD = KSPC
      INSTR = 512
      CALL GENCOD(3)
      LNKCOD = -1
      INSTR = 0
      IF (NPASS .EQ. 1) GO TO 5240
      INSTR = IFSTK(IFPTR) - LOC - 1
      IFPTR = IFPTR + 1
 5240 CALL GENCOD(3)
      GO TO 280
      END
      SUBROUTINE INVBRN(I)
C.... INVERT LOGICAL CONDITION OF BRANCH INSTRUCTION
      IF (IAND(I,8) .NE. 0) GO TO 20
      I = IOR(I,8)
      RETURN
   20 I = IAND(I,1015)
      RETURN
      END
      SUBROUTINE GENINS(I)
      IMPLICIT INTEGER (A-Z)
      COMMON /CODE/NPASS,LOC,INCODE,INSTR,ISKEL,LNKCOD,LSTCOD
      COMMON /REGS/UTIL,INDX,LINK
      LNKCOD = 1
      LSTCOD = 1H
      INSTR = IOR(I,UTIL)
      CALL GENCOD(3)
      RETURN
      END
      SUBROUTINE XTRDSC(TYPE,LSTINS)
      IMPLICIT INTEGER(A-Z)
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK 11802
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C.... EXTRACT OPERAND DESCRIPTOR
      COMMON /KTERMS/ KTERMS(7)
      COMMON /INLINE/ LINENO,IPTR,INMAX,ILBL,IOPR,IOPRN,ICOMM,IN(60)
      COMMON /REGS/ UTIL,INDX, LINK
      COMMON /ARGS/ VALUE, STATUS, NATURE, SCOND, STYPE
      COMMON /ACHR/ ACHR(64)
      EQUIVALENCE (KSPC,ACHR(1))
      EQUIVALENCE (KLPRN,ACHR(9))
      EQUIVALENCE (KRPRN,ACHR(10))
      COMMON /DSCSTK/ DSCSTK(6)
      COMMON /CODE/ NPASS,LOC,INCODE,INSTR,ISKEL,LNKCOD,LSTCOD
C....
      I = LSTINS
C.... EXTRACT FIRST ELEMENT
      KTERMS(6) = KLPRN
      CALL XTROPR
      DSCSTK(6) = VALUE
C.... CHECK FOR LEFT SIDE AND LITERAL
      IF (TYPE .EQ. 1 .AND. NATURE .EQ. 1) CALL ERROR(6)
C.... CHECK FOR SUBSCRIPT
      IF (IN(IPTR) .EQ. KLPRN) GO TO 100
C.... CHECK FOR = 0
      IF (I.EQ.640 .AND. NATURE.EQ.1 .AND. VALUE.EQ.0) GO TO 20
C.... CHECK FOR + OPERATOR FOLLOWED BY LITERAL 1
      IF (I.EQ.704 .AND. NATURE.EQ.1 .AND. VALUE.EQ.1) GO TO 40
C.... CHECK FOR - OPERATOR FOLLOWED BY LITERAL 1
      IF (I.EQ.768 .AND. NATURE.EQ.1 .AND. VALUE.EQ.1) GO TO 60
C.... IF NOT GO@ AND LITERAL, SET UP IMMEDIATE INSTRUCTION
      IF (UTIL .NE. 7 .AND. NATURE .NE. 2) I = IOR(I,56)
      DSCSTK(3) = IOR(I,UTIL)
      CALL DSCCOD
      RETURN
C.... = 0, ISSUE CLRR RU (7UU)
   20 INSTR = IOR(IOR(448,ISL(UTIL,3)),UTIL)
      GO TO 220
C.... + 1, ISSUE INCR RU (1U)
   40 I = 8
      GO TO 80
C.... - 1, ISSUE DECR RU (2U)
   60 I = 16
   80 INSTR = IOR(I,UTIL)
      GO TO 220
C.... LOCATE SUBSCRIPT
  100 IPTR = IPTR + 1
      CALL SKPSPC
      IF (STATUS .EQ. 1) CALL ERROR(6)
C.... SET INSTRUCTION TO MVII VAR,RI (127I)
      DSCSTK(3) = IOR(696,INDX)
      CALL DSCCOD
      CALL SKPSPC
      IF (STATUS .EQ. 1) CALL ERROR(6)
C.... EXTRACT SUBSCRIPT
      KTERMS(6) = KRPRN
      CALL XTRLIT
      IF (STATUS .EQ. 0) GO TO 120
C.... LITERAL SUBSCRIPT
C.... CHECK FOR SUBSCRIPT OF ZERO
      IF (VALUE .EQ. 0) GO TO 160
C.... CHECK FOR SUBSCRIPT OF 1 OR -1
      IF (VALUE .EQ. 1) GO TO 130
      IF (VALUE .EQ. -1) GO TO 135
C.... ISSUE ADDI LIT,RI (137I)
      DSCSTK(3) = IOR(760,INDX)
      DSCSTK(6) = VALUE
      CALL DSCCOD
      GO TO 160
C.... VARIABLE SUBSCRIPT
  120 CALL XTRSYM
C.... ADD VAR,RI (130I)
      DSCSTK(3) = IOR(704,INDX)
      DSCSTK(6) = VALUE
      CALL DSCCOD
      CALL SKPSPC
      IF (STATUS .EQ. 1) GO TO 200
C.... CHECK FOR LITERAL FOLLOWING
      IF (IN(IPTR) .EQ. KRPRN) GO TO 180
C.... EXTRACT LITERAL
      CALL XTRLIT
      IF (STATUS .EQ. 0) CALL ERROR(6)
C.... CHECK FOR + OR - 1
      IF (VALUE .EQ. 1) GO TO 130
      IF (VALUE .EQ. -1) GO TO 135
C.... ADDI LIT,RI (137I)
      DSCSTK(3) = IOR(760,INDX)
      DSCSTK(6) = VALUE
      CALL DSCCOD
      GO TO 160
C.... +1, ISSUE INCR RI (1I)
  130 I = 8
      GO TO 140
C.... -1, ISSUE DECR RI (2I)
  135 I = 16
  140 INSTR = IOR(I,INDX)
      LSTCOD = KSPC
      LNKCOD = 1
      CALL GENCOD(3)
  160 CALL SKPSPC
      IF (STATUS .EQ. 1) CALL ERROR(6)
C.... BYPASS ")"
      IF (IN(IPTR) .EQ. KRPRN) GO TO 180
      CALL ERROR(6)
      GO TO 200
  180 IPTR = IPTR + 1
C.... MVI@ RI,RU (12IU)
  200 INSTR = IOR(LSTINS,IOR(ISL(INDX,3),UTIL))
  220 LSTCOD = KSPC
      LNKCOD = 1
      CALL GENCOD(3)
      RETURN
      END
      SUBROUTINE DSCCOD
      IMPLICIT INTEGER (A-Z)
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C.... SET UP DESCRIPTOR LINK AND LIST CODES
      COMMON /DSCSTK/ DSCSTK(6)
      COMMON /ARGS/ VALUE, STATUS, NATURE, SCOND, STYPE
      COMMON /ACHR/ ACHR(64)
      EQUIVALENCE (KSPC,ACHR(1))
      EQUIVALENCE (KR,ACHR(51))
      EQUIVALENCE (KX,ACHR(57))
C.... CHECK FOR LITERAL
      IF (NATURE .LE. 1) GO TO 100
C.... DETERMINE SYMBOL CONDITION
      IF (SCOND .EQ. 0) GO TO 100
      GO TO (100,200,300), SCOND
C.... ABSOLUTE
  100 I = 2
      J = KSPC
      GO TO 400
C.... RELOCATABLE
  200 I = 5
      J = KR
      GO TO 400
C.... EXTERNAL
  300 I = 10
      J = KX
  400 DSCSTK(1) = I
      DSCSTK(2) = KSPC
      DSCSTK(4) = -1
      DSCSTK(5) = J
      CALL ISSCOD
      RETURN
      END
      SUBROUTINE ISSCOD
      IMPLICIT INTEGER(A-Z)
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
      COMMON /DSCSTK/ DSCSTK(6)
      COMMON /CODE/ NPASS,LOC,INCODE,INSTR,ISKEL,LNKCOD,LSTCOD
C....
      DO 100 I = 1, 6, 3
      LNKCOD = DSCSTK(I)
      LSTCOD = DSCSTK(I+1)
      INSTR = DSCSTK(I+2)
      CALL GENCOD(3)
  100 CONTINUE
      RETURN
      END
      SUBROUTINE GENDST(INS)
      IMPLICIT INTEGER(A-Z)
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK 11802
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... GENERATE GO TO CODE
      COMMON /ARGS/ VALUE, STATUS, NATURE, SCOND, STYPE
      COMMON /CODE/ NPASS,LOC,INCODE,INSTR,ISKEL,LNKCOD,LSTCOD
      COMMON /ACHR/ ACHR(64)
      EQUIVALENCE (KSPC,ACHR(1))
      EQUIVALENCE (KX,ACHR(57))
      COMMON /DSCSTK/ DSCSTK(6)
      I = INS
      STYPE = 0
      CALL XTROPR
      IF (SCOND .EQ. 1) CALL ERROR(16)
      IF (STYPE .EQ. 3 .OR. STYPE .EQ. 4) CALL ERROR(16)
      IF (SCOND .EQ. 3) GO TO 20
      DISPL = VALUE - LOC - 2
      VALUE = DISPL
      IF (DISPL .GE. 0) GO TO 20
      I = IOR(I,32)
      DISPL = INOT(DISPL)
C!!!! IN 1'S COMPLEMENT INSTALLATIONS
C!!!! THE FOLLOWING STATEMENT IS REQUIRED
C!!!! DISPL = DISPL + 1
   20 DSCSTK(1) = 2
      DSCSTK(2) = KSPC
      DSCSTK(3) = I
      DSCSTK(4) = -1
      DSCSTK(5) = KSPC
      DSCSTK(6) = DISPL
      IF (SCOND .NE. 3) GO TO 40
      DSCSTK(1) = 11
      DSCSTK(5) = KX
   40 CALL ISSCOD
      RETURN
      END
      SUBROUTINE IDNTOP
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... 600 WEST JOHN STREET
C.... MICROELECTRONICS DIVISION
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... IDENTIFY STATEMENT OPERATOR
      COMMON /IDNMSK/ M1,M2,KHRBIT
      COMMON /INLINE/LINENO,IPTR,INMAX,ILBL,IOPR,IOPRN,ICOMM,IN(60)
      COMMON /CODE/ NPASS,LOC,INCODE,INSTR,ISKEL,LNKCOD,LSTCOD
      INTEGER ACHR
      COMMON /ACHR/ ACHR(64)
      EQUIVALENCE (KSPC,ACHR(1))
      EQUIVALENCE (KEQL,ACHR(30))
      INTEGER BOP
      DIMENSION BOP(60)
      INTEGER JOP
      DIMENSION JOP(14)
      DIMENSION MOP(16)
      INTEGER RSOP
      DIMENSION RSOP(56)
      INTEGER OP
      DIMENSION OP(116)
      INTEGER OPS
      DIMENSION OPS(18)
      INTEGER DIR
      DIMENSION DIR(54)
      INTEGER SFX
      DIMENSION SFX(4)
      DIMENSION IDNTMP(2)
      DIMENSION LDCHR(5)
      EQUIVALENCE (IDNTM1,IDNTMP(1))
      EQUIVALENCE (IDNTM2,IDNTMP(2))
C.... OPERATOR LEADING CHARACTERS USED FOR HASHING
      DATA LDCHR/1HB,1HJ,1HM,1HR,1HS/
C.... OPERATORS STARTING WITH "B", ARRANGED IN
C.... DECREASING FEQUENCY OF USE
      DATA BOP/
     + 2HB ,2H  ,512,  2HBZ,2HE ,516,  2HBN,2HZE,524,
     + 2HBE,2HQ ,516,  2HBN,2HEQ,524,  2HBL,2HT ,517,
     + 2HBL,2HE ,518,  2HBG,2HT ,526,  2HBG,2HE ,525,
     + 2HBL,2HLT,521,  2HBL,2HGE,513,  2HBP,2HL ,515,
     + 2HBM,2HI ,523,  2HBC,2H  ,513,  2HBN,2HC ,521,
     + 2HBO,2HV ,514,  2HBN,2HOV,522,  2HBU,2HSC,519,
     + 2HBE,2HSC,527,  2HBE,2HXT,528 /
C.... OPERATORS STARTING WITH "J", ARRANGED IN
C.... DECREASING ORDER OF USE
      DATA JOP /
     + 2HJR,2H    ,2HJS,2HR , 2HJS,2HRE,
     + 2HJS,2HRD,  2HJ ,2H  ,  2HJE,2H  ,
     + 2HJD,2H   /
C.... MOVE OUT OPERATORS
      DATA MOP /
     + 2HMO,2HVR,8,128,
     + 2HMV,2HO@,17,576,
     + 2HMV,2HOI,18,632,
     + 2HMV,2HO ,19,576 /
C.... OPERATORS STARTING WITH "R" OR "S",
C.... ARRANGED IN DECREASING ORDER OF USE
      DATA RSOP /
     + 2HSW,2HAP,3,64,  2HSL,2HL ,3,72,
     + 2HRL,2HC ,3,80,  2HSL,2HLC,3,88,
     + 2HSL,2HR ,3,96,  2HSA,2HR ,3,104,
     + 2HRR,2HC ,3,112,  2HSA,2HRC,3,120,
     + 2HSE,2HTC,1,7,  2HSD,2HBD,23,1,
     + 2HRS,2HWD,2,56,  2HSI,2HN ,25,54,
     + 2HSI,2HN0,1,54, 2HSI,2HN1,1,55 /
C.... OPERATORS ARRANGED IN DECREASING ORDER OF USE
      DATA OP /
     + 2HIN,2HCR,2,8,  2HDE,2HCR,2,16,
     + 2HPS,2HHR,2,624,  2HPU,2HLR,2,688,
     + 2HCL,2HRR,21,448,  2HTS,2HTR,22,128,
     + 2HNE,2HGR,2,32,  2HCO,2HMR,2,24,
     + 2HCL,2HRC,1,6,  2HAD,2HCR,2,40,
     + 2HEI,2HS ,1,2, 2HDI,2HS ,1,3,
     + 2HTC,2HI ,1,5,  2HGS,2HWD,24,48,
     + 2HHL,2HT ,1,0,  2HNO,2HP ,1,52,
     + 2HCL,2HHB,3,68,
     + 2HNO,2HPP,5,520,
     + 2HCA,2HLL,26,4,
     + 2HGO,2HTO,27,0,
     + 2HGO,2H  ,27,1,
     + 2HGO,2H@ ,28,0,
     + 2HIF,2H  ,29,0,
     + 2HPU,2HTU,30,576,
     + 2HGE,2HTU,31,640,
     + 2HLE,2HT ,32,0,
     + 2HDO,2H  ,33,0,
     + 2HCO,2HNT,34,0,
     + 2HEL,2HSE,35,0/
C.... SUFFIXED OPERATORS
C.... OP CODE DETERMINED BY POSITION
      DATA OPS( 1)/'MV'/, OPS( 2)/'I '/, OPS( 3)/640/
      DATA OPS( 4)/'AD'/, OPS( 5)/'D '/, OPS( 6)/704/
      DATA OPS( 7)/'SU'/, OPS( 8)/'B '/, OPS( 9)/768/
      DATA OPS(10)/'CM'/, OPS(11)/'P '/, OPS(12)/832/
      DATA OPS(13)/'AN'/, OPS(14)/'D '/, OPS(15)/896/
      DATA OPS(16)/'XO'/, OPS(17)/'R '/, OPS(18)/960/
      DATA SFX(1)/'@'/, SFX(2)/'R'/, SFX(3)/'I'/, SFX(4)/' '/
C.... DIRECTIVES
C.... OP CODE DETERMINED BY POSITION (-1 TO -23)
C.... NON CODE GENERATING DIRECTIVES
      DATA DIR( 1)/'EN'/, DIR( 2)/'D '/
      DATA DIR( 3)/'AB'/, DIR( 4)/'S '/
      DATA DIR( 5)/'OR'/, DIR( 6)/'G '/
      DATA DIR( 7)/'EO'/, DIR( 8)/'T '/
      DATA DIR( 9)/'EQ'/, DIR(10)/'U '/
      DATA DIR(11)/'PA'/, DIR(12)/'GE'/
      DATA DIR(13)/'LS'/, DIR(14)/'T '/
      DATA DIR(15)/'NL'/, DIR(16)/'ST'/
      DATA DIR(17)/'IF'/, DIR(18)/'EQ'/
      DATA DIR(19)/'IF'/, DIR(20)/'NE'/
      DATA DIR(21)/'EN'/, DIR(22)/'DC'/
      DATA DIR(23)/'HE'/, DIR(24)/'AD'/
      DATA DIR(25)/'BI'/, DIR(26)/'TS'/
      DATA DIR(27)/'ME'/, DIR(28)/'ML'/
C.... CODE GENERATING DIRECTIVES
      DATA DIR(29)/2HRE/, DIR(30)/2HS /
      DATA DIR(31)/2HZE/, DIR(32)/2HRO/
      DATA DIR(33)/2HWO/, DIR(34)/2HRD/
      DATA DIR(35)/2HBY/ ,DIR(36)/2HTE/
      DATA DIR(37)/2HTE/, DIR(38)/2HXT/
C.... MODULE CONTROL DIRECTIVES
      DATA DIR(39)/2HEN/, DIR(40)/2HTR/
      DATA DIR(41)/2HRE/, DIR(42)/2HL /
      DATA DIR(43)/2HGL/, DIR(44)/2HOB/
      DATA DIR(45)/2HEX/, DIR(46)/2HT /
      DATA DIR(47)/2HUT/, DIR(48)/2HIL/
      DATA DIR(49)/2HIN/, DIR(50)/2HDX/
      DATA DIR(51)/2HLI/, DIR(52)/2HNK/
      DATA DIR(53)/2HRE/, DIR(54)/2HGS/
C.... PACK STATEMENT OPERATOR 2 CHARACTERS PER WORD
      IPTR = IOPR
      DO 105 I = 1, 2, 1
C!!!! IMPLEMENTATION NOTE:
C!!!! SOURCE STATEMENTS ARE CARRIED IN A1 FORMAT, IE,
C!!!! 1 CHARACTER PER WORD, LEFT JUSTIFIED WITH
C!!!! SPACES RIGHT FILL.  TWO CHARACTERS MUST BE PACKED IN
C!!!! A2 FORMAT , IE, 2 CHARACTERS PER WORD LEFT JUSTIFIED
C!!!! WITH SPACES RIGHT FILL FOR TABLE COMPARISON.
      IDNTMP(I)=IOR(IAND(IN(IPTR),M1),IAND(ISL(IN(IPTR+1),-KHRBIT),M2))
      IPTR = IPTR + 2
  105 CONTINUE
C.... CHECK FOR OPERATOR STRING GREATER THAN FOUR CHARACTERS
      IF (IN(IOPR+4) .NE. KSPC) GO TO 160
C.... TRY SUFFIXED OPERATORS
      J = IN(IOPR+2)
      DO 110 I = 1, 16, 3
      IF (IDNTM1 .EQ. OPS(I) .AND. J .EQ. OPS(I+1)) GO TO 200
  110 CONTINUE
C.... TRY NON SUFFIXED OPERATORS
C.... IDENTIFY FIRST CHARACTER FOR HASHING
C.... (B,J,M,R&S)
      J = IN(IOPR)
      DO 120 I = 1, 5, 1
      IF (J .EQ. LDCHR(I)) GO TO 300
  120 CONTINUE
C.... TRY NON HASHED OPERATORS
      DO 130 I = 1, 113, 4
      IF (IDNTM1 .EQ. OP(I) .AND.
     +   IDNTM2 .EQ. OP(I+1)) GO TO 180
  130 CONTINUE
C.... TRY DIRECTIVES
  140 DO 150 I = 1, 53, 2
      IF (IDNTM1 .EQ. DIR(I) .AND.
     +   IDNTM2 .EQ. DIR(I+1)) GO TO 170
  150 CONTINUE
C.... TRY "=" (SAME AS EQU)
      IF (IDNTM1 .EQ. KEQL .AND.
     +   IDNTM2 .EQ. KSPC) GO TO 175
C.... OPERATOR UNRECOGNIZED
  160 INCODE = 0
      INSTR = 52
      CALL ERROR(5)
      RETURN
C.... DIRECTIVE IDENTIFIED
  170 INCODE = -(I/2+1)
      RETURN
C.... "=" SAME AS EQU
  175 INCODE = -5
      RETURN
C.... NON SUFFIXED, NON HASHED OPERATOR IDENTIFIED
  180 INCODE = OP(I+2)
      ISKEL = OP(I+3)
      RETURN
C.... IDENTIFY SUFFIX
  200 ISKEL = OPS(I+2)
      J = IN(IOPR+3)
      DO 210 I = 1, 4, 1
      IF (J .EQ. SFX(I)) GO TO 220
  210 CONTINUE
C.... CANNOT IDENTIFY SUFFIX, ERROR
      GO TO 160
  220 INCODE = I + 6
C.... IF R SUFFIX, CLR EXT BIT
      IF (INCODE .EQ. 8) ISKEL = IAND(ISKEL,511)
C.... IF I SUFFIX, SET MODE 7
      IF (INCODE .EQ. 9) ISKEL = IOR(ISKEL,56)
      RETURN
C.... FIRST CHARACTER IDENTIFIED AS HASHING CHARACTER
  300 GO TO (310,340,370,400,400), I
C.... "B" OPERATORS
  310 DO 320 I = 1, 58, 3
      IF (IDNTM1 .EQ. BOP(I) .AND.
     +   IDNTM2 .EQ. BOP(I+1)) GO TO 330
  320 CONTINUE
C.... CANNOT IDENTIFY, TRY DIRECTIVE
      GO TO 140
  330 INCODE = 4
      IF (I .EQ. 58) INCODE = 6
      ISKEL = BOP(I+2)
      RETURN
C.... "J" OPERATORS
  340 DO 350 I = 1, 13, 2
      IF (IDNTM1 .EQ. JOP(I) .AND.
     +   IDNTM2 .EQ. JOP(I+1)) GO TO 360
  350 CONTINUE
C.... CANNOT IDENTIFY, ERROR
      GO TO 160
  360 INCODE = I/2 + 10
      ISKEL = 4
      IF (I .NE. 1) RETURN
      INCODE = 20
      ISKEL = 135
      RETURN
C.... "M" OPERATORS
  370 DO 380 I = 1, 13, 4
      IF (IDNTM1 .EQ. MOP(I) .AND.
     +   IDNTM2 .EQ. MOP(I+1)) GO TO 390
  380 CONTINUE
C.... CANNOT IDENTIFY, TRY DIRECTIVE
      GO TO 140
  390 INCODE = MOP(I+2)
      ISKEL = MOP(I+3)
      RETURN
C.... "R" OR "S" OPERATORS
  400 DO 410 I = 1, 53, 2
      IF (IDNTM1 .EQ. RSOP(I) .AND.
     +   IDNTM2 .EQ. RSOP(I+1)) GO TO 420
  410 CONTINUE
C.... CANNOT IDENTIFY, TRY DIRECTIVE
      GO TO 140
  420 INCODE = RSOP(I+2)
      ISKEL = RSOP(I+3)
      RETURN
      END
      SUBROUTINE NXTSTR
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... LOCATE BEGINNING OF NEXT SOURCE STATEMENT CHARACTER STRING
C.... IF END OF STATEMENT REACHED (;) STATUS = +1
C.... IF END NOT REACHED     STATUS =  0
      COMMON /INLINE/LINENO,IPTR,INMAX,ILBL,IOPR,IOPRN,ICOMM,IN(60)
      COMMON /ARGS/ KVALUE, KSTATS, NATURE, KSCOND, KSTYPE
      INTEGER ACHR
      COMMON /ACHR/ ACHR(64)
      EQUIVALENCE (KCOMMA,ACHR(13))
      COMMON /KTERMS/ KTERMS(7)
C.... BYPASS SPACES
      CALL SKPSPC
C.... CHECK FOR END OF STATEMENT
      IF (KSTATS .EQ. 1) RETURN
C.... CHECK FOR COMMA
      K = IN(IPTR)
      IF (K .EQ. KCOMMA) GO TO 20
C.... CHECK FOR SPECIAL SEPARATORS
      IF (K .EQ. KTERMS(6) .OR. K .EQ. KTERMS(7)) RETURN
C.... QUESTIONABLE SYNTAX
   10 CALL ERROR(14)
      RETURN
C.... BYPASS COMMA
   20 IPTR = IPTR + 1
C.... BYPASS SPACES
      CALL SKPSPC
      IF (KSTATS .EQ. 1) GO TO 10
      RETURN
      END
      SUBROUTINE SKPSPC
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C.... BYPASS SOURCE STATMENT SPACES
C.... IF END OF STATEMENT REACHED (;) STATUS = +1
C.... IF END NOT REACHED     STATUS =  0
      COMMON /INLINE/ LINENO,IPTR,INMAX,ILBL,IOPR,IOPRN,ICOMM,IN(60)
      COMMON /ARGS/ VALUE, KSTATS, NATURE, SCOND, STYPE
      INTEGER ACHR
      COMMON /ACHR/ ACHR(64)
      EQUIVALENCE (KSPC,ACHR(1))
      EQUIVALENCE (KSCOLN,ACHR(28))
   20 K = IN(IPTR)
      IF (K .EQ. KSCOLN) GO TO 60
      IF (K .NE. KSPC) GO TO 40
      IPTR = IPTR + 1
      GO TO 20
   40 KSTATS = 0
      RETURN
   60 KSTATS = 1
      RETURN
      END
      SUBROUTINE OPRFIN
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... CHECK FOR CURRENT OPERAND FINISHED
      COMMON /INLINE/LINENO,IPTR,INMAX,ILBL,IOPR,IOPRN,ICOMM,IN(60)
      INTEGER ACHR
      COMMON /ACHR/ ACHR(64)
      EQUIVALENCE (KSPC,ACHR(1))
      EQUIVALENCE (KSCOLN,ACHR(28))
   20 IF (IN(IPTR) .EQ. KSCOLN .OR. IPTR .GE. INMAX) RETURN
      IF (IN(IPTR) .NE. KSPC) GO TO 40
      IPTR = IPTR + 1
      GO TO 20
C.... QUESTIONABLE SYNTAX
   40 CALL ERROR(14)
      RETURN
      END
      SUBROUTINE ASCII(KHR)
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... CONVERT A HOLLERITH CHARACTER TO 7 BIT ASCII CODE
      COMMON /ARGS/ KVALUE, KSTATS, NATURE, KCOND, KSTYPE
      INTEGER ACHR
      COMMON /ACHR/ ACHR(64)
C.... IDENTIFY CHARACTER
      DO 20 KVALUE = 1, 64, 1
      IF (KHR .EQ. ACHR(KVALUE)) GO TO 40
   20 CONTINUE
C.... ILLEGAL CHARACTER
      CALL ERROR(8)
C.... FORCE SPACE
      KVALUE = 1
C.... CONVERT TO ASCII
   40 KVALUE = KVALUE + 31
      RETURN
      END
      FUNCTION MOD40U(K)
C.... CONVERT MODULO 40 CHARACTER TO HOLLERITH
      INTEGER ACHR
      COMMON /ACHR/ ACHR(64)
C.... CHECK FOR SPACE ( 0 )
      IF (K .EQ. 0) I = 1
C.... CHECK FOR A - Z ( 1 - 26 )
      IF (K .GE. 1 .AND . K .LE. 26 ) I = K + 33
C.... CHECK FOR $ ( 27 )
      IF (K .EQ. 27) I = 5
C.... CHECK FOR & ( 28 )
      IF (K .EQ. 28) I = 7
C.... CHECK FOR ? ( 29 )
      IF (K .EQ. 29) I = 32
C.... CHECK FOR 0 - 9 ( 30 - 39 )
      IF (K .GE. 30 .AND. K .LE. 39) I = K - 13
      MOD40U = ACHR(I)
      RETURN
      END
      SUBROUTINE CHKREG(K)
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... CHECK CURRENT "VALUE" QUANTITY FOR 0-3
C.... OR 0-7, IF NOT ISSUE DIAGNOSTIC, FORCE 0
      INTEGER SCOND, STYPE
      COMMON /ARGS/ KVALUE, KSTATS, NATURE, SCOND, STYPE
      IF (KVALUE .GE. 0 .AND. KVALUE .LE. K) GO TO 20
      KVALUE = 0
C.... ILLEGAL REGISTER
   10 CALL ERROR(7)
      RETURN
C... CHECK FOR OPERAND NOT ABS
   20 IF (SCOND .GT. 1) CALL ERROR(12)
      RETURN
      END
      SUBROUTINE CHKMOD
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... CHECK CURRENT "VALUE" QUANTITY FOR 1-6
C.... OR 0-7, IF NOT ISSUE DIAGNOSTIC, FORCE 1
      INTEGER SCOND, STYPE
      COMMON /ARGS/ KVALUE, KSTATS, NATURE, SCOND, STYPE
      IF (KVALUE .LT. 1 .OR. KVALUE .GT. 6) GO TO 10
      IF (KVALUE .GE. 0 .AND. KVALUE .LE. 7) GO TO 20
      KVALUE = 1
C.... ILLEGAL REGISTER
   10 CALL ERROR(7)
      RETURN
C.... CHECK FOR OPERAND NOT ABS
   20 IF (SCOND .GT. 1) CALL ERROR(12)
      RETURN
      END
      SUBROUTINE CHKWRD
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... CHECK CURRENT "VALUE" QUANTITY FOR MAGNITUDE
C.... EXCEEDING WORD SIZE
      INTEGER WRDSIZ
      COMMON /WRDSIZ/ WRDSIZ
      COMMON /ARGS/ KVALUE, KSTATS, NATURE, KCOND, KSTYPE
      IF (WRDSIZ .EQ. 0) RETURN
C.... WORD SIZE TOO LARGE
      IF (IAND(KVALUE,WRDSIZ) .NE. KVALUE) CALL ERROR(15)
      RETURN
      END
      SUBROUTINE CHKEND
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... CHECK CURRENT SOURCE STATEMENT CHARACTER FOR STRING TERMINATOR
C.... IF NOT ISSUE QUESTIONABLE SYNTAX DIAGNOSTIC, THEN LOCATE THE NEXT
C.... TERMINATOR OR END OF STATEMENT.
      COMMON /INLINE/LINENO,IPTR,INMAX,ILBL,IOPR,IOPRN,ICOMM,IN(60)
      COMMON /KTERMS/ KTERMS(7)
C.... CHECK FOR STRING TERMINATOR
      DO 20 I = 1, 7, 1
      IF (IN(IPTR) .EQ. KTERMS(I)) RETURN
   20 CONTINUE
C.... NOT VALID STRING TERMINATOR, ISSUE QUESTIONABLE SYNTAX DIAGNOSTIC
      CALL ERROR(14)
C.... LOCATE END OF STRING
      CALL FNDEND
      RETURN
      END
      SUBROUTINE FNDEND
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... LOCATE NEXT STRING TERMINATOR
      COMMON /INLINE/LINENO,IPTR,INMAX,ILBL,IOPR,IOPRN,ICOMM,IN(60)
      COMMON /KTERMS/ KTERMS(7)
C.... CHECK FOR STRING TERMINATOR
   10 DO 20 I = 1, 7, 1
      IF (IN(IPTR) .EQ. KTERMS(I)) RETURN
   20 CONTINUE
      IPTR = IPTR + 1
      GO TO 10
      END
      SUBROUTINE XTROPR
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C....
C.... EXTRACT VALUE OF CURRENT OPERAND EXPRESSION
C.... EXPRESSION ELEMENTS MAY BE:
C....     USER SYMBOLS, LOC SYMBOL (!) OR LITERALS
C.... SIX ITEMS PER EXPRESSION ARE ALLOWED
C.... EXPRESSION OPERATORS ARE: + AND - ONLY
      COMMON /INLINE/LINENO,IPTR,INMAX,ILBL,IOPR,IOPRN,ICOMM,IN(60)
      COMMON /CODE/ NPASS,LOC,INCODE,INSTR,ISKEL,LNKCOD,LSTCOD
      COMMON /ARGS/ KVALUE,KSTATS,NATURE,KSCOND,KSTYPE
      COMMON /CONST/ KB15, ML16B, ML15B
      COMMON /KTERMS/ KTERMS(7)
      INTEGER ACHR
      COMMON /ACHR/ ACHR(64)
      EQUIVALENCE (KSPC,ACHR(1))
      EQUIVALENCE (LOCSYM,ACHR(2))
      EQUIVALENCE (KPLUS,ACHR(12))
      EQUIVALENCE (KCOMMA,ACHR(13))
      EQUIVALENCE (KMINUS,ACHR(14))
      EQUIVALENCE (KSCOLN,ACHR(28))
      INTEGER SYMSTK, STKPTR, STKMAX
      DIMENSION SYMSTK(6,6)Hl}"ATA STKMAX/6/
      DATA GRTNUM /65535.0/
C.... INITIALIZE EXPRESSION VALUE
      KVALUE = 0
      KSCOND = 0
      NATURE = 0
C.... INITIALIZE STACK POINTER
      STKPTR = 0
C.... INITIALIZE ITEM SIGN TO POSITIVE
   20 KSIGN = 1
C.... CHECK FOR NULL OPERAND
      K = IN(IPTR)
      IF (K .NE. KSPC) GO TO 30
   25 CALL ERROR(6)
      CALL FNDEND
      RETURN
C.... NOT SEPARATOR, CHECK FOR +
   30 IF (K .NE. KPLUS) GO TO 40
C.... SET + FLAG
      KSIGN = +KSIGN
      GO TO 50
C.... CHECK FOR -
   40 IF (K .NE. KMINUS) GO TO 60
C.... SET - FLAG
      KSIGN = -KSIGN
C.... BYPASS + OR -
   50 IPTR = IPTR + 1
      K = IN(IPTR)
      DO 55 I = 1, 7, 1
      IF (K .EQ. KTERMS(I)) GO TO 25
   55 CONTINUE
C.... CHECK FOR LOC SYMBOL (!)
   60 IF (K .NE. LOCSYM) GO TO 80
C.... MOVE LOC VALUE TO STACK
      KVALUE = LOC
C.... LOC (!) IS SAME AS SYMBOL, IE, RELOCATABLE
      NATURE = 2
      KSCOND = 2
C.... BYPASS LOC SYMBOL (!)
      IPTR = IPTR + 1
C.... CHECK FOR VALID STRING TERMINATION
      CALL CHKEND
C.... MOVE EXPRESSION ELEMENT VALUE TO STAK
C.... IF LEADING MINUS SIGN, NEGATE ITEM BEFORE PUSHING ON STACK
C!!!! WATCH OUT FOR 16 BIT INSTALLATIONS
   70 IF (KSIGN .LT. 0) KVALUE = -KVALUE
C.... MOVE VALUE TO STACK, CHECK FOR STACK FULL
      STKPTR = STKPTR + 1
      IF (STKPTR .GT. STKMAX) GO TO 75
C.... ELEMENT VALUE
      SYMSTK(STKPTR,1) = KVALUE
C.... ELEMENT CONDITION
      SYMSTK(STKPTR,2) = KSCOND
C.... ELEMENT NATURE
      SYMSTK(STKPTR,3) = NATURE
C.... CHECK FOR OPERAND TERMINATOR
      K = IN(IPTR)
      IF (K .EQ. KSPC) GO TO 100
      IF (K .EQ. KCOMMA .OR. K .EQ. KSCOLN) GO TO 100
      IF (K .EQ. KTERMS(6) .OR. K .EQ. KTERMS(7)) GO TO 100
      GO TO 20
C.... STACK FULL, ISSUE DIAGNOSTIC, ADJUST STACK PTR, SUM EXPRESSION
   75 CALL ERROR(6)
      STKPTR = STKPTR - 1
      GO TO 100
C.... TRY LITERAL EXTRACTION
   80 CALL XTRLIT
C.... CHECK FOR LITERAL FOUND
      IF (KSTATS .EQ. 1) GO TO 70
C.... NOT LITERAL OR ! TRY SYMBOL EXTRACTION
C.... EXTRACT SYMBOL ATTRIBUTES
      CALL XTRSYM
      GO TO 70
C.... REACHED END OF OPERAND EXPRESSION OR STACK FULL
  100 KVALUE = 0
      ACCUM = 0.0
C.... INITIALIZE EXPRESSION NATURE TO LITERAL
      NATURE = 1
C.... INITIALIZE REL & EXT ELEMENT COUNTS
      NREL = 0
      NEXT = 0
C.... SUM EXPRESSION
      DO 110 I = 1, STKPTR, 1
C.... COMPUTE EXPRESSION VALUE
      ACCUM = ACCUM + FLOAT(SYMSTK(I,1))
C.... IF ANY ELEMENT IS ABSOLUTE, INITIALIZE CONDITION
      IF (SYMSTK(I,2) .EQ. 1) KSCOND = 1
C.... COUNT NUMBER OF ELEMENTS RELOCATABLE
      IF (SYMSTK(I,2) .EQ. 2) NREL = NREL + 1
C.... COUNT NUMBER OF ELEMENTS EXTERNAL
      IF (SYMSTK(I,2) .EQ. 3) NEXT = NEXT + 1
C.... IF ANY ELEMENT IS A SYMBOL, EXPRESSION NATURE IS SYMBOL
      IF (SYMSTK(I,3) .EQ. 2) NATURE = 2
  110 CONTINUE
C.... CHECK FOR ABS EXPR
      IF (NREL + NEXT .EQ. 0) GO TO 120
C.... IF > 1 EXT ELEMENT ISSUE DIAGNOSTIC
      IF (NEXT .GT. 1) CALL ERROR(11)
C.... IF > 1 REL OR EXT ELEMENT, EXPR IS ABS
      IF (NREL .GT. 1 .OR. NEXT .GT. 1) GO TO 120
C.... EXPR REL IF ONLY 1 REL ELEMENT
      IF (NREL .EQ. 1 .AND. NEXT .EQ. 0) KSCOND = 2
C.... EXPR EXT IF ONLY 1 EXT ELEMENT
      IF (NEXT .EQ. 1 .AND. NREL .EQ. 0) KSCOND = 3
C.... CHECK FOR EXPRESSION VALUE TOO LARGE
  120 CONTINUE
      IF (ABS(ACCUM) .LE. GRTNUM) GO TO 130
      KVALUE = 32767
      CALL ERROR(13)
      GO TO 150
  130 CONTINUE
      IF (ABS(ACCUM) .LE. 32767.0) GO TO 140
      ACCUM = ACCUM - 32768.0
      KVALUE = IOR(KB15,IFIX(ACCUM))
      GO TO 150
  140 KVALUE = IFIX(ACCUM)
  150 KSTATS = 1
      RETURN
      END
      SUBROUTINE XTRLIT
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... CHECK CURRENT STATEMENT STRING FOR LITERAL
C....
C.... IF LITERAL, EXTRACT VALUE, SET STATUS = +1, SET PTR TO STR TERM
C....
C.... IF ERROR, ISSUE DIAGNOSTIC, SET STATUS = -1, VALUE = 0
C....
C.... IF NOT LITERAL, SET STATUS = 0, VALUE = 0, NO PTR CHANGE
      COMMON /ASCIIK/ KASCSP, MSK1, MSK2, MSK3
      COMMON /CONST/ KB15, ML16B, ML15B
      COMMON /INLINE/LINENO,IPTR,INMAX,ILBL,IOPR,IOPRN,ICOMM,IN(60)
      COMMON /ARGS/ KVALUE, KSTATS, NATURE, KSCOND, KSTYPE
      COMMON /KDIGS/ KDIGS(16)
      INTEGER ACHR
      COMMON /ACHR/ ACHR(64)
      EQUIVALENCE (KAPOS,ACHR(8))
      EQUIVALENCE (K0,ACHR(17))
      EQUIVALENCE (K7,ACHR(24))
      EQUIVALENCE (KSCOLN,ACHR(28))
      DIMENSION LCHRS(7)
      DATA LCHRS/2H+ ,2H- ,2H. ,2HX ,2HB ,2H' ,2H" /
C.... INITIALIZE - NO SIGN, NO LTIERAL FOUND, ZERO VALUE
      KSIGN = 0
      KSTATS = 0
      KVALUE = 0
      NATURE = 0
C.... CHECK FOR LEADING + - . X B ' "
   10 K = IN(IPTR)
      DO 20 I = 1, 7, 1
      IF (K .NE. LCHRS(I)) GO TO 20
C.... FOUND LEADING + - . X B ' "
      GO TO ( 110, 120, 140, 150, 180, 200, 200 ), I
   20 CONTINUE
C.... NOT LEADING + - . X B ' " , CHECK FOR 0-7
C.... IF NOT 0-7, STRING IS NOT LITERAL
      IF (K .LT. K0 .OR. K .GT. K7) RETURN
C.... OCTAL LITERAL, SET EXTRACTION CONTROLS
      LTYPE = 8
      NCHRS = 5
   25 CONTINUE
      GRTNUM = 65535.0
C.... INIT LITERAL ACCUMULATOR, SET MAX NO. CHRS
   30 CONTINUE
      ACCUM = 0.0
      LIM = IPTR + NCHRS
C.... EXTRACT LITERAL
      DO 40 J = IPTR, LIM, 1
C.... IF NON NUMERIC, TERMINATE LITERAL ACCUMULATION
      DO 35 I = 1, LTYPE, 1
      IF (IN(IPTR) .EQ. KDIGS(I)) GO TO 37
   35 CONTINUE
      GO TO 50
C.... ACCUMULATE DIGIT
   37 ACCUM = (ACCUM*FLOAT(LTYPE)) + FLOAT(I-1)
      IPTR = IPTR + 1
   40 CONTINUE
C.... CHECK FOR HEX OR BINARY LITERAL CLOSING '
   50 IF (LTYPE .NE. 2 .AND. LTYPE .NE. 16) GO TO 55
      IF (IN(IPTR) .NE. KAPOS) GO TO 55
C.... BYPASS CLOSING '
      IPTR = IPTR + 1
C.... CHECK FOR VALID STRING TERMINATION
   55 CALL CHKEND
C.... CHECK FOR LITERAL .GT. 32767.0R 65535
      IF (ACCUM .LE. GRTNUM) GO TO 70
C.... LITERAL TOO LARGE, ISSUE DIAGNOSTIC, SET ERROR CONDITIONS
      KVALUE = 32767
      CALL ERROR(13)
      GO TO 90
C.... CONVERT ACCUMULATOR TO INTEGER, CHECK FOR -, SET OK CONDITION
   70 CONTINUE
      IF (ACCUM .LE. 32767.0) GO TO 75
      ACCUM = ACCUM - 32768.0
      KVALUE = IOR(KB15,IFIX(ACCUM))
      GO TO 80
   75 KVALUE = IFIX(ACCUM)
C!!!! WATCH OUT FOR 16 BIT INSTALLATIONS
   80 IF (KSIGN .LT. 0) KVALUE = -KVALUE
   90 KSTATS = 1
      KSCOND = 1
      NATURE = 1
      RETURN
C.... LEADING +, CHECK FOR PREVIOUS SIGN, SET SIGN FLAG, BYPASS
  110 IF (KSIGN .NE. 0) CALL ERROR(6)
      KSIGN = 1
      GO TO 130
C.... LEADING -, CHECK FOR PREVIOUS SIGN, SET FLAG, BYPASS
  120 IF (KSIGN .NE. 0) CALL ERROR(6)
      KSIGN = -1
C....  CHECK FOR END OF INPUT
  130 IPTR = IPTR + 1
      IF (IN(IPTR) .EQ. KSCOLN) GO TO 300
      GO TO 10
C.... DECIMAL LITERAL, SET EXTRACTION CONTROLS
  140 LTYPE = 10
      GRTNUM = 32767.0
      NCHRS = 4
C.... BYPASS LEADING "."
      IPTR = IPTR + 1
      GO TO 30
C.... HEXADECIMAL LITERAL
C.... SET EXTRACTION CONTROLS
  150 LTYPE = 16
      NCHRS = 3
C.... CHECK FOR "X'" OR "B'"
  160 IF (IN(IPTR+1) .NE. KAPOS) RETURN
      IPTR = IPTR + 2
      GO TO 25
C.... BINARY LITERAL
C.... SET EXTRACTION CONTROLS
  180 LTYPE = 2
      NCHRS = 15
      GO TO 160
C.... ASCII LITERAL
C.... USE FIRST CHARACTER AS DELIMITER
  200 K = IN(IPTR)
C.... BYPASS LEADING DELIMITER
      IPTR = IPTR + 1
C.... CHECK FOR END OF INPUT
      IF (IPTR .GE. INMAX) GO TO 300
C.... INITILAIZE TO ASCII BLANKS ( 020040 OCTAL )
      I = KASCSP
C.... EXTRACT
      DO 220 LIM = 1, 2, 1
C.... CHECK FOR STRING DELIMITER
      IF (IN(IPTR) .NE. K) GO TO 205
C.... CHECK FOR DOUBLE DELIMITERS
      IF (IN(IPTR+1) .NE. K) GO TO 260
      IPTR = IPTR + 1
C.... CONVERT TO SEVEN BIT ASCII
  205 CALL ASCII(IN(IPTR))
C.... PACK ASCII CHARACTERS
C.... INSERT LOW BYTE
      IF (LIM .EQ. 1) I = KVALUE
C.... INSERT HIGH BYTE
      IF (LIM .EQ. 2) I = IOR(I,ISL(KVALUE,8))
C.... CHECK FOR END OF STATEMENT
      IF (IPTR .GE. INMAX) GO TO 300
      IPTR = IPTR + 1
  220 CONTINUE
C.... CHECK FOR  NEXT CHR = STRING DELIMITER
      IF (IN(IPTR) .EQ. K) GO TO 230
C.... QUESTIONABLE SYNTAX
      CALL ERROR(14)
      GO TO 240
  230 IF (IPTR .GE. INMAX) GO TO 250
      IPTR = IPTR + 1
  240 CALL CHKEND
  250 KVALUE = I
      GO TO 80
C.... BYPASS STRING DELIMITER
  260 IPTR = IPTR + 1
      GO TO 240
C.... SYNTAX ERROR
  300 CALL ERROR(6)
      GO TO 90
      END
      SUBROUTINE XTRSYM
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... EXTRACT SYMBOL ATTRIBUTES FROM SYMBOL TABLE
      COMMON /INLINE/LINENO,IPTR,INMAX,ILBL,IOPR,IOPRN,ICOMM,IN(60)
      INTEGER SYMIDX,SYMLIM,SYMFUL,SYMLOW,SYMMID,SYMMAX,SYMTBL
      COMMON /SYMBOL/SYMIDX,SYMLIM,SYMFUL,SYMLOW,SYMMID,SYMMAX,
     +               SYMTBL(4,400)
      INTEGER SYMTMP
      COMMON /SYMTMP/ SYMTMP(4)
      INTEGER VALUE, STATUS, NATURE, SCOND, STYPE
      COMMON /ARGS/ VALUE, STATUS, NATURE, SCOND, STYPE
      COMMON /CODE/ NPASS,LOC,INCODE,INSTR,ISKEL,LNKCOD,LSTCOD
C.... INITIALIZE
      SCOND = 0
      STYPE = 0
      NATURE = 0
      VALUE = 0
C.... PACK SYMBOL
      CALL PAKSYM(3)
C.... CHECK FOR INVALID SYMBOL
      IF (STATUS .EQ. -1) GO TO 300
C.... SET NATURE = SYMBOL
      NATURE = 2
C.... LOCATE SYMBOL
      CALL FNDSYM(3)
      IF (STATUS .EQ. 1) GO TO 200
C.... SYMBOL NOT FOUND IN TABLE, CHECK FOR PASS 2
  100 IF (NPASS .EQ. 2) GO TO 160
C.... CHECK FOR TABLE SPACE
      IF (SYMIDX .LE. SYMLIM) GO TO 120
      IF (SYMFUL .EQ. 0) SYMFUL = LINENO
      GO TO 300
C.... INSERT SYMBOL
  120 SYMTBL(1,SYMIDX) = SYMTMP(3)
      SYMTBL(2,SYMIDX) = SYMTMP(4)
C.... ZERO VALUE
      SYMTBL(3,SYMIDX) = 0
C.... MARK SYMBOL REFERENCED
      SYMTBL(4,SYMIDX) = 8
C.... IF "ENTR" MARK SYMBOL REFERENCED & ENTR
      IF (INCODE .EQ. -20) SYMTBL(4,SYMIDX) = 264
C.... UPDATE SYMBOL TABLE POINTER
      SYMIDX = SYMIDX + 1
      GO TO 300
C.... SYMBOL UNDEFINED, "U" DIAGNOSTIC
  160 CALL ERROR(3)
      GO TO 300
C.... SYMBOL FOUND IN TABLE, SAVE TABLE POINTER
  200 I = VALUE
C.... RETURN SYMBOL VALUE
      VALUE = SYMTBL(3,I)
C.... MARK SYMBOL REFERENCED (2'3 = 1)
      SYMTBL(4,I)=IOR(SYMTBL(4,I),8)
      STATUS = SYMTBL(4,I)
C.... CHECK IF SYMBOL MULTI DEFINED (2'8)
      IF (IAND(STATUS,512) .NE. 0) CALL ERROR(4)
C.... RETURN SYMBOL TYPE.
C....  0 = UNKNOWN
C....  1 = EQU
C....  2 = INSTRUCTION
C....  3 = DATA, TEXT
C....  4 = RES, ZERO
      STYPE = IAND(ISL(STATUS,-4),7)
C.... RETURN SYMBOL CONDITION
C....  0 = UNDEFINED
C....  1 = ABSOLUTE
C....  2 = RELOCATABLE
C....  3 = EXTERNAL
      SCOND = IAND(STATUS,3)
C.... CHECK FOR SYMBOL UNDEFINED
      IF (SCOND .EQ. 0) GO TO 160
C.... IF OP IS ENTR MARK SYMBOL AS ENTRY
      IF (INCODE .EQ. -20) SYMTBL(4,I) = IOR(SYMTBL(4,I),256)
C.... GENERATE EXTERNAL SYMBOL REFERENCE IF REQUIRED
      IF (SCOND .EQ. 3) CALL WRTEXT(SYMTBL(1,I),SYMTBL(2,I))
  300 STATUS = 1
      RETURN
      END
      SUBROUTINE FNDSYM(IP)
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... SEARCH SYMBOL TABLE FOR CURRENT SYMBOL
      INTEGER SYMIDX,SYMLIM,SYMFUL,SYMLOW,SYMMID,SYMMAX,SYMTBL
      COMMON /SYMBOL/ SYMIDX,SYMLIM,SYMFUL,SYMLOW,SYMMID,SYMMAX,
     +                SYMTBL(4,400)
      INTEGER SYMTMP
      COMMON /SYMTMP/ SYMTMP(4)
      INTEGER VALUE, STATUS, NATURE, SCOND, STYPE
      COMMON /ARGS/ VALUE, STATUS, NATURE, SCOND, STYPE
      COMMON /CODE/ NPASS,LOC,INCODE,INSTR,ISKEL,LNKCOD,LSTCOD
C.... SET NO FIND FLAG
      STATUS = 0
C.... CHECK FOR EMPTY SYMBOL TABLE
      IF (SYMIDX .LE. 1) RETURN
C.... CHECK FOR PASS 2
      IF (NPASS .EQ. 2) GO TO 100
      SYMMAX = SYMIDX - 1
C.... PASS 1 SEQUENTIAL TABLE SEARCH
   10 DO 20 VALUE = 1, SYMMAX, 1
      IF (SYMTBL(1,VALUE) .EQ. SYMTMP(IP) .AND.
     +   SYMTBL(2,VALUE) .EQ. SYMTMP(IP+1)) GO TO 40
   20 CONTINUE
C.... CANNOT FIND SYMBOL IN TABLE
   30 CALL REFSYM(0)
      RETURN
C.... FOUND SYMBOL, RETURN INFO
   40 STATUS = 1
      CALL REFSYM(VALUE)
      RETURN
C.... PASS 2 BINARY TABLE SEARCH
C.... IF LESS THAN 20 SYMBOLS USE SEQUENTIAL SEARCH
  100 IF (SYMMAX .LT. 20) GO TO 10
      LO = SYMLOW
      VALUE = SYMMID
      MX = SYMMAX
      J = IABS(SYMTMP(IP))
      K = IABS(SYMTMP(IP+1))
  120 L = IABS(SYMTBL(1,VALUE))
      IF (J .EQ. L) GO TO 160
      IF (VALUE .LE. LO .OR. VALUE .GE. MX) GO TO 30
      IF (J .GT. L) GO TO 180
C.... SYMBOL IS IN LOWER INTERVAL
  140 MX = VALUE
      I = (VALUE-LO)/2
      IF (I .EQ. 0) I = 1
      VALUE = VALUE - I
      GO TO 120
C.... FIRST 3 CHARS ARE EQUAL
  160 L = IABS(SYMTBL(2,VALUE))
      IF (K .EQ. L) GO TO 40
      IF (K .LT. L) GO TO 140
C.... SYMBOL IS IN HIGHER INTERVAL
  180 LO = VALUE
      I = (MX-VALUE)/2
      IF (I .EQ. 0) I = 1
      VALUE = VALUE + I
      GO TO 120
      END
      SUBROUTINE LSTSYM
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... LIST SYMBOL TABLE
      COMMON /INPUT/ INPUT(60)
      COMMON /CONST/ KB15, ML16B, ML15B
      INTEGER BINFLG, BINTYP
      COMMON /BINFLG/ BINFLG, BINTYP
      INTEGER SYMIDX,SYMLIM,SYMFUL,SYMLOW,SYMMID,SYMMAX,SYMTBL
      COMMON /SYMBOL/ SYMIDX,SYMLIM,SYMFUL,SYMLOW,SYMMID,SYMMAX,
     +                SYMTBL(4,400)
      COMMON /IOUNIT/ KSRC, KOBJ, KEYBD, KDSPLY, KXREF, LIST, LUNIT
      COMMON /PAGCNT/ NUMPAG, NUMLIN, MAXLIN
      INTEGER VALUE, STATUS, NATURE, SCOND, STYPE
      COMMON /ARGS/ VALUE, STATUS, NATURE, SCOND, STYPE
      COMMON /LSTFLG/ LSTOPT, LSTFIL, LSTXPD
      DIMENSION MS1(4), MS2(5), MS3(2), MS4(2), MS5(2), MS6(2)
      DATA MS1/1HU, 1HA, 1HR, 1HX/
      DATA MS2/2H  , 2HEQ, 2HIN, 2HDT, 2HRS/
      DATA MS3/1H , 1HG/
      DATA MS4/1H , 1HE/
      DATA MS5/2HUR, 2H  /
      DATA MS6/2H  , 2HDD/
C.... CHECK FOR NULL SYMBOL TABLE
      J = SYMIDX - 1
      IF (SYMIDX .LE. 1) GO TO 120
C.... CHECK FOR PAGE FULL
      IF (NUMLIN+3 .GE. MAXLIN) GO TO 10
C.... SKIP 3 LINES ON LISTING
      WRITE(LIST,1000)
 1000 FORMAT(//)
      NUMLIN = NUMLIN + 3
      GO TO 15
   10 CALL NXTPAG
C.... LIST SYMBOLS
   15 M  = 0
      DO 100 I = 1, J, 1
C.... CHECK FOR PAGE FULL
      IF (NUMLIN .GE. MAXLIN) CALL NXTPAG
C.... SYMBOL CONDITION
C.... BIT 2'1 - 2'0
C.... 0 = UNDEF
C.... 1 = ABSOLUTE
C.... 2 = RELOCATABLE
C.... 3 = EXTERNAL
      STATUS = SYMTBL(4,I)
      IS1 = IAND(STATUS,3) + 1
C.... FORCE ALL REL TYPES TO ABS ON LISTING
      IF (IS1 .EQ. 3 .AND. BINTYP .EQ. 2) IS1 = 2
C.... CHECK FOR UNREFERENCED SYMBOL
C.... BIT 2'3
C.... 0 = UNREFERENCED
C.... 1 = REFERENCED
      IS5 = IAND(ISL(STATUS,-3),1) + 1
C.... SYMBOL TYPE
C.... BIT 2'6 - 2'4
C.... 0 = UNKNOWN
C.... 1 = EQU
C.... 2 = INSTRUCTION
C.... 3 = DATA
C.... 4 = RES
      IS2 = IAND(ISL(STATUS,-4),7) + 1
C.... SYMBOL NATURE
C.... BIT 2'7
C.... 0 = LOCAL
C.... 1 = GLOBAL
      IS3 = IAND(ISL(STATUS,-7),1) + 1
C.... PROGRAM ENTRY
C....  BIT 2'8
C....  0 = NOT ENTRY
C....  1 = ENTRY
      IS4 = IAND(ISL(STATUS,-8),1) + 1
C.... CHECK FOR MULTIPLE DEFINTION
C.... BIT 2'9
C.... 0 = OK
C.... 1 = MULTIPLE DEFINED
      IS6 = ISL(STATUS,-9) + 1
C.... CONVERT SYMBOL VALUE TO OCTAL
      VALUE = IAND(SYMTBL(3,I),ML16B)
      INPUT(M+7) = 0
      IF (IAND(VALUE,KB15) .NE. 0) INPUT(M+7) = 1
      VALUE = IAND(VALUE,ML15B)
      K = 12
   40 INPUT(M+K) = IAND(VALUE,7)
      VALUE = ISL(VALUE,-3)
      K = K - 1
      IF (K .GT. 7) GO TO 40
C.... UNPACK MODULO 40 SYMBOL
      L = 1
      N = 0
   45 INPUT(M+3+N) = MOD40U(IFIX(AMOD(ABS(FLOAT(SYMTBL(L,I))),40.0)))
      K = IFIX(ABS(FLOAT(SYMTBL(L,I)))/40.0)
      INPUT(M+2+N) = MOD40U(MOD(K,40))
      INPUT(M+1+N) = MOD40U(K/40)
      L = L + 1
      N = 3
      IF (L .EQ. 2) GO TO 45
C.... SYMBOL ATTRIBUTES
      INPUT(M+13)  = MS1(IS1)
      INPUT(M+14)  = MS2(IS2)
      INPUT(M+15)  = MS3(IS3)
      INPUT(M+16)  = MS4(IS4)
      INPUT(M+17)  = MS5(IS5)
      INPUT(M+18) = MS6(IS6)
      IF (M .NE. 0) GO TO 60
      M  = 18
      GO TO 100
   60 WRITE(LIST,1005) (INPUT(L),L = 1, 36, 1)
 1005 FORMAT(1X,6A1,1X,6I1,2X,A1,1X,A2,1X,A1,1X,A1,1X,A2,1X,A2,9X,
     +          6A1,1X,6I1,2X,A1,1X,A2,1X,A1,1X,A1,1X,A2,1X,A2)
      NUMLIN = NUMLIN + 1
      M  = 0
  100 CONTINUE
      IF (M .EQ. 0) GO TO 120
      WRITE(LIST,1010) (INPUT(L), L = 1, 18, 1)
 1010 FORMAT(1X,6A1,1X,6I1,2X,A1,1X,A2,1X,A1,1X,A1,1X,A2,1X,A2)
      NUMLIN = NUMLIN + 1
C.... LIST NUMBER OF SYMBOLS
  120 IF (NUMLIN .GE. MAXLIN-3) CALL NXTPAG
      WRITE(LIST,1015) J
 1015 FORMAT(//,X,I4,' SYMBOLS')
      NUMLIN = NUMLIN + 3
C.... CHECK FOR SYMBOL TABLE OVER FLOW
      IF (SYMFUL .NE. 0) WRITE(LIST,1020) SYMFUL
 1020 FORMAT(/,' ****** SYMBOL TABLE OVER-FLOW LINE',I5)
      RETURN
      END
      SUBROUTINE OPRSYM(KREF)
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... PROCESS GLOB & EXT DECLARATIVE SYMBOLS
      INTEGER SYMIDX,SYMLIM,SYMFUL,SYMLOW,SYMMID,SYMMAX,SYMTBL
      COMMON /SYMBOL/ SYMIDX,SYMLIM,SYMFUL,SYMLOW,SYMMID,SYMMAX,
     +                SYMTBL(4,400)
      INTEGER SYMTMP
      COMMON /SYMTMP/ SYMTMP(4)
      INTEGER VALUE, STATUS, NATURE, SCOND, STYPE
      COMMON /ARGS/ VALUE, STATUS, NATURE, SCOND, STYPE
      COMMON /CODE/ NPASS,LOC,INCODE,INSTR,ISKEL,LNKCOD,LSTCOD
      COMMON /INLINE/LINENO,IPTR,INMAX,ILBL,IOPR,IOPRN,ICOMM,IN(60)
C.... SEARCH TABLE FOR SYMBOL
      CALL FNDSYM(3)
C.... INSERT SYMBOLS ONLY IN PASS 1
      IF (NPASS .EQ. 1) GO TO 15
C.... CHECK FOR SYMBOL FOUND
      IF (STATUS .EQ. 0) GO TO 10
C.... CHECK FOR SYMBOL UNDEFINED
      IF (IAND(SYMTBL(4,VALUE),3) .EQ. 0) GO TO 10
C.... CHECK FOR SYMBOL MULT DEFINED
      IF (IAND(SYMTBL(4,VALUE),512) .NE. 0) CALL ERROR(4)
C.... CHECK FOR SYMBOL EQU TYPE
      IF (IAND(SYMTBL(4,VALUE),112) .EQ. 16) CALL ERROR(19)
      RETURN
C.... SYMBOL IS UNDEFINED
   10 CALL ERROR(3)
      RETURN
C.... PASS 1, CHECK FOR SYMBOL FOUND IN TABLE
   15 IF (STATUS .EQ. 1) GO TO 40
C.... SYMBOL NOT IN TABLE, CHECK FOR SPACE
      IF (SYMIDX .LE. SYMLIM) GO TO 20
C.... NO ROOM, MARK LINE NUMBER OF OVER FLOW
      IF (SYMFUL .EQ. 0) SYMFUL = LINENO
      RETURN
C.... INSERT SYMBOL IN TABLE
   20 SYMTBL(1,SYMIDX) = SYMTMP(3)
      SYMTBL(2,SYMIDX) = SYMTMP(4)
      SYMTBL(3,SYMIDX) = 0
      SYMTBL(4,SYMIDX) = KREF
      VALUE = SYMIDX
      SYMIDX = SYMIDX + 1
C.... CHECK FOR EXT OPERATOR
      IF (INCODE .EQ. -23) STATUS = 3
      GO TO 60
C.... SYMBOL ALREADY IN TABLE, INSERT CODES
C.... CHECK FOR SYMBOL DEFINED
   40 IF (IAND(SYMTBL(4,VALUE),3) .NE. 0) GO TO 50
C.... UNDEFINED, CHECK FOR EXT OPERATOR
      IF (INCODE .NE. -23) GO TO 60
      STATUS = 3
      GO TO 80
C.... IF EXT SET MULT DEFINED (2'9)
   50 IF (INCODE .EQ. -23 .AND. IAND(SYMTBL(4,VALUE),3) .EQ. 3) RETURN
      IF (INCODE .EQ. -23) STATUS = 512
      GO TO 80
C.... CHECK FOR GLOB
   60 IF (INCODE .EQ. -22) STATUS = 128
C.... CHECK FOR EQU
      IF (IAND(SYMTBL(4,VALUE),112) .EQ. 16) RETURN
   80 SYMTBL(4,VALUE) = IOR(SYMTBL(4,VALUE),STATUS)
      RETURN
      END
      SUBROUTINE FINSYM
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... COMPLETE ANY INDIRECT SYMBOL DEFINTIONS
      INTEGER SYMIDX,SYMLIM,SYMFUL,SYMLOW,SYMMID,SYMMAX,SYMTBL
      COMMON /SYMBOL/ SYMIDX,SYMLIM,SYMFUL,SYMLOW,SYMMID,SYMMAX,
     +                SYMTBL(4,400)
C.... CHECK FOR NULL SYMBOL TABLE
      IF (SYMIDX .LE. 2) GO TO 40
      L = SYMIDX - 2
      DO 20 I = 1,L ,1
C.... BIT 2'2 = 1 INDICATES CURRENT SYMBOL IS
C.... DEFINED BY NEXT ENTRY
      IF (IAND(SYMTBL(4,I),4) .EQ. 0) GO TO 20
      SYMTBL(3,I) = SYMTBL(3,I+1)
      SYMTBL(4,I) = SYMTBL(4,I+1)
   20 CONTINUE
   40 RETURN
      END
      SUBROUTINE REFSYM(ISYM)
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... GENERATE SYMBOL REFERENCES FOR CROSS REFERENCE LISTING
      COMMON /INLINE/LINENO,IPTR,INMAX,ILBL,IOPR,IOPRN,ICOMM,IN(60)
      INTEGER XFLG, XLINE, XPTR, XBUF
      COMMON /XREF/ XFLG, NSYM, XLINE, XPTR, XBUF(64)
      COMMON /IOUNIT/ KSRC, KOBJ, KEYBD, KDSPLY, KXREF, LIST, LUNIT
      COMMON /CODE/ NPASS,LOC,INCODE,INSTR,ISKEL,LNKCOD,LSTCOD
      IF (NPASS .EQ. 1 .OR. XFLG .EQ. 0) RETURN
C.... IF SAME OLD LINE, OUTPUT INDEX ONLY
      IF (XLINE .EQ. LINENO+NSYM) GO TO 50
C.... NEW LINE, OUTPUT LINE INDICATOR FIRST
      XLINE = LINENO + NSYM
      XBUF(XPTR) = XLINE
      XPTR = XPTR + 1
C.... CHECK FOR BUFFER FULL
      IF (XPTR .LE. 64) GO TO 50
C.... OUTPUT FULL BUFFER
      WRITE(KXREF) XBUF
      XPTR = 1
C.... PLACE SYMBOL INDEX IN BUFFER
   50 XBUF(XPTR) = ISYM
      XPTR = XPTR + 1
C.... CHECK FOR BUFFER FULL OR END OF ASSEMBLY
      IF (XPTR .LE. 64 .AND. ISYM .NE. -1) GO TO 60
C.... OUTPUT BUFFER
      WRITE(KXREF) XBUF
      XPTR = 1
   60 RETURN
      END
      SUBROUTINE PAKSYM(IOUT)
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... CHECK FOR VALID SYMBOL AND
C.... PACK CURRENT SYMBOL MODULO 40
C.... INTO SYMTMP(IOUT+1) & SYMTMP(IOUT+2)
C.... IOUT = 1 OR 3
C.... IF SYMBOL STARTS WITH INVALID CHARACTER
C.... DIAGNOSTIC IS ISSUED AND NO PACK TAKES PLACE
C.... 6 CHARACTERS OR UNTIL A NON VALID CHARACTER
C.... IS REACHED ARE PACKED
      COMMON /INLINE/LINENO,IPTR,INMAX,ILBL,IOPR,IOPRN,ICOMM,IN(60)
      INTEGER VALUE, STATUS, NATURE, SCOND, STYPE
      COMMON /ARGS/ VALUE, STATUS, NATURE, SCOND, STYPE
      INTEGER SYMTMP
      COMMON /SYMTMP/ SYMTMP(4)
      INTEGER TMP
      COMMON /TMP/ TMP(6)
      INTEGER ACHR
      COMMON /ACHR/ ACHR(64)
      EQUIVALENCE(KDOLLR,ACHR(5))
      EQUIVALENCE(KAMPRS,ACHR(7))
      EQUIVALENCE(KQUEST,ACHR(32))
C.... CLEAR SYMBOL AREAS
      SYMTMP(IOUT) = 0
      SYMTMP(IOUT+1) = 0
      DO 20 I = 1, 6, 1
      TMP(I) = 0
   20 CONTINUE
C.... MOVE 6 CHRS TO TEMP AREA
      DO 100 J = 1, 6, 1
      K = IN(IPTR)
C.... CONVERT CHR TO MODULO 40 CODE
C.... A - Z
      L = 34
      DO 40 I = 1, 26, 1
      IF (K .EQ. ACHR(L)) GO TO 80
      L = L + 1
   40 CONTINUE
C.... $ & ?
      I = 27
      IF (K .EQ. KDOLLR) GO TO 80
      I = 28
      IF (K .EQ. KAMPRS) GO TO 80
      I = 29
      IF (K .EQ. KQUEST) GO TO 80
C.... FIRST SYMBOL CHARACTER MAY BE A-Z $ & ? ONLY
      IF (J .EQ. 1) GO TO 70
C.... 0 - 9
      I = 30
      DO 60 L = 17, 26, 1
      IF (K .EQ. ACHR(L)) GO TO 80
      I = I + 1
   60 CONTINUE
C.... NOT VALID MODULO 40 CHR, CHECK FOR FIRST CHR
      IF (J .NE. 1) GO TO 120
C.... INVALID SYMBOL ISSUE SYNTAX DIAGNOSTIC
   70 CALL ERROR(6)
C.... LOCATE END OF CHAR STRING
      CALL FNDEND
      STATUS = -1
      RETURN
C.... MOVE MODULO 40 CHR TO TEMP
   80 TMP(J) = I
      IPTR = IPTR + 1
      IF (IPTR .GE. INMAX) GO TO 120
  100 CONTINUE
C.... CHECK FOR VALID STRING TERMINATOR
  120 CALL CHKEND
C.... PACK 3 MODULO 40 CHRS PER WORD
      II = INTADD(TMP(1)*40,TMP(2))
      SYMTMP(IOUT) = INTADD(II*40,TMP(3))
      II = INTADD(TMP(4)*40,TMP(5))
      SYMTMP(IOUT+1) = INTADD(II*40,TMP(6))
      STATUS = 1
      RETURN
C!!!! REPLACE THIS FUNCTION WITH ASSEMBLY
C!!!! LANGUAGE FOR 16 BIT INSTALLATIONS
      FUNCTION INTADD(I1,I2)
      INTADD = I1 + I2
      RETURN
      END
      SUBROUTINE SRTSYM
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... SORT SYMBOL TABLE
      INTEGER SYMIDX,SYMLIM,SYMFUL,SYMLOW,SYMMID,SYMMAX,SYMTBL
      COMMON /SYMBOL/ SYMIDX,SYMLIM,SYMFUL,SYMLOW,SYMMID,SYMMAX,
     +                SYMTBL(4,400)
C.... COMPUTE PASS 2 TABLE SEARCH CONTROLS
      SYMMAX = SYMIDX - 1
      SYMLOW = 1
      SYMMID = SYMMAX / 2
      I = 1
    2 IF (SYMMID .LT. I) GO TO 4
      I = I * 2
      GO TO 2
    4 J = I / 2
      IF (I-SYMMID .LT. SYMMID-J) GO TO 6
      SYMMID = J
      GO TO 8
    6 SYMMID = I
C.... CHECK FOR NULL TABLE OR ONLY 1 ITEM IN TABLE
    8 IF (SYMIDX .LE. 2) RETURN
C.... SET PASS LIMIT
      L = SYMIDX - 2
C.... SET INTERCHANGE POINT
   10 J = 1
C.... SORT TABLE INTO ASCENDING ORDER
      DO 100 I = 1, L, 1
      IF ( IABS(SYMTBL(1,I)) - IABS(SYMTBL(1,I+1)) ) 100, 20, 40
   20 IF ( IABS(SYMTBL(2,I)) .LE. IABS(SYMTBL(2,I+1)) ) GO TO 100
C.... INTERCHANGE ITEMS
   40    DO 50 J = 1, 4, 1
         M = SYMTBL(J,I)
         SYMTBL(J,I) = SYMTBL(J,I+1)
         SYMTBL(J,I+1) = M
   50    CONTINUE
C.... MARK POINT OF INTERCHANGE
      J = I
  100 CONTINUE
C.... CHECK FOR SORT DONE
      IF (J .EQ. 1) RETURN
      L = J - 1
      GO TO 10
      END
      SUBROUTINE LBLPRC
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... SYMBOL TABLE PROCESSING
C.... CURRENT SYMBOL IS INSERTED INTO SYMBOL TABLE
C.... SYMBOL TABLE ENTRY FORMAT
C.... WORDS 1 & 2 = MODULO 40 SYMBOL
C.... WORD 3 = VALUE
C.... WORD 4 = ATTRIBUTES
C.... ATTRIBUTES:
C....  BITS 2'1-2'0  SYMBOL CONDITION
C...   0 = UNDEFINED
C....  1 = ABSOLUTE
C....  2 = RELOCATABLE
C....  3 = EXTERNAL
C....  BIT 2'2
C....  0 = DIRECT DEFINTION
C....  1 = INDIRECT DEFINTION TO NEXT SEQUENTIAL SYMBOL
C....  BIT 2'3
C....  0 = UNREFERENCED
C....  1 = REFERENCED
C....  BITS 2'6,2'5,2'4  SYMBOL TYPE
C....  0 = UNKNOWN
C....  1 = EQU
C....  2 = INSTRUCTION
C....  3 = DATA (WORD,BYTE,TEXT)
C....  4 = RES, ZERO
C....  BIT 2'7
C....  0 = LOCAL
C....  1 = GLOBAL
C....  BIT 2'8
C....  0 = NOT ENTRY
C....  1 = ENTRY
C....  BIT 2'9
C....  0 = SINGLE DEFINITION
C....  1 = MULTIPLE DEFINITION
      INTEGER SYMIDX,SYMLIM,SYMFUL,SYMLOW,SYMMID,SYMMAX,SYMTBL
      COMMON /SYMBOL/ SYMIDX,SYMLIM,SYMFUL,SYMLOW,SYMMID,SYMMAX,
     +                SYMTBL(4,400)
      INTEGER SYMTMP
      COMMON /SYMTMP/ SYMTMP(4)
      COMMON /CODE/ NPASS,LOC,INCODE,INSTR,ISKEL,LNKCOD,LSTCOD
      INTEGER VALUE, STATUS, SCOND, STYPE
      COMMON /ARGS/ VALUE, STATUS, NATURE, SCOND, STYPE
      COMMON /INLINE/ LINENO,IPTR,INMAX,ILBL,IOPR,IOPRN,ICOMM,IN(60)
C.... PACK CURRENT LABEL
      IPTR = ILBL
      CALL PAKSYM(1)
C.... CHECK FOR INVALID SYMBOL
      IF(STATUS .LT. 0) RETURN
C.... SEARCH TABLE FOR CURRENT LABEL
      CALL FNDSYM(1)
C.... IF PASS 2, CHECK FOR ERRORS
      IF(NPASS .EQ. 2) GO TO 100
C.... CHECK FOR LABEL LOCATED
      IF(STATUS .EQ. 1) GO TO 60
C.... LABEL NOT IN TABLE, CHECK FOR SPACE
      IF(SYMIDX .LE. SYMLIM) GO TO 20
C.... TABLE FULL, MARK LINE NUMBER OF OVER FLOW
      IF(SYMFUL .EQ. 0) SYMFUL = LINENO
      RETURN
C.... INSERT CURRENT LABEL
   20 SYMTBL(1,SYMIDX) = SYMTMP(1)
      SYMTBL(2,SYMIDX) = SYMTMP(2)
C.... CHECK FOR "EQU" (DIRECT ASSIGNMENT)
      IF(INCODE .EQ. -5)  GO TO 200
C.... UPDATE TABLE POINTER
      VALUE = SYMIDX
      SYMIDX = SYMIDX + 1
C.... DEFAULT RELOCATABLE CONDITION
      SYMTBL(4,VALUE) = 2
C.... SET LABEL VALUE
   40 SYMTBL(3,VALUE) = LOC
C.... DEFAULT INSTRUCTION TYPE
      STATUS = 32
C.... CHECK FOR RES OR ZERO TYPE
      IF(INCODE .EQ. -15 .OR. INCODE .EQ. -16) STATUS = 64
C.... CHECK FOR WORD, BYTE, TEXT TYPE
      IF(INCODE.EQ.-17.OR.INCODE.EQ.-18.OR.INCODE.EQ.-19)STATUS=48
C.... INSERT LABEL ATTRIBUTES
      SYMTBL(4,VALUE) = IOR(SYMTBL(4,VALUE),STATUS)
      RETURN
C.... LABEL ALREADY IN TABLE, CHECK FOR UNDEFINED
   60 IF(IAND(SYMTBL(4,VALUE),3) .EQ. 0) GO TO 80
C.... LABEL IS DEFINED, SET MULTIPLE DEFINTION BIT
      SYMTBL(4,VALUE) = IOR(SYMTBL(4,VALUE),512)
      RETURN
C....CHECK FOR EQU
   80 IF(INCODE .EQ. -5)  GO TO 300
C.... SET RELOCATABLE CONDITION
      SYMTBL(4,VALUE) = IOR(SYMTBL(4,VALUE),2)
      GO TO 40
C.... PASS 2
C.... CHECK FOR DOUBLY DEFINED LABEL
  100 I = SYMTBL(4,VALUE)
      IF(IAND(I,512) .NE. 0) CALL ERROR(2)
C.... CHECK FOR "EQU" OPERATOR
      IF(INCODE .EQ. -5) GO TO 140
C.... CHECK FOR LABEL UNDEFINED
      IF(IAND(I,3) .EQ. 0) RETURN
C.... CHECK FOR CORRECT PASS 2 PHASING ONLY IF
C.... LABEL SINGLY DEFINED AND RELOCATABLE.
      IF(IAND(I,515).EQ.2 .AND. SYMTBL(3,VALUE).NE.LOC) CALL ERROR(10)
C.... CHECK FOR GLOBAL LABEL
      IF(IAND(I,128) .EQ. 0) RETURN
C.... ISSUE GLOBAL LABEL DEFINITION OBJ CODE SEQ
      CALL WRTOBJ(17,SYMTBL(1,VALUE))
      CALL WRTOBJ(-2,SYMTBL(2,VALUE))
      RETURN
C.... PROCESS EQU OPERANDS FOR ERRORS
  140 CALL XTREQU
      RETURN
C.... PROCESS "EQU", DEFAULT LABEL TYPE
  200 SYMTBL(4,SYMIDX) = 16
      SYMTBL(3,SYMIDX) = 0
C.... PROCESS OPERAND
      CALL XTREQU
C.... CHECK FOR FORWARD SYMBOL REFERENCE
      IF(SCOND .EQ. 4) GO TO 230
C.... TRANSFER OPERAND VALUE TO LABEL
      SYMTBL(3,SYMIDX) = VALUE
C.... CHECK FOR UNDEFINED OPERAND
      IF(SCOND .EQ. 0) GO TO 210
C.... CHECK FOR SYMBOL OPERAND
      IF(SCOND .EQ. 3) GO TO 220
C.... SET ABS OR REL SYMBOL TYPE
      SYMTBL(4,SYMIDX) = IOR(SYMTBL(4,SYMIDX),SCOND)
  210 SYMIDX = SYMIDX + 1
      RETURN
C.... TRANSFER OPERAND SYMBOL ATTRIBUTES TO LABEL
  220 SYMTBL(4,SYMIDX) = STYPE
      GO TO 210
C.... FORWARD SYMBOL REFERENCE
C.... INSERT OPERAND SYMBOL WITH LINK
C.... TO LABEL SYMBOL
  230 SYMIDX = SYMIDX + 1
C.... CHECK FOR LABEL EQU ITSELF
      IF(SYMTMP(1) .EQ. SYMTMP(3) .AND.
     +   SYMTMP(2) .EQ. SYMTMP(4)) RETURN
      IF(SYMIDX .LE. SYMLIM) GO TO 240
      IF(SYMFUL .EQ. 0) SYMFUL = LINENO
      RETURN
  240 SYMTBL(4,SYMIDX-1) = IOR(SYMTBL(4,SYMIDX-1),4)
      SYMTBL(1,SYMIDX) = SYMTMP(3)
      SYMTBL(2,SYMIDX) = SYMTMP(4)
      SYMTBL(3,SYMIDX) = 0
      SYMTBL(4,SYMIDX) = 8
      SYMIDX = SYMIDX + 1
      RETURN
C.... EQU OPERATION HAS LABEL ALREADY IN TABLE
  300 I = VALUE
      CALL XTREQU
C.... CHECK FOR UNDEFINED OR FORWARD SYMBOL REFERENCE
      IF(SCOND .EQ. 0 .OR. SCOND .EQ. 4) RETURN
C.... TRANSFER OPERAND VALUE
      SYMTBL(3,I) = VALUE
C.... CHECK FOR SYMBOL OPERAND
      IF(SCOND .EQ. 3) GO TO 320
C.... SET ABS OR REL SYMBOL TYPE
      SYMTBL(4,I) = IOR(SCOND,16)
      RETURN
C.... TRANSFER SYMBOL ATTRIBUTES TO LABEL
  320 SYMTBL(4,I) = STYPE
      RETURN
      END
      SUBROUTINE XTREQU
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... GI CPU 1600 CROSS ASSEMBLER VERSION 1C
C.... EXTRACT OPERAND FOR EQU STATEMENT ONLY
C.... PROCESS OPERAND STRINGS OF FORMS:
C....
C.... LITERAL
C.... LOC SYMBOL (!)
C.... LOC SYMBOL + OR - LITERAL
C.... SYMBOL
C.... EXTRACTED OPERAND VALUE RETURNED IN 'VALUE'
C.... OPERAND TYPE RETURNED IN 'SCOND'
C.... IF OPERAND IS A DEFINED SYMBOL, ATTRIBUTES
C.... RETURNED IN 'STATUS'
C.... SCOND = 0 IF OPERAND IS UNDEFINED
C.... SCOND = 1 IF OPERAND IS ABSOLUTE
C.... SCOND = 2 IF OPERAND IS RELOCATABLE
C.... SCOND = 3 IF OPERAND IS A SYMBOL
C.... SCOND = 4 IF OPERAND IS AN UNDEFINED FORWARD SYMBOL
      INTEGER TMP
      COMMON /TMP/ TMP(6)
      COMMON /INLINE/ LINENO,IPTR,INMAX,ILBL,IOPR,IOPRN,ICOMM,IN(60)
      INTEGER SYMIDX,SYMLIM,SYMFUL,SYMLOW,SYMMID,SYMMAX,SYMTBL
      COMMON /SYMBOL/ SYMIDX,SYMLIM,SYMFUL,SYMLOW,SYMMID,SYMMAX,
     +                SYMTBL(4,400)
      INTEGER VALUE, STATUS, SCOND, STYPE
      COMMON /ARGS/ VALUE, STATUS, NATURE, SCOND, STYPE
      INTEGER SYMTMP
      COMMON /SYMTMP/ SYMTMP(4)
      COMMON /CODE/ NPASS,LOC,INCODE,INSTR,ISKEL,LNKCOD,LSTCOD
      INTEGER ACHR
      COMMON /ACHR/ ACHR(64)
      EQUIVALENCE (LOCSYM,ACHR(2))
      EQUIVALENCE (KPLUS,ACHR(12))
      EQUIVALENCE (KMINUS,ACHR(14))
      COMMON /KTERMS/ KTERMS(7)
C.... SET OPERAND SCAN POINTER
      IPTR = IOPRN
C.... CHECK FOR LOC SYMBOL (!)
      IF(IN(IPTR) .NE. LOCSYM) GO TO 40
      VALUE = 0
      J = LOC
C.... BYPASS !
      IF(IPTR .GE. INMAX) GO TO 20
      IPTR = IPTR + 1
C.... CHECK FOR LITERAL FOLLOWING LOC SYMBOL
      IF(IN(IPTR) .NE. KPLUS .AND. IN(IPTR) .NE. KMINUS) GO TO 20
      CALL XTRLIT
      IF(STATUS .EQ. 0) CALL ERROR(6)
   20 VALUE = J + VALUE
C.... SET RELOCATABLE CODE
      SCOND = 2
C.... SET SYMBOL NATURE
      NATURE = 2
      GO TO 90
C.... CHECK FOR LITERAL
   40 CALL XTRLIT
      IF(STATUS .EQ. 0) GO TO 100
C.... SET ABSOLUTE CODE
      SCOND = 1
C.... SET LITERAL NATURE
      NATURE = 1
C.... CHECK FOR TERMINATORS (SPC , ;)
   70 DO 80 I = 1, 3, 1
      IF(IN(IPTR) .EQ. KTERMS(I)) GO TO 90
   80 CONTINUE
C.... NOT TERMINATOR, ISSUE DIAGNOSTIC
      CALL ERROR(8)
C.... CHECK FOR OPERAND FINISHED
   90 CALL OPRFIN
   95 INSTR = VALUE
      RETURN
C.... LOOKS LIKE SYMBOL, PACK IT
  100 CALL PAKSYM(3)
C.... CHECK FOR VALID SYMBOL
      IF(STATUS .EQ. -1) GO TO 120
C.... LOCATE SYMBOL IN TABLE
  110 CALL FNDSYM(3)
      IF(STATUS .EQ. 1) GO TO 130
      IF(NPASS .EQ. 1) GO TO 150
  115 CALL ERROR(3)
  120 SCOND = 0
      VALUE = 0
      GO TO 70
C.... SYMBOL FOUND, CHECK FOR UNDEFINED CONDITION
  130 IF(IAND(SYMTBL(4,VALUE),3) .EQ. 0) GO TO 115
C.... NOTE SYMBOL REFERENCED
      SYMTBL(4,VALUE) = IOR(SYMTBL(4,VALUE),8)
C.... RETURN ATTRIBUTES
      STYPE = SYMTBL(4,VALUE)
      VALUE = SYMTBL(3,VALUE)
C.... SET OPERAND IS SYMBOL FLAG
      SCOND = 3
C.... SET SYMBOL NATURE
      NATURE = 2
      GO TO 70
C.... INVALID OPERAND, ISSUE DIAGNOSTIC, SET UNDEFINED CODE
  140 CALL ERROR(6)
      SCOND = 0
      VALUE = 0
      GO TO 95
C.... OPERAND IS A FORWARD SYMBOL REFERENCE
  150 SCOND = 4
      GO TO 70
      END
      SUBROUTINE IDENT
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... REQUEST USER IDENTIFICATION OF FILES
      COMMON /FNAMES/ NAMIN(8), NAMBIN(8), NAMXRF(8), NAMLST(8)
      INTEGER ACHR
      COMMON /ACHR/ ACHR(64)
      EQUIVALENCE (KSPC,ACHR(1))
      EQUIVALENCE (KCOMMA,ACHR(13))
      EQUIVALENCE (KF,ACHR(39))
      EQUIVALENCE (KN,ACHR(47))
      EQUIVALENCE (KY,ACHR(58))
      COMMON /IOUNIT/ KSRC, KOBJ, KEYBD, KDSPLY, KXREF, LIST, LUNIT
      COMMON /INPUT/ INPUT(60)
      COMMON /INLINE/LINENO,IPTR,INMAX,ILBL,IOPR,IOPRN,ICOMM,IN(60)
      COMMON /LSTFLG/ LSTOPT, LSTFIL, LSTXPD
      INTEGER XFLG, XLINE, XPTR, XBUF
      COMMON /XREF/ XFLG, NSYM, XLINE, XPTR, XBUF(64)
      INTEGER BINFLG, BINTYP
      COMMON /BINFLG/ BINFLG, BINTYP
      INTEGER ASMFLG
      COMMON /CAFLGS/ LSTFLG, ASMFLG
C.... CLEAR FILE NAME BUFFERS
   10 DO 20 I = 1,8
      NAMIN(I) = KSPC
      NAMBIN(I) = KSPC
   20 CONTINUE
C.... REQUEST SOURCE FILE INFO
      WRITE(KDSPLY,1000)
 1000 FORMAT(' SRC FILE,ACCNT?')
      READ(KEYBD,1010) INPUT
 1010 FORMAT(60A1)
C.... CHECK FOR NO FILE NAME
      IF (INPUT(1) .EQ. KSPC) STOP
C.... SEPARATE FILE NAME AND ACCOUNT STRINGS
      IPTR = 1
      DO 40 I = 1,8
      IF (INPUT(IPTR) .EQ. KSPC) GO TO 100
      IF (INPUT(IPTR) .EQ. KCOMMA) GO TO 60
      NAMIN(I) = INPUT(IPTR)
   40 IPTR = IPTR + 1
C.... EIGHT CHRTR FILE NAME, CHK FOR ACCOUNT NEXT
      IF (INPUT(IPTR) .EQ. KSPC) GO TO 100
      IF (INPUT(IPTR) .NE. KCOMMA) GO TO 10
C.... HAVE ACCOUNT, EXTRACT IT
   60 IF (INPUT(IPTR+1) .EQ. KSPC) GO TO 100
      IPTR = IPTR + 1
      DO 80 I = 1,8
      IF (INPUT(IPTR) .EQ. KSPC) GO TO 100
      NAMBIN(I) = INPUT(IPTR)
   80 IPTR = IPTR + 1
C.... OPEN SOURCE FILE
  100 CALL OPNINP(NAMIN(1),NAMBIN(1),I)
C.... CHECK FOR FILE FOUND
      IF (I .EQ. 0) GO TO 110
      WRITE(KDSPLY,1020)
 1020 FORMAT(' FILE DOES NOT EXIST !')
      GO TO 10
  110 LSTOPT = 0
      LSTFIL = 0
      LIST = KDSPLY
C.... REQUEST LISTING OPTION
      DO 150 I = 1,8
      NAMLST(I) = KSPC
  150 CONTINUE
C.... REQUEST LISTING OPTIONS
      WRITE(KDSPLY,1040)
 1040 FORMAT(' LIST? (Y/N OR F=NAME)')
      READ(KEYBD,1030) I, NAMLST
 1030 FORMAT(A2,8A1)
      IF (I .EQ. KN) GO TO 200
      IF (I .EQ. KY) GO TO 185
      IF (I .NE. 2HF=) GO TO 110
C.... LISTING ON FILE
      LIST = LUNIT
      LSTFIL = 1
      IF (NAMLST(1) .EQ. KSPC) GO TO 110
      DO 180 I = 1,8
      IF (NAMLST(I) .NE. NAMIN(I)) GO TO 190
  180 CONTINUE
C.... USER HAS SPECIFIED THE SAME FILE NAME
C.... FOR MORE THAN ONE FILE, GIVE ERROR
C.... MESSAGE, REQUEST LIST FILE NAME AGAIN
      WRITE(KDSPLY,1070)
 1070 FORMAT(' FILE CONFLICT !')
      GO TO 110
C.... LISTING ON TERMINAL
  185 LIST = KDSPLY
  190 LSTOPT = 1
C.... REQUEST EXPANDED LISTING
      WRITE(KDSPLY,1073)
 1073 FORMAT(' XPND LIST? (Y/N)')
      READ(KEYBD,1076) I
 1076 FORMAT(A1)
      LSTXPD = 0
      IF (I .EQ. KN .OR. I .EQ. KSPC) GO TO 200
      IF (I .NE. KY) GO TO 190
      LSTXPD = 1
C.... REQUEST OBJECT FILE NAME
  200 DO 210 I = 1,8
      NAMBIN(I) = KSPC
  210 CONTINUE
      BINFLG = -1
      WRITE(KDSPLY,1080)
 1080 FORMAT(' OBJ FILE?')
      READ(KEYBD,1060) NAMBIN
 1060 FORMAT(8A1)
C.... NO FILE NAME IMPLIES NO OBJECT GENERATION
      IF (NAMBIN(1) .EQ. KSPC) GO TO 320
      BINFLG = 0
      DO 240 I = 1,8
      IF (NAMBIN(I) .NE. NAMIN(I)) GO TO 280
  240 CONTINUE
C.... FILE NAME CONFLICT
  260 WRITE(KDSPLY,1070)
      GO TO 200
  280 DO 300 I = 1,8
      IF (NAMBIN(I) .NE. NAMLST(I)) GO TO 320
  300 CONTINUE
      GO TO 260
C.... REQUEST CROSS REFERENCE FILE OPTION
  320 WRITE(KDSPLY,1090)
 1090 FORMAT(' XREF FILE?')
      XFLG = 0
      DO 330 I = 1,8
      NAMXRF(I) = KSPC
  330 CONTINUE
      READ(KEYBD,1060) NAMXRF
C.... NO FILE NAME IMPLIES NO CROSS REF GENERATION
      IF (NAMXRF(1) .EQ. KSPC) GO TO 400
      DO 340 I = 1,8
      IF (NAMXRF(I) .NE. NAMIN(I)) GO TO 355
  340 CONTINUE
  350 WRITE(KDSPLY,1070)
      GO TO 320
  355 DO 360 I = 1,8
      IF ( NAMXRF(I) .NE. NAMBIN(I)) GO TO 370
  360 CONTINUE
      GO TO 350
  370 DO 380 I = 1,8
      IF (NAMXRF(I) .NE. NAMLST(I)) GO TO 390
  380 CONTINUE
      GO TO 350
  390 XFLG = 1
  400 RETURN
      END
      SUBROUTINE INSRC
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... INPUT AND TABULATE A SOURCE STATEMENT
      COMMON /CODE/ NPASS,LOC,INCODE,INSTR,ISKEL,LNKCOD,LSTCOD
      INTEGER ACHR
      COMMON /ACHR/ ACHR(64)
      EQUIVALENCE (KSPC,ACHR(1))
      EQUIVALENCE (KXCLM,ACHR(2))
      EQUIVALENCE (KQUOT,ACHR(3))
      EQUIVALENCE (KAPOS,ACHR(8))
      EQUIVALENCE (KSCOLN,ACHR(28))
      EQUIVALENCE (KD,ACHR(37))
      EQUIVALENCE (KE,ACHR(38))
      EQUIVALENCE (KN,ACHR(47))
      EQUIVALENCE (KY,ACHR(58))
      INTEGER ERRPTR
      COMMON /ERRPTR/ ERRPTR
      COMMON /INPUT/ INPUT(60)
      COMMON /IOUNIT/ KSRC, KOBJ, KEYBD, KDSPLY, KXREF, LIST, LUNIT
      COMMON /INLINE/LINENO,IPTR,INMAX,ILBL,IOPR,IOPRN,ICOMM,IN(60)
C.... CLEAR INTERNAL SOURCE BUFFER
    5 DO 10 I = 1,INMAX,1
   10 IN(I) = KSPC
C.... INCREMENT STATEMENT COUNT
      LINENO = LINENO + 1
C.... READ A SOURCE RECORD
      READ(KSRC,1000, END=20) INPUT
 1000 FORMAT(60A1)
      GO TO 40
C.... READ END FILE ON INPUT, ISSUE DIAGNOSTIC
C.... SUPPLY "END" STATEMENT
   20 IPTR = IOPR
      ERRPTR = KXCLM
      CALL ERROR(18)
      IN(IOPR) = KE
      IN(IOPR+1) = KN
      IN(IOPR+2) = KD
      BACK SPACE KSRC
      GO TO 600
C.... TAB INPUT FOR ASSEMBLY
   40 N = 0
      M = 0
      I = 1
C.... SET LABEL CONTROLS
      IPTR = ILBL
      L = ILBL + 7
C.... CHECK FOR ENTIRE LINE OF COMMENTS
      IF (INPUT(1) .EQ. KSCOLN) GO TO 510
C.... TABULATE LABEL, OPERATOR, OPERAND, COMMENTS
  200 N = N + 1
  210 GO TO (245, 230, 240, 500), N
C.... SET OPERATOR CONTROLS
  230 IPTR = IOPR
      L = IOPR + 5
      GO TO 245
C.... SET OPERAND CONTROLS
  240 IPTR = IOPRN
      L = INMAX
C.... TABULATE FIELDS
  245 DO 270 IPTR = IPTR, L, 1
      K = INPUT(I)
C.... CHECK FOR LABEL OR OPERATOR FIELDS
      IF (N .LE. 2) GO TO 255
C.... CHECK FOR CHARACTER STRING OPEN
      IF (M .NE. 0) GO TO 250
C.... CHECK FOR START OF CHARACTER STRING
      IF (K .NE. KAPOS .AND. K .NE. KQUOT) GO TO 255
C.... SET STRING OPEN FLAG, SAVE DELIMITER
      M = K
      GO TO 260
C.... CHARACTER STRING OPEN, CHECK FOR DELIMITER
  250 IF (K .NE. M) GO TO 265
C.... STRING CLOSED, CLEAR FLAG
      M = 0
C.... SEMICOLON STARTS COMMENTS
  255 IF (K .EQ. KSCOLN) GO TO 500
C.... SPACE TERMINATES LABEL AND OPERATOR FIELDS
  260 IF (N .LE. 2 .AND. K .EQ. KSPC) GO TO 300
C.... MOVE CHARACTER TO INTERNAL BUFFER
  265 IN(IPTR) = K
C.... CHECK FOR BUFFER FULL
      I = I + 1
      IF (I .GT. 60) GO TO 600
  270 CONTINUE
      J = 0
C.... MAXIMUM FIELD CHARACTERS MOVED, CHECK FOR SPACE NEXT
  280 IF (INPUT(I) .EQ. KSPC) GO TO 300
C.... BYPASS CHARACTERS UNTIL SPACE
C.... GIVE TRUNCATION DIAGNOSTIC
      IF (J .EQ. 1) GO TO 290
      J = 1
      CALL ERROR(17)
  290 I = I + 1
      IF (I .LT. 60) GO TO 280
      GO TO 600
C.... BYPASS INTER FIELD SPACES
  300 IF (INPUT(I) .NE. KSPC) GO TO 200
      I = I + 1
      IF (I .GT. 60) GO TO 600
      GO TO 300
C.... COMMENTS REACHED, TAB TO COMMENT AREA IF NOT THERE YET
  500 IF (IPTR .LT. ICOMM) IPTR = ICOMM
  510 DO 520 IPTR = IPTR, INMAX, 1
      IN(IPTR) = INPUT(I)
      I = I + 1
      IF (I .GT. 60) GO TO 600
  520 CONTINUE
C.... CHECK FOR POSSIBLE STATEMENT TRUCATION
      IF (INPUT(I) .NE. KSPC) CALL ERROR(17)
C.... MARK END OF STATEMENT
  600 IN(INMAX+1) = KSCOLN
      RETURN
      END
      SUBROUTINE PRINT(IFORM)
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... GENERATE PROGRAM LISTING
C.... ARGUMENT IS SET TO LISTING FORM (1-5)
C....  1 - LINE #, STATEMENT
C....  2 - LINE #,ADDR,CONTS,STATEMENT
C....  3 - ADDR,CONTS
C....  4 - LINE #,ADDR,STATEMENT
C....  5 - LINE #,CONTS,STATEMENT
      INTEGER BINFLG, BINTYP
      COMMON /BINFLG/ BINFLG, BINTYP
      COMMON /CODE/ NPASS,LOC,INCODE,INSTR,ISKEL,LNKCOD,LSTCOD
      COMMON /LSTFLG/ LSTOPT, LSTFIL, LSTXPD
      INTEGER ASMFLG
      COMMON /CAFLGS/ LSTFLG, ASMFLG
      COMMON /IOUNIT/ KSRC, KOBJ, KEYBD, KDSPLY, KXREF, LIST, LUNIT
      COMMON /INLINE/LINENO,IPTR,INMAX,ILBL,IOPR,IOPRN,ICOMM,IN(60)
      COMMON /INPUT/ INPUT(60)
      COMMON /PAGCNT/ NUMPAG, NUMLIN, MAXLIN
      INTEGER ACHR
      COMMON /ACHR/ ACHR(64)
      EQUIVALENCE (KSPC,ACHR(1))
      EQUIVALENCE (KR,ACHR(51))
      COMMON /CONST/ KB15, ML16B, ML15B
C.... NO LISTING ON PASS 1
      IF (NPASS .EQ. 1) RETURN
C.... IF ABS ASSEMBLY CLEAR RELOCATBLE INDICATOR
      IF (BINTYP .EQ. 2 .AND. LSTCOD .EQ. KR) LSTCOD = KSPC
C.... CHECK FOR NO LISTING OR LISTING SURPRESSED BY ASSEMBLY DIRECTIVE
      IF (LSTOPT .EQ. 0 .OR. LSTFLG .EQ. 0) RETURN
C.... HOME PAGE IF FULL
      IF (NUMLIN .GE. MAXLIN) CALL NXTPAG
C.... NO SOURCE FOR FORMAT 3
      IF (IFORM .EQ. 3) GO TO 30
C.... DELETE TRAILING BLANKS
      K = INMAX
   20 IF (IN(K) .NE. KSPC) GO TO 30
      K = K - 1
      IF (K .GT. 1) GO TO 20
C.... CONVERT CURRENT ASSEMBLY LOCATION TO OCTAL
   30 L = 6
      N = LOC
      I = 1
      J = 0
      GO TO 50
C.... CONVERT CURRENT INSTRUCTION TO OCTAL
   40 L = 12
      N = INSTR
      I = 7
      J = 1
C.... MASK OUT LOWER 16 BITS
   50 N = IAND(N,ML16B)
C.... CHECK FOR MS BIT = 1 (2'15)
      INPUT(I) = 0
      IF (IAND(N,KB15) .NE. 0) INPUT(I) = 1
C.... MASK OUT LOWER 15 BITS
      N = IAND(N,ML15B)
C.... CONVERT LOWER 15 BITS TO OCTAL
   60 INPUT(L) = IAND(N,7)
      N = ISL(N,-3)
      L = L - 1
      IF (L .GT. I) GO TO 60
C.... CHECK FOR INSTR FIELD CONVERTED
      IF (J .EQ. 0) GO TO 40
C.... BOTH FIELDS CONVERTED, PRINT LISTING LINE
      GO TO (100, 200, 300, 400, 500), IFORM
C.... LINE #, STATEMENT
  100 WRITE(LIST,1000) LINENO, (IN(I), I = 1,K)
 1000 FORMAT(1X,I4,'.',17X,60A1)
      GO TO 600
C.... LINE #,ADDR, CONTS, STATEMENT
  200 WRITE(LIST,2000) LINENO, (INPUT(I), I = 1,12), LSTCOD,
     1                (IN(I), I = 1,K)
 2000 FORMAT(1X,I4,'. ',6I1,X,6I1,A1,2X,60A1)
      GO TO 600
C.... ADDR, CONTS
  300 WRITE(LIST,3000) (INPUT(I), I = 1,12), LSTCOD
 3000 FORMAT(7X,6I1,X,6I1,A1)
      GO TO 600
C.... LINE #, ADDR, STATEMENT
  400 WRITE(LIST,4000) LINENO, (INPUT(I),I = 1,6),
     1                (IN(I), I = 1,K)
 4000 FORMAT(1X,I4,'. ',6I1,10X,60A1)
      GO TO 600
C.... LINE #,CONTENTS,STATEMENT
  500 WRITE(LIST,5000) LINENO,(INPUT(I),I=7,12),(IN(I),I=1,K)
 5000 FORMAT(1X,I4,'.',8X,6I1,3X,60A1)
C.... INCREMENT LINES PER PAGE COUNT
  600 NUMLIN = NUMLIN + 1
      RETURN
      END
      SUBROUTINE NXTPAG
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... ADVANCE PROGRAM LISTING TO NEXT PAGE
      COMMON /CODE/ NPASS,LOC,INCODE,INSTR,ISKEL,LNKCOD,LSTCOD
      INTEGER HEAD, HEADMX, HEADFL
      COMMON/HEADNG/ HEAD(58), HEADMX, HEADFL
      INTEGER TITLE
      COMMON /TITLE/ TITLE(6)
      COMMON /IOUNIT/ KSRC, KOBJ, KEYBD, KDSPLY, KXREF, LIST, LUNIT
      COMMON /PAGCNT/ NUMPAG, NUMLIN, MAXLIN
      COMMON /DATE/ KTD(8)
      INTEGER VERNO
      COMMON /VERNO/ VERNO(6)
      COMMON /LSTFLG/ LSTOPT, LSTFIL, LSTXPD
C.... CHECK FOR PASS 1
      IF (NPASS .EQ. 1) RETURN
C.... CHECK FOR TERMINAL LISTING
      IF (LSTFIL .EQ. 0) GO TO 10
C.... FILE LISTING, HOME PAGE
      WRITE(LIST,1020)
 1020 FORMAT(1H1)
      GO TO 40
C.... CHECK FOR PAGE FULL
   10 IF (NUMLIN .GE. MAXLIN) GO TO 30
C.... SPACE TO BOTTOM OF PAGE
   20 WRITE(LIST,1000)
 1000 FORMAT(1H )
      NUMLIN = NUMLIN + 1
      IF (NUMLIN .LT. MAXLIN) GO TO 20
C.... ADVANCE TO TOP OF NEXT PAGE
   30 WRITE(LIST,1005)
 1005 FORMAT(/////)
C.... INCR PAGE COUNT
   40 NUMPAG = NUMPAG + 1
      WRITE(LIST,1010) TITLE, VERNO, KTD, NUMPAG
1010  FORMAT(1X,6A1,4X,6A2,12X,8A2,12X,'PAGE',I4)
      NUMLIN = 1
C.... CHECK FOR HEADING
      IF (HEADFL .EQ. 0) GO TO 50
      WRITE(LIST,1015) HEAD
 1015 FORMAT(X,58A1)
      NUMLIN = 2
   50 WRITE(LIST,1017)
 1017 FORMAT(1H )
      NUMLIN = NUMLIN + 1
      RETURN
      END
      SUBROUTINE ERROR(ICODE)
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... LIST PROGRAM ERRORS
      COMMON /KTERMS/ KTERMS(7)
      COMMON /CODE/ NPASS,LOC,INCODE,INSTR,ISKEL,LNKCOD,LSTCOD
      COMMON /IOUNIT/ KSRC, KOBJ, KEYBD, KDSPLY, KXREF, LIST, LUNIT
      COMMON /ERRCNT/ NERR, NINFO
      COMMON /INPUT/ INPUT(60)
      COMMON /INLINE/LINENO,IPTR,INMAX,ILBL,IOPR,IOPRN,ICOMM,IN(60)
      INTEGER ACHR
      COMMON /ACHR/ ACHR(64)
      EQUIVALENCE (KSPC,ACHR(1))
      EQUIVALENCE (KE,ACHR(38))
      EQUIVALENCE (KI,ACHR(42))
      EQUIVALENCE (KUPARW,ACHR(63))
      INTEGER ERRPTR
      COMMON /ERRPTR/ ERRPTR
      COMMON /PAGCNT/ NUMPAG, NUMLIN, MAXLIN
      COMMON /LSTFLG/ LSTOPT, LSTFIL, LSTXPD
      INTEGER ERR
      DIMENSION ERR(20)
      DOUBLE PRECISION MES
      DIMENSION MES(20)
C.... DIAGNOSTIC CODES
C.... ERRORS
      DATA ERR(1)/1HL/
      DATA ERR(2)/1HD/
      DATA ERR(3)/1HU/
      DATA ERR(4)/1HM/
      DATA ERR(5)/1HO/
      DATA ERR(6)/1HS/
      DATA ERR(7)/1HR/
      DATA ERR(8)/1HC/
      DATA ERR(9)/1HB/
      DATA ERR(10)/1HP/
      DATA ERR(11)/1HX/
      DATA ERR(12)/1HV/
      DATA ERR(13)/1HN/
C.... INFORMATIVES
      DATA ERR(14)/1HQ/
      DATA ERR(15)/1HW/
      DATA ERR(16)/1HA/
      DATA ERR(17)/1HT/
      DATA ERR(18)/1HE/
      DATA ERR(19)/1H?/
      DATA ERR(20)/1HL/
C.... DIAGNOSTIC MESSAGES
C.... ERRORS
      DATA MES(1)/8HLABEL   /
      DATA MES(2)/8HDBL DEF /
      DATA MES(3)/8HUNDF SYM/
      DATA MES(4)/8HMDEF SYM/
      DATA MES(5)/8HOP UNREC/
      DATA MES(6)/8HSYNTAX  /
      DATA MES(7)/8HREG ILL /
      DATA MES(8)/8HCHR ILL /
      DATA MES(9)/8HDBL BYTE/
      DATA MES(10)/8HPHASE   /
      DATA MES(11)/8HEXT NUM /
      DATA MES(12)/8HVAL OPRN/
      DATA MES(13)/8HNUMBER   /
C.... INFORMATIVES
      DATA MES(14)/8H? SYNTAX/
      DATA MES(15)/8HWRD SIZE/
      DATA MES(16)/'ADR/DEST'/
      DATA MES(17)/8HTRUNCATN/
      DATA MES(18)/8H? NO END/
      DATA MES(19)/8H? USE   /
      DATA MES(20)/8HMEM LIM /
C.... NO LISTING ON PASS 1
      IF (NPASS .EQ. 1) RETURN
C.... CHECK FOR FULL PAGE
      IF (NUMLIN .GE. MAXLIN-2) CALL NXTPAG
C.... DETERMINE DIAGNOSTIC SEVERITY
      IF (ICODE.GT.13 .AND. ICODE.LT.21 .OR. ICODE.EQ.26) GO TO 30
C.... COUNT ERROR DIAGNOSTICS
      NERR = NERR + 1
      N = KE
      GO TO 40
C.... COUNT INFORMATIVE DIAGNOSTICS
   30 NINFO = NINFO + 1
      N = KI
C.... CLEAR ERROR POINTER BUFFER
   40 DO 45 I = 1, INMAX, 1
      INPUT(I) = KSPC
   45 CONTINUE
C.... IF ERROR POINTER AT END OF STMNT, BACK IT
      I = IPTR
      IF (I .LT. INMAX) GO TO 50
   47 I = I - 1
      IF (IN(I) .NE. KSPC) GO TO 50
      IF (I .GT. 1) GO TO 47
C.... BACK ERROR POINTER FROM STRING TERMINATOR
   50 I = I - 1
      DO 53 J = 1, 7, 1
      IF (IN(IPTR) .EQ. KTERMS(J)) GO TO 55
   53 CONTINUE
      I = I + 1
   55 J = IPTR
C.... SET ERROR POINTER
      INPUT(I) = ERRPTR
C.... LIST ERROR DIAGNOSTIC
      I = ICODE - 20
      IF (I .LT. 1) GO TO 70
      GO TO (80, 90, 100, 110, 120, 130, 140), I
   70 IF (ERRPTR .EQ. KUPARW) WRITE(LIST,1010) (INPUT(I),I=1,J)
      WRITE(LIST,1000) ERR(ICODE),N,MES(ICODE),LINENO
 1000 FORMAT(' ****** ',A1,2X,'(',A1,')',2X,A8,' LINE',I5)
      IF (LSTFIL .EQ. 1)
     + WRITE(KDSPLY,1000) ERR(ICODE),N,MES(ICODE),LINENO
   75 IF (ERRPTR .NE. KUPARW) WRITE(LIST,1010) (INPUT(I),I=1,J)
 1010 FORMAT(23X,60A1)
      GO TO 200
C.... ERROR 21
   80 WRITE(LIST,1020)
 1020 FORMAT(' ******    (E)  OPEN IF-THEN',/)
      IF (LSTFIL .EQ. 1) WRITE(KDSPLY,1020)
      GO TO 200
C.... ERROR 22
   90 WRITE(LIST,1030)
 1030 FORMAT(' ******    (E)  OPEN DO LOOP(S)',/)
      IF (LSTFIL .EQ. 1) WRITE(KDSPLY,1030)
      GO TO 200
C.... ERROR 23
  100 WRITE(LIST,1040)
 1040 FORMAT(' ******    (E)  TOO MANY DO NESTS',/)
      IF (LSTFIL .EQ. 1) WRITE(KDSPLY,1040)
      GO TO 200
C.... ERROR 24
  110 WRITE(LIST,1050)
 1050 FORMAT(' ******    (E)  TOO MANY IF-THENS',/)
      IF (LSTFIL .EQ. 1) WRITE(KDSPLY,1050)
      GO TO 200
C.... ERROR 25
  120 WRITE(LIST,1060) LINENO
 1060 FORMAT(' ******    (E) EXT DO LOOP ON LINE #',I5)
      IF (LSTFIL .EQ. 1) WRITE(KDSPLY,1060) LINENO
      GO TO 75
C.... ERROR 26
  130 WRITE(LIST,1080)
 1080 FORMAT(' ******    (I)  END NOT EOF',/)
      IF (LSTFIL .EQ. 1) WRITE(KDSPLY,1080)
      GO TO 200
C.... ERROR 27
  140 WRITE(LIST,1090)
 1090 FORMAT(' ******    (E)  NO OPEN IF-THEN',/)
      IF (LSTFIL .EQ. 1) WRITE(KDSPLY,1090)
C.... UPDATE LINES/PAGE COUNT
  200 NUMLIN = NUMLIN + 2
      RETURN
      END
      SUBROUTINE GENCOD(K)
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... GENERATE LISTING AND OBJECT CODE FOR
C.... ONE INSTRUCTION ASSEMBLY
      COMMON /CONST/ KB15, ML16B, ML15B
      COMMON /LSTFLG/ LSTOPT, LSTFIL, LSTXPD
      COMMON /CODE/ NPASS,LOC,INCODE,INSTR,ISKEL,LNKCOD,LSTCOD
      COMMON /MEMLIM/ MEMLO, MEMHI
      INTEGER ORGFLG
      COMMON /ORGFLG/ ORGFLG
C.... CHECK FOR MEMORY LIMITS EXCEEDED
      GO TO (10,20,30), K
   10 IF (LOC .LT. MEMLO .OR. LOC .GT. MEMHI) CALL ERROR(20)
      CALL PRINT(2)
      GO TO 40
   20 CALL PRINT(3)
      GO TO 40
   30 IF (LSTXPD .EQ. 1) CALL PRINT(3)
   40 CALL WRTOBJ(LNKCOD,INSTR)
      ORGFLG = 1
C!!!! WATCH OUT FOR 16 BIT INSTALLATIONS
      LOC = LOC + 1
      RETURN
      END
      SUBROUTINE WRTOBJ(KODE,INFO)
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... GENERATE OBJECT OBJECT RECORDS
      COMMON /IOUNIT/ KSRC, KOBJ, KEYBD, KDSPLY, KXREF, LIST, LUNIT
      COMMON /CODE/ NPASS,LOC,INCODE,INSTR,ISKEL,LNKCOD,LSTCOD
      INTEGER BINFLG, BINTYP
      COMMON /BINFLG/ BINFLG,BINTYP
      INTEGER OBJBFR
      COMMON /OBJBFR/ OBJBFR(64)
      EQUIVALENCE (IOBJ,OBJBFR(3))
C.... OBJECT ON PASS 2 IF REQUIRED
      IF (NPASS .EQ. 1 .OR. BINFLG .EQ. -1) RETURN
C.... CHECK FOR END OF ASSEMBLY
      IF (KODE .NE. -3) GO TO 20
C.... SET RECORD DATA WORD COUNT
      IOBJ = IOBJ - 4
C.... SET LAST RECORD INDICATOR
      OBJBFR(1) = -OBJBFR(1)
C.... WRITE LAST RECORD
      WRITE(KOBJ) OBJBFR
      RETURN
C.... CHECK FOR FIRST OBJECT SEQUENCE
   20 IF (IOBJ .NE. 0) GO TO 40
C.... FIRST OBJECT SEQUENCE, SET RECORD HEADER
      OBJBFR(1) = BINTYP
C.... SET ASSEMBLY BASE ADDRESS
      OBJBFR(2) = LOC
C.... INITIALIZE OBJECT BUFFER POINTER
      IOBJ = 4
C.... CHECK FOR TITLE CODE
      IF (KODE .EQ. 16) GO TO 30
C.... FIRST CODE NOT TITLE, FORCE BLANK TITLE
      OBJBFR(4) = 16
      OBJBFR(5) = 0
      OBJBFR(6) = 0
      IOBJ = 7
C.... SET CODE GENERATED FLAG
   30 BINFLG = 1
C.... CHECK FOR OBJ SEQ CONTINUATION, ADDRESS ADJUSTMENT
   40 IF (KODE) 200,140,60
C.... DETERMINE NUMBER WORDS IN OBJ SEQ
   60 GO TO (140,120,100,140,120,100,120,100,140,
     +       120,120,100,120,100,140,120,120,120), KODE
C.... 4 WORD OBJ SEQ
  100 MOBJ = 61
      GO TO 160
C.... 3 WORD OBJ SEQ
  120 MOBJ = 62
      GO TO 160
C.... 2 WORD OBJ SEQ
  140 MOBJ = 63
C.... CHECK FOR BUFFER SPACE
  160 IF (IOBJ .LE. MOBJ) GO TO 180
C.... BUFFER FULL, WRITE OBJ RECORD
      IOBJ = IOBJ - 4
      WRITE(KOBJ) OBJBFR
      IOBJ = 4
C.... INSERT OBJ SEQ CODE
  180 OBJBFR(IOBJ) = KODE
      IOBJ = IOBJ + 1
  200 OBJBFR(IOBJ) = INFO
      IOBJ = IOBJ + 1
      RETURN
      END
      SUBROUTINE WRTEXT(I,J)
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... CP1600 MICROPROCESSOR CROSS ASSEMBLER
C....
C.... GENERATE EXTERNAL SYMBOL REFERENCE OBJECT CODE
      CALL WRTOBJ(18,I)
      CALL WRTOBJ(-1,J)
      RETURN
      END
 