;********************************************************
;*							*
;*	COLD START INITIALIZATION ROUTINE FOR		*
;*	CONFIGURING THE SYSTEM AFTER A POWER-ON		*
;*	OR PUSHBUTTON RESET.				*
;*				   18-Oct-80		*
;*							*
;********************************************************
;
;
;	-- MONITOR ENTRY POINT TABLE --
;
COLD:	JP	INIT		;MONITOR COLD ENTRY POINT
WARM:	JP	PROMPT		;MONITOR WARM ENTRY POINT
CONST:	JP	KBDST		;CONSOLE STATUS VECTOR
CONIN:	JP	KBDIN		;CONSOLE INPUT VECTOR
CONOUT:	JP	CRTOUT		;CONSOLE OUTPUT VECTOR
	JP	CRTOUT		;CRT OUTPUT VECTOR
	JP	SIOST		;SIO CHANEL B STATUS VECTOR
	JP	SIOIN		;SIO CHANEL B INPUT VECTOR
	JP	SIOOUT		;SIO CHANEL B OUTPUT VECTOR
	JP	SELECT		;DISK DRIVE SELECT
	JP	HOME		;HOME R/W HEAD
	JP	SEEK		;SEEK TO TRACK
	JP	READ		;READ SECTOR
	JP	WRITE		;WRITE SECTOR
;
;
;
;	DO A SHORT POST-RESET TIME DELAY. ALSO INITIALIZES THE
;	STACK POINTER AND FILLS THE MONITOR SCRATCH RAM WITH ZEROS.
;
INIT:	DI
	LD	HL,RAM		;POINT TO START OF MONITOR RAM
INIT1:	LD	(HL),0		;FILL 256 BYTE SPACE WITH ZEROS
	LD	SP,HL		;DO SOMETHING USEFUL TO ADD DELAY
	INC	L
	JR	NZ,INIT1-$	;LOOP TAKES ABOUT 4 MILLISECONDS
;
;	INITIALIZE THE Z-80 FOR INTERRUPT MODE #2

	LD	A,H
	LD	I,A		;LOAD I REG WITH MSB OF VECTOR TABLE
	IM	2		; AND SELECT INTERRUPT MODE 2
;
	CALL	CLRSCN		;FILL THE CRT MEMORY WITH BLANKS
;
;	STORE ANY NON-ZERO VALUES FOR VARIABLES IN MEMORY
;
	LD	HL,INTAB	;POINT TO DEFAULT VARIABLE TABLE
INIT2:	LD	B,0
	LD	C,(HL)		;BC=DATA BLOCK BYTECOUNT
	INC	HL
	LD	E,(HL)		;DE=DESTINATION FOR DATA
	INC	HL
	LD	D,(HL)
	INC	HL
	LDIR			;COPY DATA @ HL TO VARIABLES @ DE
	BIT	7,(HL)
	JR	Z,INIT2-$	;LOOP AGAIN IF NOT AT END OF TABLE
;
;	INITIALIZE THE PROGRAMMABLE I/O DEVICES
;
	INC	HL		;POINT TO I/O INIT DATA TABLE
INIT3:	LD	B,(HL)		;B=INIT LOOP BYTECOUNT
	INC	HL
	LD	C,(HL)		;C=DEVICE CONTROL PORT#
	INC	HL
	OTIR			;SEND DATA @ HL TO PORT @ C
	BIT	7,(HL)		;TEST FOR TABLE END MARKER
	JR	Z,INIT3-$	;LOOP AGAIN IF NOT AT END
;
;	DETERMINE IF CONSOLE I/O CONFIGURATION WILL BE FOR THE
;	ON-BOARD CRT AND KEYBOARD OR AN EXTERNAL SERIAL TERMINAL.
;
	IN	A,(C)		;TEST SIO READ REGISTER 2 TO DETERMINE
	CP	00000110B	; IF THE SIO IS INSTALLED IN THE BOARD
	JR	NZ,PARALL-$	;SKIP CONFIGURATION TEST IF NO SIO
	IN	A,(KBDDAT)	;MAKE SURE KBD PIO 'READY' IS RESET
	LD	B,00010000B	;B=RESET SIO EXTERNAL STATUS COMMAND  
DECIDE:	OUT	(C),B		;TEST FOR ARRIVAL OF A SERIAL
	IN	A,(C)		; INPUT CHARACTER START BIT
	BIT	4,A
	JR	NZ,BAUD-$	;EXIT LOOP IF START BIT DETECTED
	IN	A,(BITDAT)
	BIT	3,A		;TEST FOR DATA READY STROBE FROM
	JR	NZ,DECIDE-$	; PARALLEL KBD AND LOOP IF INACTIVE
PARALL:	IN	A,(KBDDAT)	;DISCARD FIRST KEYBOARD CHARACTER
	LD	A,10000011B
	OUT	(KBDCTL),A	;ENABLE INTERRUPTS FROM KBD PIO
	JR	SIGNON-$	;GO SIGNON WITH BULIT-IN CONSOLE I/O
;
;
;	AUTOMATIC BAUD RATE SETTING ROUTINE FOR SIO
;
BAUD:	XOR	A
BAUD1:	OUT	(C),B
	IN	D,(C)		;READ SIO STATUS REGISTER
	BIT	4,D		;TEST THE SYNC/HUNT BIT
	JR	Z,BAUD1-$	;LOOP UNTIL IT CHANGES STATE
BAUD2:	INC	A
	OUT	(C),B		;RESET REGISTER #0 FLAGS AGAIN
	IN	D,(C)		; AND LOOP TIMING THE SYNC/HUNT BIT
	BIT	4,D
	JR	NZ,BAUD2-$	;REPEAT UNTIL BIT CHANGES AGAIN
	LD	HL,RATES-1
BAUD3:	INC	HL		;INDEX INTO BAUD RATE TABLE
	RLA			; USING COUNT DERRIVED IN A
	JR	NC,BAUD3-$
	LD	A,(HL)		;GET BAUD RATE CONTROL BYTE FROM
	OUT	(BAUDB),A	; TABLE AND OUTPUT TO COM-8116 TIMER
	CALL	SIOIN		;DISARD FIRST SERIAL INPUT CHARACTER
	LD	A,1
	OUT	(SIOCPB),A	;RE-PROGRAM SIO B TO GENERATE
	LD	A,00011100B	; INTERRUPTS ON RECIEVED DATA,
	OUT	(SIOCPB),A	; PARITY DOES NOT AFFECT VECTOR
	LD	HL,SIOOUT
	LD	(CONOUT+1),HL	;RE-DIRECT CONSOLE OUTPUT TO SIO
;
;	PRINT SIGNON MESSAGE
;
SIGNON:	EI
	CALL	PNEXT
	DEFB	CR,LF
	DEFM	'... system monitor 3.3 ...'
	DEFB	CR,LF
	DEFB	EOT
	JP	WARM		;GO ENTER MONITOR
;
;
;
;	BAUD RATE CONSTANTS FOR COM 8116 BAUD RATE GENERATOR
;
RATES:	DEFB	0101B		;   300 BAUD
	DEFB	0110B		;   600 BAUD
	DEFB	0111B		;  1200 BAUD
	DEFB	1010B		;  2400 BAUD
	DEFB	1100B		;  4800 BAUD
	DEFB	1110B		;  9600 BAUD
	DEFB	1111B		; 19200 BAUD
	DEFB	1111B		; 19200 BAUD
;
;
INTAB	EQU	$		;INITIALIZATION DATA TABLES
;
;
;	INITIALIZE THE Z-80 'I' REGISTER INTERRUPT VECTOR TABLE
;
	DEFB	2
	DEFW	SYSVEC+2
	DEFW	KEYSRV		;PARALLEL KEYBOARD INTERRUPT VECTOR

	DEFB	2
	DEFW	CTCVEC+6
	DEFW	TIMER		;ONE SECOND TIMER INTERRUPT VECTOR

	DEFB	4
	DEFW	SIOVEC+4
	DEFW	SIOINT		;SIO RECIEVE INTERRUPT VECTOR
	DEFW	SIOERR		;SIO PARITY, OVERRUN & FRAMING ERROR
;
;	INITIALIZE DISK I/O DRIVER VARIABLES
;
	DEFB	8
	DEFW	UNIT
	DEFB	255		;FLAG ALL DRIVES AS DE-SELECTED
	DEFB	255,255,255,255	;CLEAR HEAD POSITION TABLE
	DEFB	00000000B	;SELECT FASTEST SEEK SPEED
	DEFB	128		;SELECT 128 BYTE SECTOR LENGTH
	DEFB	30		;SET MOTOR TURN-OFF TIMER
;
;	INITIALIZE THE CRT DISPLAY CURSOR
;
	DEFB	2
	DEFW	CHRSAV
	DEFB	' '
	DEFB	'_'		;USE NON-BLINKING UNDERSCORE
;
;	SET DEFAULT 'SOFTWARE' INTERRUPT VECTORS
;
	DEFB	6
	DEFW	TIKVEC
	DEFW	DSKTMR		;POINT 'TIKVEC' TO DISK MOTOR TIMER
	DEFW	STASH		;POINT 'PINVEC' TO FIFO INPUT ROUTINE
	DEFW	STASH		;POINT 'SINVEC' TO FIFO INPUT ROUTINE
;
;	SET FREE MEMORY POINTER
;
	DEFB	2
	DEFW	FREPTR
	DEFW	ROMEND		;POINT TO FIRST LOCATION AFTER MONITOR
;
;
	DEFB	-1		;END OF VARIABLE INIT TABLE
;
;
;
BAUDA	EQU	00H		;CHANEL A BAUD RATE GENETATOR
SIO	EQU	04H		;DUAL SERIAL I/O
GENPIO	EQU	08H		;GENERAL PURPOSE PARALLEL I/O
BAUDB	EQU	0CH		;CHANEL B BAUD RATE GENERATOR
WD1771	EQU	10H		;WESTERN DIGITAL DISK CONTROLLER
SCROLL	EQU	14H		;CRT SCROLL MEMORY SCROLL REGISTER
CTC	EQU	18H		;QUAD COUNTER/TIMER CIRCUIT
SYSPIO	EQU	1CH		;SYSTEM PARALLEL I/O
;
;	INITIALIZE SYSTEM PIO FOR USE AS BANK-SWITCH,
;	DISK DRIVE SELECT AND PARALLEL KEYBOARD INPUT
;
BITDAT	EQU	SYSPIO+0
BITCTL	EQU	SYSPIO+1
KBDDAT	EQU	SYSPIO+2
KBDCTL	EQU	SYSPIO+3

	DEFB	3,BITCTL
	DEFB	11001111B	;PUT SYSTEM PIO IN BIT MODE
	DEFB	00011000B	;MAKE BITS 4 AND 3 BE INPUTS
	DEFB	01000000B	;DISABLE INTERRUPTS
;
	DEFB	1,BITDAT
	DEFB	00000000B	;DE-SELECT ROMS, ENABLE DRIVE 0
;
	DEFB	2,KBDCTL
	DEFB	01001111B	;PUT KEYBOARD PORT IN INPUT MODE
	DEFB	SYSVEC+2	;LOAD KEYBOARD INTERRUPT VECTOR
;
;
;	INITIALIZE CHANELS 2 AND 3 OF THE CTC
;	TO GENERATE ONE SECOND INTERRUPTS FROM CTC3
;
CTC0	EQU	CTC+0		;CTC CHANEL 0 PORT#
CTC1	EQU	CTC+1		;CTC CHANEL 1
CTC2	EQU	CTC+2		;CTC CHANEL 2
CTC3	EQU	CTC+3		;CTC CHANEL 3

	DEFB	1,CTC0
	DEFB	CTCVEC		;BASE INTERRUPT VECTOR FOR CTC
;
	DEFB	2,CTC2
	DEFB	00100111B	;PUT CTC2 IN TIMER MODE
	DEFB	105		;CTC2 PERIOD=105*256*400 NANOSECONDS
;
	DEFB	2,CTC3
	DEFB	11000111B	;PUT CTC3 IN COUNTER MODE
	DEFB	93		;CTC3 PERIOD=999936 MICROSECONDS
;
;
;	INITIALIZE SIO CHANEL B FOR ASYNCHRONOUS SERIAL
;	INTERFACE TO PRINTER OR TERMINAL
;
SIODPA	EQU	SIO+0		;SIO DATA PORT A
SIODPB	EQU	SIO+1		;SIO DATA PORT B
SIOCPA	EQU	SIO+2		;SIO CONTROL/STATUS PORT A
SIOCPB	EQU	SIO+3		;SIO CONTROL/STATUS PORT B

	DEFB	1,BAUDB
	DEFB	0101B		;SET COM 8116 FOR 300 BAUD DEFAULT

	DEFB	11,SIOCPB
	DEFB	4		;SELECT REGISTER #4
	DEFB	01000101B	;16X CLOCK, 1 STOP BIT, ODD PARITY
	DEFB	1		;SELECT REGISTER #1
	DEFB	00000100B	;STATUS AFFECTS VECTOR, NO INTERRUPTS
	DEFB	3		;SELECT REGISTER #3
	DEFB	01000001B	;7 BITS/RX CHARACTER
	DEFB	5		;SELECT REGISTER #5
	DEFB	10101010B	;7 BITS/TX CHARACTER, ASSERT DTR
	DEFB	2		;SELECT REGISTER #2
	DEFB	SIOVEC		;LOAD INTERRUPT VECTOR BASE
	DEFB	2		;SELECT READ REG #2 FOR SIO TEST

	DEFB	-1		;END-OF-TABLE
;
;	INIT DONE
;
;
