/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xtranmode.c,v 1.2 87/04/24 16:53:55 davidb Exp $ */
/*
@(#)xtranmode.c	1.5 4/5/85

Save code space, at the expense of time by providing a common
routine to translate exos open mode flags to Unix mode flags.
*/
#include <xerrno.h>
#include <xstdio.h>
#include <xspecial.h>

#ifdef BSD4dot2
#include <sys/file.h>
#else
#include <fcntl.h>
#endif

xtranmode( mode, ioflag )

register int mode;
int *ioflag;		/* flag to go into _xiob structure */
{
int uflag;

uflag = 0;
/*
Translate mode to Unix open flags.
*/
if( mode & XFWRITE )
	{
	if( mode & (XFAPPEND | XFCREAT | XFTRUNC))
		{
		/*
		file creation is a seperate issue, from appending
		or truncation, which are mutually exclusive.
		*/
		uflag = ( mode & XFCREAT )? O_CREAT : 0;
		if( (mode & XFAPPEND) && !(mode & XFTRUNC) )
			{
			uflag |= O_APPEND ;
			}
		else if( (mode & XFTRUNC) && !(mode &  XFAPPEND))
			{
			uflag |= O_TRUNC ;
			}
		else if ( mode & (XFAPPEND | XFTRUNC ))
			{
			xperror( XEINVAL, "append and trunc" );
			return( XEINVAL );
			}
		}
	if( mode & XFREAD )
		{
		*ioflag = _XIORW | _XPrimary;
		uflag |= O_RDWR;
		}
	else
		{
		*ioflag = _XIOWRT;
		uflag |= O_WRONLY;
		}
	}
else if( mode & XFREAD )
	{
	if( mode & (XFAPPEND | XFCREAT | XFTRUNC))
		{
		xperror( XEINVAL, "read and other flags" );
		return( XEINVAL );
		}
	*ioflag = _XIOREAD | _XPrimary;
	uflag = O_RDONLY;
	}
else
	{
	xperror( XEINVAL, "not read or write" );
	return( XEINVAL );
	}
return( uflag );
}
