/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xdopen.c,v 1.2 87/04/24 16:50:41 davidb Exp $ */

/*
@(#)xdopen.c	1.4 3/29/85
xdopen(3x) for Unix.
*/

#include <xstdio.h>
#include <UnixXos.h>
#include <xspecial.h>
#include <xerrno.h>
#include <ex_errno.h>	/* Contains constants used by XMAPERRNO(). */
#include <UnixXos.h>	/* Contains XMAPERRNO(). dab 861219. */

#include <sys/types.h>
#include <sys/stat.h>

extern int errno;
extern long lseek();
extern int xdraread();
extern int xdrawrite();
extern int xdrbread();
extern int xdrbwrite();


/*
 * Xdopen attempts to support types of files for which the Unix OS
 * provides no real support.  We assume that any file may be looked
 * at in any way.  If this should later turn out to be not the case
 * io may fail later, but so be it.
 * Specifically, we attempt to support
 *	unstructured ascii files
 *	unstructured binary files
 *	record ascii files (one line per record assumed)
 *	record binary files
 */
xdopen( name, mode, special )

char *name;
register int mode;
int special;
{
int rval;
int exosfd;
int uflag;
int ioflag;
register XFILE *file;
char buf[MXNAMELEN + 1];
int count;
int sz_recordmark;
struct stat mystat;

rval = xmodname( &name, special, buf, sizeof( buf ) );
if( rval < 0 )
	return( rval );
rval = stat( name, &mystat );
if( rval >= 0 )
	{
	/* file exists */
	if( mystat.st_mode & 040000 )
		{
		return( XEISDIR );
		}
	}
/*
Translate mode to Unix open flags.
*/
uflag = xtranmode( mode, &ioflag );
if ( uflag < 0 )
	return( uflag );
rval = open( name, uflag, 0664 );
if( rval < 0 )
	return( XMAPERRNO(errno) );
exosfd = xnewod();		/* get a free file descriptor */
if( exosfd < 0 )
	{
	close( rval );
	return( exosfd );
	}
file = &_xiob[exosfd];
file->_flag |= ioflag;
file->_sys_id = (char *)rval;
if( mode & XFRECORD )
	{
	/*
	 * Supply functions for record io operations
	 */
	if( mode & XFASCII )
		{
		file->_read = xdraread;
		file->_write = xdrawrite;
		file->_close = xdclose;
		}
	else
		{
		char rmbuf[ sizeof( RECORDMARK ) - 1 ];
		char *rmpt = RECORDMARK;
		int i;
		long offset;
		long count;
		int sz_recordmark;

		sz_recordmark = sizeof( RECORDMARK ) - 1;
		/*
		 Make sure that the file is marked as a record file.
		*/
		if( mode & XFCREAT ) {
			count = write( rval, rmpt, sz_recordmark );
			if( count == -1L ) {
				xclose( exosfd );
				return( XMAPERRNO(errno) );
			}
		} else {
			offset = lseek( rval, 0L, 1 );
			if( offset == -1L ) {
				xclose( exosfd );
				return( XMAPERRNO(errno) );
			}
			if( !offset ) {
				offset += sz_recordmark;
			}
			count = lseek( rval, 0L, 0 );
			if( count == -1L ) {
				xclose( exosfd );
				return( XMAPERRNO(errno) );
			}
			count = read( rval, rmbuf, sz_recordmark );
			if( count == -1L ) {
				xclose( exosfd );
				return( XMAPERRNO(errno) );
			}
			for ( i = 0 ; i < sz_recordmark ; ++i ) {
				if( rmbuf[i] != rmpt[i] ) {
					xclose( exosfd );
					return( XEFILESTRU );
				}
			}
			count = lseek( rval, offset, 0 );
			if( count == -1L ) {
				xclose( exosfd );
				return( XMAPERRNO(errno) );
			}
		}
		file->_read = xdrbread;
		file->_write = xdrbwrite;
		file->_close = xdclose;
		}
	}
else
	{
	file->_read = xdread;
	file->_write = xdwrite;
	if( mode & XRANDOM ) 
		{
		/*
		This forces the user to state his/her intentions
		*/
		file->_flag |= _XIORNDOM;
		file->_lseek = xdlseek;
		}
	file->_close = xdclose;
	}
return( exosfd );
}

/*
 * Ascii record read
 */
xdraread( sys_id, buf, len )
	char *sys_id;
	char *buf;
	int len;
{
	int rval;
	long offset;
	int rcount;
	char *pt;

	offset = lseek( (int)sys_id, 0L, 1 );	/* get current possition */
	if( offset == -1 )
		return( XMAPERRNO(errno) );
	rval = read( (int)sys_id, buf, len );
	if( rval < 0 )
		return( XMAPERRNO(errno) );
	if( rval == 0 ) {
		/* hit end of file */
		return( XEOF );
	}
	/*
	Scan buffer for end of line
	*/
	for( rcount = 0, pt = buf ; rcount < rval ; ++rcount, ++pt ) {
		if( *pt == '\n' ) {
			/*
			 * possition file at start of next record.
			 */
			offset += rcount + 1;
			break;
		}
	}
	if( rval == rcount ) {
		/*
		no end of record found
		*/
		rval = XEGRANULARITY;
	} else {
		rval = rcount;
	}
	offset = lseek( (int)sys_id, offset, 0 );
	if( offset == -1 ) 
		return( XMAPERRNO(errno) );
	return( rval );
}

xdrawrite( sys_id, buf, len )
	char *sys_id;
	char *buf;
	int len;
{
	int rval;
	char *pt;
	long offset;
	int count;

	/*
	Check that mapping is invertable.
	*/
	for( pt = buf, count = 0 ; count < len ; ++pt, ++count ) {
		if( *pt == '\n' )
			return( XEGRANULARITY );
	}
	offset = lseek( (int)sys_id, 0L, 1 );
	if( len > 0 ) {
		rval = write( (int)sys_id, buf, len );
	} else
		rval = 0;
	if( rval < 0 ) {
		lseek( (int)sys_id, offset, 0 );
		return( XMAPERRNO(errno) );
	}
	count = write( (int)sys_id, "\n", 1 );
	if( count < 0 ) {
		lseek( (int)sys_id, offset, 0 );
		return( XMAPERRNO(errno) );
	}
	return( rval );
}

#define R_VALID 0x12345678	/* consistancy check value */
struct rec_hdr {
	long r_length;
	long r_valid;
};

xdrbread( sys_id, buf, len )
	char *sys_id;
	char *buf;
	int len;
{
	struct rec_hdr header;
	int rval;
	long offset;


	offset = lseek( (int)sys_id, 0L, 1 ); /* get current possition */
	if( offset == -1L ) {
		return( XMAPERRNO(errno) );
	}
	/*
	Get record header
	*/
	rval = read( (int)sys_id, &header, sizeof( header ) );
	if( rval < 0 ) {
		lseek( (int)sys_id, offset, 0 );
		return( XMAPERRNO(errno) );
	}
	if( rval == 0 ) {
		return( XEOF );
	}
	if( header.r_valid != R_VALID ) {
		lseek( (int)sys_id, offset, 0 );
		return( XENOPOSSITION );
	}
	if( header.r_length > len ) {
		lseek( (int)sys_id, offset, 0 );
		return( XEGRANULARITY );
	}
	len = header.r_length;
	if( len > 0 ) {
		rval = read( (int)sys_id, buf, len );
		if( rval == 0 ) {
			return( XELOSTDATA );
		}
	} else {
		rval = 0;
	}
	if( rval < 0 ) {
		lseek( (int)sys_id, offset, 0 );
		return( XMAPERRNO(errno) );
	}
	return( rval );
}

xdrbwrite( sys_id, buf, len )
	char *sys_id;
	char *buf;
	int len;
{
	int rval;
	long offset;
	struct rec_hdr header;

	offset = lseek( (int)sys_id, 0L, 1 );
	if( offset == -1L ) {
		return( XMAPERRNO(errno) );
	}
	header.r_length = len;
	header.r_valid = R_VALID;
	rval = write( (int)sys_id, &header, sizeof( header ));
	if( rval < 0 ) {
		lseek( (int) sys_id, offset, 0 );
		return( XMAPERRNO(errno) );
	}
	if ( len > 0 ) {
		rval = write( (int)sys_id, buf, len );
	} else {
		rval = 0;
	}
	if( rval < 0 ) {
		lseek( (int) sys_id, offset, 0 );
		return( XMAPERRNO(errno) );
	}
	return( rval );
}
