/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: getclient.c,v 1.2 87/04/24 16:48:26 davidb Exp $ */
/*
@(#)getclient.c	1.5 7/12/85
Unix version of getclient.
*/
#include <stdio.h>
#include <sys/types.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <ex_errno.h>	/* Contains constants used by XMAPERRNO(). */
#include <UnixXos.h>	/* Contains XMAPERRNO(). dab 861219. */

getclient( type, pf, sin, options, typical_serv )

	int type;
	struct sockproto *pf;
	/*
	struct sockaddr *sin;
	*/
	struct sockaddr_in *sin;
	int options;
	int (*typical_serv)();
{
	int s;
	extern int errno;
	int status;
	struct sockaddr from;

for( ; ; )
	{
	fprintf(stderr, "addr = %x, port = %x\n", sin->sin_addr, sin->sin_port);
	s = socket( type, pf, sin, options );
	if ( s < 0 )
		{
		xperror( XMAPERRNO(errno), "getclient socket" );
		sleep( 5 );
		continue;
		}
	/*
	wait for service request
	*/
	if ( accept( s, &from ) < 0 )
		{
		xperror( XMAPERRNO(errno), "getclient accept" );
		close( s );
		sleep( 5 );
		continue;
		}
	/*
	Unix specific process management
	*/
	if( fork() == 0 )
		{
		/* this fork and exit allows loop to continue */
		if( fork())
			exit(0);
		else
			(*typical_serv)( s, &from );
		}
	close( s );
	wait( &status );	/* Unix process cleanup */
	}
}
