/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xtelread.c,v 1.4 87/04/24 16:47:36 davidb Exp $ */

/*
$Header: xtelread.c,v 1.4 87/04/24 16:47:36 davidb Exp $
$Log:	xtelread.c,v $
 * Revision 1.4  87/04/24  16:47:36  davidb
 * Fixing copyright message
 * 
 * Revision 1.3  87/03/26  19:40:16  grant
 * Updating source from Generic trees
 * 
 * Revision 1.2  87/01/19  16:50:44  grant
 * cleanup davidb's, header stuff.
 * 
 * Revision 1.7  86/12/19  18:00:42  davidb
 * Updating source from Generic trees
 * 
 * Revision 1.3  86/11/05  08:28:02  alexl
 * Updating source from Generic trees
 * 
 * Revision 1.1  86/10/08  10:50:59  mark
 * merging in changes for new ftp
 * 
 * Revision 1.3  86/09/19  10:19:26  albert
 * allow use of Excelan's standard file specification.
 * 
 * Revision 1.2  86/09/10  10:52:46  albert
 * use Excelan's standard style of include specification.
 * 
 * Revision 1.1  86/09/04  16:19:35  albert
 * first working version
 * 
 * Revision 1.2  86/08/25  17:47:23  mark
 * syncing revision level
 * 
 * Revision 1.1  86/04/18  19:13:09  mark
 * Initial revision
 * 
*/

#ifdef	vms
#include "h_xlib/xstdio.h"
#include "h_xlib/xerrno.h"
#include "h_xlib/telnet.h"
#else	/* vms */
#include <xstdio.h>
#include <xerrno.h>
#include <xtelnet.h> 	/* Xlib specific stuff. Used to be in */
#include <arpa/telnet.h> /* include/EXOS/telnet.h. dab 861125. */
#endif	/* vms */

/*
 * Telnet receiver states for fsm
 */
#define	TS_DATA		0
#define	TS_IAC		1
#define	TS_WILL		2
#define	TS_WONT		3
#define	TS_DO		4
#define	TS_DONT		5
#define TS_CR		6

xtelread( sys_id, buf, len )
register struct tel_state *sys_id;
char *buf;
int len;
{
	int cnt;
	register char *backpt = buf;
	char *frontpt;
	int c;
	int rval = 0;

	if( !sys_id )
		return( XEBADF );
	/*
	We must loop here to prevent the read from returning 0
	when the first part of a control sequence is read.
	This has unfortunate consequences with respect to the semantics
	of select, but it seems better to assume that the rest of the
	control sequence is on its way than to return an erronious
	end of file.
	*/
	while ( rval == 0 ) {
		frontpt = buf;
		/*
		The read and return below work, because
		rval == 0 => we have added no data to the buffer
				-and-
		XEWOULDBLOCK and other errors may be returned
		correctly even if sys_id->read_state has changed.
		*/
		cnt = xread( sys_id->od, buf, len );
		if ( cnt <= 0 )
			return( cnt );
		while (cnt > 0) {
			c = *frontpt++ & 0377;
			cnt--;
			switch ( sys_id->read_state ) {

			case TS_DATA:
				if (c == IAC)
					sys_id->read_state = TS_IAC;
				else if( c == '\r' && cnt &&
					!(sys_id->his_opts[TELOPT_ECHO]) )
					sys_id->read_state = TS_CR;
				else {
					*backpt++ = c;
					++rval;
				}
				continue;

			case TS_CR:
				if( c == '\n' )
					{
					*backpt++ = '\n';
					sys_id->read_state = TS_DATA;
					++rval;
					}
				else if ( c == IAC )
					{
					/*
					The simplifying assumption is that '\r'
					followed by telnet control information,
					followed by '\n' isn't a telnet end of
					line.
					*/
					*backpt++ = '\r';
					++rval;
					sys_id->read_state = TS_IAC;
					}
				else
					{
					*backpt++ = '\r';
					++rval;
					*backpt++ = c;
					++rval;
					sys_id->read_state = TS_DATA;
					}
				continue;
			case TS_IAC:
				switch (c) {
				
				case WILL:
					sys_id->read_state = TS_WILL;
					continue;

				case WONT:
					sys_id->read_state = TS_WONT;
					continue;

				case DO:
					sys_id->read_state = TS_DO;
					continue;

				case DONT:
					sys_id->read_state = TS_DONT;
					continue;

				case DM:
					/* xfflush(xstdout);		/* ? */
					(*(sys_id->nvt_action))( sys_id, DM, c);
					break;

				case NOP:
					break;
				case GA:
					(*(sys_id->nvt_action))( sys_id, GA, c);
					break;
				case IAC:
					*backpt++ = c;
					++rval;
					break;

				default:
					(*(sys_id->nvt_action))( sys_id, c, c );
					break;
				}
				sys_id->read_state = TS_DATA;
				continue;

			case TS_WILL:
				(*(sys_id->nvt_action))( sys_id, WILL, c );
				sys_id->read_state = TS_DATA;
				continue;

			case TS_WONT:
				(*(sys_id->nvt_action))( sys_id, WONT, c );
				sys_id->read_state = TS_DATA;
				continue;

			case TS_DO:
				(*(sys_id->nvt_action))( sys_id, DO, c );
				sys_id->read_state = TS_DATA;
				continue;

			case TS_DONT:
				(*(sys_id->nvt_action))( sys_id, DONT, c );
				sys_id->read_state = TS_DATA;
				continue;
			}
		}
	} /* while rval == 0 */
	return( rval );
}

_xtelstate( sys_id, ch )
/*
State changes for out-of-band input.
I assume that
	1) the out of band character is either DM or IAC to start
	the DM command
	2) all previous commands were sent before the OOB byte
Otherwise, the OOB byte is not part of the TELNET stream.
*/
	struct tel_state *sys_id;
	int ch;
{
	
	if( sys_id->read_state == TS_DATA ) {
		if( ch == IAC )
			sys_id->read_state = TS_IAC;
	} else {
		/*
		do nothing
		*/
	}
}
