/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xnatfsopen.c,v 1.4 87/04/24 16:18:43 davidb Exp $ */
/*
$Header: xnatfsopen.c,v 1.4 87/04/24 16:18:43 davidb Exp $
$Log:	xnatfsopen.c,v $
 * Revision 1.4  87/04/24  16:18:43  davidb
 * Fixing copyright message
 * 
 * Revision 1.3  87/03/26  19:38:28  grant
 * Updating source from Generic trees
 * 
 * Revision 1.2  86/10/15  15:57:26  albert
 * change semantics of xnatls to allow whether a directory should be
 * interpreted as a file.
 * 
 * Revision 2.4  86/10/09  16:28:04  albert
 * semantics of xnatls is changed to add in a new parameter for the flag
 * to determine if a directory should be treated as a file.
 * 
 * Revision 2.2  86/10/08  22:09:40  albert
 * Semantics of xnatls is changed to add in a new parameter for the 
 * flag to determine if a directory should be treated as a file.
 * 
 * Revision 2.1  86/09/30  16:46:50  albert
 * update from generic baseline software.
 * 
 * Revision 1.5  86/09/29  16:47:39  mark
 * added support for record and file commands
 * 
 * Revision 1.4  86/09/19  10:00:45  albert
 * allow Excelan's standard include file specification.
 * 
 * Revision 1.2  86/09/10  10:39:46  albert
 * should use Excelan's standard style of include specification.
 * 
 * Revision 1.1  86/09/04  16:19:20  albert
 * first working version
 * 
 * Revision 1.2  86/08/25  17:36:54  mark
 * syncing revision level
 * 
 * Revision 1.1  86/04/18  19:11:27  mark
 * Initial revision
 * 
*/

#include "elib.h"
#ifdef	vms
#include "h_xlib/xnatio.h"
#include "h_xlib/xstat.h"
#include "h_xlib/xcmd.h"
#else	/* vms */
#include <xnatio.h>
#include <xstat.h>
#include <xcmd.h>
#endif	/* vms */

extern char *xmalloc();
static int setftpmode();	/* set mode according to transfer attributes */

xnatfsopen( protocol, system, user, pass, account, context )
	int protocol;
	char *system;
	char *user;
	char *pass;
	char *account;
	struct filesystem *context;
{
	/*
	The only thing we need to do is store the current directory
	*/
	struct xnat_conn_state *nat_pt;
	int rval;

	nat_pt = (struct xnat_conn_state *)
		xmalloc( sizeof(struct xnat_conn_state) );
	if( nat_pt == (struct xnat_conn_state *) XNULL )
		return( XENOMEM );
	rval = xpwd( nat_pt->pwdsave, PWDLEN, PWD );
	nat_pt->flag1 = F_ASCII;
	nat_pt->flag2 = 0;
	context->conn_state = (char *)nat_pt;
	return( rval );
}

xnatfsclose( context )
	struct filesystem *context;
{
	xfree( context->conn_state );
	return( 0 );
}


xnatopen( name, mode, special, statb, context )
	char *name;
	int mode;
	int special;
	struct xstatbuf *statb;
	struct filesystem *context;
/*
$Implementation:
	Implementors should be very careful with this function.

	Case 1:	XFFORCE flag is set and XFCREAT is clear.
		This function should determine which mode the file should
		be opened based on statb.  If it cannot be done, an error
		should be returned.
	Case 2: XFFORCE flag is set and XFCREAT is set.
		This function should determine how the file should be
		created based on statb.  If it cannot be done, and error
		should be returned.
	Case 3: XFFORCE flag cleared and XFCREAT is set.
		This function should create the file based on the mode
		parameter.  It should also return the file attributes
		in the statb parameter.
	Case 4: XFFORCE flag cleared and XFCREAT is clear.
		This function should open the file based on the mode
		parameter.  It should also return the file attributes
		in the statb parameter.

	Note:
		This function does not support FTAM currently.
$
*/
{
	int rval;
	struct xnat_conn_state *nat_pt;

	nat_pt = (struct xnat_conn_state *)context->conn_state;

	/* now is the type to determine what to do best if XFFORCE is set */
	if (mode & XFFORCE) {
		/*
		Reject file types that the local system cann't
		support
		*/
		if (statb->x_mode & X_IFDIR)
			return (XEOPNOTSUPP); /* cannot open directory this way */
		switch (statb->x_ptype) {
			case P_FTAM:
				return (XEOPNOTSUPP);/* no support for FTAM yet */
			case P_FTP:	/* now play around with mode flag */
				if (setftpmode(&statb->p_data.ftp, &mode) 
				    == XEOPNOTSUPP)
					return (XEOPNOTSUPP);	/* no support */
				break;
			case P_NATIVE:	/* use native stuff */
				if (statb->x_mode & X_IFTEXT)
					mode |= XFASCII;
				if (statb->x_mode & X_IFRECORD)
					mode |= XFRECORD;
			default:
				break;
			};
	}
	xchdir( nat_pt->pwdsave, FILE_NAME );
	rval = xdopen( name, mode, special );
	if( rval < 0 )
		return( rval );
	if( mode & XFCREAT ) {
		xchattr( name, special, statb );
	} else if( mode & XFFORCE ) {
		/*
		We want to reject files that aren't of the type indicated
		by statb, yet are being forced to be interpretted that
		way. */
	} else {
		xstat( name, special, statb );
	}
	return( rval );
}

xnatdiropen( name, special, context )
	char *name;
	int special;
	struct filesystem *context;
{
	int rval;
	struct xnat_conn_state *nat_pt;

	nat_pt = (struct xnat_conn_state *)context->conn_state;
	xchdir( nat_pt->pwdsave, FILE_NAME );
	rval = xdiropen( name, special );
	return( rval );
}

xnatstat( name, special, info, context )
	char *name;
	int special;
	struct xstatbuf *info;
	struct filesystem *context;
{
	int rval;
	struct xnat_conn_state *nat_pt;

	nat_pt = (struct xnat_conn_state *)context->conn_state;
	xchdir( nat_pt->pwdsave, FILE_NAME );
	if( special == SERVICE_PARA ) {
		xbzero( info, sizeof(struct xstatbuf) );
		info->x_ptype = NATIVE;
		/*
		make a best guess about mode flags
		*/
		info->x_mode = X_PREAD | X_PWRITE | X_IREAD | X_IWRITE |
			X_GREAD | X_OREAD;
		if( nat_pt->flag1 & F_ASCII ) {
			info->x_mode |= X_IFTEXT;
		}
		if( nat_pt->flag1 & F_BINARY ) {
			info->x_mode |= X_IFBIN;
		}
		if( nat_pt->flag1 & F_RECORD ) {
			info->x_mode |= X_IFRECORD;
		}
		rval = 0;
	} else {
		rval = xstat( name, special, info );
	}
	return( rval );
}

xnatchdir( name, special, context )
	char *name;
	int special;
	struct filesystem *context;
{
	int rval;
	struct xnat_conn_state *nat_pt;

	nat_pt = (struct xnat_conn_state *)context->conn_state;
	xchdir( nat_pt->pwdsave, FILE_NAME );
	rval = xchdir( name, special );
	xpwd( nat_pt->pwdsave, PWDLEN, PWD );
	return( rval );
}

xnatchattr( name, special, info, context )
	char *name;
	int special;
	struct filesystem *context;
	struct xstatbuf *info;
{
	int rval;
	struct xnat_conn_state *nat_pt;

	nat_pt = (struct xnat_conn_state *)context->conn_state;
	if( special == SERVICE_PARA ) {
		if( info->x_mode & X_IFTEXT ) {
			nat_pt->flag1 |= F_ASCII;
		}
		if( info->x_mode & X_IFBIN ) {
			nat_pt->flag1 |= F_BINARY;
		}
		if( info->x_mode & X_IFRECORD ) {
			nat_pt->flag1 |= F_RECORD;
		}
		rval = 0;
	} else {
		xchdir( nat_pt->pwdsave, FILE_NAME );
		rval = xchattr( name, special, info );
	}
	return( rval );
}

xnatmkdir( name, special, context )
	char *name;
	int special;
	struct filesystem *context;
{
	int rval;
	struct xnat_conn_state *nat_pt;

	nat_pt = (struct xnat_conn_state *)context->conn_state;
	xchdir( nat_pt->pwdsave, FILE_NAME );
	rval = xmkdir( name, special );
	return( rval );
}

xnatrmdir( name, special, context )
	char *name;
	int special;
	struct filesystem *context;
{
	int rval;
	struct xnat_conn_state *nat_pt;

	nat_pt = (struct xnat_conn_state *)context->conn_state;
	xchdir( nat_pt->pwdsave, FILE_NAME );
	rval = xrmdir( name, special );
	return( rval );
}

xnatrename( from, fspecial, to, tspecial, context )
	char *from;
	int fspecial;
	char *to;
	int tspecial;
	struct filesystem *context;
{
	int rval;
	struct xnat_conn_state *nat_pt;

	nat_pt = (struct xnat_conn_state *)context->conn_state;
	xchdir( nat_pt->pwdsave, FILE_NAME );
	rval = xrename( from, fspecial, to, tspecial );
	return( rval );
}

xnatls( od, name, code, dircheck, context )
	int od;
	char *name;
	int code;
	int dircheck;	/* flag to show if treat directory as a file */
	struct filesystem *context;
{
	int rval;
	struct xnat_conn_state *nat_pt;

	nat_pt = (struct xnat_conn_state *)context->conn_state;
	xchdir( nat_pt->pwdsave, FILE_NAME );
	rval = xls( od, name, code, dircheck);
	return( rval );
}

xnatpwd( buf, len, code, context )
	char *buf;
	int len;
	int code;
	struct filesystem *context;
{
	int rval;
	struct xnat_conn_state *nat_pt;

	nat_pt = (struct xnat_conn_state *)context->conn_state;
	xchdir( nat_pt->pwdsave, FILE_NAME );
	rval = xpwd( buf, len, code );
	return( rval );
}

xnatunlink( name, special, context )
	char *name;
	int special;
	struct filesystem *context;
{
	int rval;
	struct xnat_conn_state *nat_pt;

	nat_pt = (struct xnat_conn_state *)context->conn_state;
	xchdir( nat_pt->pwdsave, FILE_NAME );
	rval = xunlink( name, special );
	return( rval );
}

extern struct cmd *xgetcmd();

xnathelp( argc, argv, table, context )
	int argc;
	char *argv[];
	struct cmd *table;
	struct filesystem *context;
{
	argv[0] = (char *)table;
	return( 0 );
}

xnatascii( argc, argv, table, context )
	int argc;
	char *argv[];
	struct cmd *table;
	struct filesystem *context;
{
	struct xnat_conn_state *nat_pt;
	int rval = 0;

	nat_pt = (struct xnat_conn_state *)context->conn_state;
	nat_pt->flag1 |= F_ASCII;
	nat_pt->flag1 &= ~F_BINARY;
	return( rval );
}

xnatbin( argc, argv, table, context )
	int argc;
	char *argv[];
	struct cmd *table;
	struct filesystem *context;
{
	struct xnat_conn_state *nat_pt;
	int rval = 0;

	nat_pt = (struct xnat_conn_state *)context->conn_state;
	nat_pt->flag1 |= F_BINARY;
	nat_pt->flag1 &= ~F_ASCII;
	return( rval );
}

xnatrecord( argc, argv, table, context )
	int argc;
	char *argv[];
	struct cmd *table;
	struct filesystem *context;
{
	struct xnat_conn_state *nat_pt;
	int rval = 0;

	nat_pt = (struct xnat_conn_state *)context->conn_state;
	if( (argv[0])[0] == 'r' ) {
		nat_pt->flag1 |= F_RECORD;
	} else {
		nat_pt->flag1 &= ~F_RECORD;
	}
	return( rval );
}

char	xnatahelp[] =	"set ascii transfer type";
char	xnatbhelp[] =	"set binary transfer type";
char	xnatfhelp[] =	"set unstructured file transfer type";
char	xnatrhelp[] =	"set record transfer type";


struct cmd xnatcmdtab[] = {
	{ "ascii", xnatahelp, 1, 0, xnatascii },
	{ "binary", xnatbhelp, 1, 0, xnatbin },
	{ "file", xnatfhelp, 1, 0, xnatrecord },
	{ "help",	0, 0, 0, xnathelp },
	{ "record", xnatrhelp, 1, 0, xnatrecord },
	{ 0, "", 0, 0, 0 }
};

xnatcmd( argc, argv, context )
	int argc;
	char *argv[];
	struct filesystem *context;
{
	struct cmd *cmd_pt;
	int rval = XEOPNOTSUPP;

	cmd_pt = xgetcmd( argv[0], xnatcmdtab );
	if( cmd_pt != XNULL ) {
		rval = (*cmd_pt->c_handler)( argc, argv, xnatcmdtab, context );
	}
	return( rval );
}

static int setftpmode(transfer, mode)
struct ftp_attr *transfer;	/* transfer attributes */
int	*mode;				/* mode to be set */
{
	switch (transfer->rep_type) {
		case RT_ASCII:
		case RT_IMAGE:
			break;	/* these are supported */
		case RT_LOCALBYTE:	/* only support 8-bit mode */
			if (transfer->byte_sz == 8)
				break;
		default:	/* others are not supported */
			return XEOPNOTSUPP;				
	};
	if( transfer->format != TF_NONPRINT )
		return XEOPNOTSUPP;
	if( (transfer->structure != IS_FILE ) && 
		(transfer->structure != IS_RECORD) )
		return XEOPNOTSUPP;
	if( transfer->trans_mode != TM_STREAM )
		return XEOPNOTSUPP;

	/* check that XFASCII is not set in mode */

	/* use appropriate open routine for opening the file */

	if (transfer->rep_type == RT_ASCII)
		*mode |= XFASCII;		
	if (transfer->structure == IS_RECORD)
		*mode |= XFRECORD;
	return 0;
}				
