/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xmodname.c,v 1.2 87/04/24 16:18:33 davidb Exp $ */
/*
@(#)xmodname.c	1.3 3/29/85

Unix routine to form path names relative to the user's home directory,
current directory, etc.
This routine belongs in Xoslib, but is here to keep the linker happy.
*/
#include <xspecial.h>
#include <xerrno.h>

#include <pwd.h>

xmodname( name, special, buf, sz_buf )

char **name;
int special;
char *buf;
int sz_buf;
{
int rval;
char *pt = buf;

switch( special ) {
	case FILE_NAME:
		pt = *name;
		break;
	case CURRENT_DIR:
		buf[0] = '.';
		buf[1] = '\0';
		break;
	case UP_DIRECTORY:
		buf[0] = '.';
		buf[1] = '.';
		buf[3] = '\0';
	case HM_RELATIVE:
	case HOME_DIR:
		{
		struct passwd *pwent;
		extern struct passwd *getpwuid();
		int uid;
		
		uid = getuid();
		pwent = getpwuid( uid );
		if( pwent == (struct passwd *)0 )
			return( XEPERM );
		if ( special == HM_RELATIVE )
			{
			/*
			Check for enough room in buffer,
			concatenate home directory and *name.
			*/
			if( (2 + xstrlen( pwent->pw_dir ) + xstrlen( *name ))
				> sz_buf )
				return( XE2BIG );
			xsprintf( buf, "%s/%s", pwent->pw_dir, *name );
			}
		else
			{
			/*
			Use home directory.
			*/
			pt = pwent->pw_dir;
			}
		}
		break;
	case CD_RELATIVE:
		/*
		Check for enough room in buffer,
		prepend "./" to *name.
		*/
		if( (3 + xstrlen( *name )) > sz_buf )
			return( XE2BIG );
		xsprintf( buf, "./%s", *name );
		break;
	default:
		return( XEINVAL );
	}
*name = pt;
return( 0 );
}
