/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xftppass.c,v 1.2 87/04/24 16:16:38 davidb Exp $ */
/*
@(#)xpassthru.c	1.6 6/14/85

Xpasstnet(3X) and xpassfnet(3X) for Unix.
This file logically belongs in xoslib, but it is included here
to keep the linker happy.
*/

#include <xstdio.h>
#include <xerrno.h>
#include <ex_errno.h>	/* Contains constants used by XMAPERRNO(). */
#include <UnixXos.h>	/* Contains XMAPERRNO(). dab 861219. */
#include <xspecial.h>
#include <xftpio.h>
#include <arpa/ftp.h>

/*
 * defines for record structure transfer
 */
#define	RECORD_ESCAPE	'\377'
#define END_OF_FILE	'\002'
#define END_OF_RECORD	'\001'


extern long _xpass();
extern int type;
extern int stru;
extern int hash;
extern int aborted;
extern int errno;
extern int xftpread();
extern int xftpwrite();

#define TONET 1
#define FROMNET 2
#define BOTHNET 4

xftpsclose( sys_id )
	struct ftp_ofile *sys_id;
{
	/*
	This routine is just a no-op because the structure used is
	on the stack, and the underlying object will be closed
	by a higher level routine.
	Oh, it does need to send the end of file if we're writing.
	*/
static char eof_sequence[] = {RECORD_ESCAPE, END_OF_FILE};

	if( sys_id->open_mode & XFWRITE ) {
		xwrite(sys_id->od, eof_sequence, sizeof eof_sequence);
	}
}

long
xpasstnet( inod, outod )

XFILE *inod;	/* input EXOS io object */
XFILE *outod;	/* output EXOS io object */
{
return( _xpass( TONET, inod, outod ) );
}


long
xpassfnet( inod, outod )

XFILE *inod;	/* input EXOS io object */
XFILE *outod;	/* output EXOS io object */
{
return( _xpass( FROMNET, inod, outod ) );
}

long
xnetpass( inod, outod )

XFILE *inod;	/* input EXOS io object */
XFILE *outod;	/* output EXOS io object */
{
return( _xpass( BOTHNET, inod, outod ) );
}

long
_xpass( direction, inod, outod )

int direction;	/* to or from net */
XFILE *inod;	/* input EXOS io object */
XFILE *outod;	/* output EXOS io object */
{
char buf[1024];
int c;
int d;
long bytes = 0;
long hashbytes = sizeof( buf );
int io_type;
struct ftp_ofile sys_id;
XFILE *file;
int exosfd;
int rod;
int wod;

rod = xfileno( inod );
wod = xfileno( outod );
if( stru == STRU_R ) {
	io_type =  TYPE_I;
	/*
	Create filter for record structure transfer
	The idea here is to provide just enough information to
	keep xftpread, or xftpwrite happy.
	*/
	exosfd = xnewod();
	if( exosfd < 0 ) {
		return( exosfd );
	}
	file = &_xiob[exosfd];
	file->_sys_id = (char *)&sys_id;
	file->_read = xftpread;
	file->_write = xftpwrite;
	file->_close = xftpsclose;
	xbzero( &sys_id, sizeof( sys_id ) );
	if( direction == FROMNET ) {
		sys_id.od = rod;
		rod = exosfd;
		file->_flag |= _XIOREAD;
	} else {
		sys_id.od = wod;
		wod = exosfd;
		file->_flag |= _XIOWRT;
		sys_id.open_mode = XFWRITE;
	}
	sys_id.below_type.rep_type = (type == TYPE_A)? RT_ASCII : RT_IMAGE;
	sys_id.below_type.structure = IS_RECORD;
	sys_id.below_type.trans_mode = TM_STREAM;
	sys_id.below_type.format = TF_NONPRINT;
	sys_id.below_type.byte_sz = 8;
} else if( direction == BOTHNET ) {
	io_type = TYPE_I;
} else {
	io_type = type;
}
switch (io_type) {
	case TYPE_I:
	case TYPE_L:
		errno = d = 0;
		while ((c = xread( rod, buf, sizeof (buf))) >= 0) {
			if( aborted ) {
				if( stru == STRU_R )
					xclose( exosfd );
				return( XEINTR );
			}
			/* for now */
			if( stru != STRU_R && c == 0 )
				break;
			if ((d = xwrite( wod, buf, c)) < 0)
				break;
			bytes += c;
			if (hash) {
				xputchar('#');
				xfflush(xstdout);
			}
		}
		if (hash) {
			xputchar('\n');
			xfflush(xstdout);
		}
		if (c < 0 && c != XEOF ) {
			xperror( c, "on input");
			if( stru == STRU_R )
				xclose( exosfd );
			return( c );
		}
		if (d < 0) {
			/*
			Throw away any data remaining in the pipe.
			*/
			while
			((c = xread( rod, buf, sizeof(buf))) > 0)
				;
			xperror( d, "on output");
			if( stru == STRU_R )
				xclose( exosfd );
			return( d );
		}
		break;

	case TYPE_A:
		if( direction == FROMNET )
			{
			while ((c = xgetc(inod)) != XEOF) 
				{
				if( aborted ) {
					return( XEINTR );
				}
				if (c == '\r') 
					{
					while (hash && (bytes >= hashbytes)) 
						{
						xputchar('#');
						xfflush(xstdout);
						hashbytes += sizeof (buf);
						}
					bytes++;
					if ((c = xgetc(inod)) != '\n') 
						{
						if (xferror (outod))
							break;
						xputc ('\r', outod);
						}
					if (c == '\0') 
						{
						bytes++;
						continue;
						}
					}
				if( xferror( outod ) )
					break;
				xputc (c, outod);
				bytes++;
				}
			}
		else if ( direction == TONET )
			{
			while ((c = xgetc(inod)) != XEOF) 
				{
				if( aborted ) {
					return( XEINTR );
				}
				if (c == '\n')
					{
					while (hash && (bytes >= hashbytes)) 
						{
						xputchar('#');
						xfflush(xstdout);
						hashbytes += sizeof (buf);
						}
					bytes++;
					xputc('\r', outod );
					if (c == '\0') 
						{
						bytes++;
						continue;
						}
					}
				if( xferror( outod ) )
					break;
				xputc (c, outod);
				bytes++;
				}
			}
		else
			{
			return( XEINVAL );
			}
		if (hash) {
			xputchar('\n');
			xfflush(xstdout);
		}
		if ((xferror(inod)) ) {
			xperror ( XMAPERRNO(errno), "on input");
			return( XMAPERRNO(errno) );
		}
		if (xferror (outod)) {
			/*
			Throw away any data remaining in the pipe.
			*/
			while
			((c = xread( rod, buf, sizeof(buf))) > 0)
				;
			xperror ( XMAPERRNO(errno), "on output");
			return( XMAPERRNO(errno) );
		}
		break;
	default:
		return( XEOPNOTSUPP );
	}
if( stru == STRU_R )
	xclose( exosfd );
return( bytes );
}
