/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: _xfilbuf.c,v 1.2 87/04/24 16:09:18 davidb Exp $ */
/*
@(#)_xfilbuf.c	1.4 5/22/85

System independent routine for filling buffers associated with
a pointer to an io object.  (used to implement xgetc).
*/
#include "xgenlib.h"

_xfilbuf( file )

register XFILE *file;
{
int rval;
char ch;

if( !( file->_flag & _XUsed ) )
	return( XEOF );
if( !( file->_flag & _XIOREAD ) )
	return( XEOF );
if( file->_flag & _XIOERR ) 
	{
	/*
 	* Allow user to retry after an error.
 	*/
	file->_flag &= ~_XIOERR;
	}
if( file->_base )
	{
	rval = xread( xfileno(file), file->_base, file->_bufsiz );
	}
else
	{
	rval = xread( xfileno(file), &ch, 1 );
	}
if ( rval == XEOF )
	{
	file->_flag |= _XIOEOF;
	return( XEOF );
	}
else if( rval < 0 )
	{
	file->_flag |= _XIOERR;
	return( XEOF );
	}
file->_cnt = rval - 1;
if( file->_base )
	{
	file->_ptr = &file->_base[1];
	return( (file->_base[0]) & 0xff );
	}
else
	{
	return( ch & 0xff );
	}
}
