/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: rwho.c,v 1.2 87/04/24 15:19:13 davidb Exp $ */
static char sccsId[] = "@(#)rwho.c	1.7 5/31/85";

/*
 * Remote who program
 */
#include <sys/types.h>
#include <stdio.h>
#include <sys/extypes.h> /* For u_char, etc., defns. dab 861125. */
#include <ndir.h>
#include <utmp.h>
#include "rwhod.h"


#define	NUSERS	 200
#define	NEXCLUDE 100
#define	NINCLUDE 100

struct	myutmp {
	char	myhost[32];
	int	myidle;
	struct	outmp myutmp;
} myutmp[NUSERS];
struct	whod wd;

int	nusers = 0;
char	*exclude[NEXCLUDE];
char	*include[NINCLUDE];
int	ninclude = 0;
int	nexclude = 0;

#define	WHDRSIZE	(sizeof (wd) - sizeof (wd.wd_we))
#define	RWHODIR		"/usr/spool/rwho"

char	*ctime(), *strcpy();
int	utmpcmp();
int	nmutmpcmp();
int	now = 0;
int	aflg = 0;
int	uflg = 0;

main(argc, argv)
	int argc;
	char **argv;
{
	int cc, width;
	register struct whod *w = &wd;
	register struct whoent *we;
	register struct myutmp *mp;
	int f, n, i;
	register DIR * dirp;
	register struct direct *dp;

	argc--, argv++;
again:
	if (argc > 0 && !strcmp(argv[0], "-a")) {
		argc--, argv++;
		aflg++;
		goto again;
	}
	if (argc > 0 && !strcmp(argv[0], "-u")) {
		argc--, argv++;
		uflg++;
		goto again;
	}
	if (argc > 0) {
		if (argv[0][0] == '-') {
			exclude[nexclude] = &argv[0][1];
			if (nexclude < NEXCLUDE-2)
				nexclude++;
		} else {
			include[ninclude] = &argv[0][0];
			if (ninclude < NINCLUDE-2)
				ninclude++;
		}
		argc--, argv++;
		goto again;
	}
	(void) time(&now);
	if (chdir(RWHODIR) < 0) {
		experror(RWHODIR);
		exit(1);
	}
	if ((dirp = opendir(".")) == NULL) {
		experror(RWHODIR);
		exit(1);
	}
	mp = myutmp;
	while (dp=readdir(dirp)) {
		if (dp->d_ino == 0) 
			continue;
		if (strncmp(dp->d_name, "whod.", 5))
			continue;
		f = open(dp->d_name, 0);
		if (f < 0)
			continue;
		cc = read(f, (char *)&wd, sizeof (struct whod));
		if (cc < WHDRSIZE) {
			(void) close(f);
			continue;
		}
		if (now - w->wd_recvtime > 5 * 60) {
			(void) close(f);
			continue;
		}
		cc -= WHDRSIZE;
		we = w->wd_we;
		for (n = cc / sizeof (struct whoent); n > 0; n--) {
			if (aflg == 0 && we->we_idle >= 60*60) {
				we++;
				continue;
			}
			if (ninclude != 0) {
				for (i = 0; i < ninclude; i++) {
				    if (strncmp(w->wd_hostname, include[i],
				        sizeof(w->wd_hostname)) == 0)
						break;
				}
				if (i >= ninclude) {
					we++;
					continue;
				}
			}
			if (nexclude != 0) {
				for (i = 0; i < nexclude; i++) {
				    if (strncmp(w->wd_hostname, exclude[i],
				        sizeof(w->wd_hostname)) == 0)
						break;
				}
				if (i < nexclude) {
					we++;
					continue;
				}
			}
			if (nusers >= NUSERS) {
				printf("too many users\n");
				exit(1);
			}
			mp->myutmp = we->we_utmp;
			mp->myidle = we->we_idle;
			(void) strcpy(mp->myhost, w->wd_hostname);
			nusers++;
			we++;
			mp++;
		}
		(void) close(f);
	}
	closedir(dirp);
	if (uflg)
		qsort((char *)myutmp, nusers, sizeof (struct myutmp), utmpcmp);
	else
		qsort((char *)myutmp, nusers, sizeof (struct myutmp), nmutmpcmp);
	mp = myutmp;
	width = 0;
	for (i = 0; i < nusers; i++) {
		int j = strlen(mp->myhost) + 1 + strlen(mp->myutmp.out_line);
		if (j > width)
			width = j;
		mp++;
	}
	mp = myutmp;
	for (i = 0; i < nusers; i++) {
		char buf[22];
		sprintf(buf, "%s:%s", mp->myhost, mp->myutmp.out_line);
		printf("%-8.8s %-*s %.12s",
		   mp->myutmp.out_name,
		   width,
		   buf,
		   ctime((time_t *)&mp->myutmp.out_time)+4);
		mp->myidle /= 60;
		if (mp->myidle) {
			if (aflg) {
				if (mp->myidle >= 100*60)
					mp->myidle = 100*60 - 1;
				if (mp->myidle >= 60)
					printf(" %2d", mp->myidle / 60);
				else
					printf("   ");
			} else
				printf(" ");
#if SYSTEM3 || SYSTEM5
			printf(":%.2d", mp->myidle % 60);
#else
			printf(":%02d", mp->myidle % 60);
#endif
		}
		printf("\n");
		mp++;
	}
	exit(0);
}

utmpcmp(u1, u2)
	struct myutmp *u1, *u2;
{
	int rc;

	rc = strncmp(u1->myutmp.out_name, u2->myutmp.out_name, 8);
	if (rc)
		return (rc);
	rc = strncmp(u1->myhost, u2->myhost, 8);
	if (rc)
		return (rc);
	return (strncmp(u1->myutmp.out_line, u2->myutmp.out_line, 8));
}

nmutmpcmp(u1, u2)
	struct myutmp *u1, *u2;
{
	int rc;

	rc = strncmp(u1->myhost, u2->myhost, 8);
	if (rc)
		return (rc);
	rc = strncmp(u1->myutmp.out_name, u2->myutmp.out_name, 8);
	if (rc)
		return (rc);
	return (strncmp(u1->myutmp.out_line, u2->myutmp.out_line, 8));
}
