/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: mbuf.c,v 1.2 87/04/24 15:10:49 davidb Exp $ */
char	nsvers[] = " @(#)mbuf.c	1.3 10/4/85 ";

#include "netstat.h"

struct mbpool mbpool;
struct xmbpool xmbpool;
struct pmbpool pmbpool;

extern	int exos;
extern	int dflag;

#ifdef notdef
static struct mbtypes {
	int	mt_type;
	char	*mt_name;
} mbtypes[] = {
	{ MT_DATA,	"data" },
	{ MT_HEADER,	"packet headers" },
	{ MT_SOCKET,	"socket structures" },
	{ MT_PCB,	"protocol control blocks" },
	{ MT_RTABLE,	"routing table entries" },
	{ MT_HTABLE,	"IMP host table entries" },
	{ MT_ATABLE,	"address resolution tables" },
	{ MT_FTABLE,	"fragment reassembly queue headers" },
	{ MT_SONAME,	"socket names and addresses" },
	{ MT_ZOMBIE,	"zombie process information" },
	{ MT_SOOPTS,	"socket options" },
	{ 0, 0 }
};
#endif

static char *mtname[] = {
	"free",
	"data",
	"header",
	"socket",
	"pcb",
	"rt entry",
	"ip frag",
	"ts buf",
	0
};

#define MUSER_MAX 16 
#define MUSER_MISC MUSER_MAX-1

struct muser {
	u_short addr;
	short	cnt;
} musert[MUSER_MAX] = { 0 };

/*
 * Print mbuf statistics.
 */
mbpr(mbp, xmbp, pmbp)
	struct mbpool *mbp;
	struct xmbpool *xmbp;
	struct pmbpool *pmbp;
{
	register int totmem, totfree, totmbufs;
	register struct mbtypes *mp;
	int i, j;
	u_short useraddr;
	u_short *userp;

	if (mbp == 0 || xmbp == 0 || pmbp == 0) {
		xprintf("mbpool||xmbpool||pmbpool: symbol not in namelist\n");
		return;
	}

	klseek(exos, mbp, 0);
	klread(exos, &mbpool, sizeof(struct mbpool));
	fixmbpool(&mbpool);

	klseek(exos, xmbp, 0);
	klread(exos, &xmbpool, sizeof(struct xmbpool));
	fixxmbpool(&xmbpool);

	klseek(exos, pmbp, 0);
	klread(exos, &pmbpool, sizeof(struct pmbpool));
	fixpmbpool(&pmbpool);

	xprintf("%-8.8s\t%-8.8s\t%-8.8s\t%-8.8s\t\n", 
		"", "mbpool", "xmbpool", "pmbpool");
	xprintf("%8.8s\t%-8d\t%-8d\t%-8d\t\n", "total", 
		mbpool.mbp_mbufs&0xffff, xmbpool.xmb_mbufs&0xffff, 
		pmbpool.pmb_mbufs&0xffff);
	xprintf("%8.8s\t%-8d\t%-8d\t%-8d\t\n", "available",
		mbpool.mbp_free&0xffff, xmbpool.xmb_free&0xffff, 
		pmbpool.pmb_free&0xffff);
	xprintf("%8.8s\t%-8d\t%-8d\t%-8d\t\n", "denied",
		mbpool.mbp_drops&0xffff, xmbpool.xmb_drops&0xffff, 
		pmbpool.pmb_drops&0xffff);

	if (dflag) {
		xprintf("%8.8s\t%-8x\t%-8x\t%-8x\t\n", "start",
		    mbpool.mbp_start&0xffff, xmbpool.xmb_start&0xffff, 
		    pmbpool.pmb_start&0xffff);
		xprintf("%8.8s\t%-8x\t%-8x\t%-8x\t\n", "end",
		    mbpool.mbp_end&0xffff , xmbpool.xmb_end&0xffff, 
		    pmbpool.pmb_end&0xffff);
		xprintf("%8.8s\t%-8d\t%-8.8s\t%-8.8s\t\n", "high_wat",
		    mbpool.mbp_hiwat&0xffff, "N/A", "N/A");
		xprintf("%8.8s\t%-8d\t%-8.8s\t%-8.8s\t\n", "low_wat",
		    mbpool.mbp_lowat&0xffff, "N/A", "N/A");
		xprintf("%8.8s\t%-8d\t%-8.8s\t%-8.8s\t\n", "sleeping",
		    mbpool.mbp_wakup&0xffff, "N/A", "N/A");
		xprintf("%8.8s\t%8.8s\t%-8x\t%-8.8s\t\n", "seg", "N/A",
		    xmbpool.xmb_seg&0xffff, "N/A");

		xprintf("\n<small mbuf usage>:\n");
		i = 1;
		while ( (mtname[i] != 0) && (i < MT_MAX) ) {
		    xprintf("\t%12s\t%-8d\n", mtname[i], 
			    mbpool.mbp_usage[i]&0xffff);
		    i++;
		}

/* Use MBDEBUG for the mbuf user analysis. It should only be used with
 * a special net module compiled with MBDEBUG switch on. Turn this switch
 * on in mbuf.h
 */
#ifdef	MBDEBUG
		xprintf("\n<small mbuf users>:\n");
		userp = &((struct mbuf *)mbpool.mbp_start)->m_user;

		while (userp < mbpool.mbp_end) {	
			klseek(exos, userp, 0); 
			klread(exos, &useraddr, sizeof(short));
			(unsigned)userp += MSIZE;

			useraddr = xtohs(useraddr);
			if (useraddr) {
				for (j = 0;  j < MUSER_MAX; j++) {
					if (useraddr == musert[j].addr) {
						musert[j].cnt++;
						break;
					}
					if (musert[j].addr == 0) {
						musert[j].addr = useraddr;
						musert[j].cnt = 1;
						break;
					}
					musert[MUSER_MISC].cnt++;
				}
			}
		}	
		for (i = 0; i < MUSER_MAX; i++) {
			if (musert[i].addr == 0)
				break;
 			xprintf("mbuf user[%d]:  %x	%d\n", 
				i, musert[i].addr&0xffff, musert[i].cnt&0xffff);
		}
#endif

	}

#ifdef notdef
	totmbufs = 0;
	for (mp = mbtypes; mp->mt_name; mp++)
		if (mbstat.m_mtypes[mp->mt_type]) {
			xprintf("\t%d mbufs allocated to %s\n",
				mbstat.m_mtypes[mp->mt_type], mp->mt_name);
			totmbufs += mbstat.m_mtypes[mp->mt_type];
		}
	if (totmbufs != mbstat.m_mbufs - mbstat.m_mbfree)
		xprintf("*** %d mbufs missing ***\n",
			(mbstat.m_mbufs - mbstat.m_mbfree) - totmbufs);
	xprintf("%d/%d mapped pages in use\n",
		mbstat.m_clusters - mbstat.m_clfree, mbstat.m_clusters);
	totmem = mbstat.m_mbufs * MSIZE + mbstat.m_clusters * CLBYTES;
	totfree = mbstat.m_mbfree * MSIZE + mbstat.m_clusters * CLBYTES;
	xprintf("%d Kbytes allocated to network (%d%% in use)\n",
		totmem / 1024, (totmem - totfree) * 100 / totmem);
#endif

}



fixmbpool(mbp)
struct mbpool *mbp;
{
	int i;
	
	mbp->mbp_mbufs = xtohs(mbp->mbp_mbufs);
	mbp->mbp_free = xtohs(mbp->mbp_free);
	mbp->mbp_freep = xtohs(mbp->mbp_free);
	mbp->mbp_start = xtohs(mbp->mbp_start);
	mbp->mbp_end = xtohs(mbp->mbp_end);
	mbp->mbp_hiwat = xtohs(mbp->mbp_hiwat);
	mbp->mbp_lowat = xtohs(mbp->mbp_lowat);
	mbp->mbp_wakup = xtohs(mbp->mbp_wakup);
	mbp->mbp_drops = xtohs(mbp->mbp_drops);
	for (i = 0; i < MT_MAX; i++)
		mbp->mbp_usage[i] = xtohs(mbp->mbp_usage[i]);
}

fixpmbpool(mbp)
struct pmbpool *mbp;
{
	mbp->pmb_mbufs = xtohs(mbp->pmb_mbufs);
	mbp->pmb_free = xtohs(mbp->pmb_free);
	mbp->pmb_freep = xtohs(mbp->pmb_freep);
	mbp->pmb_start = xtohs(mbp->pmb_start);
	mbp->pmb_end = xtohs(mbp->pmb_end);
}

fixxmbpool(mbp)
struct xmbpool *mbp;
{
	mbp->xmb_mbufs = xtohs(mbp->xmb_mbufs);
	mbp->xmb_free = xtohs(mbp->xmb_free);
	mbp->xmb_freep = xtohs(mbp->xmb_freep);
	mbp->xmb_start = xtohs(mbp->xmb_start);
	mbp->xmb_end = xtohs(mbp->xmb_end);
	mbp->xmb_seg = xtohs(mbp->xmb_seg);
}
