/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xftpio.h,v 1.4 87/04/24 14:42:48 davidb Exp $ */
/*
$Header: xftpio.h,v 1.4 87/04/24 14:42:48 davidb Exp $
$Log:	xftpio.h,v $
 * Revision 1.4  87/04/24  14:42:48  davidb
 * Fixing copyright message
 * 
 * Revision 1.3  87/03/26  19:18:20  grant
 * Updating source from Generic trees
 * 
 * Revision 1.1  86/10/07  18:04:11  mark
 * merging in changes for new ftp
 * 
 * Revision 1.4  86/09/29  17:11:35  mark
 * added size field to read buffer
 * 
 * Revision 1.1  86/09/04  16:35:29  albert
 * first working version
 * 
 * Revision 1.2  86/09/02  16:07:25  mark
 * added copyright notice, F_ACCEPTED etc.
 * 
 * Revision 1.2  86/08/25  18:17:02  mark
 * syncing revision level
 * 
 * Revision 1.1  86/05/09  15:31:53  mark
 * Initial revision
 * 
*/

/*
The declarations below are intended to be private to the FTP io set
and xftp routines which support generic file transfer protocol interactions.
*/

/*
structure for conn_state field of struct filesystem for ftp connections
*/
struct ftp_conn_state {
	char hostname[36];		/* host that we're connected to */
	int od;				/* descriptor for control connection */
	XFILE *cin;			/* for xgetc's from server */
	XFILE *cout;			/* for xoprintf's to server */
	struct ftp_attr ftp_type; /* negotiated type info */
	struct ftp_ofile *file_state;	/* currently open file */
	struct filesystem *ftp_fs;	/* back pointer to filesystem struct */
	/*
	Flags.
	Since we are going to support multiple simultanious connections,
	it seems worthwhile to trade time for space.
	So flags that were integers are now bits.
	*/
	short flags1;			/* first 16 flags */
	short flags2;			/* second 16 flags */
	short flags3;			/* third 16 flags */
	short flags4;			/* forth 16 flags */
};
/*
Defines for flag values
*/
#define F_CONNECTED 0x1		/* server connection est. */
#define F_TRACE 0x2		/* do packet tracing */
#define F_HASH 0x4		/* print `#' when 1K xfer'd */
#define F_SENDPORT 0x8		/* send port commands */
#define F_VERBOSE 0x10		/* be chatty */
#define F_FROMATTY 0x20		/* being used interactively */
#define F_INTERACTIVE 0x40	/* prompt for m* commands */
#define F_DEBUG 0x80		/* print debugging information*/
#define F_BELL 0x100		/* make noise when done */
#define F_DOGLOB 0x200		/* expand local files */
#define F_AUTOLOGIN 0x400	/* jump into login sequence */
#define F_HOMOOS 0x800		/* same os on other side */
#define F_HOMOARCH 0x1000	/* same architecture and os on other side */
#define F_TRANSLATE 0x2000	/* force file translation */
#define F_EXOSFTP 0x4000	/* one of our servers */
#define F_LOCAL 0x8000		/* one of our servers */
#define F_SENDIP 0x1		/* set if other side can cope */
#define F_SERVER 0x2		/* called from server */
#define F_ACCEPTED 0x2000	/* accept completed on data connection */
#define F_OUT 0x4000		/* data connection is write only */
#define F_VALIDIN 0x8000	/* input type is valid */

/*
Macros for easy testing of flags
*/
#define P_CONNECTED( pt ) ((pt->flags1) & 0x1)	/* server connection est. */
#define P_TRACE( pt ) ((pt->flags1) & 0x2)	/* do packet tracing */
#define P_HASH( pt ) ((pt->flags1) & 0x4)	/* print `#' when 1K xfer'd */
#define P_SENDPORT( pt ) ((pt->flags1) & 0x8)	/* send port commands */
#define P_VERBOSE( pt ) ((pt->flags1) & 0x10)	/* be chatty */
#define P_FROMATTY( pt ) ((pt->flags1) & 0x20)	/* being used interactively */
#define P_INTERACTIVE( pt ) ((pt->flags1) & 0x40)/* prompt for m* commands */
#define P_DEBUG( pt ) ((pt->flags1) & 0x80)	/* print debugging information*/
#define P_BELL( pt ) ((pt->flags1) & 0x100)	/* make noise when done */
#define P_DOGLOB( pt ) ((pt->flags1) & 0x200)	/* expand local files */
#define P_AUTOLOGIN( pt ) ((pt->flags1) & 0x400)/* jump into login sequence */
#define P_HOMOOS( pt ) ((pt->flags1) & 0x800)	/* same os on other side */
#define P_HOMOARCH( pt ) ((pt->flags1) & 0x1000)/* same architecture and os
						 on other side */
#define P_TRANSLATE( pt )((pt->flags1) & 0x2000)/* force file translation */
#define P_EXOSFTP( pt ) ((pt->flags1) & 0x4000)	/* one of our servers */
#define P_LOCAL( pt ) ((pt->flags1) & 0x8000)	/* one of our servers */
#define P_SENDIP( pt ) ((pt->flags2) & 0x1)	/* set if other side can
							cope with ip */
#define P_SERVER( pt ) ((pt->flags2) & 0x2)	/* called from server */

/*
Structure for read state information
*/
struct ftp_r_state {
	int state_v;		/* state for finite state machines */
	char *buf;		/* data read but not given to user */
	int count;		/* amount of data in buf */
	int size;		/* size of buf */
};

/*
Structure for write state information
*/
struct ftp_w_state {
	int prev_return;	/* return code of previous write */
};

/*
Structure for _sys_id field of _xiobuf structure for ftp files.
*/
struct ftp_ofile {
	int od;					/* underlying object */
	struct ftp_conn_state *server_info;	/*back pointer to conn_state */
	struct ftp_attr above_type;	/* type as seen by caller */
	struct ftp_attr below_type;	/* type as seen by callee */
	int open_mode;				/* how file was opened */
	struct ftp_r_state r_state;		/* state information for reads*/
	struct ftp_w_state w_state;		/*state information for writes*/
	short flag1;				/* first 16 flags */
	short flag2;				/* second 16 flags */
};

/*
Macros for easy testing of flags
*/
#define O_CONNECTED( pt ) ((pt->flag1) & 0x1)	/* server connection est. */
#define O_TRACE( pt ) ((pt->flag1) & 0x2)	/* do packet tracing */
#define O_HASH( pt ) ((pt->flag1) & 0x4)	/* print `#' when 1K xfer'd */
#define O_SENDPORT( pt ) ((pt->flag1) & 0x8)	/* send port commands */
#define O_VERBOSE( pt ) ((pt->flag1) & 0x10)	/* be chatty */
#define O_FROMATTY( pt ) ((pt->flag1) & 0x20)	/* being used interactively */
#define O_INTERACTIVE( pt ) ((pt->flag1) & 0x40)/* prompt for m* commands */
#define O_DEBUG( pt ) ((pt->flag1) & 0x80)	/* print debugging information*/
#define O_BELL( pt ) ((pt->flag1) & 0x100)	/* make noise when done */
#define O_DOGLOB( pt ) ((pt->flag1) & 0x200)	/* expand local files */
#define O_AUTOLOGIN( pt ) ((pt->flag1) & 0x400)/* jump into login sequence */
#define O_HOMOOS( pt ) ((pt->flag1) & 0x800)	/* same os on other side */
#define O_HOMOARCH( pt ) ((pt->flag1) & 0x1000)/* same architecture and os
						 on other side */
#define O_TRANSLATE( pt )((pt->flag1) & 0x2000)/* force file translation */
#define O_EXOSFTP( pt ) ((pt->flag1) & 0x4000)	/* one of our servers */
#define O_LOCAL( pt ) ((pt->flag1) & 0x8000)	/* one of our servers */
#define O_SENDIP( pt ) ((pt->flag2) & 0x1)	/* set if other side can
							cope */
#define O_SERVER( pt ) ((pt->flag2) & 0x2)	/* called from server */
#define O_ACCEPTED( pt ) ((pt->flag2) & 0x2000)	/* accept completed on data
							connection */
#define O_OUT( pt ) ((pt->flag2) & 0x4000)	/* data connection is 
							write only */
#define O_VALIDIN( pt ) ((pt->flag2) & 0x8000)	/* input type is valid */
