/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: soioctl.h,v 1.2 87/04/24 14:41:25 davidb Exp $ */
/* @(#)soioctl.h	1.5 4/9/85*/
/*
 * Ioctl extensions:
 *	- these should be in <sys/ioctl.h>, but since we can't depend
 *	  on them being there (and they most likely won't be) we keep
 *	  them here
 *	- needless to say, but all of these ioctls apply only to sockets
 */

#ifndef	_SOIOCTL
#define _SOIOCTL

#ifdef	BSD4dot2
#include <sys/ioctl.h>

#undef	SIOCDONE
#undef	SIOCSKEEP
#undef	SIOCGKEEP
#undef	SIOCSLINGER
#undef	SIOCGLINGER
#undef	SIOCSENDOOB
#undef	SIOCRCVOOB

#undef	SIOCATMARK
#undef	SIOCSPGRP
#undef	SIOCGPGRP
#undef	SIOCADDRT
#undef	SIOCDELRT

#undef	SIOCCHGRT
#undef	SIOCDISPRT
#undef	SIOCSHOWRT


/*
   _IOXFIO and _IOXSIO may have already been defined in include/EXOS/ex_ioctl.h
   In particular, netload.h includes ex_ioctl.h and exos/misc.h, which includes
   this file.

   They are defined in ex_ioctl.h only if BSD4dot2 is set.
   dab 86/11/10.
*/

#ifndef _IOXFIO
#define _IOXFIO(y)	(IOC_VOID|(sizeof(int)<<16)|('f'<<8)|y)
#endif /* _IOXFIO */

#ifndef _IOXSIO
#define _IOXSIO(y)	(IOC_VOID|(sizeof(int)<<16)|('s'<<8)|y)
#endif /* _IOXSIO */

#else	/* BSD4dot2 */

/*
   SIGURG was moved here from include/EXOS/exos/misc.h. dab 861119.
   SIGURG is used by ftpdstart.c, ex_admin.c.
*/

#define SIGURG	16	/* This is SIGUSR1 in System V */
#define	TIOCPKT		(('t'<<8)|112)	/* on pty: set/clear packet mode */
#define		TIOCPKT_DATA		0x00	/* data packet */
#define		TIOCPKT_FLUSHREAD	0x01	/* flush packet */
#define		TIOCPKT_FLUSHWRITE	0x02	/* flush packet */
#define		TIOCPKT_STOP		0x04	/* stop output */
#define		TIOCPKT_START		0x08	/* start output */
#define		TIOCPKT_NOSTOP		0x10	/* no more ^S, ^Q */
#define		TIOCPKT_DOSTOP		0x20	/* now do ^S ^Q */

#define _IOXFIO(y)	(('f'<<8)|y)
#define _IOXSIO(y)	(('s'<<8)|y)

#endif	/* BSD4dot2 */

#ifdef FIONREAD
#undef FIONREAD
#endif
#ifdef FIONBIO
#undef FIONBIO
#endif
#ifdef FIOASYNC
#undef FIOASYNC
#endif

#define	FIONREAD	_IOXFIO(127)	/* get # bytes to read */
#define	FIONBIO		_IOXFIO(126)
#define	FIOASYNC	_IOXFIO(125)

#define	SIOCDONE	_IOXSIO(0)	/* shutdown read/write on socket */
#define	SIOCSKEEP	_IOXSIO(1)	/* set keep alive */
#define	SIOCGKEEP	_IOXSIO(2)	/* inspect keep alive */
#define	SIOCSLINGER	_IOXSIO(3)	/* set linger time */
#define	SIOCGLINGER	_IOXSIO(4)	/* get linger time */
#define	SIOCSENDOOB	_IOXSIO(5)	/* send out of band */
#define	SIOCRCVOOB	_IOXSIO(6)	/* get out of band */

#define	SIOCATMARK	_IOXSIO(7)	/* at out of band mark? */
#define	SIOCSPGRP	_IOXSIO(8)	/* set process group */
#define	SIOCGPGRP	_IOXSIO(9)	/* get process group */
#define	SIOCADDRT	_IOXSIO(10)	/* add a routing table entry */
#define	SIOCDELRT	_IOXSIO(11)	/* delete a routing table entry */

#define	SIOCCHGRT	_IOXSIO(12)	/* change a routing table entry */
#define SIOCDISPRT	_IOXSIO(13)	/* display a particular route */ 
#define SIOCSHOWRT	_IOXSIO(14)	/* display a route based on hash 
					 * this mechanism is used to cycle
					 * through all the entries in the 
					 * routing tables.
					 */
#endif	/* _SOIOCTL */
