/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: route.h,v 1.2 87/04/24 14:39:24 davidb Exp $ */
/* @(#)route.h	1.7 5/31/85 */

/*
 * GAP 1/11/85:  W A R N I N G  - This file is included by both host
 * and board code.  Make changes with extreme caution, and test
 * effects on both the host and board sides.
 */

/*
 * Kernel resident routing tables.
 * 
 * The routing tables are initialized at boot time by
 * making entries for all directly connected interfaces.
 * Routing daemons can thereafter update the routing tables.
 *
 * TODO:
 *	keep statistics
 */

/*
 * A route consists of a destination address and a reference
 * to a routing entry.  These are often held by protocols
 * in their control blocks, e.g. inpcb.
 */
struct route {
	struct	rtentry *ro_rt;
	struct	sockaddr ro_dst;
#ifdef notdef
	caddr_t	ro_pcb;			/* not used yet */
#endif
};
#ifdef KERNEL
/*
 * The route ``routetoif'' is a special atom passed to the output routines
 * to implement the SO_DONTROUTE option.
 */
struct	route routetoif;
#endif

/*
 * We distinguish between routes to hosts and routes to networks,
 * preferring the former if available.  For each route we infer
 * the interface to use from the gateway address supplied when
 * the route was entered.  Routes that forward packets through
 * gateways are marked so that the output routines know to address the
 * gateway rather than the ultimate destination.
 *
 * AA - 4/11/85: The rtentry structure below has been set up 
 * 	so that it it compatible with the host, board
 *	and machines such as VAX that like 
 *	to do long alignments.
 *	!!! DO NOT FIDDLE WITH THIS STRUCTURE UNLESS YOU 
 *	!!! UNDERSTAND THIS 
 */
struct rtentry {
	struct	sockaddr rt_dst;	/* key */
	struct	sockaddr rt_gateway;	/* value */
	union {
		struct  rtentry *RT_next; /* next pointer */
		long	pad_rt_next;
	} rt_nextu;
	u_long	rt_use;			/* raw # packets forwarded */
	union {
		struct	ifnet *RT_ifp;	/* the answer: interface to use */
		long	pad_rt_ifp;
	} rt_ifpu;
	char    rt_flags;               /* up/down?, host/net */
	char    rt_refcnt;              /* # held references */
	u_short rt_hash;                /* to speed lookups */
};
#define	rt_next	rt_nextu.RT_next
#define	rt_ifp	rt_ifpu.RT_ifp
#define	RTHASHSIZ	7
struct  rtentry *rthost[RTHASHSIZ];
struct  rtentry *rtnet[RTHASHSIZ];

#define	RTF_UP		0x1		/* route useable */
#define	RTF_GATEWAY	0x2		/* destination is a gateway */
#define	RTF_HOST	0x4		/* host entry (net otherwise) */

#define	RTFREE(rt) \
	if ((rt)->rt_refcnt == 1) \
		rtfree(rt); \
	else \
		(rt)->rt_refcnt--;

