/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: ex_errno.h,v 1.2 87/04/24 14:37:31 davidb Exp $ */

/*
   These error numbers used to be defined in include/EXOS/exos/misc.h.
   They are used by only a few modules: rlogin.c, rsh.c, asynctest.c,
   libex_driver/ex_socket.c, rcmd.c. dab 861124.
*/

/*
   The error codes are now moved up to stay out of the way of UNIX error
   numbers. The mapping is done in src/lib/libex_driver/ex_subr.c: ex_send()
   and ex_socket.c: ex_pendio(). 

   ERR_MAP_OFFSET must be such that the largest error number possible is 
   less than 128. Otherwise, when u.u_error (a char) is stuffed into
   errno (an int) in the user space, it is sign extended and becomes
   negative.
   dab 861212.
*/

#define ERR_MAP_OFFSET	50

#define MINEXERR (EWOULDBLOCK)	/* Moved from libc/perror.c. dab 861217. */
#define MAXEXERR (EHOSTUNREACH)	/* Moved from libc/perror.c. dab 861217. */
				/* Also used by XMAPERRNO macro in UnixXos.h */

/*
 * Network error numbers, originally derived from 4.2 BSD. The original numbers
 * are preserved in this file, but are offset to move them out of the way of
 * System V error numbers.
 * dab 861212.
 */

/* non-blocking and interrupt i/o */
#define	EWOULDBLOCK	35 + ERR_MAP_OFFSET /* Operation would block */
#define	EINPROGRESS	36 + ERR_MAP_OFFSET /* Operation now in progress */
#define	EALREADY	37 + ERR_MAP_OFFSET /* Operation already in progress */

/* argument errors */
#define	ENOTSOCK	38 + ERR_MAP_OFFSET /* Socket operation on non-socket */
#define	EDESTADDRREQ	39 + ERR_MAP_OFFSET /* Destination address required */
#define	EMSGSIZE	40 + ERR_MAP_OFFSET /* Message too long */
#define	EPROTOTYPE	41 + ERR_MAP_OFFSET /* Protocol wrong type for socket */
#define	ENOPROTOOPT	42 + ERR_MAP_OFFSET /* Protocol not available */
#define	EPROTONOSUPPORT	43 + ERR_MAP_OFFSET /* Protocol not supported */
#define	ESOCKTNOSUPPORT	44 + ERR_MAP_OFFSET /* Socket type not supported */
#define	EOPNOTSUPP	45 + ERR_MAP_OFFSET /* Operation not supported on socket */
#define	EPFNOSUPPORT	46 + ERR_MAP_OFFSET /* Protocol family not supported */
#define	EAFNOSUPPORT	47 + ERR_MAP_OFFSET /* Address family not supported by protocol family */
#define	EADDRINUSE	48 + ERR_MAP_OFFSET /* Address already in use */
#define	EADDRNOTAVAIL	49 + ERR_MAP_OFFSET /* Can't assign requested address */

/* operational errors */
#define	ENETDOWN	50 + ERR_MAP_OFFSET /* Network is down */
#define	ENETUNREACH	51 + ERR_MAP_OFFSET /* Network is unreachable */
#define	ENETRESET	52 + ERR_MAP_OFFSET /* Network dropped connection on reset */
#define	ECONNABORTED	53 + ERR_MAP_OFFSET /* Software caused connection abort */
#define	ECONNRESET	54 + ERR_MAP_OFFSET /* Connection reset by peer */
#define	ENOBUFS		55 + ERR_MAP_OFFSET /* No buffer space available */
#define	EISCONN		56 + ERR_MAP_OFFSET /* Socket is already connected */
#define	ENOTCONN	57 + ERR_MAP_OFFSET /* Socket is not connected */
#define	ESHUTDOWN	58 + ERR_MAP_OFFSET /* Can't send after socket shutdown */
#define	ETOOMANYREFS	59 + ERR_MAP_OFFSET /* Too many references: can't splice */
#define	ETIMEDOUT	60 + ERR_MAP_OFFSET /* Connection timed out */
#define	ECONNREFUSED	61 + ERR_MAP_OFFSET /* Connection refused */

/* random errors */
#define	ELOOP		62 + ERR_MAP_OFFSET /* Too many levels of symbolic links */
#define	ENAMETOOLONG	63 + ERR_MAP_OFFSET /* File name too long */
#define	EHOSTDOWN	64 + ERR_MAP_OFFSET /* Host is down */
#define EHOSTUNREACH	65 + ERR_MAP_OFFSET /* No route to host */
